/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import java.awt.Color;
import java.awt.Paint;

public class AreaChartForCategoryDataDemo
extends ApplicationFrame {
    protected CategoryDataset data;

    public AreaChartForCategoryDataDemo(String title) {
        super(title);
        double[][] data = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0}, {5.0, 7.0, 6.0, 8.0, 4.0, 4.0, 2.0, 1.0}, {4.0, 3.0, 2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        DefaultCategoryDataset dataset = new DefaultCategoryDataset(data);
        String[] seriesNames = new String[]{"First", "Second", "Third"};
        dataset.setSeriesNames(seriesNames);
        Object[] categories = new String[]{"Type 1", "Type 2", "Type 3", "Type 4", "Type 5", "Type 6", "Type 7", "Type 8"};
        dataset.setCategories(categories);
        JFreeChart chart = ChartFactory.createAreaChart("Area Chart", "Category", "Value", dataset, true);
        chart.setBackgroundPaint(Color.yellow);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.5f);
        plot.setIntroGapPercent(0.0);
        plot.setTrailGapPercent(0.0);
        plot.setLabelsVisible(true);
        plot.setSeriesPaint(new Paint[]{Color.green, Color.orange, Color.red});
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(TickUnits.createIntegerTickUnits());
        HorizontalCategoryAxis domainAxis = (HorizontalCategoryAxis)plot.getDomainAxis();
        domainAxis.setVerticalCategoryLabels(true);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        AreaChartForCategoryDataDemo demo = new AreaChartForCategoryDataDemo("Area Chart Demo");
        demo.pack();
        demo.setVisible(true);
    }
}

