/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.data;

import com.jrefinery.chart.data.ArrayHolder;
import com.jrefinery.chart.data.PlotFitAlgorithm;
import com.jrefinery.data.Statistics;
import com.jrefinery.data.XYDataset;
import java.util.Vector;

public class MovingAveragePlotFitAlgorithm
implements PlotFitAlgorithm {
    private XYDataset dataset;
    private int period = 5;
    private Vector plots;

    public String getName() {
        return "Moving Average";
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setXYDataset(XYDataset ds) {
        this.dataset = ds;
        Vector datasets = new Vector();
        int i = 0;
        while (i < ds.getSeriesCount()) {
            int seriessize = ds.getItemCount(i);
            Number[] x_data = new Number[seriessize];
            Number[] y_data = new Number[seriessize];
            int j = 0;
            while (j < seriessize) {
                x_data[j] = ds.getXValue(i, j);
                y_data[j] = ds.getYValue(i, j);
                ++j;
            }
            Vector<Number[]> pair = new Vector<Number[]>();
            pair.addElement(x_data);
            pair.addElement(y_data);
            datasets.addElement(pair);
            ++i;
        }
        this.plots = new Vector();
        int j = 0;
        while (j < datasets.size()) {
            Vector pair = (Vector)datasets.elementAt(j);
            Number[] x_data = (Number[])pair.elementAt(0);
            Number[] y_data = (Number[])pair.elementAt(1);
            this.plots.addElement(new ArrayHolder(Statistics.getMovingAverage(x_data, y_data, this.period)));
            ++j;
        }
    }

    public Number getY(int series, Number x) {
        double[][] mavg = ((ArrayHolder)this.plots.elementAt(series)).getArray();
        int j = 0;
        while (j < mavg.length) {
            if (mavg[j][0] == x.doubleValue()) {
                return new Double(mavg[j][1]);
            }
            ++j;
        }
        return null;
    }
}

