/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.data;

import com.jrefinery.chart.data.PlotFitAlgorithm;
import com.jrefinery.data.Statistics;
import com.jrefinery.data.XYDataset;
import java.util.Vector;

public class LinearPlotFitAlgorithm
implements PlotFitAlgorithm {
    private XYDataset dataset;
    private double[][] linear_fit;

    public String getName() {
        return "Linear Fit";
    }

    public void setXYDataset(XYDataset data) {
        this.dataset = data;
        Vector datasets = new Vector();
        int i = 0;
        while (i < data.getSeriesCount()) {
            int seriessize = data.getItemCount(i);
            Number[] x_data = new Number[seriessize];
            Number[] y_data = new Number[seriessize];
            int j = 0;
            while (j < seriessize) {
                x_data[j] = data.getXValue(i, j);
                y_data[j] = data.getYValue(i, j);
                ++j;
            }
            Vector<Number[]> pair = new Vector<Number[]>();
            pair.addElement(x_data);
            pair.addElement(y_data);
            datasets.addElement(pair);
            ++i;
        }
        this.linear_fit = new double[datasets.size()][2];
        int i2 = 0;
        while (i2 < datasets.size()) {
            Vector pair = (Vector)datasets.elementAt(i2);
            this.linear_fit[i2] = Statistics.getLinearFit((Number[])pair.elementAt(0), (Number[])pair.elementAt(1));
            ++i2;
        }
    }

    public Number getY(int series, Number x) {
        return new Double(this.linear_fit[series][0] + this.linear_fit[series][1] * x.doubleValue());
    }
}

