/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class XYPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot,
PropertyChangeListener {
    protected XYPlot parent = null;
    protected int weight = 1;
    protected ValueAxis domainAxis;
    protected ValueAxis rangeAxis;
    protected XYItemRenderer renderer;
    protected List verticalLines = null;
    protected List verticalColors = null;
    protected List horizontalLines = null;
    protected List horizontalColors = null;

    public XYPlot(XYDataset data, ValueAxis domainAxis, ValueAxis rangeAxis) {
        this(data, domainAxis, rangeAxis, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, new StandardXYItemRenderer());
    }

    public XYPlot(XYDataset data, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        this(data, domainAxis, rangeAxis, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, renderer);
    }

    public XYPlot(XYDataset data, ValueAxis domainAxis, ValueAxis rangeAxis, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float alpha, XYItemRenderer renderer) {
        super(data, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, alpha);
        this.renderer = renderer;
        this.renderer.addPropertyChangeListener(this);
        this.domainAxis = domainAxis;
        if (domainAxis != null) {
            domainAxis.setPlot(this);
            domainAxis.addChangeListener(this);
        }
        this.rangeAxis = rangeAxis;
        if (rangeAxis != null) {
            rangeAxis.setPlot(this);
            rangeAxis.addChangeListener(this);
        }
    }

    public boolean isSubplot() {
        return this.parent != null;
    }

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(XYPlot parent) {
        this.parent = parent;
    }

    public int getSeriesCount() {
        int result = 0;
        XYDataset data = this.getXYDataset();
        if (data != null) {
            result = data.getSeriesCount();
        }
        return result;
    }

    public List getLegendItemLabels() {
        ArrayList<String> result = new ArrayList<String>();
        XYDataset data = this.getXYDataset();
        if (data != null) {
            int seriesCount = data.getSeriesCount();
            int i = 0;
            while (i < seriesCount) {
                result.add(data.getSeriesName(i));
                ++i;
            }
        }
        return result;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public XYItemRenderer getItemRenderer() {
        return this.renderer;
    }

    public void setXYItemRenderer(XYItemRenderer renderer) {
        boolean changed = false;
        if (this.renderer != null) {
            if (!this.renderer.equals(renderer)) {
                this.renderer.removePropertyChangeListener(this);
                this.renderer = renderer;
                changed = true;
            }
        } else if (renderer != null) {
            this.renderer = renderer;
            changed = true;
        }
        if (changed) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public XYDataset getXYDataset() {
        return (XYDataset)this.dataset;
    }

    public void addVerticalLine(Number location) {
        this.addVerticalLine(location, Color.blue);
    }

    public void addVerticalLine(Number location, Paint color) {
        if (this.verticalLines == null) {
            this.verticalLines = new ArrayList();
            this.verticalColors = new ArrayList();
        }
        this.verticalColors.add(color);
        this.verticalLines.add(location);
    }

    public void addHorizontalLine(Number value) {
        this.addHorizontalLine(value, Color.red);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addHorizontalLine(Number location, Paint color) {
        if (this.horizontalLines == null) {
            this.horizontalLines = new ArrayList();
            this.horizontalColors = new ArrayList();
        }
        this.horizontalColors.add(color);
        this.horizontalLines.add(location);
    }

    public ValueAxis getDomainAxis() {
        ValueAxis result = this.domainAxis;
        if (result == null && this.parent != null) {
            result = this.parent.getDomainAxis();
        }
        return result;
    }

    public ValueAxis getRangeAxis() {
        ValueAxis result = this.rangeAxis;
        if (result == null && this.parent != null) {
            result = this.parent.getRangeAxis();
        }
        return result;
    }

    public boolean isCompatibleDomainAxis(ValueAxis axis) {
        if (axis == null) {
            return true;
        }
        return axis instanceof HorizontalAxis;
    }

    public boolean isCompatibleRangeAxis(ValueAxis axis) {
        if (axis == null) {
            return true;
        }
        return axis instanceof VerticalAxis;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        double hAxisAreaHeight = 0.0;
        if (this.domainAxis != null) {
            HorizontalAxis hAxis = (HorizontalAxis)((Object)this.domainAxis);
            hAxisAreaHeight = hAxis.reserveHeight(g2, this, plotArea);
        }
        double vAxisWidth = 0.0;
        if (this.rangeAxis != null) {
            VerticalAxis vAxis = (VerticalAxis)((Object)this.rangeAxis);
            vAxisWidth = vAxis.reserveAxisArea(g2, this, plotArea, hAxisAreaHeight).getWidth();
        }
        Rectangle2D.Double dataArea = new Rectangle2D.Double(plotArea.getX() + vAxisWidth, plotArea.getY(), plotArea.getWidth() - vAxisWidth, plotArea.getHeight() - hAxisAreaHeight);
        if (info != null) {
            info.setDataArea(dataArea);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairInfo.setAnchorX(this.getDomainAxis().getAnchorValue());
        crosshairInfo.setAnchorY(this.getRangeAxis().getAnchorValue());
        this.drawOutlineAndBackground(g2, dataArea);
        if (this.domainAxis != null) {
            this.domainAxis.draw(g2, plotArea, dataArea);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.draw(g2, plotArea, dataArea);
        }
        this.render(g2, dataArea, info, crosshairInfo);
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, CrosshairInfo crosshairInfo) {
        XYDataset data = this.getXYDataset();
        if (data != null) {
            Shape originalClip = g2.getClip();
            Composite originalComposite = g2.getComposite();
            g2.clip(dataArea);
            g2.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            this.drawVerticalLines(g2, dataArea);
            this.drawHorizontalLines(g2, dataArea);
            this.renderer.initialise(g2, dataArea, this, data, info);
            ValueAxis domainAxis = this.getDomainAxis();
            ValueAxis rangeAxis = this.getRangeAxis();
            int seriesCount = data.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = data.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    this.renderer.drawItem(g2, dataArea, info, this, domainAxis, rangeAxis, data, series, item, crosshairInfo);
                    ++item;
                }
                ++series;
            }
            domainAxis.setCrosshairValue(crosshairInfo.getCrosshairX());
            if (domainAxis.isCrosshairVisible()) {
                this.drawVerticalLine(g2, dataArea, domainAxis.getCrosshairValue(), domainAxis.getCrosshairStroke(), domainAxis.getCrosshairPaint());
            }
            rangeAxis.setCrosshairValue(crosshairInfo.getCrosshairY());
            if (rangeAxis.isCrosshairVisible()) {
                this.drawHorizontalLine(g2, dataArea, rangeAxis.getCrosshairValue(), rangeAxis.getCrosshairStroke(), rangeAxis.getCrosshairPaint());
            }
            g2.setClip(originalClip);
            g2.setComposite(originalComposite);
        }
    }

    protected void drawVerticalLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        double xx = this.getDomainAxis().translateValueToJava2D(value, dataArea);
        Line2D.Double line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
    }

    protected void drawHorizontalLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        double yy = this.getRangeAxis().translateValueToJava2D(value, dataArea);
        Line2D.Double line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
    }

    protected void drawVerticalLines(Graphics2D g2, Rectangle2D dataArea) {
        if (this.verticalLines != null) {
            int i = 0;
            while (i < this.verticalLines.size()) {
                g2.setPaint((Paint)this.verticalColors.get(i));
                g2.setStroke(new BasicStroke(1.0f));
                Number x = (Number)this.verticalLines.get(i);
                int xint = (int)this.getDomainAxis().translateValueToJava2D(x.doubleValue(), dataArea);
                g2.drawLine(xint, (int)dataArea.getMinY(), xint, (int)dataArea.getMaxY());
                ++i;
            }
        }
    }

    protected void drawHorizontalLines(Graphics2D g2, Rectangle2D dataArea) {
        if (this.horizontalLines != null) {
            int i = 0;
            while (i < this.horizontalLines.size()) {
                g2.setPaint((Paint)this.horizontalColors.get(i));
                g2.setStroke(new BasicStroke(1.0f));
                Number y = (Number)this.horizontalLines.get(i);
                int yint = (int)this.getRangeAxis().translateValueToJava2D(y.doubleValue(), dataArea);
                g2.drawLine((int)dataArea.getMinX(), yint, (int)dataArea.getMaxX(), yint);
                ++i;
            }
        }
    }

    public void handleClick(int x, int y, ChartRenderingInfo info) {
        ValueAxis hva = this.getDomainAxis();
        double hvalue = hva.translateJava2DtoValue(x, info.getDataArea());
        hva.setAnchorValue(hvalue);
        hva.setCrosshairValue(hvalue);
        ValueAxis vva = this.getRangeAxis();
        double vvalue = vva.translateJava2DtoValue(y, info.getDataArea());
        vva.setAnchorValue(vvalue);
        vva.setCrosshairValue(vvalue);
    }

    public void zoom(double percent) {
        if (percent > 0.0) {
            ValueAxis domainAxis = this.getDomainAxis();
            double range = domainAxis.getMaximumAxisValue() - domainAxis.getMinimumAxisValue();
            double scaledRange = range * percent;
            domainAxis.setAnchoredRange(scaledRange);
            ValueAxis rangeAxis = this.getRangeAxis();
            range = rangeAxis.getMaximumAxisValue() - rangeAxis.getMinimumAxisValue();
            scaledRange = range * percent;
            rangeAxis.setAnchoredRange(scaledRange);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    public String getPlotType() {
        return "XY Plot";
    }

    public Range getHorizontalDataRange() {
        Range result = null;
        if (this.dataset != null) {
            result = DatasetUtilities.getDomainExtent(this.dataset);
        }
        return result;
    }

    public Range getVerticalDataRange() {
        Range result = null;
        if (this.dataset != null) {
            result = DatasetUtilities.getRangeExtent(this.dataset);
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent event) {
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        if (this.parent != null) {
            this.parent.datasetChanged(event);
        } else {
            PlotChangeEvent e = new PlotChangeEvent(this);
            this.notifyListeners(e);
        }
    }

    public HorizontalAxis getHorizontalAxis() {
        return (HorizontalAxis)((Object)this.getDomainAxis());
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.getDomainAxis();
    }

    public VerticalAxis getVerticalAxis() {
        return (VerticalAxis)((Object)this.getRangeAxis());
    }

    public ValueAxis getVerticalValueAxis() {
        return this.getRangeAxis();
    }

    public void setDomainAxis(ValueAxis axis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(axis)) {
            if (axis != null) {
                try {
                    axis.setPlot(this);
                }
                catch (PlotNotCompatibleException e) {
                    throw new AxisNotCompatibleException("Plot.setDomainAxis(...): plot not compatible with axis.");
                }
                axis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = axis;
    }

    public void setRangeAxis(ValueAxis axis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(axis)) {
            if (axis != null) {
                try {
                    axis.setPlot(this);
                }
                catch (PlotNotCompatibleException e) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                axis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = axis;
    }
}

