/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalNumberAxis3D
extends VerticalNumberAxis {
    public static final double DEFAULT_EFFECT_3D = 10.0;
    private double effect3d = 10.0;

    public VerticalNumberAxis3D() {
        this(null);
    }

    public VerticalNumberAxis3D(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.autoRange = true;
    }

    public VerticalNumberAxis3D(String label, Font labelFont, double minimumAxisValue, double maximumAxisValue) {
        this(label, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, false, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, minimumAxisValue, maximumAxisValue, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, 10.0);
    }

    public VerticalNumberAxis3D(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean labelDrawnVertical, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, boolean autoRangeStickyZero, Number autoRangeMinimum, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint, double effect3d) {
        super(label, labelFont, labelPaint, labelInsets, labelDrawnVertical, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke, autoRange, autoRangeIncludesZero, autoRangeStickyZero, autoRangeMinimum, minimumAxisValue, maximumAxisValue, inverted, autoTickUnitSelection, tickUnit, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        this.effect3d = effect3d;
    }

    public double getEffect3d() {
        return this.effect3d;
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D dataArea) {
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            double yy;
            double xx;
            g2.setFont(this.labelFont);
            g2.setPaint(this.labelPaint);
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            if (this.verticalLabel) {
                xx = drawArea.getX() + (double)this.labelInsets.left + labelBounds.getHeight();
                yy = dataArea.getY() + dataArea.getHeight() / 2.0 + labelBounds.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString(this.label, g2, (float)xx, (float)yy, -1.5707963267948966);
            } else {
                xx = drawArea.getX() + (double)this.labelInsets.left;
                yy = drawArea.getY() + drawArea.getHeight() / 2.0 - labelBounds.getHeight() / 2.0;
                g2.drawString(this.label, (float)xx, (float)yy);
            }
        }
        this.refreshTicks(g2, drawArea, dataArea);
        double xx = dataArea.getX();
        g2.setFont(this.tickLabelFont);
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float yy = (float)this.translateValueToJava2D(tick.getNumericalValue(), dataArea);
            if (this.tickLabelsVisible) {
                g2.setPaint(this.tickLabelPaint);
                g2.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (this.tickMarksVisible) {
                g2.setStroke(this.getTickMarkStroke());
                Line2D.Double mark = new Line2D.Double(dataArea.getX() - 2.0, yy, dataArea.getX(), yy);
                g2.draw(mark);
            }
            if (!this.gridLinesVisible) continue;
            g2.setStroke(this.gridStroke);
            g2.setPaint(this.gridPaint);
            Line2D.Double gridline = new Line2D.Double(xx + this.effect3d, (double)yy - this.effect3d, dataArea.getMaxX() + this.effect3d, (double)yy - this.effect3d);
            g2.draw(gridline);
            Line2D.Double grid3Dline = new Line2D.Double(xx, yy, xx + this.effect3d, (double)yy - this.effect3d);
            g2.draw(grid3Dline);
        }
    }

    static {
        DEFAULT_EFFECT_3D = 10.0;
    }
}

