/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalNumberAxis
extends NumberAxis
implements VerticalAxis {
    protected boolean verticalLabel;

    public VerticalNumberAxis() {
        this(null);
    }

    public VerticalNumberAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.autoRange = true;
    }

    public VerticalNumberAxis(String label, Font labelFont, double minimumAxisValue, double maximumAxisValue) {
        this(label, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, minimumAxisValue, maximumAxisValue, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public VerticalNumberAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean verticalLabel, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, boolean autoRangeStickyZero, Number autoRangeMinimum, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint) {
        super(label, labelFont, labelPaint, labelInsets, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke, autoRange, autoRangeIncludesZero, autoRangeStickyZero, autoRangeMinimum, minimumAxisValue, maximumAxisValue, inverted, autoTickUnitSelection, tickUnit, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        this.verticalLabel = verticalLabel;
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean flag) {
        if (this.verticalLabel != flag) {
            this.verticalLabel = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateValueToJava2D(double value, Rectangle2D dataArea) {
        double axisMin = this.range.getLowerBound();
        double axisMax = this.range.getUpperBound();
        double maxY = dataArea.getMaxY();
        double minY = dataArea.getMinY();
        if (this.inverted) {
            return minY + (value - axisMin) / (axisMax - axisMin) * (maxY - minY);
        }
        return maxY - (value - axisMin) / (axisMax - axisMin) * (maxY - minY);
    }

    public double translateJava2DtoValue(float java2DValue, Rectangle2D dataArea) {
        double axisMin = this.range.getLowerBound();
        double axisMax = this.range.getUpperBound();
        double plotY = dataArea.getY();
        double plotMaxY = dataArea.getMaxY();
        if (this.inverted) {
            return axisMin + ((double)java2DValue - plotY) / (plotMaxY - plotY) * (axisMax - axisMin);
        }
        return axisMax - ((double)java2DValue - plotY) / (plotMaxY - plotY) * (axisMax - axisMin);
    }

    protected void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof VerticalValuePlot) {
            double minRange;
            VerticalValuePlot vvp = (VerticalValuePlot)((Object)this.plot);
            Range r = vvp.getVerticalDataRange();
            if (r == null) {
                r = new Range(0.0, 1.0);
            }
            double lower = r.getLowerBound();
            double upper = r.getUpperBound();
            double range = upper - lower;
            if (range < (minRange = this.autoRangeMinimumSize.doubleValue())) {
                upper = (upper + lower + minRange) / 2.0;
                lower = (upper + lower - minRange) / 2.0;
            }
            if (this.autoRangeIncludesZero) {
                if (this.autoRangeStickyZero) {
                    upper = upper <= 0.0 ? 0.0 : (upper += this.upperMargin * (upper - Math.min(lower, 0.0)));
                    lower = lower >= 0.0 ? 0.0 : (lower -= this.lowerMargin * (upper - lower));
                } else {
                    range = Math.max(0.0, upper) - Math.min(0.0, lower);
                    upper = Math.max(0.0, upper + this.upperMargin * range);
                    lower = Math.min(0.0, lower - this.lowerMargin * range);
                }
            } else if (this.autoRangeStickyZero) {
                upper = upper <= 0.0 ? Math.min(0.0, upper + this.upperMargin * range) : (upper += this.upperMargin * range);
                lower = lower >= 0.0 ? Math.max(0.0, lower - this.lowerMargin * range) : (lower -= this.lowerMargin * range);
            } else {
                upper += this.upperMargin * range;
                lower -= this.lowerMargin * range;
            }
            this.range = new Range(lower, upper);
        }
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            double yy;
            double xx;
            g2.setFont(this.labelFont);
            g2.setPaint(this.labelPaint);
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            if (this.verticalLabel) {
                xx = drawArea.getX() + (double)this.labelInsets.left + labelBounds.getHeight();
                yy = plotArea.getY() + plotArea.getHeight() / 2.0 + labelBounds.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString(this.label, g2, (float)xx, (float)yy, -1.5707963267948966);
            } else {
                xx = drawArea.getX() + (double)this.labelInsets.left;
                yy = drawArea.getY() + drawArea.getHeight() / 2.0 - labelBounds.getHeight() / 2.0;
                g2.drawString(this.label, (float)xx, (float)yy);
            }
        }
        this.refreshTicks(g2, drawArea, plotArea);
        double xx = plotArea.getX();
        g2.setFont(this.tickLabelFont);
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float yy = (float)this.translateValueToJava2D(tick.getNumericalValue(), plotArea);
            if (this.tickLabelsVisible) {
                g2.setPaint(this.tickLabelPaint);
                g2.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (this.tickMarksVisible) {
                g2.setStroke(this.getTickMarkStroke());
                Line2D.Double mark = new Line2D.Double(plotArea.getX() - 2.0, yy, plotArea.getX() + 2.0, yy);
                g2.draw(mark);
            }
            if (!this.gridLinesVisible) continue;
            g2.setStroke(this.gridStroke);
            g2.setPaint(this.gridPaint);
            Line2D.Double gridline = new Line2D.Double(xx, yy, plotArea.getMaxX(), yy);
            g2.draw(gridline);
        }
    }

    public double reserveWidth(Graphics2D g2, Plot plot, Rectangle2D drawArea) {
        if (!this.visible) {
            return 0.0;
        }
        if (this.fixedDimension > 0.0) {
            return this.fixedDimension;
        }
        double labelWidth = 0.0;
        if (this.label != null) {
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            labelWidth = this.labelInsets.left + this.labelInsets.right;
            labelWidth = this.verticalLabel ? (labelWidth += labelBounds.getHeight()) : (labelWidth += labelBounds.getWidth());
        }
        double tickLabelWidth = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelWidth += this.getMaxTickLabelWidth(g2, drawArea);
        }
        return labelWidth + tickLabelWidth;
    }

    public Rectangle2D reserveAxisArea(Graphics2D g2, Plot plot, Rectangle2D drawArea, double reservedHeight) {
        if (!this.visible) {
            return new Rectangle2D.Double(drawArea.getX(), drawArea.getY(), 0.0, drawArea.getHeight() - reservedHeight);
        }
        if (this.fixedDimension > 0.0) {
            return new Rectangle2D.Double(drawArea.getX(), drawArea.getY(), this.fixedDimension, drawArea.getHeight() - reservedHeight);
        }
        double labelWidth = 0.0;
        if (this.label != null) {
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, g2.getFontRenderContext());
            labelWidth = this.labelInsets.left + this.labelInsets.right;
            labelWidth = this.verticalLabel ? (labelWidth += labelBounds.getHeight()) : (labelWidth += labelBounds.getWidth());
        }
        double tickLabelWidth = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            Rectangle2D.Double approximatePlotArea = new Rectangle2D.Double(drawArea.getX(), drawArea.getY(), drawArea.getWidth(), drawArea.getHeight() - reservedHeight);
            this.refreshTicks(g2, drawArea, approximatePlotArea);
            tickLabelWidth += this.getMaxTickLabelWidth(g2, approximatePlotArea);
        }
        return new Rectangle2D.Double(drawArea.getX(), drawArea.getY(), labelWidth + tickLabelWidth, drawArea.getHeight() - reservedHeight);
    }

    private void selectAutoTickUnit(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        NumberTickUnit candidate2;
        FontRenderContext frc = g2.getFontRenderContext();
        double tickLabelHeight = this.tickLabelFont.getLineMetrics("123", frc).getHeight() + (float)this.tickLabelInsets.top + (float)this.tickLabelInsets.bottom;
        double zero = this.translateValueToJava2D(0.0, plotArea);
        NumberTickUnit candidate1 = (NumberTickUnit)this.standardTickUnits.getCeilingTickUnit(this.tickUnit);
        double y = this.translateValueToJava2D(candidate1.getSize(), plotArea);
        double unitHeight = Math.abs(y - zero);
        double bestguess = tickLabelHeight / unitHeight * candidate1.getSize();
        NumberTickUnit guess = new NumberTickUnit(bestguess, null);
        this.tickUnit = candidate2 = (NumberTickUnit)this.standardTickUnits.getCeilingTickUnit(guess);
    }

    public void refreshTicks(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        this.ticks.clear();
        g2.setFont(this.tickLabelFont);
        if (this.autoTickUnitSelection) {
            this.selectAutoTickUnit(g2, drawArea, plotArea);
        }
        double size = this.tickUnit.getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        int i = 0;
        while (i < count) {
            double currentTickValue = lowestTickValue + (double)i * size;
            double yy = this.translateValueToJava2D(currentTickValue, plotArea);
            String tickLabel = this.tickUnit.valueToString(currentTickValue);
            Rectangle2D tickLabelBounds = this.tickLabelFont.getStringBounds(tickLabel, g2.getFontRenderContext());
            float x = (float)(plotArea.getX() - tickLabelBounds.getWidth() - (double)this.tickLabelInsets.left - (double)this.tickLabelInsets.right);
            float y = (float)(yy + tickLabelBounds.getHeight() / 2.0);
            Tick tick = new Tick(new Double(currentTickValue), tickLabel, x, y);
            this.ticks.add(tick);
            ++i;
        }
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalValuePlot;
    }
}

