/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalCategoryPlot
extends CategoryPlot
implements VerticalValuePlot {
    public VerticalCategoryPlot(CategoryDataset data, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer) {
        this(data, domainAxis, rangeAxis, renderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15);
    }

    public VerticalCategoryPlot(CategoryDataset data, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float foregroundAlpha, double introGapPercent, double trailGapPercent, double categoryGapPercent, double itemGapPercent) {
        super(data, domainAxis, rangeAxis, renderer, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, foregroundAlpha, introGapPercent, trailGapPercent, categoryGapPercent, itemGapPercent);
    }

    public CategoryDataset getCategoryDataset() {
        return (CategoryDataset)this.dataset;
    }

    public ValueAxis getVerticalValueAxis() {
        return this.rangeAxis;
    }

    public double getCategoryCoordinate(int category, Rectangle2D area) {
        double result = area.getX() + area.getWidth() * this.introGapPercent;
        int categoryCount = this.getCategoryDataset().getCategoryCount();
        if (categoryCount > 1) {
            double categorySpan = area.getWidth() * (1.0 - this.introGapPercent - this.trailGapPercent - this.categoryGapsPercent);
            double categoryGapSpan = area.getWidth() * this.categoryGapsPercent;
            result = result + ((double)category + 0.5) * (categorySpan / (double)categoryCount) + (double)category * (categoryGapSpan / (double)(categoryCount - 1));
        } else {
            result += ((double)category + 0.5) * area.getWidth() * (1.0 - this.introGapPercent - this.trailGapPercent);
        }
        return result;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof CategoryAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public boolean isCompatibleDomainAxis(CategoryAxis axis) {
        if (axis == null) {
            return true;
        }
        return this.isCompatibleHorizontalAxis(axis);
    }

    public boolean isCompatibleRangeAxis(ValueAxis axis) {
        if (axis == null) {
            return true;
        }
        return this.isCompatibleVerticalAxis(axis);
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (plotArea.getWidth() >= 10.0 && plotArea.getHeight() >= 10.0) {
            Rectangle2D axisArea = plotArea;
            if (this.renderer != null) {
                axisArea = this.renderer.getAxisArea(plotArea);
            }
            double hAxisAreaHeight = 0.0;
            if (this.domainAxis != null) {
                HorizontalAxis hAxis = (HorizontalAxis)((Object)this.domainAxis);
                hAxisAreaHeight = hAxis.reserveHeight(g2, this, axisArea);
            }
            double vAxisWidth = 0.0;
            if (this.rangeAxis != null) {
                VerticalAxis vAxis = (VerticalAxis)((Object)this.rangeAxis);
                vAxisWidth = vAxis.reserveAxisArea(g2, this, axisArea, hAxisAreaHeight).getWidth();
            }
            Rectangle2D.Double dataArea = new Rectangle2D.Double(plotArea.getX() + vAxisWidth, plotArea.getY(), plotArea.getWidth() - vAxisWidth, plotArea.getHeight() - hAxisAreaHeight);
            Rectangle2D.Double axisDataArea = new Rectangle2D.Double(axisArea.getX() + vAxisWidth, axisArea.getY(), axisArea.getWidth() - vAxisWidth, axisArea.getHeight() - hAxisAreaHeight);
            if (info != null) {
                info.setDataArea(dataArea);
            }
            Shape dataClipRegion = dataArea;
            if (this.renderer != null) {
                dataClipRegion = this.renderer.getDataClipRegion(dataArea);
            }
            if (this.renderer != null) {
                this.renderer.drawPlotBackground(g2, this, axisDataArea, dataClipRegion);
                Iterator iterator = this.markers.iterator();
                while (iterator.hasNext()) {
                    Marker marker = (Marker)iterator.next();
                    this.renderer.drawRangeMarker(g2, this, this.getRangeAxis(), marker, axisDataArea, dataClipRegion);
                }
            }
            this.getDomainAxis().draw(g2, axisArea, axisDataArea);
            this.getRangeAxis().draw(g2, axisArea, axisDataArea);
            this.render(g2, axisDataArea, info, dataClipRegion);
        }
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, Shape backgroundPlotArea) {
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            Shape savedClip = g2.getClip();
            g2.clip(backgroundPlotArea);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            int seriesCount = data.getSeriesCount();
            this.renderer.initialise(g2, dataArea, this, this.getRangeAxis(), data, info);
            int categoryIndex = 0;
            Object previousCategory = null;
            Iterator iterator = data.getCategories().iterator();
            while (iterator.hasNext()) {
                Object category = iterator.next();
                int series = 0;
                while (series < seriesCount) {
                    this.renderer.drawCategoryItem(g2, dataArea, this, this.getRangeAxis(), data, series, category, categoryIndex, previousCategory);
                    ++series;
                }
                ++categoryIndex;
                previousCategory = category;
            }
            ValueAxis vva = this.getRangeAxis();
            if (vva.isCrosshairVisible()) {
                this.drawHorizontalLine(g2, dataArea, vva.getCrosshairValue(), vva.getCrosshairStroke(), vva.getCrosshairPaint());
            }
            g2.setClip(savedClip);
            g2.setComposite(originalComposite);
        }
    }

    public String getPlotType() {
        return "Vertical Category Plot";
    }

    public Range getVerticalDataRange() {
        Range result = null;
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            result = this.renderer != null && this.renderer.isStacked() ? DatasetUtilities.getStackedRangeExtent(data) : DatasetUtilities.getRangeExtent(data);
        }
        return result;
    }

    public Number getMinimumVerticalDataValue() {
        Number result = null;
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            result = this.renderer.isStacked() ? (Number)DatasetUtilities.getMinimumStackedRangeValue(data) : (Number)DatasetUtilities.getMinimumRangeValue(data);
        }
        return result;
    }

    public Number getMaximumVerticalDataValue() {
        Number result = null;
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            result = this.renderer.isStacked() ? (Number)DatasetUtilities.getMaximumStackedRangeValue(data) : (Number)DatasetUtilities.getMaximumRangeValue(data);
        }
        return result;
    }

    public void handleClick(int x, int y, ChartRenderingInfo info) {
        ValueAxis vva = this.getRangeAxis();
        double vvalue = vva.translateJava2DtoValue(y, info.getDataArea());
        vva.setAnchorValue(vvalue);
        vva.setCrosshairValue(vvalue);
    }

    private void drawHorizontalLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        double yy = this.getRangeAxis().translateValueToJava2D(value, dataArea);
        Line2D.Double line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
    }
}

