/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.data.MeterDataset;
import com.jrefinery.data.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.util.List;

public class ThermometerPlot
extends Plot
implements VerticalValuePlot {
    public static final int UNITS_NONE = 0;
    public static final int UNITS_FARINHEIGHT = 1;
    public static final int UNITS_CELCIUS = 2;
    public static final int UNITS_KELVIN = 3;
    protected static final String[] UNITS;
    protected MeterDataset data;
    protected int units = 2;
    RoundRectangle2D.Double outer1;
    RoundRectangle2D.Double outer2;
    RoundRectangle2D.Double outer3;
    Ellipse2D.Double circle1;
    Ellipse2D.Double circle2;
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int BULB = 2;
    protected int valueLocation = 2;
    protected static final int bulbRadius = 40;
    protected static final int bulbDiameter = 80;
    protected static final int columnRadius = 20;
    protected static final int columnDiameter = 40;
    protected static final int gapRadius = 5;
    protected static final int gapDiameter = 10;
    protected static final int legendWidth = 10;
    public static int NORMAL;
    public static int WARNING;
    public static int CRITICAL;
    protected int range = WARNING;
    protected int rangeData = WARNING;
    protected static final int RANGE_HI = 0;
    protected static final int RANGE_LOW = 1;
    protected static final int DISPLAY_HI = 2;
    protected static final int DISPLAY_LOW = 3;
    protected static final int DISPLAY_RANGE = 4;
    protected double[][] rangeInfo = new double[][]{{2.0, -10.0, 1.0, -10.0, 11.0}, {29.0, 0.0, 26.0, 0.0, 26.0}, {41.0, 20.0, 40.0, 20.0, 20.0}};
    protected Paint[] rangePaint = new Paint[]{Color.blue, Color.yellow, Color.red};
    protected Color outerColour = Color.black;
    protected Color valueColour = Color.white;
    protected Font valueFont = new Font("Arial", 1, 24);
    protected DecimalFormat valueFormat = new DecimalFormat();
    protected Stroke outerStroke = new BasicStroke(1.0f);
    protected Stroke rangeInidcatorStroke = new BasicStroke(3.0f);
    protected int rangeIndcatorStrokeSize = 3;
    protected boolean followValue = false;
    protected boolean drawLines = false;
    protected boolean ignoreDataModelRangeChanges = true;
    protected ValueAxis rangeAxis;

    public ThermometerPlot() {
        this(new DefaultMeterDataset());
    }

    public ThermometerPlot(MeterDataset data) {
        this(data, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f);
    }

    public ThermometerPlot(MeterDataset data, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float foregroundAlpha) {
        super(data, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, foregroundAlpha);
        this.data = data;
        if (data != null) {
            data.addChangeListener(this);
        }
        this.setInsets(insets);
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.outer1 = new RoundRectangle2D.Double();
        this.outer2 = new RoundRectangle2D.Double();
        this.outer3 = new RoundRectangle2D.Double();
        this.setRangeAxis(new VerticalNumberAxis(null));
        this.setAxisRange();
    }

    public void setRangeAxis(ValueAxis axis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(axis)) {
            if (axis != null) {
                try {
                    axis.setPlot(this);
                }
                catch (PlotNotCompatibleException e) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                axis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = axis;
    }

    public void zoom(double percent) {
    }

    public String getPlotType() {
        return "Thermometer Plot";
    }

    public MeterDataset getData() {
        return this.data;
    }

    public void setData(MeterDataset data) {
        MeterDataset existing = this.data;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.data = data;
        if (this.data != null) {
            data.addChangeListener(this);
        }
        PlotChangeEvent event = new PlotChangeEvent(this);
        this.notifyListeners(event);
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    protected static boolean isValidNumber(double i) {
        return !Double.isNaN(i) && !Double.isInfinite(i);
    }

    public void setValueFormat(DecimalFormat fo) {
        if (fo != null) {
            this.valueFormat = fo;
        }
    }

    public int getValueDisplayLocation() {
        return this.valueLocation;
    }

    public void setUnits(int u) {
        if (u >= 0 && u < UNITS.length && this.units != u) {
            this.units = u;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setUnits(String u) {
        if (u == null) {
            return;
        }
        u = u.toUpperCase().trim();
        int i = 0;
        while (i < UNITS.length) {
            if (u.equals(UNITS[i].toUpperCase().trim())) {
                this.setUnits(i);
                i = UNITS.length;
            }
            ++i;
        }
    }

    public void setFont(Font f) {
        if (f != null) {
            this.rangeAxis.setTickLabelFont(f);
            this.setValueFont(f);
        }
    }

    public void setValueFont(Font f) {
        if (f != null && !this.valueFont.equals(f)) {
            this.valueFont = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public int getUnits() {
        return this.units;
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setRangePaint(int range, Paint paint) {
        if (range >= 0 && range < this.rangePaint.length && paint != null) {
            this.rangePaint[range] = paint;
        }
    }

    public Paint getRangePaint(int range) {
        if (range >= 0 && range < this.rangePaint.length) {
            return this.rangePaint[range];
        }
        return Color.black;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        int i = 0;
        int j = 0;
        int l = 0;
        int k = 0;
        int tickY = 0;
        int tickX1 = 0;
        int tickX2 = 0;
        String temp = null;
        FontMetrics metrics = null;
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        this.drawOutlineAndBackground(g2, plotArea);
        int midX = (int)(plotArea.getX() + plotArea.getWidth() / 2.0);
        int midY = (int)(plotArea.getY() + plotArea.getHeight() / 2.0);
        int ticksYStart = (int)(plotArea.getMinY() + 40.0);
        int ticksYStop = (int)(plotArea.getMaxY() - 80.0);
        this.circle1.setFrame(midX - 40, ticksYStop, 80.0, 80.0);
        k = ticksYStop + 5;
        i = 70;
        j = 35;
        this.circle2.setFrame(midX - j, k, i, i);
        this.outer1.setRoundRect(midX - 20, plotArea.getMinY(), 40.0, k, 40.0, 40.0);
        i = 30;
        j = 15;
        this.outer2.setRoundRect(midX - j, plotArea.getMinY() + 5.0, i, k, i, i);
        Area a1 = new Area(this.circle1);
        Area a2 = new Area(this.outer1);
        a1.add(a2);
        a2 = new Area(this.outer2);
        Area a3 = new Area(this.circle2);
        a2.add(a3);
        if (this.data != null && this.data.isValueValid()) {
            double current = this.data.getValue().doubleValue();
            this.rangeData = this.range;
            switch (this.range) {
                case 0: {
                    if (current > this.rangeInfo[1][0]) {
                        this.range = 2;
                    }
                    if (!(current > this.rangeInfo[0][0])) break;
                    this.range = 1;
                    break;
                }
                case 1: {
                    if (current > this.rangeInfo[1][2]) {
                        this.range = 2;
                    }
                    if (!(current < this.rangeInfo[1][3])) break;
                    this.range = 0;
                    break;
                }
                case 2: {
                    if (current < this.rangeInfo[2][1]) {
                        this.range = 1;
                    }
                    if (!(current < this.rangeInfo[1][1])) break;
                    this.range = 0;
                    break;
                }
                default: {
                    this.range = 1;
                }
            }
            if (this.rangeData != this.range) {
                this.setAxisRange();
            }
            this.rangeData = this.range;
            if (this.followValue && this.range == 1) {
                if (current < this.rangeInfo[0][0]) {
                    this.rangeData = 0;
                }
                if (current > this.rangeInfo[2][1]) {
                    this.rangeData = 2;
                }
            }
            double ds = (current - this.rangeInfo[this.range][3]) / this.rangeInfo[this.range][4] * (double)(ticksYStop - ticksYStart);
            i = 30;
            j = 15;
            l = i / 2;
            k = (int)((long)ticksYStop - Math.round(ds));
            if ((double)k < 5.0 + plotArea.getMinY()) {
                k = (int)(5.0 + plotArea.getMinY());
                l = 40;
            }
            if (k < ticksYStop + 40) {
                this.outer3.setRoundRect(midX - j, k, i, ticksYStop + 40 - k, l, l);
                Area a4 = new Area(this.outer3);
                a3.add(a4);
            }
            g2.setPaint(this.rangePaint[this.rangeData]);
            g2.fill(a3);
            i = 0;
            if (this.drawLines) {
                i += 40;
            }
            Rectangle2D.Double drawArea = new Rectangle2D.Double(midX - 20 - 10, ticksYStart, 10 + i, ticksYStop - ticksYStart + 1);
            this.rangeAxis.draw(g2, plotArea, drawArea);
            g2.setStroke(this.rangeInidcatorStroke);
            if (this.rangeIndcatorStrokeSize > 0) {
                double incY = (double)(ticksYStop - ticksYStart) / this.rangeInfo[this.range][4];
                tickX1 = midX + 20 + this.rangeIndcatorStrokeSize;
                tickX2 = tickX1 + 10;
                if (this.inRange(this.range, this.rangeInfo[1][1])) {
                    tickY = ticksYStart;
                    g2.setPaint(this.rangePaint[1]);
                    g2.drawLine(tickX1, tickY += (int)(incY * (this.rangeInfo[this.range][2] - this.rangeInfo[1][1])), tickX2, tickY);
                }
                if (this.inRange(this.range, this.rangeInfo[2][1])) {
                    tickY = ticksYStart;
                    g2.setPaint(this.rangePaint[2]);
                    g2.drawLine(tickX1, tickY += (int)(incY * (this.rangeInfo[this.range][2] - this.rangeInfo[2][1])), tickX2, tickY);
                }
            }
            g2.setFont(this.valueFont);
            g2.setColor(this.valueColour);
            metrics = g2.getFontMetrics();
            switch (this.valueLocation) {
                case 1: {
                    g2.drawString(this.valueFormat.format(current), midX + 20 + 5, midY);
                    break;
                }
                case 2: {
                    temp = this.valueFormat.format(current);
                    i = metrics.stringWidth(temp) / 2;
                    g2.drawString(temp, midX - i, ticksYStop + 40 + 5);
                    break;
                }
            }
        }
        g2.setColor(this.outerColour);
        g2.setFont(this.valueFont);
        metrics = g2.getFontMetrics();
        tickX1 = midX - 20 - 10 - metrics.stringWidth(UNITS[this.units]);
        if ((double)tickX1 > plotArea.getMinX()) {
            g2.drawString(UNITS[this.units], tickX1, (int)(plotArea.getMinY() + 20.0));
        }
        if (this.outerColour != null) {
            g2.setStroke(this.outerStroke);
            g2.draw(a1);
            g2.draw(a2);
        }
    }

    public void setRangeInfo(int range, double low, double hi) {
        this.setRangeInfo(range, low, hi, low, hi);
    }

    public void setRangeInfo(int range, double range_low, double range_hi, double display_low, double display_hi) {
        if (range >= 0 && range < 3) {
            this.setRange(range, range_low, range_hi);
            this.setDisplayRange(range, display_low, display_hi);
        }
    }

    public void setRange(int range, double low, double hi) {
        if (range >= 0 && range < 3) {
            this.rangeInfo[range][0] = hi;
            this.rangeInfo[range][1] = low;
        }
    }

    public void setDisplayRange(int range, double low, double hi) {
        if (range >= 0 && range < this.rangePaint.length && ThermometerPlot.isValidNumber(hi) && ThermometerPlot.isValidNumber(low)) {
            if (hi > low) {
                this.rangeInfo[range][2] = hi;
                this.rangeInfo[range][3] = low;
            } else {
                this.rangeInfo[range][2] = hi;
                this.rangeInfo[range][3] = low;
            }
            this.rangeInfo[range][4] = this.rangeInfo[range][2] - this.rangeInfo[range][3];
        }
    }

    public void setDisplayLocation(int loc) {
        if (loc >= 0 && loc < 3) {
            this.valueLocation = loc;
        }
    }

    public void setThermometerColor(Color c) {
        this.outerColour = c;
    }

    private boolean inRange(int range, double value) {
        return this.rangeInfo[range][2] > value && this.rangeInfo[range][3] < value;
    }

    private void checkDataModelData() {
        if (this.data != null) {
            Number test = this.data.getMaximumCriticalValue();
            if (test != null) {
                this.rangeInfo[ThermometerPlot.CRITICAL][0] = test.doubleValue();
            }
            if ((test = this.data.getMinimumCriticalValue()) != null) {
                this.rangeInfo[ThermometerPlot.CRITICAL][1] = test.doubleValue();
            }
            if ((test = this.data.getMaximumWarningValue()) != null) {
                this.rangeInfo[ThermometerPlot.WARNING][0] = test.doubleValue();
            }
            if ((test = this.data.getMinimumWarningValue()) != null) {
                this.rangeInfo[ThermometerPlot.WARNING][1] = test.doubleValue();
            }
            if ((test = this.data.getMaximumNormalValue()) != null) {
                this.rangeInfo[ThermometerPlot.NORMAL][0] = test.doubleValue();
            }
            if ((test = this.data.getMinimumNormalValue()) != null) {
                this.rangeInfo[ThermometerPlot.NORMAL][1] = test.doubleValue();
            }
        }
    }

    public void datasetChanged(DatasetChangeEvent event) {
        if (!this.ignoreDataModelRangeChanges) {
            this.checkDataModelData();
        }
        super.datasetChanged(event);
    }

    public Number getMinimumVerticalDataValue() {
        return new Double(this.rangeInfo[this.range][3]);
    }

    public Number getMaximumVerticalDataValue() {
        return new Double(this.rangeInfo[this.range][2]);
    }

    public Range getVerticalDataRange() {
        return new Range(this.rangeInfo[this.range][3], this.rangeInfo[this.range][2]);
    }

    public void setShowValueLines(boolean b) {
        this.drawLines = b;
    }

    public boolean getShowValueLines(boolean b) {
        return this.drawLines;
    }

    public void setFollowData(boolean v) {
        this.followValue = v;
    }

    public boolean getFollowData() {
        return this.followValue;
    }

    public void setRangeIndicatorWidth(int width) {
        if (width != this.rangeIndcatorStrokeSize && width >= 0 && width < 16) {
            this.rangeIndcatorStrokeSize = width;
            this.rangeInidcatorStroke = new BasicStroke(width);
        }
    }

    public int getRangeIndicatorWidth() {
        return this.rangeIndcatorStrokeSize;
    }

    public void setOuterStoke(Stroke s) {
        if (s != null) {
            this.outerStroke = s;
        }
    }

    public Stroke getOuterStroke() {
        return this.outerStroke;
    }

    public void propertyChange() {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected void setAxisRange() {
        this.rangeAxis.setRange(new Range(this.rangeInfo[this.range][3], this.rangeInfo[this.range][2]));
    }

    public List getLegendItemLabels() {
        return null;
    }

    public boolean isCompatibleRangeAxis(ValueAxis axis) {
        if (axis == null) {
            return true;
        }
        return axis instanceof VerticalAxis;
    }

    public ValueAxis getVerticalValueAxis() {
        return this.rangeAxis;
    }

    static {
        UNITS_NONE = 0;
        UNITS_FARINHEIGHT = 1;
        UNITS_CELCIUS = 2;
        UNITS_KELVIN = 3;
        UNITS = new String[]{"", "\u00b0F", "\u00b0C", "\u00b0K"};
        NONE = 0;
        LEFT = 1;
        BULB = 2;
        bulbRadius = 40;
        bulbDiameter = 80;
        columnRadius = 20;
        columnDiameter = 40;
        gapRadius = 5;
        gapDiameter = 10;
        legendWidth = 10;
        NORMAL = 0;
        WARNING = 1;
        CRITICAL = 2;
        RANGE_HI = 0;
        RANGE_LOW = 1;
        DISPLAY_HI = 2;
        DISPLAY_LOW = 3;
        DISPLAY_RANGE = 4;
    }
}

