/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.LegendChangeEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class StandardLegend
extends Legend {
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    protected Stroke outlineStroke;
    protected Paint outlinePaint;
    protected Paint backgroundPaint;
    protected Spacer innerGap;
    protected Font itemFont;
    protected Paint itemPaint;
    protected Stroke keyBoxOutlineStroke = new BasicStroke(0.5f);
    protected Paint keyBoxOutlinePaint = Color.lightGray;

    public StandardLegend(JFreeChart chart) {
        this(chart, 3, new Spacer(1, 2.0, 2.0, 2.0, 2.0), Color.white, new BasicStroke(), Color.gray, DEFAULT_FONT, Color.black);
    }

    public StandardLegend(JFreeChart chart, int outerGap, Spacer innerGap, Paint backgroundPaint, Stroke outlineStroke, Paint outlinePaint, Font itemFont, Paint itemPaint) {
        super(chart, outerGap);
        this.innerGap = innerGap;
        this.backgroundPaint = backgroundPaint;
        this.outlineStroke = outlineStroke;
        this.outlinePaint = outlinePaint;
        this.itemFont = itemFont;
        this.itemPaint = itemPaint;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getKeyBoxOutlineStroke() {
        return this.keyBoxOutlineStroke;
    }

    public void setKeyBoxOutlineStroke(Stroke stroke) {
        this.keyBoxOutlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getKeyBoxOutlinePaint() {
        return this.keyBoxOutlinePaint;
    }

    public void setKeyBoxOutlinePaint(Paint paint) {
        this.keyBoxOutlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D g2, Rectangle2D available) {
        return this.draw(g2, available, (this._anchor & 1) != 0, (this._anchor & 2) != 0);
    }

    protected Rectangle2D draw(Graphics2D g2, Rectangle2D available, boolean horizontal, boolean inverted) {
        List legendItemLabels = this.chart.getPlot().getLegendItemLabels();
        if (legendItemLabels != null && legendItemLabels.size() > 0) {
            Rectangle2D legendArea = new Rectangle2D.Double();
            Point2D.Double translation = new Point2D.Double();
            LegendItem[] items = new LegendItem[legendItemLabels.size()];
            g2.setFont(this.itemFont);
            if (horizontal) {
                double xstart = available.getX() + (double)this.outerGap;
                double xlimit = available.getX() + available.getWidth() - (double)(2 * this.outerGap) - 1.0;
                double maxRowWidth = 0.0;
                double xoffset = 0.0;
                double rowHeight = 0.0;
                double totalHeight = 0.0;
                boolean startingNewRow = true;
                int i = 0;
                while (i < legendItemLabels.size()) {
                    items[i] = this.createLegendItem(g2, legendItemLabels.get(i).toString(), xoffset, totalHeight);
                    if (!startingNewRow && items[i].getX() + items[i].getWidth() + xstart > xlimit) {
                        maxRowWidth = Math.max(maxRowWidth, xoffset);
                        xoffset = 0.0;
                        totalHeight += rowHeight;
                        --i;
                        startingNewRow = true;
                    } else {
                        rowHeight = Math.max(rowHeight, items[i].getHeight());
                        xoffset += items[i].getWidth();
                        startingNewRow = false;
                    }
                    ++i;
                }
                maxRowWidth = Math.max(maxRowWidth, xoffset);
                legendArea = new Rectangle2D.Double(0.0, 0.0, maxRowWidth, totalHeight += rowHeight);
                double yloc = inverted ? available.getY() + available.getHeight() - totalHeight - (double)this.outerGap : available.getY() + (double)this.outerGap;
                double xloc = available.getX() + available.getWidth() / 2.0 - maxRowWidth / 2.0;
                translation = new Point2D.Double(xloc, yloc);
            } else {
                double totalHeight = 0.0;
                double maxWidth = 0.0;
                g2.setFont(this.itemFont);
                int i = 0;
                while (i < items.length) {
                    items[i] = this.createLegendItem(g2, legendItemLabels.get(i).toString(), 0.0, totalHeight);
                    totalHeight += items[i].getHeight();
                    maxWidth = Math.max(maxWidth, items[i].getWidth());
                    ++i;
                }
                legendArea = new Rectangle2D.Float(0.0f, 0.0f, (float)maxWidth, (float)totalHeight);
                double xloc = inverted ? available.getMaxX() - maxWidth - (double)this.outerGap : available.getX() + (double)this.outerGap;
                double yloc = available.getY() + available.getHeight() / 2.0 - totalHeight / 2.0;
                translation = new Point2D.Double(xloc, yloc);
            }
            g2.translate(((Point2D)translation).getX(), ((Point2D)translation).getY());
            g2.setPaint(this.backgroundPaint);
            g2.fill(legendArea);
            g2.setPaint(this.outlinePaint);
            g2.setStroke(this.outlineStroke);
            g2.draw(legendArea);
            int i = 0;
            while (i < items.length) {
                g2.setPaint(this.chart.getPlot().getSeriesPaint(i));
                Shape keyBox = items[i].getMarker();
                g2.fill(keyBox);
                if (this.outlineKeyBoxes) {
                    g2.setPaint(this.keyBoxOutlinePaint);
                    g2.setStroke(this.keyBoxOutlineStroke);
                    g2.draw(keyBox);
                }
                g2.setPaint(this.itemPaint);
                g2.drawString(items[i].label, (float)items[i].labelPosition.getX(), (float)items[i].labelPosition.getY());
                ++i;
            }
            g2.translate(-((Point2D)translation).getX(), -((Point2D)translation).getY());
            if (horizontal) {
                double yloc = inverted ? available.getY() : available.getY() + legendArea.getHeight() + (double)this.outerGap;
                return new Rectangle2D.Double(available.getX(), yloc, available.getWidth(), available.getHeight() - legendArea.getHeight() - (double)(2 * this.outerGap));
            }
            double xloc = inverted ? available.getX() : available.getX() + legendArea.getWidth() + (double)(2 * this.outerGap);
            return new Rectangle2D.Double(xloc, available.getY(), available.getWidth() - legendArea.getWidth() - (double)(2 * this.outerGap), available.getHeight());
        }
        return available;
    }

    private Rectangle2D getLegendBox(int series, int seriesCount, float textHeight, Rectangle2D innerLegendArea) {
        int innerGap = 2;
        float boxHeightAndWidth = textHeight * 0.7f;
        float xx = (float)innerLegendArea.getX() + (float)innerGap + 0.15f * textHeight;
        float yy = (float)innerLegendArea.getY() + (float)innerGap + ((float)series + 0.15f) * textHeight;
        return new Rectangle2D.Float(xx, yy, boxHeightAndWidth, boxHeightAndWidth);
    }

    private LegendItem createLegendItem(Graphics2D graphics, String label, double x, double y) {
        int innerGap = 2;
        FontMetrics fm = graphics.getFontMetrics();
        LineMetrics lm = fm.getLineMetrics(label, graphics);
        float textHeight = lm.getHeight();
        LegendItem item = new LegendItem(label);
        float xloc = (float)(x + (double)innerGap + (double)(1.15f * textHeight));
        float yloc = (float)(y + (double)innerGap + (double)(textHeight - lm.getLeading() - lm.getDescent()));
        item.labelPosition = new Point2D.Float(xloc, yloc);
        float boxDim = textHeight * 0.7f;
        xloc = (float)(x + (double)innerGap + (double)(0.15f * textHeight));
        yloc = (float)(y + (double)innerGap + (double)(0.15f * textHeight));
        item.setMarker(new Rectangle2D.Float(xloc, yloc, boxDim, boxDim));
        float width = (float)(item.labelPosition.getX() - x + fm.getStringBounds(label, graphics).getWidth() + 0.5 * (double)textHeight);
        float height = (float)(2 * innerGap) + textHeight;
        item.setBounds(x, y, width, height);
        return item;
    }
}

