/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalBarRenderer3D;
import com.jrefinery.chart.VerticalNumberAxis3D;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.data.CategoryDataset;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class StackedVerticalBarRenderer3D
extends VerticalBarRenderer3D {
    public boolean isStacked() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset data) {
        return 1;
    }

    public boolean hasItemGaps() {
        return false;
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Paint seriesPaint = plot.getSeriesPaint(series);
        Paint seriesOutlinePaint = plot.getSeriesOutlinePaint(series);
        double rectX = dataArea.getX() + dataArea.getWidth() * plot.getIntroGapPercent() + (double)categoryIndex * this.categorySpan / (double)data.getCategoryCount();
        if (data.getCategoryCount() > 1) {
            rectX += (double)categoryIndex * this.categoryGapSpan / (double)(data.getCategoryCount() - 1);
        }
        double positiveBase = 0.0;
        double negativeBase = 0.0;
        int i = 0;
        while (i < series) {
            Number v = data.getValue(i, category);
            if (v != null) {
                double d = v.doubleValue();
                if (d > 0.0) {
                    positiveBase += d;
                } else {
                    negativeBase += d;
                }
            }
            ++i;
        }
        Number value = data.getValue(series, category);
        if (value != null) {
            EntityCollection entities;
            double barY;
            double translatedValue;
            double translatedBase;
            double xx = value.doubleValue();
            if (xx > 0.0) {
                translatedBase = axis.translateValueToJava2D(positiveBase, dataArea);
                translatedValue = axis.translateValueToJava2D(positiveBase + xx, dataArea);
                barY = Math.min(translatedBase, translatedValue);
            } else {
                translatedBase = axis.translateValueToJava2D(negativeBase, dataArea);
                translatedValue = axis.translateValueToJava2D(negativeBase + xx, dataArea);
                barY = Math.min(translatedBase, translatedValue);
            }
            double rectWidth = this.itemWidth;
            double barHeight = Math.abs(translatedValue - translatedBase);
            Rectangle2D.Double bar = new Rectangle2D.Double(rectX, barY, rectWidth, barHeight);
            g2.setPaint(seriesPaint);
            g2.fill(bar);
            GeneralPath barR3d = null;
            GeneralPath barT3d = null;
            double effect3d = 0.0;
            VerticalAxis vAxis = (VerticalAxis)((Object)plot.getRangeAxis());
            if (barHeight != 0.0 && vAxis instanceof VerticalNumberAxis3D) {
                effect3d = ((VerticalNumberAxis3D)vAxis).getEffect3d();
                barR3d = new GeneralPath();
                barR3d.moveTo((float)(rectX + rectWidth), (float)barY);
                barR3d.lineTo((float)(rectX + rectWidth), (float)(barY + barHeight));
                barR3d.lineTo((float)(rectX + rectWidth + effect3d), (float)(barY + barHeight - effect3d));
                barR3d.lineTo((float)(rectX + rectWidth + effect3d), (float)(barY - effect3d));
                if (seriesPaint instanceof Color) {
                    g2.setPaint(((Color)seriesPaint).darker());
                }
                g2.fill(barR3d);
                if (xx > 0.0) {
                    barT3d = new GeneralPath();
                    barT3d.moveTo((float)rectX, (float)barY);
                    barT3d.lineTo((float)(rectX + effect3d), (float)(barY - effect3d));
                    barT3d.lineTo((float)(rectX + rectWidth + effect3d), (float)(barY - effect3d));
                    barT3d.lineTo((float)(rectX + rectWidth), (float)barY);
                    if (seriesPaint instanceof Color) {
                        g2.setPaint((Color)seriesPaint);
                    }
                    g2.fill(barT3d);
                }
            }
            if (rectWidth > 3.0) {
                g2.setStroke(plot.getSeriesOutlineStroke(series));
                g2.setPaint(seriesOutlinePaint);
                g2.draw(bar);
                if (barR3d != null) {
                    g2.draw(barR3d);
                }
                if (barT3d != null) {
                    g2.draw(barT3d);
                }
            }
            if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
                String tip = "";
                if (this.toolTipGenerator != null) {
                    tip = this.toolTipGenerator.generateToolTip(data, series, category);
                }
                CategoryItemEntity entity = new CategoryItemEntity(bar, tip, series, category, categoryIndex);
                entities.addEntity(entity);
            }
        }
    }
}

