/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalBarRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class StackedHorizontalBarRenderer
extends HorizontalBarRenderer {
    public StackedHorizontalBarRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    public StackedHorizontalBarRenderer(CategoryToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        double positiveBase = 0.0;
        double negativeBase = 0.0;
        int i = 0;
        while (i < series) {
            Number v = data.getValue(i, category);
            if (v != null) {
                double d = v.doubleValue();
                if (d > 0.0) {
                    positiveBase += d;
                } else {
                    negativeBase += d;
                }
            }
            ++i;
        }
        Number value = data.getValue(series, category);
        if (value != null) {
            EntityCollection entities;
            double rectX;
            double translatedValue;
            double translatedBase;
            double xx = value.doubleValue();
            if (xx > 0.0) {
                translatedBase = axis.translateValueToJava2D(positiveBase, dataArea);
                translatedValue = axis.translateValueToJava2D(positiveBase + xx, dataArea);
                rectX = Math.min(translatedBase, translatedValue);
            } else {
                translatedBase = axis.translateValueToJava2D(negativeBase, dataArea);
                translatedValue = axis.translateValueToJava2D(negativeBase + xx, dataArea);
                rectX = Math.min(translatedBase, translatedValue);
            }
            double rectY = dataArea.getY() + dataArea.getHeight() * plot.getIntroGapPercent() + (double)categoryIndex * this.categorySpan / (double)data.getCategoryCount();
            if (data.getCategoryCount() > 1) {
                rectY += (double)categoryIndex * this.categoryGapSpan / (double)(data.getCategoryCount() - 1);
            }
            double rectWidth = Math.abs(translatedValue - translatedBase);
            double rectHeight = this.itemWidth;
            Rectangle2D.Double bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
            Paint seriesPaint = plot.getSeriesPaint(series);
            g2.setPaint(seriesPaint);
            g2.fill(bar);
            if (this.itemWidth > 3.0) {
                g2.setStroke(plot.getSeriesStroke(series));
                g2.setPaint(plot.getSeriesOutlinePaint(series));
                g2.draw(bar);
            }
            if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
                String tip = "";
                if (this.toolTipGenerator != null) {
                    tip = this.toolTipGenerator.generateToolTip(data, series, category);
                }
                CategoryItemEntity entity = new CategoryItemEntity(bar, tip, series, category, categoryIndex);
                entities.addEntity(entity);
            }
        }
    }

    public boolean isStacked() {
        return true;
    }

    public boolean hasItemGaps() {
        return false;
    }

    public int barWidthsPerCategory(CategoryDataset data) {
        return 1;
    }
}

