/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

public class Spacer
implements Cloneable {
    public static final int RELATIVE = 0;
    public static final int ABSOLUTE = 1;
    protected int type;
    protected double left;
    protected double top;
    protected double right;
    protected double bottom;

    public Spacer(int type, double left, double top, double right, double bottom) {
        this.type = type;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public double getLeftSpace(double width) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.left;
        } else if (this.type == 0) {
            result = this.left * width;
        }
        return result;
    }

    public double getRightSpace(double width) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.right;
        } else if (this.type == 0) {
            result = this.right * width;
        }
        return result;
    }

    public double getTopSpace(double height) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.top;
        } else if (this.type == 0) {
            result = this.top * height;
        }
        return result;
    }

    public double getBottomSpace(double height) {
        double result = 0.0;
        if (this.type == 1) {
            result = this.bottom;
        } else if (this.type == 0) {
            result = this.bottom * height;
        }
        return result;
    }

    public double getAdjustedWidth(double width) {
        double result = width;
        if (this.type == 1) {
            result = result + this.left + this.right;
        } else if (this.type == 0) {
            result = result + this.left * width + this.right * width;
        }
        return result;
    }

    public double getAdjustedHeight(double height) {
        double result = height;
        if (this.type == 1) {
            result = result + this.top + this.bottom;
        } else if (this.type == 0) {
            result = result + this.top * height + this.bottom * height;
        }
        return result;
    }

    static {
        RELATIVE = 0;
        ABSOLUTE = 1;
    }
}

