/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class SignalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public double markOffset = 5.0;
    public double shapeWidth = 15.0;
    public double shapeHeight = 25.0;

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis horizontalAxis, ValueAxis verticalAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        SignalsDataset signalData = (SignalsDataset)data;
        Number x = signalData.getXValue(series, item);
        Number y = signalData.getYValue(series, item);
        int type = signalData.getType(series, item);
        double xx = horizontalAxis.translateValueToJava2D(x.doubleValue(), dataArea);
        double yy = verticalAxis.translateValueToJava2D(y.doubleValue(), dataArea);
        Paint p = plot.getSeriesPaint(series);
        Stroke s = plot.getSeriesStroke(series);
        g2.setPaint(p);
        g2.setStroke(s);
        int direction = 1;
        if (type == 1 || type == -2) {
            yy += this.markOffset;
            direction = -1;
        } else {
            yy -= this.markOffset;
        }
        GeneralPath path = new GeneralPath();
        if (type == 1 || type == -1) {
            path.moveTo((float)xx, (float)yy);
            path.lineTo((float)(xx + this.shapeWidth / 2.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)(xx + this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)(xx + this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight));
            path.lineTo((float)(xx - this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight));
            path.lineTo((float)(xx - this.shapeWidth / 6.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)(xx - this.shapeWidth / 2.0), (float)(yy - (double)direction * this.shapeHeight / 3.0));
            path.lineTo((float)xx, (float)yy);
        } else {
            path.moveTo((float)xx, (float)yy);
            path.lineTo((float)xx, (float)(yy - (double)direction * this.shapeHeight));
            Ellipse2D.Double ellipse = new Ellipse2D.Double(xx - this.shapeWidth / 2.0, yy + (direction == 1 ? -this.shapeHeight : this.shapeHeight - this.shapeWidth), this.shapeWidth, this.shapeWidth);
            path.append(ellipse, false);
        }
        g2.fill(path);
        g2.setPaint(Color.black);
        g2.draw(path);
        if (entities != null) {
            String tip = "";
            if (this.toolTipGenerator != null) {
                tip = this.toolTipGenerator.generateToolTip(data, series, item);
            }
            XYItemEntity entity = new XYItemEntity(path, tip, series, item);
            entities.addEntity(entity);
        }
    }
}

