/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ShapeFactory;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class SeriesShapeFactory
implements ShapeFactory {
    private static final int SHAPE_COUNT = 11;

    public Shape getShape(int series, int item, double x, double y, double scale) {
        return this.getShape(series, null, x, y, scale);
    }

    public Shape getShape(int series, Object category, double x, double y, double scale) {
        double delta = 0.5 * scale;
        int index = series % 11;
        int[] xpoints = null;
        int[] ypoints = null;
        switch (index) {
            case 0: {
                return new Rectangle2D.Double(x - delta, y - delta, scale, scale);
            }
            case 1: {
                return new Ellipse2D.Double(x - delta, y - delta, scale, scale);
            }
            case 2: {
                xpoints = SeriesShapeFactory.intArray(x, x + delta, x - delta);
                ypoints = SeriesShapeFactory.intArray(y - delta, y + delta, y + delta);
                return new Polygon(xpoints, ypoints, 3);
            }
            case 3: {
                xpoints = SeriesShapeFactory.intArray(x, x + delta, x, x - delta);
                ypoints = SeriesShapeFactory.intArray(y - delta, y, y + delta, y);
                return new Polygon(xpoints, ypoints, 4);
            }
            case 4: {
                return new Rectangle2D.Double(x - delta, y - delta / 2.0, scale, scale / 2.0);
            }
            case 5: {
                xpoints = SeriesShapeFactory.intArray(x - delta, x + delta, x);
                ypoints = SeriesShapeFactory.intArray(y - delta, y - delta, y + delta);
                return new Polygon(xpoints, ypoints, 3);
            }
            case 6: {
                return new Ellipse2D.Double(x - delta, y - delta / 2.0, scale, scale / 2.0);
            }
            case 7: {
                xpoints = SeriesShapeFactory.intArray(x - delta, x + delta, x - delta);
                ypoints = SeriesShapeFactory.intArray(y - delta, y, y + delta);
                return new Polygon(xpoints, ypoints, 3);
            }
            case 8: {
                return new Rectangle2D.Double(x - delta / 2.0, y - delta, scale / 2.0, scale);
            }
            case 9: {
                xpoints = SeriesShapeFactory.intArray(x - delta, x + delta, x + delta);
                ypoints = SeriesShapeFactory.intArray(y, y - delta, y + delta);
                return new Polygon(xpoints, ypoints, 3);
            }
        }
        return new Ellipse2D.Double(x - delta / 2.0, y - delta, scale / 2.0, scale);
    }

    private static int[] intArray(double a, double b, double c) {
        return new int[]{(int)a, (int)b, (int)c};
    }

    private static int[] intArray(double a, double b, double c, double d) {
        return new int[]{(int)a, (int)b, (int)c, (int)d};
    }

    static {
        SHAPE_COUNT = 11;
    }
}

