/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.entity.PieSectionEntity;
import com.jrefinery.chart.tooltips.StandardPieToolTipGenerator;
import com.jrefinery.data.PieDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Pie3DPlot
extends PiePlot {
    protected double depthFactor = 0.2;

    public Pie3DPlot(PieDataset data) throws AxisNotCompatibleException {
        super(data);
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        Paint paint;
        List categories;
        Rectangle2D clipArea;
        Shape savedClip = g2.getClip();
        Rectangle2D rectangle2D = clipArea = savedClip != null ? savedClip.getBounds2D().createIntersection(plotArea) : plotArea;
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        double gapHorizontal = plotArea.getWidth() * this.interiorGapPercent;
        double gapVertical = plotArea.getHeight() * this.interiorGapPercent;
        double pieX = plotArea.getX() + gapHorizontal / 2.0;
        double pieY = plotArea.getY() + gapVertical / 2.0;
        double pieW = plotArea.getWidth() - gapHorizontal;
        double pieH = plotArea.getHeight() - gapVertical;
        if (this.circular) {
            double min = Math.min(pieW, pieH) / 2.0;
            pieX = (pieX + pieX + pieW) / 2.0 - min;
            pieY = (pieY + pieY + pieH) / 2.0 - min;
            pieW = 2.0 * min;
            pieH = 2.0 * min;
        }
        Rectangle2D.Double explodedPieArea = new Rectangle2D.Double(pieX, pieY, pieW, pieH);
        double explodeHorizontal = (1.0 - this.radiusPercent) * pieW;
        double explodeVertical = (1.0 - this.radiusPercent) * pieH;
        Rectangle2D.Double pieArea = new Rectangle2D.Double(pieX + explodeHorizontal / 2.0, pieY + explodeVertical / 2.0, pieW - explodeHorizontal, pieH - explodeVertical);
        this.drawOutlineAndBackground(g2, plotArea);
        PieDataset data = this.getPieDataset();
        if (data == null) {
            return;
        }
        if ((double)data.getCategories().size() > plotArea.getWidth()) {
            String text = "Too many elements";
            Font sfont = new Font("dialog", 1, 10);
            g2.setFont(sfont);
            int stringWidth = (int)sfont.getStringBounds(text, g2.getFontRenderContext()).getWidth();
            g2.drawString(text, (int)(plotArea.getX() + (plotArea.getWidth() - (double)stringWidth) / 2.0), (int)(plotArea.getY() + plotArea.getHeight() / 2.0));
            return;
        }
        if (this.circular) {
            double min = Math.min(plotArea.getWidth(), plotArea.getHeight()) / 2.0;
            plotArea = new Rectangle2D.Double(plotArea.getCenterX() - min, plotArea.getCenterY() - min, 2.0 * min, 2.0 * min);
        }
        if ((categories = data.getCategories()).size() == 0) {
            return;
        }
        double arcX = ((RectangularShape)pieArea).getX();
        double arcY = ((RectangularShape)pieArea).getY();
        g2.clip(clipArea);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
        double totalValue = 0.0;
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            Number value;
            double v;
            Object current = iterator.next();
            if (current == null || !((v = (value = data.getValue(current)).doubleValue()) > 0.0)) continue;
            totalValue += v;
        }
        double sumTotal = 0.0;
        int depth = (int)(((RectangularShape)pieArea).getHeight() * this.depthFactor);
        if (depth < 0) {
            return;
        }
        ArrayList<Arc2D.Double> buttomArcList = new ArrayList<Arc2D.Double>();
        boolean hasElement = false;
        iterator = categories.iterator();
        while (iterator.hasNext()) {
            Object current = iterator.next();
            Number dataValue = data.getValue(current);
            double value = dataValue.doubleValue();
            if (value <= 0.0) {
                buttomArcList.add(null);
                continue;
            }
            hasElement = true;
            double startAngle = sumTotal * 360.0 / totalValue;
            double extent = (sumTotal + value) * 360.0 / totalValue - startAngle;
            buttomArcList.add(new Arc2D.Double(arcX, arcY + (double)depth, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth, startAngle, extent, 2));
            sumTotal += value;
        }
        Shape oldClip = g2.getClip();
        Paint outlinePaint = this.getSeriesOutlinePaint(0);
        Arc2D.Double arc = new Arc2D.Double(arcX, arcY + (double)depth, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth, 0.0, 360.0, 2);
        g2.setPaint(outlinePaint);
        if (hasElement) {
            g2.drawLine((int)arc.getMaxX(), (int)arc.getCenterY(), (int)arc.getMaxX(), (int)(arc.getCenterY() - (double)depth));
        }
        int categoryCount = buttomArcList.size();
        int categoryIndex = 0;
        while (categoryIndex < categoryCount) {
            arc = (Arc2D.Double)buttomArcList.get(categoryIndex);
            if (arc != null && !(arc.getAngleStart() + arc.getAngleExtent() < 180.0)) {
                Point2D p1 = arc.getAngleStart() > 180.0 ? arc.getStartPoint() : new Point2D.Double(arc.getMinX(), arc.getCenterY());
                Point2D p2 = arc.getEndPoint();
                paint = this.getSeriesPaint(categoryIndex);
                outlinePaint = this.getSeriesOutlinePaint(categoryIndex);
                g2.setClip(oldClip.getBounds2D().createIntersection(new Rectangle2D.Double(Math.min(p2.getX(), p1.getX()), arc.getMinY(), Math.abs(p2.getX() - p1.getX()), arc.getHeight() + 3.0)));
                g2.setPaint(paint);
                g2.fill(arc);
                g2.draw(arc);
                g2.setPaint(outlinePaint);
                arc.setArcType(0);
                g2.draw(arc);
                arc.setArcType(2);
                g2.setPaint(paint);
                int[] xs = new int[]{(int)p1.getX(), (int)p2.getX(), (int)p2.getX(), (int)p1.getX()};
                int[] ys = new int[]{(int)p1.getY(), (int)p2.getY(), (int)p2.getY() - depth, (int)p1.getY() - depth};
                Polygon ploygon = new Polygon(xs, ys, 4);
                g2.fill(ploygon);
                g2.setPaint(outlinePaint);
                g2.drawLine((int)p1.getX(), (int)p1.getY(), (int)p1.getX(), (int)p1.getY() - depth);
            }
            ++categoryIndex;
        }
        g2.setClip(oldClip);
        Rectangle2D.Double upperArcBound = new Rectangle2D.Double(((RectangularShape)pieArea).getX(), ((RectangularShape)pieArea).getY(), ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth);
        int categoryIndex2 = 0;
        while (categoryIndex2 < categoryCount) {
            arc = (Arc2D.Double)buttomArcList.get(categoryIndex2);
            if (arc != null) {
                Arc2D.Double upperArc = new Arc2D.Double(arcX, arcY, ((RectangularShape)pieArea).getWidth(), ((RectangularShape)pieArea).getHeight() - (double)depth, arc.getAngleStart(), arc.getAngleExtent(), 2);
                paint = this.getSeriesPaint(categoryIndex2);
                outlinePaint = this.getSeriesOutlinePaint(categoryIndex2);
                g2.setPaint(paint);
                g2.fill(upperArc);
                g2.setStroke(new BasicStroke());
                g2.setPaint(outlinePaint);
                g2.draw(upperArc);
                Object current = categories.get(categoryIndex2);
                if (info != null) {
                    if (this.toolTipGenerator == null) {
                        this.toolTipGenerator = new StandardPieToolTipGenerator();
                    }
                    String tip = this.toolTipGenerator.generateToolTip(data, current);
                    PieSectionEntity entity = new PieSectionEntity(arc, tip, current, categoryIndex2);
                    info.getEntityCollection().addEntity(entity);
                }
                if (this.sectionLabelType != 0) {
                    this.drawLabel(g2, upperArcBound, explodedPieArea, data, data.getValue(current).doubleValue(), categoryIndex2, arc.getAngleStart(), arc.getAngleExtent());
                }
            }
            ++categoryIndex2;
        }
        g2.clip(savedClip);
        g2.setComposite(originalComposite);
    }

    public String getPlotType() {
        return "Pie 3D Plot";
    }

    public void setDepthFactor(double newDepthFactor) {
        this.depthFactor = newDepthFactor;
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }
}

