/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlaidXYPlot
extends XYPlot {
    protected List subplots = new ArrayList();
    protected int seriesCount = 0;

    public OverlaidXYPlot(String domainAxisLabel, String rangeAxisLabel) {
        this(new HorizontalNumberAxis(domainAxisLabel), new VerticalNumberAxis(rangeAxisLabel));
    }

    public OverlaidXYPlot(ValueAxis domain, ValueAxis range) {
        super(null, domain, range);
    }

    public void add(XYPlot subplot) {
        ValueAxis range;
        subplot.setParent(this);
        subplot.setDomainAxis(null);
        subplot.setRangeAxis(null);
        subplot.setFirstSeriesIndex(this.seriesCount);
        this.seriesCount += subplot.getSeriesCount();
        this.subplots.add(subplot);
        ValueAxis domain = this.getDomainAxis();
        if (domain != null) {
            domain.configure();
        }
        if ((range = this.getRangeAxis()) != null) {
            range.configure();
        }
    }

    public List getLegendItemLabels() {
        ArrayList result = new ArrayList();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot plot = (XYPlot)iterator.next();
                List more = plot.getLegendItemLabels();
                result.addAll(more);
            }
        }
        return result;
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, CrosshairInfo crosshairInfo) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot subplot = (XYPlot)iterator.next();
            subplot.render(g2, dataArea, info, crosshairInfo);
        }
    }

    public String getPlotType() {
        return "Overlaid XY Plot";
    }

    public Range getHorizontalDataRange() {
        Range result = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot plot = (XYPlot)iterator.next();
                result = Range.combine(result, plot.getHorizontalDataRange());
            }
        }
        return result;
    }

    public Range getVerticalDataRange() {
        Range result = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot plot = (XYPlot)iterator.next();
                result = Range.combine(result, plot.getVerticalDataRange());
            }
        }
        return result;
    }

    public int getSeriesCount() {
        int result = 0;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot subplot = (XYPlot)iterator.next();
            result += subplot.getSeriesCount();
        }
        return result;
    }

    public void setFirstSeriesIndex(int index) {
        this.firstSeriesIndex = index;
        int seriesCount = index;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot subplot = (XYPlot)iterator.next();
            subplot.setFirstSeriesIndex(seriesCount);
            seriesCount += subplot.getSeriesCount();
        }
    }
}

