/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlaidVerticalCategoryPlot
extends VerticalCategoryPlot {
    protected List subplots;
    protected int seriesCount = 0;

    public OverlaidVerticalCategoryPlot(String domainAxisLabel, String rangeAxisLabel, Object[] categories) {
        this(new HorizontalCategoryAxis(domainAxisLabel), new VerticalNumberAxis(rangeAxisLabel), categories);
    }

    public OverlaidVerticalCategoryPlot(CategoryAxis domain, ValueAxis range, Object[] categories) {
        super(null, domain, range, null);
        double[][] emptyArray = new double[1][categories.length];
        DefaultCategoryDataset empty = new DefaultCategoryDataset(emptyArray);
        empty.setCategories(categories);
        this.setDataset(empty);
        this.subplots = new ArrayList();
    }

    public void add(VerticalCategoryPlot subplot) {
        ValueAxis range;
        subplot.setParent(this);
        subplot.setDomainAxis(null);
        subplot.setRangeAxis(null);
        subplot.setFirstSeriesIndex(this.seriesCount);
        this.seriesCount += subplot.getSeriesCount();
        this.subplots.add(subplot);
        CategoryAxis domain = this.getDomainAxis();
        if (domain != null) {
            domain.configure();
        }
        if ((range = this.getRangeAxis()) != null) {
            range.configure();
        }
    }

    public List getLegendItemLabels() {
        ArrayList result = new ArrayList();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot plot = (VerticalCategoryPlot)iterator.next();
                List more = plot.getLegendItemLabels();
                result.addAll(more);
            }
        }
        return result;
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, Shape backgroundPlotArea) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot subplot = (VerticalCategoryPlot)iterator.next();
            subplot.render(g2, dataArea, info, backgroundPlotArea);
        }
    }

    public String getPlotType() {
        return "Overlaid Vertical Category Plot";
    }

    public int getSeriesCount() {
        int result = 0;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot subplot = (VerticalCategoryPlot)iterator.next();
            result += subplot.getSeriesCount();
        }
        return result;
    }

    public void setFirstSeriesIndex(int index) {
        this.firstSeriesIndex = index;
        int seriesCount = index;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot subplot = (VerticalCategoryPlot)iterator.next();
            subplot.setFirstSeriesIndex(seriesCount);
            seriesCount += subplot.getSeriesCount();
        }
    }

    public Range getVerticalDataRange() {
        Range result = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot plot = (VerticalCategoryPlot)iterator.next();
                result = Range.combine(result, plot.getVerticalDataRange());
            }
        }
        return result;
    }

    public Number getMinimumVerticalDataValue() {
        Number result = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot plot = (VerticalCategoryPlot)iterator.next();
                Number subMin = plot.getMinimumVerticalDataValue();
                if (result == null) {
                    result = subMin;
                    continue;
                }
                if (subMin == null) continue;
                result = new Double(Math.min(result.doubleValue(), subMin.doubleValue()));
            }
        }
        return result;
    }

    public Number getMaximumVerticalDataValue() {
        Number result = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot plot = (VerticalCategoryPlot)iterator.next();
                Number subMax = plot.getMaximumVerticalDataValue();
                if (result == null) {
                    result = subMax;
                    continue;
                }
                if (subMax == null) continue;
                result = new Double(Math.max(result.doubleValue(), subMax.doubleValue()));
            }
        }
        return result;
    }
}

