/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.MeterDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.List;

public class MeterPlot
extends Plot {
    public static final String CRITICAL_TEXT = "Critical";
    public static final String WARNING_TEXT = "Warning";
    public static final String NORMAL_TEXT = "Normal";
    static final Color DEFAULT_NORMAL_COLOR;
    static final Color DEFAULT_WARNING_COLOR;
    static final Color DEFAULT_CRITICAL_COLOR;
    public static final int DEFAULT_METER_ANGLE = 270;
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final Color DEFAULT_BACKGROUND_COLOR;
    public static final Font DEFAULT_LABEL_FONT;
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    protected int labelType;
    protected Font labelFont;
    protected int meterCalcAngle = -1;
    protected double meterRange = -1.0;
    protected int meterAngle = 270;
    protected double minMeterValue = 0.0;
    protected TickUnits tickUnits = null;
    protected NumberTickUnit tickUnit = null;
    Color colorNormal = DEFAULT_NORMAL_COLOR;
    Color colorCritical = DEFAULT_CRITICAL_COLOR;
    Color colorWarning = DEFAULT_WARNING_COLOR;
    public static final int DIALTYPE_PIE = 0;
    public static final int DIALTYPE_CIRCLE = 1;
    public static final int DIALTYPE_CHORD = 2;
    protected int dialType = 1;
    protected Color dialBorderColor;
    protected boolean drawBorder;

    public MeterPlot(MeterDataset data) {
        this(data, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 1, DEFAULT_LABEL_FONT);
    }

    public MeterPlot(MeterDataset data, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float foregroundAlpha, int labelType, Font labelFont) {
        super(data, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, foregroundAlpha);
        this.labelType = labelType;
        this.labelFont = labelFont;
        this.setInsets(insets);
    }

    public List getLegendItemLabels() {
        return null;
    }

    public Color getNormalColor() {
        return this.colorNormal;
    }

    public Color getWarningColor() {
        return this.colorWarning;
    }

    public Color getCriticalColor() {
        return this.colorCritical;
    }

    public void setWarningColor(Color color) {
        this.colorWarning = color == null ? DEFAULT_WARNING_COLOR : color;
    }

    public void setCriticalColor(Color color) {
        this.colorCritical = color == null ? DEFAULT_CRITICAL_COLOR : color;
    }

    public void setNormalColor(Color color) {
        this.colorNormal = color == null ? DEFAULT_NORMAL_COLOR : color;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int angle) {
        this.meterAngle = angle;
    }

    public int getDialType() {
        return this.dialType;
    }

    public void setDialType(int type) {
        this.dialType = type;
    }

    public Color getDialBorderColor() {
        return this.dialBorderColor;
    }

    public void setDialBorderColor(Color color) {
        this.dialBorderColor = color;
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean draw) {
        this.drawBorder = draw;
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != type) {
            this.labelType = type;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("MeterPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public MeterDataset getMeterDataset() {
        return (MeterDataset)this.dataset;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        plotArea.setRect(plotArea.getX() + 4.0, plotArea.getY() + 4.0, plotArea.getWidth() - 8.0, plotArea.getHeight() - 8.0);
        if (this.drawBorder) {
            this.drawOutlineAndBackground(g2, plotArea);
        }
        double gapHorizontal = 6.0;
        double gapVertical = 6.0;
        double meterX = plotArea.getX() + gapHorizontal / 2.0;
        double meterY = plotArea.getY() + gapVertical / 2.0;
        double meterW = plotArea.getWidth() - gapHorizontal;
        double meterH = plotArea.getHeight() - gapVertical + (this.meterAngle <= 180 && this.dialType != 1 ? plotArea.getHeight() / 1.25 : 0.0);
        double min = Math.min(meterW, meterH) / 2.0;
        meterX = (meterX + meterX + meterW) / 2.0 - min;
        meterY = (meterY + meterY + meterH) / 2.0 - min;
        meterW = 2.0 * min;
        meterH = 2.0 * min;
        Rectangle2D.Double meterArea = new Rectangle2D.Double(meterX, meterY, meterW, meterH);
        Rectangle2D.Double originalArea = new Rectangle2D.Double(((RectangularShape)meterArea).getX() - 4.0, ((RectangularShape)meterArea).getY() - 4.0, ((RectangularShape)meterArea).getWidth() + 8.0, ((RectangularShape)meterArea).getHeight() + 8.0);
        double meterMiddleX = meterArea.getCenterX();
        double meterMiddleY = meterArea.getCenterY();
        MeterDataset data = this.getMeterDataset();
        if (data != null) {
            double dataMin = data.getMinimumValue().doubleValue();
            double dataMax = data.getMaximumValue().doubleValue();
            this.minMeterValue = dataMin;
            this.meterCalcAngle = 180 + (this.meterAngle - 180) / 2;
            this.meterRange = dataMax - dataMin;
            Shape savedClip = g2.getClip();
            g2.clip(originalArea);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            this.drawArc(g2, originalArea, dataMin, dataMax, Color.black, 1);
            this.drawTicks(g2, meterArea, dataMin, dataMax);
            this.drawArcFor(g2, meterArea, data, 3);
            this.drawArcFor(g2, meterArea, data, 0);
            this.drawArcFor(g2, meterArea, data, 1);
            this.drawArcFor(g2, meterArea, data, 2);
            if (data.isValueValid()) {
                double dataVal = data.getValue().doubleValue();
                this.drawTick(g2, meterArea, dataVal, true, Color.cyan, true, data.getUnits());
                g2.setColor(Color.green);
                g2.setStroke(new BasicStroke(2.0f));
                double radius = ((RectangularShape)meterArea).getWidth() / 2.0 + 3.0 + 15.0;
                double valueAngle = this.calculateAngle(dataVal);
                double valueP1 = meterMiddleX + radius * Math.cos(Math.PI * (valueAngle / 180.0));
                double valueP2 = meterMiddleY - radius * Math.sin(Math.PI * (valueAngle / 180.0));
                Polygon arrow = new Polygon();
                if (valueAngle > 135.0 && valueAngle < 225.0 || valueAngle < 45.0 && valueAngle > -45.0) {
                    double valueP3 = meterMiddleY - 2.5;
                    double valueP4 = meterMiddleY + 2.5;
                    arrow.addPoint((int)meterMiddleX, (int)valueP3);
                    arrow.addPoint((int)meterMiddleX, (int)valueP4);
                } else {
                    arrow.addPoint((int)(meterMiddleX - 2.5), (int)meterMiddleY);
                    arrow.addPoint((int)(meterMiddleX + 2.5), (int)meterMiddleY);
                }
                arrow.addPoint((int)valueP1, (int)valueP2);
                Ellipse2D.Double circle = new Ellipse2D.Double(meterMiddleX - 5.0, meterMiddleY - 5.0, 10.0, 10.0);
                g2.fill(arrow);
                g2.fill(circle);
            }
            g2.clip(savedClip);
            g2.setComposite(originalComposite);
        }
    }

    void drawArcFor(Graphics2D g2, Rectangle2D meterArea, MeterDataset data, int type) {
        Number minValue = null;
        Number maxValue = null;
        Color color = null;
        switch (type) {
            case 2: {
                minValue = data.getMinimumCriticalValue();
                maxValue = data.getMaximumCriticalValue();
                color = this.getCriticalColor();
                break;
            }
            case 1: {
                minValue = data.getMinimumWarningValue();
                maxValue = data.getMaximumWarningValue();
                color = this.getWarningColor();
                break;
            }
            case 0: {
                minValue = data.getMinimumNormalValue();
                maxValue = data.getMaximumNormalValue();
                color = this.getNormalColor();
                break;
            }
            case 3: {
                minValue = data.getMinimumValue();
                maxValue = data.getMaximumValue();
                color = DEFAULT_BACKGROUND_COLOR;
                break;
            }
            default: {
                return;
            }
        }
        if (minValue != null && maxValue != null) {
            double dataMin = data.getMinimumValue().doubleValue();
            if (data.getBorderType() == type) {
                this.drawArc(g2, meterArea, minValue.doubleValue(), data.getMinimumValue().doubleValue(), color);
                this.drawArc(g2, meterArea, data.getMaximumValue().doubleValue(), maxValue.doubleValue(), color);
            } else {
                this.drawArc(g2, meterArea, minValue.doubleValue(), maxValue.doubleValue(), color);
            }
            this.drawTick(g2, meterArea, minValue.doubleValue(), true, color);
            this.drawTick(g2, meterArea, maxValue.doubleValue(), true, color);
        }
    }

    void drawArc(Graphics2D g2, Rectangle2D area, double minValue, double maxValue, Color color) {
        this.drawArc(g2, area, minValue, maxValue, color, 0);
    }

    void drawArc(Graphics2D g2, Rectangle2D area, double minValue, double maxValue, Color color, int outlineType) {
        double startAngle = this.calculateAngle(maxValue);
        double endAngle = this.calculateAngle(minValue);
        double extent = endAngle - startAngle;
        double x = area.getX();
        double y = area.getY();
        double w = area.getWidth();
        double h = area.getHeight();
        g2.setColor(color);
        if (outlineType > 0) {
            g2.setStroke(new BasicStroke(10.0f));
        } else {
            g2.setStroke(new BasicStroke(3.0f));
        }
        int joinType = 0;
        if (outlineType > 0) {
            switch (this.dialType) {
                case 0: {
                    joinType = 2;
                    break;
                }
                case 2: {
                    if (this.meterAngle > 180) {
                        joinType = 1;
                        break;
                    }
                    joinType = 2;
                    break;
                }
                case 1: {
                    joinType = 2;
                    extent = 360.0;
                }
            }
        }
        Arc2D.Double arc = new Arc2D.Double(x, y, w, h, startAngle, extent, joinType);
        if (outlineType > 0) {
            g2.fill(arc);
        } else {
            g2.draw(arc);
        }
    }

    double calculateAngle(double value) {
        double ret = (double)this.meterCalcAngle - (value -= this.minMeterValue) / this.meterRange * (double)this.meterAngle;
        return ret;
    }

    void drawTicks(Graphics2D g2, Rectangle2D meterArea, double minValue, double maxValue) {
        int numberOfTicks = 20;
        double diff = (maxValue - minValue) / (double)numberOfTicks;
        double i = minValue;
        while (i <= maxValue) {
            this.drawTick(g2, meterArea, i);
            i += diff;
        }
    }

    void drawTick(Graphics2D g2, Rectangle2D meterArea, double value) {
        this.drawTick(g2, meterArea, value, false, null, false, null);
    }

    void drawTick(Graphics2D g2, Rectangle2D meterArea, double value, boolean label, Color color) {
        this.drawTick(g2, meterArea, value, label, color, false, null);
    }

    void drawTick(Graphics2D g2, Rectangle2D meterArea, double value, boolean label, Color labelColor, boolean curValue, String units) {
        double valueAngle = this.calculateAngle(value);
        double meterMiddleX = meterArea.getCenterX();
        double meterMiddleY = meterArea.getCenterY();
        if (labelColor == null) {
            labelColor = Color.white;
        }
        g2.setColor(labelColor);
        g2.setStroke(new BasicStroke(2.0f));
        double valueP2X = 0.0;
        double valueP2Y = 0.0;
        if (!curValue) {
            double radius = meterArea.getWidth() / 2.0 + 3.0;
            double radius1 = radius - 15.0;
            double valueP1X = meterMiddleX + radius * Math.cos(Math.PI * (valueAngle / 180.0));
            double valueP1Y = meterMiddleY - radius * Math.sin(Math.PI * (valueAngle / 180.0));
            valueP2X = meterMiddleX + radius1 * Math.cos(Math.PI * (valueAngle / 180.0));
            valueP2Y = meterMiddleY - radius1 * Math.sin(Math.PI * (valueAngle / 180.0));
            Line2D.Double line = new Line2D.Double(valueP1X, valueP1Y, valueP2X, valueP2Y);
            g2.draw(line);
        } else {
            valueP2X = meterMiddleX;
            valueP2Y = meterMiddleY;
            valueAngle = 90.0;
        }
        if (this.labelType == 1 && label) {
            DecimalFormat df = new DecimalFormat("#,###,###,##0.00");
            String tickLabel = df.format(value);
            if (curValue && units != null) {
                tickLabel = tickLabel + "  " + units;
            }
            Rectangle2D tickLabelBounds = g2.getFont().getStringBounds(tickLabel, g2.getFontRenderContext());
            double x = valueP2X;
            double y = valueP2Y;
            if (curValue) {
                y += 10.0;
            }
            if (valueAngle == 90.0 || valueAngle == 270.0) {
                x -= tickLabelBounds.getWidth() / 2.0;
            } else if (valueAngle < 90.0 || valueAngle > 270.0) {
                x -= tickLabelBounds.getWidth();
            }
            y = valueAngle > 135.0 && valueAngle < 225.0 || valueAngle > 315.0 || valueAngle < 45.0 ? (y -= tickLabelBounds.getHeight() / 2.0) : (y += tickLabelBounds.getHeight() / 2.0);
            if (this.labelFont != null) {
                g2.setFont(this.labelFont);
            }
            g2.drawString(tickLabel, (float)x, (float)y);
        }
    }

    public String getPlotType() {
        return "Meter Plot";
    }

    public void zoom(double percent) {
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis == null;
    }

    static {
        CRITICAL_TEXT = CRITICAL_TEXT;
        WARNING_TEXT = WARNING_TEXT;
        NORMAL_TEXT = NORMAL_TEXT;
        DEFAULT_NORMAL_COLOR = Color.green;
        DEFAULT_WARNING_COLOR = Color.yellow;
        DEFAULT_CRITICAL_COLOR = Color.red;
        DEFAULT_METER_ANGLE = 270;
        DEFAULT_BORDER_SIZE = 3.0f;
        DEFAULT_CIRCLE_SIZE = 10.0f;
        DEFAULT_BACKGROUND_COLOR = Color.green;
        DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
        NO_LABELS = 0;
        VALUE_LABELS = 1;
        DIALTYPE_PIE = 0;
        DIALTYPE_CIRCLE = 1;
        DIALTYPE_CHORD = 2;
    }
}

