/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.MeterPlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.StandardLegend;
import com.jrefinery.chart.event.LegendChangeEvent;
import com.jrefinery.data.MeterDataset;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MeterLegend
extends StandardLegend {
    protected String legendText;
    public boolean showNormal = true;
    public boolean showCritical = true;
    public boolean showWarning = true;

    public MeterLegend(JFreeChart chart, String legendText) {
        this(chart, 3, new Spacer(1, 2.0, 2.0, 2.0, 2.0), Color.white, new BasicStroke(), Color.gray, StandardLegend.DEFAULT_FONT, Color.black, legendText);
    }

    public MeterLegend(JFreeChart chart, int outerGap, Spacer innerGap, Paint backgroundPaint, Stroke outlineStroke, Paint outlinePaint, Font itemFont, Paint itemPaint, String legendText) {
        super(chart, outerGap, innerGap, backgroundPaint, outlineStroke, outlinePaint, itemFont, itemPaint);
        this.legendText = legendText;
    }

    public String getLegendText() {
        return this.legendText;
    }

    public void setLegendText(String text) {
        this.legendText = text;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D g2, Rectangle2D available) {
        return this.draw(g2, available, (this._anchor & 1) != 0, (this._anchor & 2) != 0);
    }

    private boolean updateInformation(MeterPlot plot, MeterDataset data, int type, int index, String[] legendItemLabels, Color[] legendItemColors) {
        boolean ret = false;
        String label = null;
        Number minValue = null;
        Number maxValue = null;
        Color color = null;
        switch (type) {
            case 2: {
                minValue = data.getMinimumCriticalValue();
                maxValue = data.getMaximumCriticalValue();
                color = plot.getCriticalColor();
                label = "Critical";
                break;
            }
            case 1: {
                minValue = data.getMinimumWarningValue();
                maxValue = data.getMaximumWarningValue();
                color = plot.getWarningColor();
                label = "Warning";
                break;
            }
            case 0: {
                minValue = data.getMinimumNormalValue();
                maxValue = data.getMaximumNormalValue();
                color = plot.getNormalColor();
                label = "Normal";
                break;
            }
            case 3: {
                minValue = data.getMinimumValue();
                maxValue = data.getMaximumValue();
                color = MeterPlot.DEFAULT_BACKGROUND_COLOR;
                label = "Meter Graph";
                break;
            }
            default: {
                return false;
            }
        }
        if (minValue != null && maxValue != null) {
            double dataMin = data.getMinimumValue().doubleValue();
            label = data.getBorderType() == type ? label + "  Range: " + data.getMinimumValue().toString() + " to " + minValue.toString() + "  and  " + maxValue.toString() + " to " + data.getMaximumValue().toString() : label + "  Range: " + minValue.toString() + " to " + maxValue.toString();
            legendItemLabels[index] = label;
            legendItemColors[index] = color;
            ret = true;
        }
        return ret;
    }

    protected Rectangle2D draw(Graphics2D g2, Rectangle2D available, boolean horizontal, boolean inverted) {
        int legendCount = 0;
        Plot plot = this.chart.getPlot();
        if (!(plot instanceof MeterPlot)) {
            throw new IllegalArgumentException("Plot must be MeterPlot");
        }
        MeterPlot meterPlot = (MeterPlot)plot;
        MeterDataset data = meterPlot.getMeterDataset();
        legendCount = 1;
        ++legendCount;
        if (this.showCritical && data.getMinimumCriticalValue() != null) {
            ++legendCount;
        }
        if (this.showWarning && data.getMinimumWarningValue() != null) {
            ++legendCount;
        }
        if (this.showNormal && data.getMinimumNormalValue() != null) {
            ++legendCount;
        }
        String[] legendItemLabels = new String[legendCount];
        Color[] legendItemColors = new Color[legendCount];
        int currentItem = 0;
        legendItemLabels[currentItem] = this.legendText + (data.isValueValid() ? "   Current Value: " + data.getValue().toString() : "");
        legendItemColors[currentItem] = null;
        if (this.updateInformation(meterPlot, data, 3, ++currentItem, legendItemLabels, legendItemColors)) {
            ++currentItem;
        }
        if (this.showCritical && this.updateInformation(meterPlot, data, 2, currentItem, legendItemLabels, legendItemColors)) {
            ++currentItem;
        }
        if (this.showWarning && this.updateInformation(meterPlot, data, 1, currentItem, legendItemLabels, legendItemColors)) {
            ++currentItem;
        }
        if (this.showNormal && this.updateInformation(meterPlot, data, 0, currentItem, legendItemLabels, legendItemColors)) {
            ++currentItem;
        }
        if (legendItemLabels != null) {
            Rectangle2D legendArea = new Rectangle2D.Double();
            Point2D.Double translation = new Point2D.Double();
            LegendItem[] items = new LegendItem[legendItemLabels.length];
            g2.setFont(this.itemFont);
            if (horizontal) {
                double xstart = available.getX() + (double)this.outerGap;
                double xlimit = available.getX() + available.getWidth() - (double)(2 * this.outerGap) - 1.0;
                double maxRowWidth = 0.0;
                double xoffset = 0.0;
                double rowHeight = 0.0;
                double totalHeight = 0.0;
                boolean startingNewRow = true;
                int i = 0;
                while (i < legendItemLabels.length) {
                    items[i] = this.createLegendItem(g2, legendItemLabels[i], xoffset, totalHeight);
                    if (!startingNewRow && items[i].getX() + items[i].getWidth() + xstart > xlimit) {
                        maxRowWidth = Math.max(maxRowWidth, xoffset);
                        xoffset = 0.0;
                        totalHeight += rowHeight;
                        --i;
                        startingNewRow = true;
                    } else {
                        rowHeight = Math.max(rowHeight, items[i].getHeight());
                        xoffset += items[i].getWidth();
                        startingNewRow = false;
                    }
                    ++i;
                }
                maxRowWidth = Math.max(maxRowWidth, xoffset);
                legendArea = new Rectangle2D.Double(0.0, 0.0, maxRowWidth, totalHeight += rowHeight);
                double yloc = inverted ? available.getY() + available.getHeight() - totalHeight - (double)this.outerGap : available.getY() + (double)this.outerGap;
                double xloc = available.getX() + available.getWidth() / 2.0 - maxRowWidth / 2.0;
                translation = new Point2D.Double(xloc, yloc);
            } else {
                double totalHeight = 0.0;
                double maxWidth = 0.0;
                g2.setFont(this.itemFont);
                int i = 0;
                while (i < items.length) {
                    items[i] = this.createLegendItem(g2, legendItemLabels[i], 0.0, totalHeight);
                    totalHeight += items[i].getHeight();
                    maxWidth = Math.max(maxWidth, items[i].getWidth());
                    ++i;
                }
                legendArea = new Rectangle2D.Float(0.0f, 0.0f, (float)maxWidth, (float)totalHeight);
                double xloc = inverted ? available.getMaxX() - maxWidth - (double)this.outerGap : available.getX() + (double)this.outerGap;
                double yloc = available.getY() + available.getHeight() / 2.0 - totalHeight / 2.0;
                translation = new Point2D.Double(xloc, yloc);
            }
            g2.translate(((Point2D)translation).getX(), ((Point2D)translation).getY());
            g2.setPaint(this.backgroundPaint);
            g2.fill(legendArea);
            g2.setPaint(this.outlinePaint);
            g2.setStroke(this.outlineStroke);
            g2.draw(legendArea);
            int i = 0;
            while (i < items.length) {
                Color color = legendItemColors[i];
                if (color != null) {
                    g2.setPaint(color);
                    g2.fill(items[i].getMarker());
                }
                g2.setPaint(this.itemPaint);
                g2.drawString(items[i].label, (float)items[i].labelPosition.getX(), (float)items[i].labelPosition.getY());
                ++i;
            }
            g2.translate(-((Point2D)translation).getX(), -((Point2D)translation).getY());
            if (horizontal) {
                double yloc = inverted ? available.getY() : available.getY() + legendArea.getHeight() + (double)this.outerGap;
                return new Rectangle2D.Double(available.getX(), yloc, available.getWidth(), available.getHeight() - legendArea.getHeight() - (double)(2 * this.outerGap));
            }
            double xloc = inverted ? available.getX() : available.getX() + legendArea.getWidth() + (double)(2 * this.outerGap);
            return new Rectangle2D.Double(xloc, available.getY(), available.getWidth() - legendArea.getWidth() - (double)(2 * this.outerGap), available.getHeight());
        }
        return available;
    }

    private LegendItem createLegendItem(Graphics graphics, String label, double x, double y) {
        int innerGap = 2;
        FontMetrics fm = graphics.getFontMetrics();
        LineMetrics lm = fm.getLineMetrics(label, graphics);
        float textHeight = lm.getHeight();
        LegendItem item = new LegendItem(label);
        float xloc = (float)(x + (double)innerGap + (double)(1.15f * textHeight));
        float yloc = (float)(y + (double)innerGap + (double)(textHeight - lm.getLeading() - lm.getDescent()));
        item.labelPosition = new Point2D.Float(xloc, yloc);
        float boxDim = textHeight * 0.7f;
        xloc = (float)(x + (double)innerGap + (double)(0.15f * textHeight));
        yloc = (float)(y + (double)innerGap + (double)(0.15f * textHeight));
        item.setMarker(new Rectangle2D.Float(xloc, yloc, boxDim, boxDim));
        float width = (float)(item.labelPosition.getX() - x + fm.getStringBounds(label, graphics).getWidth() + 0.5 * (double)textHeight);
        float height = (float)(2 * innerGap) + textHeight;
        item.setBounds(x, y, width, height);
        return item;
    }
}

