/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.StandardLegend;
import com.jrefinery.chart.event.LegendChangeEvent;
import com.jrefinery.chart.event.LegendChangeListener;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Legend {
    public static final int WEST = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    protected static final int INVERTED = 2;
    protected static final int HORIZONTAL = 1;
    protected int _anchor = 3;
    protected JFreeChart chart;
    protected int outerGap;
    protected boolean outlineKeyBoxes;
    protected List listeners;

    public static Legend createInstance(JFreeChart chart) {
        return new StandardLegend(chart);
    }

    public Legend(JFreeChart chart, int outerGap) {
        this.chart = chart;
        this.outerGap = outerGap;
        this.listeners = new ArrayList();
    }

    public boolean getOutlineKeyBoxes() {
        return this.outlineKeyBoxes;
    }

    public void setOutlineKeyBoxes(boolean flag) {
        this.outlineKeyBoxes = flag;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public abstract Rectangle2D draw(Graphics2D var1, Rectangle2D var2);

    public void addChangeListener(LegendChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(LegendChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(LegendChangeEvent event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            LegendChangeListener listener = (LegendChangeListener)iterator.next();
            listener.legendChanged(event);
        }
    }

    public int getAnchor() {
        return this._anchor;
    }

    public void setAnchor(int anchor) {
        switch (anchor) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this._anchor = anchor;
                this.notifyListeners(new LegendChangeEvent(this));
                break;
            }
        }
    }

    static {
        WEST = 0;
        NORTH = 1;
        EAST = 2;
        SOUTH = 3;
        INVERTED = 2;
        HORIZONTAL = 1;
    }
}

