/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.TitleChangeEvent;
import com.jrefinery.ui.Size2D;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public class ImageTitle
extends AbstractTitle {
    protected Image image;
    protected int height;
    protected int width;

    public ImageTitle(Image image) {
        this(image, image.getHeight(null), image.getWidth(null), 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public ImageTitle(Image image, int position, int horizontalAlignment, int verticalAlignment) {
        this(image, position, image.getHeight(null), image.getWidth(null), horizontalAlignment, verticalAlignment, AbstractTitle.DEFAULT_SPACER);
    }

    public ImageTitle(Image image, int height, int width, int position, int horizontalAlignment, int verticalAlignment, Spacer spacer) {
        super(position, horizontalAlignment, verticalAlignment, spacer);
        this.image = image;
        this.height = height;
        this.width = width;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public void draw(Graphics2D g2, Rectangle2D titleArea) {
        if (this.position != 0 && this.position != 1) {
            throw new RuntimeException("ImageTitle.draw(...) - invalid title position.");
        }
        this.drawHorizontal(g2, titleArea);
    }

    public boolean isValidPosition(int position) {
        if (position == 0) {
            return true;
        }
        if (position == 1) {
            return true;
        }
        if (position == 2) {
            return true;
        }
        return position == 3;
    }

    public double getPreferredWidth(Graphics2D g2) {
        double result = this.width;
        if (this.spacer != null) {
            result = this.spacer.getAdjustedWidth(result);
        }
        return result;
    }

    public double getPreferredHeight(Graphics2D g2) {
        double result = this.height;
        if (this.spacer != null) {
            result = this.spacer.getAdjustedHeight(result);
        }
        return result;
    }

    protected Size2D drawHorizontal(Graphics2D g2, Rectangle2D chartArea) {
        double startY = 0.0;
        double topSpace = 0.0;
        double bottomSpace = 0.0;
        double leftSpace = 0.0;
        double rightSpace = 0.0;
        if (this.spacer != null) {
            topSpace = this.spacer.getTopSpace(this.height);
            bottomSpace = this.spacer.getBottomSpace(this.height);
            leftSpace = this.spacer.getLeftSpace(this.width);
            rightSpace = this.spacer.getRightSpace(this.width);
        }
        startY = this.position == 0 ? chartArea.getY() + topSpace : chartArea.getY() + chartArea.getHeight() - bottomSpace - (double)this.height;
        double startX = 0.0;
        if (this.horizontalAlignment == 4) {
            startX = chartArea.getX() + leftSpace + chartArea.getWidth() / 2.0 - (double)(this.width / 2);
        } else if (this.horizontalAlignment == 3) {
            startX = chartArea.getX() + leftSpace;
        } else if (this.horizontalAlignment == 2) {
            startX = chartArea.getX() + chartArea.getWidth() - rightSpace - (double)this.width;
        }
        g2.drawImage(this.image, (int)startX, (int)startY, this.width, this.height, null);
        return new Size2D(chartArea.getWidth() + leftSpace + rightSpace, (double)this.height + topSpace + bottomSpace);
    }
}

