/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class HorizontalNumberAxis3D
extends HorizontalNumberAxis {
    public static final double DEFAULT_EFFECT_3D = 10.0;
    private double effect3d = 10.0;

    public HorizontalNumberAxis3D() {
        this(null);
    }

    public HorizontalNumberAxis3D(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.autoRange = true;
    }

    public HorizontalNumberAxis3D(String label, Font labelFont, double minimumAxisValue, double maximumAxisValue) {
        this(label, labelFont, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, false, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, minimumAxisValue, maximumAxisValue, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, 10.0);
    }

    public HorizontalNumberAxis3D(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean verticalTickLabels, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, boolean autoRangeIncludesZero, boolean autoRangeStickyZero, Number autoRangeMinimumSize, double minimumAxisValue, double maximumAxisValue, boolean inverted, boolean autoTickUnitSelection, NumberTickUnit tickUnit, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, double crosshairValue, Stroke crosshairStroke, Paint crosshairPaint, double effect3d) {
        super(label, labelFont, labelPaint, labelInsets, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, verticalTickLabels, tickMarksVisible, tickMarkStroke, autoRange, autoRangeIncludesZero, autoRangeStickyZero, autoRangeMinimumSize, minimumAxisValue, maximumAxisValue, inverted, autoTickUnitSelection, tickUnit, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, crosshairValue, crosshairStroke, crosshairPaint);
        this.effect3d = effect3d;
    }

    public double getEffect3d() {
        return this.effect3d;
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea, Rectangle2D plotArea) {
        if (this.label != null) {
            g2.setFont(this.labelFont);
            g2.setPaint(this.labelPaint);
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D labelBounds = this.labelFont.getStringBounds(this.label, frc);
            LineMetrics lm = this.labelFont.getLineMetrics(this.label, frc);
            float labelx = (float)(plotArea.getX() + plotArea.getWidth() / 2.0 - labelBounds.getWidth() / 2.0);
            float labely = (float)(drawArea.getMaxY() - (double)this.labelInsets.bottom - (double)lm.getDescent() - (double)lm.getLeading());
            g2.drawString(this.label, labelx, labely);
        }
        this.refreshTicks(g2, drawArea, plotArea);
        float maxY = (float)plotArea.getMaxY();
        g2.setFont(this.getTickLabelFont());
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float xx = (float)this.translateValueToJava2D(tick.getNumericalValue(), plotArea);
            if (this.tickLabelsVisible) {
                g2.setPaint(this.tickLabelPaint);
                if (this.verticalTickLabels) {
                    RefineryUtilities.drawRotatedString(tick.getText(), g2, tick.getX(), tick.getY(), -1.5707963267948966);
                } else {
                    g2.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (this.tickMarksVisible) {
                g2.setStroke(this.getTickMarkStroke());
                Line2D.Float mark = new Line2D.Float(xx, maxY - 2.0f, xx, maxY + 2.0f);
                g2.draw(mark);
            }
            if (!this.gridLinesVisible) continue;
            g2.setStroke(this.gridStroke);
            g2.setPaint(this.gridPaint);
            Line2D.Double gridline = new Line2D.Double((double)xx + this.effect3d, plotArea.getMaxY() - this.effect3d, (double)xx + this.effect3d, plotArea.getMinY() - this.effect3d);
            g2.draw(gridline);
            Line2D.Double grid3Dline = new Line2D.Double(xx, plotArea.getMaxY(), (double)xx + this.effect3d, plotArea.getMaxY() - this.effect3d);
            g2.draw(grid3Dline);
        }
    }

    public double reserveHeight(Graphics2D g2, Plot plot, Rectangle2D drawArea) {
        double labelHeight = 0.0;
        if (this.label != null) {
            LineMetrics metrics = this.labelFont.getLineMetrics(this.label, g2.getFontRenderContext());
            labelHeight = (float)this.labelInsets.top + metrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double tickLabelHeight = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight += this.getMaxTickLabelHeight(g2, drawArea, this.verticalTickLabels);
        }
        return labelHeight + tickLabelHeight;
    }

    public Rectangle2D reserveAxisArea(Graphics2D g2, Plot plot, Rectangle2D drawArea, double reservedWidth) {
        double labelHeight = 0.0;
        if (this.label != null) {
            LineMetrics metrics = this.labelFont.getLineMetrics(this.label, g2.getFontRenderContext());
            labelHeight = (float)this.labelInsets.top + metrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double tickLabelHeight = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            g2.setFont(this.tickLabelFont);
            this.refreshTicks(g2, drawArea, drawArea);
            tickLabelHeight += this.getMaxTickLabelHeight(g2, drawArea, this.verticalTickLabels);
        }
        return new Rectangle2D.Double(drawArea.getX(), drawArea.getMaxY(), drawArea.getWidth() - reservedWidth, labelHeight + tickLabelHeight);
    }

    private double getMaxTickLabelHeight(Graphics2D g2, Rectangle2D drawArea, boolean vertical) {
        Font font = this.getTickLabelFont();
        g2.setFont(font);
        FontRenderContext frc = g2.getFontRenderContext();
        double maxHeight = 0.0;
        if (vertical) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D labelBounds = font.getStringBounds(tick.getText(), frc);
                if (!(labelBounds.getWidth() > maxHeight)) continue;
                maxHeight = labelBounds.getWidth();
            }
        } else {
            LineMetrics metrics = font.getLineMetrics("Sample", frc);
            maxHeight = metrics.getHeight();
        }
        return maxHeight;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }

    static {
        DEFAULT_EFFECT_3D = 10.0;
    }
}

