/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalBarRenderer;
import com.jrefinery.chart.HorizontalNumberAxis3D;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HorizontalBarRenderer3D
extends HorizontalBarRenderer {
    private static final double DEFAULT_EFFECT3D = 10.0;
    protected double effect3d;

    public HorizontalBarRenderer3D() {
        this(new StandardCategoryToolTipGenerator(), 10.0);
    }

    public HorizontalBarRenderer3D(CategoryToolTipGenerator toolTipGenerator, double effect3d) {
        super(toolTipGenerator);
        this.effect3d = effect3d;
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset data) {
        return data.getSeriesCount();
    }

    public Rectangle2D getAxisArea(Rectangle2D plotArea) {
        return new Rectangle2D.Double(plotArea.getX(), plotArea.getY() + this.effect3d, plotArea.getWidth() - this.effect3d, plotArea.getHeight() - this.effect3d);
    }

    public Shape getDataClipRegion(Rectangle2D dataArea) {
        GeneralPath result = new GeneralPath();
        result.moveTo((float)dataArea.getX(), (float)(dataArea.getMinY() + this.effect3d));
        result.lineTo((float)(dataArea.getX() + this.effect3d), (float)dataArea.getMinY());
        result.lineTo((float)dataArea.getMaxX(), (float)dataArea.getMinY());
        result.lineTo((float)dataArea.getMaxX(), (float)(dataArea.getMaxY() - this.effect3d));
        result.lineTo((float)(dataArea.getMaxX() - this.effect3d), (float)dataArea.getMaxY());
        result.lineTo((float)dataArea.getX(), (float)dataArea.getMaxY());
        result.closePath();
        return result;
    }

    public void drawPlotBackground(Graphics2D g2, CategoryPlot plot, Rectangle2D axisDataArea, Shape dataClipRegion) {
        super.drawPlotBackground(g2, plot, axisDataArea, dataClipRegion);
        double x1 = axisDataArea.getX();
        double x2 = x1 + this.effect3d;
        double x3 = axisDataArea.getMaxX() + this.effect3d;
        double y1 = axisDataArea.getMaxY();
        double y2 = y1 - this.effect3d;
        double y3 = axisDataArea.getMinY() - this.effect3d;
        g2.setPaint(plot.getOutlinePaint());
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        g2.draw(line);
        ((Line2D)line).setLine(x2, y2, x2, y3);
        g2.draw(line);
        ((Line2D)line).setLine(x2, y2, x3, y2);
        g2.draw(line);
    }

    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D axisDataArea, Shape dataClipRegion) {
        double value = marker.getValue();
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        float x = (float)axis.translateValueToJava2D(marker.getValue(), axisDataArea);
        float y = (float)axisDataArea.getMaxY();
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo((float)((double)x + this.effect3d), y - (float)this.effect3d);
        path.lineTo((float)((double)x + this.effect3d), (float)(axisDataArea.getMinY() - this.effect3d));
        path.lineTo(x, (float)axisDataArea.getMinY());
        path.closePath();
        g2.setPaint(marker.getPaint());
        g2.fill(path);
        g2.setPaint(marker.getOutlinePaint());
        g2.draw(path);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Number dataValue = data.getValue(series, category);
        if (dataValue != null) {
            double value = dataValue.doubleValue();
            double base = 0.0;
            if (this.upperClip <= 0.0) {
                if (value >= this.upperClip) {
                    return;
                }
                base = this.upperClip;
                if (value <= this.lowerClip) {
                    value = this.lowerClip;
                }
            } else if (this.lowerClip <= 0.0) {
                if (value >= this.upperClip) {
                    value = this.upperClip;
                } else if (value <= this.lowerClip) {
                    value = this.lowerClip;
                }
            } else {
                if (value <= this.lowerClip) {
                    return;
                }
                base = this.lowerClip;
                if (value >= this.upperClip) {
                    value = this.upperClip;
                }
            }
            double transX1 = axis.translateValueToJava2D(base, dataArea);
            double transX2 = axis.translateValueToJava2D(value, dataArea);
            double rectX = Math.min(transX1, transX2);
            double rectWidth = Math.abs(transX2 - transX1);
            double rectY = dataArea.getY() + dataArea.getHeight() * plot.getIntroGapPercent();
            int categories = data.getCategoryCount();
            int seriesCount = data.getSeriesCount();
            if (categories > 1) {
                rectY = rectY + (double)categoryIndex * this.categorySpan / (double)categories + (double)categoryIndex * this.categoryGapSpan / (double)(categories - 1) + (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            } else {
                rectY += (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            }
            double rectHeight = this.itemWidth;
            Rectangle2D.Double bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
            Paint seriesPaint = plot.getSeriesPaint(series);
            g2.setPaint(seriesPaint);
            g2.fill(bar);
            GeneralPath bar3dRight = null;
            GeneralPath bar3dTop = null;
            double effect3d = 0.0;
            HorizontalAxis hAxis = (HorizontalAxis)((Object)plot.getRangeAxis());
            if (rectWidth != 0.0 && hAxis instanceof HorizontalNumberAxis3D) {
                effect3d = ((HorizontalNumberAxis3D)hAxis).getEffect3d();
                bar3dRight = new GeneralPath();
                bar3dRight.moveTo((float)(rectX + rectWidth), (float)rectY);
                bar3dRight.lineTo((float)(rectX + rectWidth), (float)(rectY + rectHeight));
                bar3dRight.lineTo((float)(rectX + rectWidth + effect3d), (float)(rectY + rectHeight - effect3d));
                bar3dRight.lineTo((float)(rectX + rectWidth + effect3d), (float)(rectY - effect3d));
                if (seriesPaint instanceof Color) {
                    g2.setPaint((Color)seriesPaint);
                }
                g2.fill(bar3dRight);
                bar3dTop = new GeneralPath();
                bar3dTop.moveTo((float)rectX, (float)rectY);
                bar3dTop.lineTo((float)(rectX + effect3d), (float)(rectY - effect3d));
                bar3dTop.lineTo((float)(rectX + rectWidth + effect3d), (float)(rectY - effect3d));
                bar3dTop.lineTo((float)(rectX + rectWidth), (float)rectY);
                if (seriesPaint instanceof Color) {
                    g2.setPaint(((Color)seriesPaint).darker());
                }
                g2.fill(bar3dTop);
            }
            if (this.itemWidth > 3.0) {
                g2.setStroke(plot.getSeriesStroke(series));
                g2.setPaint(plot.getSeriesOutlinePaint(series));
                g2.draw(bar);
                if (bar3dRight != null) {
                    g2.draw(bar3dRight);
                }
                if (bar3dTop != null) {
                    g2.draw(bar3dTop);
                }
                if (plot.getLabelsVisible()) {
                    Font labelFont = plot.getLabelFont();
                    g2.setFont(labelFont);
                    Paint paint = plot.getLabelPaint();
                    g2.setPaint(paint);
                    g2.drawString(String.valueOf(dataValue), (int)(rectX + rectWidth * 0.9), (int)rectY - 15);
                }
            }
        }
    }

    static {
        DEFAULT_EFFECT3D = 10.0;
    }
}

