/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.DateUnit;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.DateRange;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DateAxis
extends ValueAxis {
    public static final Date DEFAULT_CROSSHAIR_DATE = null;
    protected Date anchorDate = new Date();
    protected Date crosshairDate;
    protected DateUnit tickUnit;
    protected SimpleDateFormat tickLabelFormatter;
    protected static long[] standardTickUnitMagnitudes = new long[]{1L, 5L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L, 300000L, 600000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 604800000L, 2592000000L, 7776000000L, 15552000000L, 31536000000L, 157680000000L, 315360000000L, 788400000000L, 1576800000000L, -1141367296000L};
    protected static int[][] standardTickUnits = new int[][]{{14, 1}, {14, 5}, {14, 10}, {14, 50}, {14, 100}, {14, 500}, {13, 1}, {13, 5}, {13, 10}, {13, 30}, {12, 1}, {12, 5}, {12, 10}, {12, 30}, {11, 1}, {11, 6}, {11, 12}, {5, 1}, {5, 7}, {2, 1}, {2, 3}, {2, 6}, {1, 1}, {1, 5}, {1, 10}, {1, 25}, {1, 50}, {1, 100}};
    protected static String[] standardTickFormats = new String[]{"HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss.SSS", "HH:mm:ss", "HH:mm:ss", "HH:mm:ss", "HH:mm:ss", "HH:mm", "HH:mm", "HH:mm", "HH:mm", "HH:mm", "d-MMM, H:mm", "d-MMM, H:mm", "d-MMM-yyyy", "d-MMM-yyyy", "MMM-yyyy", "MMM-yyyy", "MMM-yyyy", "yyyy", "yyyy", "yyyy", "yyyy", "yyyy", "yyyy"};

    protected DateAxis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, new DateRange(), true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    protected DateAxis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarksVisible, Stroke tickMarkStroke, boolean autoRange, Range range, boolean autoTickUnitSelection, DateUnit tickUnit, SimpleDateFormat tickLabelFormatter, boolean gridLinesVisible, Stroke gridStroke, Paint gridPaint, boolean crosshairVisible, Date crosshairDate, Stroke crosshairStroke, Paint crosshairPaint) {
        super(label, labelFont, labelPaint, labelInsets, tickLabelsVisible, tickLabelFont, tickLabelPaint, tickLabelInsets, tickMarksVisible, tickMarkStroke, autoRange, autoTickUnitSelection, gridLinesVisible, gridStroke, gridPaint, crosshairVisible, 0.0, crosshairStroke, crosshairPaint);
        this.range = range;
        this.crosshairDate = crosshairDate;
        if (crosshairDate != null) {
            this.crosshairValue = crosshairDate.getTime();
        }
        this.tickUnit = tickUnit;
        this.tickLabelFormatter = tickLabelFormatter;
        this.anchorValue = this.anchorDate.getTime();
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("DateAxis.setAxisRange(...): null not permitted.");
        }
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        this.autoRange = false;
        this.range = range;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date getMinimumDate() {
        Date result = null;
        if (this.range instanceof DateRange) {
            DateRange r = (DateRange)this.range;
            result = r.getLowerDate();
        } else {
            result = new Date((long)this.range.getLowerBound());
        }
        return result;
    }

    public void setMinimumDate(Date minimumDate) {
        this.range = new DateRange(minimumDate, this.getMaximumDate());
    }

    public Date getMaximumDate() {
        Date result = null;
        if (this.range instanceof DateRange) {
            DateRange r = (DateRange)this.range;
            result = r.getUpperDate();
        } else {
            result = new Date((long)this.range.getUpperBound());
        }
        return result;
    }

    public void setMaximumDate(Date maximumDate) {
        this.range = new DateRange(this.getMinimumDate(), maximumDate);
    }

    public void setAnchorValue(double value) {
        long millis = (long)value;
        this.anchorDate.setTime(millis);
        super.setAnchorValue(value);
    }

    public void setAxisRange(double lower, double upper) {
        this.range = new DateRange(lower, upper);
    }

    public Date getCrosshairDate() {
        return this.crosshairDate;
    }

    public void setCrosshairDate(Date crosshairDate) {
        this.crosshairDate = crosshairDate;
        if (crosshairDate != null) {
            double millis = crosshairDate.getTime();
            this.setCrosshairValue(millis);
        } else {
            this.setCrosshairVisible(false);
        }
    }

    public Date getAnchorDate() {
        return this.anchorDate;
    }

    public void setAnchorDate(Date anchorDate) {
        this.anchorDate = anchorDate;
        double millis = anchorDate.getTime();
        super.setAnchorValue(millis);
    }

    public DateUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateUnit unit) {
        this.tickUnit = unit;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public SimpleDateFormat getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public Date calculateLowestVisibleTickValue(DateUnit unit) {
        return this.nextStandardDate(this.getMinimumDate(), unit.getField(), unit.getCount());
    }

    public Date calculateHighestVisibleTickValue(DateUnit unit) {
        return this.previousStandardDate(this.getMaximumDate(), unit.getField(), unit.getCount());
    }

    protected Date previousStandardDate(Date date, int field, int units) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int current = calendar.get(field);
        int value = units * (current / units);
        switch (field) {
            case 14: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                int hours = calendar.get(11);
                int minutes = calendar.get(12);
                int seconds = calendar.get(13);
                calendar.set(years, months, days, hours, minutes, seconds);
                calendar.set(14, value);
                return calendar.getTime();
            }
            case 13: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                int hours = calendar.get(11);
                int minutes = calendar.get(12);
                calendar.clear(14);
                calendar.set(years, months, days, hours, minutes, value);
                return calendar.getTime();
            }
            case 12: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                int hours = calendar.get(11);
                calendar.clear(14);
                calendar.set(years, months, days, hours, value, 0);
                return calendar.getTime();
            }
            case 11: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                calendar.clear(14);
                calendar.set(years, months, days, value, 0, 0);
                return calendar.getTime();
            }
            case 5: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                calendar.clear(14);
                calendar.set(years, months, value, 0, 0, 0);
                return calendar.getTime();
            }
            case 2: {
                int years = calendar.get(1);
                calendar.clear(14);
                calendar.set(years, value, 1, 0, 0, 0);
                return calendar.getTime();
            }
            case 1: {
                calendar.clear(14);
                calendar.set(value, 0, 1, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    protected Date nextStandardDate(Date date, int field, int units) {
        Date previous = this.previousStandardDate(date, field, units);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(previous);
        calendar.add(field, units);
        return calendar.getTime();
    }

    protected int findAxisMagnitudeIndex() {
        long axisMagnitude = this.getMaximumDate().getTime() - this.getMinimumDate().getTime();
        int index = 0;
        while (index < standardTickUnitMagnitudes.length - 1) {
            if (axisMagnitude < standardTickUnitMagnitudes[index]) break;
            ++index;
        }
        return Math.max(0, index - 1);
    }
}

