/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.StandardEntityCollection;
import java.awt.geom.Rectangle2D;

public class ChartRenderingInfo {
    protected Rectangle2D chartArea = new Rectangle2D.Double();
    protected Rectangle2D plotArea = new Rectangle2D.Double();
    protected Rectangle2D dataArea = new Rectangle2D.Double();
    protected EntityCollection entities;
    protected boolean generateToolTips;

    public ChartRenderingInfo() {
        this(null);
    }

    public ChartRenderingInfo(EntityCollection entities) {
        this.entities = entities;
        this.generateToolTips = true;
    }

    public Rectangle2D getChartArea() {
        return this.chartArea;
    }

    public void setChartArea(Rectangle2D area) {
        this.chartArea.setRect(area);
    }

    public Rectangle2D getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(Rectangle2D area) {
        this.plotArea.setRect(area);
    }

    public Rectangle2D getDataArea() {
        return this.dataArea;
    }

    public void setDataArea(Rectangle2D area) {
        this.dataArea.setRect(area);
    }

    public EntityCollection getEntityCollection() {
        return this.entities;
    }

    public void setEntityCollection(EntityCollection entities) {
        this.entities = entities;
    }

    public boolean isGenerateToolTips() {
        return this.generateToolTips;
    }

    public void setGenerateToolTips(boolean flag) {
        this.generateToolTips = flag;
        this.entities = flag ? new StandardEntityCollection() : null;
    }

    public void clear() {
        this.chartArea.setRect(0.0, 0.0, 0.0, 0.0);
        this.plotArea.setRect(0.0, 0.0, 0.0, 0.0);
        this.dataArea.setRect(0.0, 0.0, 0.0, 0.0);
        if (this.entities != null) {
            this.entities.clear();
        }
    }
}

