/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlotConstants;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetChangeEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class CategoryPlot
extends Plot
implements CategoryPlotConstants {
    protected CategoryPlot parent;
    protected CategoryAxis domainAxis;
    protected ValueAxis rangeAxis;
    protected List markers;
    protected CategoryItemRenderer renderer;
    protected double introGapPercent;
    protected double trailGapPercent;
    protected double categoryGapsPercent;
    protected double itemGapsPercent;
    protected boolean labelsVisible;
    protected Font labelFont;
    protected Paint labelPaint;
    protected String labelFormatPattern;
    protected NumberFormat labelFormatter;
    protected boolean verticalLabels;

    protected CategoryPlot(CategoryDataset data, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer) {
        this(data, domainAxis, rangeAxis, renderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15);
    }

    protected CategoryPlot(CategoryDataset data, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryItemRenderer renderer, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float foregroundAlpha, double introGapPercent, double trailGapPercent, double categoryGapsPercent, double itemGapsPercent) {
        super(data, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, foregroundAlpha);
        this.renderer = renderer;
        this.domainAxis = domainAxis;
        if (domainAxis != null) {
            domainAxis.setPlot(this);
            domainAxis.addChangeListener(this);
        }
        this.rangeAxis = rangeAxis;
        if (rangeAxis != null) {
            rangeAxis.setPlot(this);
            rangeAxis.addChangeListener(this);
        }
        this.markers = new ArrayList();
        this.markers.add(new Marker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new Color(0.85f, 0.85f, 0.95f, 0.5f), 0.6f));
        this.insets = insets;
        this.introGapPercent = introGapPercent;
        this.trailGapPercent = trailGapPercent;
        this.categoryGapsPercent = categoryGapsPercent;
        this.itemGapsPercent = itemGapsPercent;
        this.labelsVisible = false;
        this.labelFont = CategoryPlotConstants.DEFAULT_LABEL_FONT;
        this.labelPaint = Color.black;
        this.labelFormatter = NumberFormat.getInstance();
        this.labelFormatPattern = null;
        this.verticalLabels = false;
    }

    public boolean isSubplot() {
        return this.parent != null;
    }

    public CategoryPlot getParent() {
        return this.parent;
    }

    public void setParent(CategoryPlot parent) {
        this.parent = parent;
    }

    public int getSeriesCount() {
        int result = 0;
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            result = data.getSeriesCount();
        }
        return result;
    }

    public List getLegendItemLabels() {
        ArrayList<String> result = new ArrayList<String>();
        CategoryDataset data = this.getCategoryDataset();
        if (data != null) {
            int seriesCount = data.getSeriesCount();
            int i = 0;
            while (i < seriesCount) {
                result.add(data.getSeriesName(i));
                ++i;
            }
        }
        return result;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer renderer) {
        this.renderer = renderer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getIntroGapPercent() {
        return this.introGapPercent;
    }

    public void setIntroGapPercent(double percent) {
        if (percent < 0.0 || percent > 0.2) {
            throw new IllegalArgumentException("BarPlot.setIntroGapPercent(double): argument outside valid range.");
        }
        if (this.introGapPercent != percent) {
            this.introGapPercent = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getTrailGapPercent() {
        return this.trailGapPercent;
    }

    public void setTrailGapPercent(double percent) {
        if (percent < 0.0 || percent > 0.2) {
            throw new IllegalArgumentException("BarPlot.setTrailGapPercent(double): argument outside valid range.");
        }
        if (this.trailGapPercent != percent) {
            this.trailGapPercent = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getCategoryGapsPercent() {
        return this.categoryGapsPercent;
    }

    public void setCategoryGapsPercent(double percent) {
        if (percent < 0.0 || percent > 0.3) {
            throw new IllegalArgumentException("BarPlot.setCategoryGapsPercent(double): argument outside valid range.");
        }
        if (this.categoryGapsPercent != percent) {
            this.categoryGapsPercent = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getItemGapsPercent() {
        return this.itemGapsPercent;
    }

    public void setItemGapsPercent(double percent) {
        if (percent < 0.0 || percent > 0.3) {
            throw new IllegalArgumentException("BarPlot.setItemGapsPercent(double): argument outside valid range.");
        }
        if (percent != this.itemGapsPercent) {
            this.itemGapsPercent = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryDataset getCategoryDataset() {
        return (CategoryDataset)this.dataset;
    }

    public CategoryAxis getDomainAxis() {
        CategoryAxis result = this.domainAxis;
        if (result == null && this.parent != null) {
            result = this.parent.getDomainAxis();
        }
        return result;
    }

    public void setDomainAxis(CategoryAxis axis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(axis)) {
            if (axis != null) {
                try {
                    axis.setPlot(this);
                }
                catch (PlotNotCompatibleException e) {
                    throw new AxisNotCompatibleException("CategoryPlot.setDomainAxis(...): plot not compatible with axis.");
                }
                axis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("CategoryPlot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = axis;
    }

    public ValueAxis getRangeAxis() {
        ValueAxis result = this.rangeAxis;
        if (result == null && this.parent != null) {
            result = this.parent.getRangeAxis();
        }
        return result;
    }

    public void setRangeAxis(ValueAxis axis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(axis)) {
            if (axis != null) {
                try {
                    axis.setPlot(this);
                }
                catch (PlotNotCompatibleException e) {
                    throw new AxisNotCompatibleException("CategoryPlot.setRangeAxis(...): plot not compatible with axis.");
                }
                axis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = axis;
    }

    public abstract boolean isCompatibleDomainAxis(CategoryAxis var1);

    public abstract boolean isCompatibleRangeAxis(ValueAxis var1);

    public abstract double getCategoryCoordinate(int var1, Rectangle2D var2);

    public void zoom(double percent) {
        ValueAxis rangeAxis = this.getRangeAxis();
        if (percent > 0.0) {
            double range = rangeAxis.getMaximumAxisValue() - rangeAxis.getMinimumAxisValue();
            double scaledRange = range * percent;
            rangeAxis.setAnchoredRange(scaledRange);
        } else {
            rangeAxis.setAutoRange(true);
        }
    }

    public void setLabelsVisible(boolean flag) {
        if (this.labelsVisible != flag) {
            this.labelsVisible = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getLabelsVisible() {
        return this.labelsVisible;
    }

    public void setLabelFont(Font font) {
        if (this.labelFont == null) {
            throw new IllegalArgumentException("CategoryPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelPaint(Paint paint) {
        if (this.labelPaint == null) {
            throw new IllegalArgumentException("CategoryPlot.setLabelPaint(...): null paint not allowed.");
        }
        if (!this.labelPaint.equals(paint)) {
            this.labelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelFormatString(String format) {
        boolean changed = false;
        if (format == null) {
            if (this.labelFormatter != null) {
                this.labelFormatPattern = null;
                this.labelFormatter = null;
                changed = true;
            }
        } else if (this.labelFormatter == null || !format.equals(this.labelFormatPattern)) {
            this.labelFormatPattern = format;
            this.labelFormatter = new DecimalFormat(format);
            changed = true;
        }
        if (changed) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public NumberFormat getLabelFormatter() {
        return this.labelFormatter;
    }

    public void setVerticalLabels(boolean flag) {
        if (this.verticalLabels != flag) {
            this.verticalLabels = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getVerticalLabels() {
        return this.verticalLabels;
    }

    public void datasetChanged(DatasetChangeEvent event) {
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        super.datasetChanged(event);
    }

    public void addRangeMarker(Marker marker) {
        this.markers.add(marker);
    }
}

