/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CandlestickRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class BoxplotRenderer
extends CandlestickRenderer {
    double medianTemp;

    public BoxplotRenderer(double median) {
        this.medianTemp = median;
    }

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        super.drawItem(g2, dataArea, info, plot, domainAxis, rangeAxis, data, series, item, crosshairInfo);
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        HighLowDataset highLowData = (HighLowDataset)data;
        Number x = highLowData.getXValue(series, item);
        Number yHigh = highLowData.getHighValue(series, item);
        Number yLow = highLowData.getLowValue(series, item);
        Number yOpen = highLowData.getOpenValue(series, item);
        Number yClose = highLowData.getCloseValue(series, item);
        double xx = domainAxis.translateValueToJava2D(x.doubleValue(), dataArea);
        double yyHigh = rangeAxis.translateValueToJava2D(yHigh.doubleValue(), dataArea);
        double yyLow = rangeAxis.translateValueToJava2D(yLow.doubleValue(), dataArea);
        double yyOpen = rangeAxis.translateValueToJava2D(yOpen.doubleValue(), dataArea);
        double yyClose = rangeAxis.translateValueToJava2D(yClose.doubleValue(), dataArea);
        double yyMedian = rangeAxis.translateValueToJava2D(this.medianTemp, dataArea);
        double exactCandleWidth = this.candleWidth;
        double thisCandleWidth = this.candleWidth;
        if (this.candleWidth <= 0.0) {
            int itemCount = highLowData.getItemCount(series);
            exactCandleWidth = (dataArea.getMaxX() - dataArea.getMinX()) / (double)itemCount * 4.5 / 7.0;
            if (exactCandleWidth < 1.0) {
                exactCandleWidth = 1.0;
            }
            if ((thisCandleWidth = exactCandleWidth) < 3.0) {
                thisCandleWidth = 3.0;
            }
        }
        Paint p = plot.getSeriesPaint(series);
        Stroke s = plot.getSeriesStroke(series);
        g2.setStroke(s);
        g2.setPaint(p);
        g2.draw(new Line2D.Double(xx - thisCandleWidth / 2.0, yyMedian + 1.0, xx + thisCandleWidth / 2.0, yyMedian + 1.0));
        g2.draw(new Line2D.Double(xx - thisCandleWidth / 2.0 - 1.0, yyMedian, xx + thisCandleWidth / 2.0 + 1.0, yyMedian));
        g2.draw(new Line2D.Double(xx - thisCandleWidth / 2.0, yyMedian - 1.0, xx + thisCandleWidth / 2.0, yyMedian - 1.0));
        if (yyHigh < yyOpen && yyHigh < yyClose) {
            g2.draw(new Line2D.Double(xx - thisCandleWidth / 2.0, yyHigh, xx + thisCandleWidth / 2.0, yyHigh));
        }
        if (yyLow > yyOpen && yyLow > yyClose) {
            g2.draw(new Line2D.Double(xx - thisCandleWidth / 2.0, yyLow, xx + thisCandleWidth / 2.0, yyLow));
        }
    }
}

