/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractCategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class AreaCategoryItemRenderer
extends AbstractCategoryItemRenderer {
    public void drawRangeMarker(Graphics2D g2, CategoryPlot plot, ValueAxis axis, Marker marker, Rectangle2D axisDataArea, Shape dataClipRegion) {
        double value = marker.getValue();
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        double y = axis.translateValueToJava2D(marker.getValue(), axisDataArea);
        Line2D.Double line = new Line2D.Double(axisDataArea.getMinX(), y, axisDataArea.getMaxX(), y);
        g2.setPaint(marker.getOutlinePaint());
        g2.draw(line);
    }

    public void drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Number value = data.getValue(series, category);
        if (value != null) {
            Number previousValue;
            double x1 = plot.getCategoryCoordinate(categoryIndex, dataArea);
            double y1 = axis.translateValueToJava2D(value.doubleValue(), dataArea);
            g2.setPaint(plot.getSeriesPaint(series));
            g2.setStroke(plot.getSeriesStroke(series));
            if (previousCategory != null && (previousValue = data.getValue(series, previousCategory)) != null) {
                double x0 = plot.getCategoryCoordinate(categoryIndex - 1, dataArea);
                double y0 = axis.translateValueToJava2D(previousValue.doubleValue(), dataArea);
                double zeroInJava2D = plot.getRangeAxis().translateValueToJava2D(0.0, dataArea);
                Polygon p = new Polygon();
                p.addPoint((int)x0, (int)y0);
                p.addPoint((int)x1, (int)y1);
                p.addPoint((int)x1, (int)zeroInJava2D);
                p.addPoint((int)x0, (int)zeroInJava2D);
                g2.setPaint(plot.getSeriesPaint(series));
                g2.setStroke(plot.getSeriesStroke(series));
                g2.fill(p);
            }
        }
    }
}

