/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractXYItemRenderer
implements XYItemRenderer {
    protected ChartRenderingInfo info;
    protected XYToolTipGenerator toolTipGenerator;
    protected PropertyChangeSupport listeners;

    protected AbstractXYItemRenderer() {
        this(null);
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator toolTipGenerator) {
        this.toolTipGenerator = toolTipGenerator;
        this.listeners = new PropertyChangeSupport(this);
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, ChartRenderingInfo info) {
        this.info = info;
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator toolTipGenerator) {
        this.toolTipGenerator = toolTipGenerator;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    protected void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propertyName, oldValue, newValue);
    }
}

