/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.TitleChangeEvent;
import com.jrefinery.chart.event.TitleChangeListener;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTitle
implements Cloneable {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    public static final int MIDDLE = 4;
    public static final int DEFAULT_POSITION = 0;
    public static final int DEFAULT_HORIZONTAL_ALIGNMENT = 4;
    public static final int DEFAULT_VERTICAL_ALIGNMENT = 4;
    public static final Spacer DEFAULT_SPACER;
    protected boolean notify;
    protected int position;
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected Spacer spacer;
    protected List listeners;

    protected AbstractTitle() {
        this(0, 4, 4, DEFAULT_SPACER);
    }

    protected AbstractTitle(int position, int horizontalAlignment, int verticalAlignment) {
        this(position, horizontalAlignment, verticalAlignment, DEFAULT_SPACER);
    }

    protected AbstractTitle(int position, int horizontalAlignment, int verticalAlignment, Spacer spacer) {
        if (!this.isValidPosition(position)) {
            throw new IllegalArgumentException("AbstractTitle(): Invalid position.");
        }
        if (!AbstractTitle.isValidHorizontalAlignment(horizontalAlignment)) {
            throw new IllegalArgumentException("AbstractTitle(): Invalid horizontal alignment.");
        }
        if (!AbstractTitle.isValidVerticalAlignment(verticalAlignment)) {
            throw new IllegalArgumentException("AbstractTitle(): Invalid vertical alignment.");
        }
        this.position = position;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.spacer = spacer;
        this.listeners = new ArrayList();
        this.notify = true;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean flag) {
        this.notify = flag;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (this.position != position) {
            this.position = position;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        if (this.horizontalAlignment != alignment) {
            this.horizontalAlignment = alignment;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        if (this.verticalAlignment != alignment) {
            this.verticalAlignment = alignment;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Spacer getSpacer() {
        return this.spacer;
    }

    public void setSpacer(Spacer spacer) {
        if (!this.spacer.equals(spacer)) {
            this.spacer = spacer;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public abstract boolean isValidPosition(int var1);

    public abstract double getPreferredWidth(Graphics2D var1);

    public abstract double getPreferredHeight(Graphics2D var1);

    public abstract void draw(Graphics2D var1, Rectangle2D var2);

    public Object clone() {
        AbstractTitle duplicate = null;
        try {
            duplicate = (AbstractTitle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("AbstractTitle.clone()");
        }
        return duplicate;
    }

    public void addChangeListener(TitleChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(TitleChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(TitleChangeEvent event) {
        if (this.notify) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TitleChangeListener listener = (TitleChangeListener)iterator.next();
                listener.titleChanged(event);
            }
        }
    }

    protected static boolean isValidHorizontalAlignment(int code) {
        switch (code) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isValidVerticalAlignment(int code) {
        switch (code) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    static {
        TOP = 0;
        BOTTOM = 1;
        RIGHT = 2;
        LEFT = 3;
        NORTH = 0;
        SOUTH = 1;
        EAST = 2;
        WEST = 3;
        CENTER = 4;
        MIDDLE = 4;
        DEFAULT_POSITION = 0;
        DEFAULT_HORIZONTAL_ALIGNMENT = 4;
        DEFAULT_VERTICAL_ALIGNMENT = 4;
        DEFAULT_SPACER = new Spacer(0, 0.05, 0.3, 0.05, 0.15);
    }
}

