/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.xa;

import com.mysql.jdbc.xa.XAConnectionImpl;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

final class ClientConnection
implements Connection {
    private XAConnectionImpl _xaConn;
    private int _clientId;

    ClientConnection(XAConnectionImpl xAConnectionImpl, int n) {
        this._xaConn = xAConnectionImpl;
        this._clientId = n;
    }

    public Statement createStatement() throws SQLException {
        try {
            return this.getUnderlying().createStatement();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            return this.getUnderlying().createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.getUnderlying().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return this.getUnderlying().prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            return this.getUnderlying().prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return this.getUnderlying().prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            return this.getUnderlying().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getUnderlying().getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        try {
            this.getUnderlying().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.getUnderlying().getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getUnderlying().getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.getUnderlying().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getUnderlying().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.getUnderlying().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this._xaConn.insideGlobalTx()) {
            throw new SQLException("Cannot commit/rollback a connection managed by the transaction manager");
        }
        try {
            this.getUnderlying().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getUnderlying().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void commit() throws SQLException {
        if (this._xaConn.insideGlobalTx()) {
            throw new SQLException("Cannot commit/rollback a connection managed by the transaction manager");
        }
        if (this.isReadOnly()) {
            throw new SQLException("Cannot commit/rollback a read-only transaction");
        }
        try {
            this.getUnderlying().commit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        if (this._xaConn.insideGlobalTx()) {
            throw new SQLException("Cannot commit/rollback a connection managed by the transaction manager");
        }
        try {
            this.getUnderlying().rollback();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getUnderlying().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.getUnderlying().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getUnderlying().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getUnderlying().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void close() throws SQLException {
        if (this._xaConn == null) {
            return;
        }
        this._xaConn.notifyClose(this._clientId);
        this._xaConn = null;
    }

    public synchronized boolean isClosed() {
        return this._xaConn == null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String toString() {
        try {
            return this.getUnderlying().toString();
        }
        catch (SQLException sQLException) {
            return "XAConnection: Connection closed";
        }
    }

    void notifyError(SQLException sQLException) {
        if (this._xaConn != null) {
            this._xaConn.notifyError(this._clientId, sQLException);
        }
    }

    Connection getUnderlying() throws SQLException {
        if (this._xaConn == null) {
            throw new SQLException("This connection has been closed");
        }
        try {
            return this._xaConn.getUnderlying(this._clientId);
        }
        catch (SQLException sQLException) {
            this._xaConn = null;
            throw sQLException;
        }
    }
}

