/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.Driver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class MysqlDataSource
implements DataSource,
Referenceable,
Serializable {
    protected static Driver _MysqlDriver = null;
    protected boolean explicitUrl = false;
    protected String url = null;
    protected String _HostName = null;
    protected int _port = 1306;
    protected String _DatabaseName = null;
    protected String _Encoding = null;
    protected String _User = null;
    protected String _Password = null;
    protected PrintWriter _LogWriter = null;
    protected String _profileSql = "false";

    public Connection getConnection() throws SQLException {
        return this.getConnection(this._User, this._Password);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        ((Hashtable)properties).put("user", string);
        ((Hashtable)properties).put("password", string2);
        ((Hashtable)properties).put("profileSql", this.getProfileSql());
        return this.getConnection(properties);
    }

    protected Connection getConnection(Properties properties) throws SQLException {
        String string = null;
        if (!this.explicitUrl) {
            StringBuffer stringBuffer = new StringBuffer("jdbc:mysql://");
            if (this._HostName != null) {
                stringBuffer.append(this._HostName);
            }
            stringBuffer.append(":");
            stringBuffer.append(this._port);
            stringBuffer.append("/");
            if (this._DatabaseName != null) {
                stringBuffer.append(this._DatabaseName);
            }
            string = stringBuffer.toString();
        } else {
            string = this.url;
        }
        return _MysqlDriver.connect(string, properties);
    }

    public String getDatabaseName() {
        return this._DatabaseName;
    }

    public PrintWriter getLogWriter() {
        return this._LogWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public int getPort() {
        return this._port;
    }

    public String getProfileSql() {
        return this._profileSql;
    }

    public void setProfileSql(String string) {
        this._profileSql = string;
    }

    public Reference getReference() throws NamingException {
        String string = "com.mysql.jdbc.jdbc2.optional.MysqlDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this._Password));
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("port", "" + this.getPort()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("profileSql", this.getProfileSql()));
        return reference;
    }

    public String getServerName() {
        return this._HostName;
    }

    public void setUrl(String string) {
        this.url = string;
        this.explicitUrl = true;
    }

    public String getUrl() {
        if (!this.explicitUrl) {
            String string = "jdbc:mysql://";
            string = string + this.getServerName() + ":" + this.getPort() + "/" + this.getDatabaseName();
            return string;
        }
        return this.url;
    }

    public void setURL(String string) {
        this.setUrl(string);
    }

    public String getURL() {
        return this.getUrl();
    }

    public String getUser() {
        return this._User;
    }

    public void setDatabaseName(String string) {
        this._DatabaseName = string;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this._LogWriter = printWriter;
    }

    public void setLoginTimeout(int n) throws SQLException {
    }

    public void setPassword(String string) {
        this._Password = string;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public void setPortNumber(int n) {
        this.setPort(n);
    }

    public void setServerName(String string) {
        this._HostName = string;
    }

    public void setUser(String string) {
        this._User = string;
    }

    static {
        try {
            _MysqlDriver = (Driver)Class.forName("com.mysql.jdbc.Driver").newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Can not load Driver class com.mysql.jdbc.Driver");
        }
    }
}

