#include <assert.h>
#include <iostream>
//#include <string.h>
//#include <stdlib.h>
//#include <time.h>

//#include "utils.hh"
//#include "Bool.hh"

//#include <Types.hh>
#include <Param.hh>

using namespace std;


// ====================
// function prototypes
// ====================
void TestParamsInFunction( CParam *pParam );



// ====================
//   main function
// ====================
int 
main(int argc, char *argv[])
{
  // output information when program was compiled, with which compiler version etc.
  cout << "Compiled on " << __DATE__ << " " << __TIME__ << " with g++ version: " << __VERSION__ ;
#ifdef __OPTIMIZE__
  cout << " in optimization mode" << endl;
#else
  cout << " in debug mode" << endl;
#endif
  cout << endl;


  CParam *pParam = new CParam;

  // some variable used to store the values of the parameters
  int   TraceLevel = -1;
  char *pLexiconFile = NULL;
  char *pGrammarFile = NULL;
  char *pLogFile = NULL;


  // first, register the parameters
  // provide long parameter name, a 1-character name (can be left 
  // unspecified by using '\0'), 

  bool Optional = true;
  bool Required = !Optional;

  pParam->AddParamDef( "TraceLevel", 'T' , &TraceLevel, 0 ,
                       "Trace level: 0 = no, 1 = minimal, 2 = full trace output",
                       Optional );

  pParam->AddParamDef( "LexiconFile", 'L' , &pLexiconFile, "Lexicon" ,
                       "name of parameter file with lexicon",
                       Required );

  pParam->AddParamDef( "GrammarFile", 'G' , &pGrammarFile, "Grammar" ,
                       "name of file with grammar",
                       Required );

  pParam->AddParamDef( "LogFile", '\0' , &pLogFile, NULL,
                       "name of log file from TC-Tool",
                       Optional );


  if (! pParam->Interpret( argv, argc) ) {
    cerr << "\n\n ... exiting!!\n";
    exit(-1);
  }

  // now display the values
  cout << "Parameters are:" << endl;
  cout << "Trace Level     = " << TraceLevel << endl;
  cout << "Lexicon File    = " << pLexiconFile << endl;
  cout << "Grammar File    = " << pGrammarFile << endl;
  cout << "TCTool Log File = " << pLogFile << endl;


  TestParamsInFunction( pParam );

  delete pParam;

  return 0;
}


void TestParamsInFunction( CParam *pParam )
{
  cout << "Parameter in function:" << endl;
  char *LexiconFile = *((char**)pParam->getValueFromKey( "LexiconFile" ));
  cout << "The file name for the lexicon is: " << LexiconFile << endl;
}
