/*
 * Decompiled with CFR 0.152.
 */
package mapudungunMorphologyAnalysis;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapudungunMorphologyAnalyzer {
    private Hashtable<String, Vector<Suffix>> hashOfSuffixes = new Hashtable();
    private Hashtable<String, Vector<Stem>> hashOfStems = new Hashtable();

    public void readStemDataFile(String stemDataFileName) {
        int DEBUG = 0;
        if (DEBUG > 0) {
            System.out.println("reading the stem data file and building the hashOfStems data structure");
        }
        Pattern stemDataPattern = Pattern.compile("^\\s*([^,\\s]+)\\s*,\\s*([^,\\s]+)\\s*,\\s*(.*)\\s*$");
        Pattern commentPattern = Pattern.compile("^\\s*#");
        Pattern blankLinePattern = Pattern.compile("^\\s*$");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(stemDataFileName)));
            while ((line = br.readLine()) != null) {
                Matcher commentMatcher;
                if (DEBUG > 0) {
                    System.out.print("\n\nline: ");
                    System.out.println(line);
                    System.out.println();
                }
                if ((commentMatcher = commentPattern.matcher(line)).lookingAt()) {
                    if (DEBUG <= 0) continue;
                    System.out.println("\tFound a comment line, skipping...\n");
                    continue;
                }
                Matcher blankLineMatcher = blankLinePattern.matcher(line);
                if (blankLineMatcher.matches()) {
                    if (DEBUG <= 0) continue;
                    System.out.println("\tFound a Blank line, skipping...\n");
                    continue;
                }
                Matcher stemDataMatcher = stemDataPattern.matcher(line);
                Boolean stemDataWellFormated = stemDataMatcher.matches();
                if (!stemDataWellFormated.booleanValue()) {
                    System.err.print("\nIll-formated line in the stem data file: ");
                    System.err.println(stemDataFileName);
                    System.err.println("\n\tEach line in the stem data file must look like:\n");
                    System.err.println("\t<suffix-graph>, <suffix-POS>, <f-structure>\n");
                    System.err.println("The offending line is:\n");
                    System.err.print("|");
                    System.err.print(line);
                    System.err.println("|");
                    System.err.println("\nExiting...\n");
                    System.err.flush();
                    System.exit(0);
                }
                String stemGraph = stemDataMatcher.group(1);
                String stemPOS = stemDataMatcher.group(2);
                String fStructure = stemDataMatcher.group(3);
                if (DEBUG > 0) {
                    System.out.print("stemGraph: ");
                    System.out.println(stemGraph);
                    System.out.print("stemPOS: ");
                    System.out.println(stemPOS);
                    System.out.print("fStructure: ");
                    System.out.println(fStructure);
                }
                Stem stem = new Stem(stemGraph, stemPOS, fStructure);
                Vector<Object> v = null;
                if (this.hashOfStems.containsKey(stem.graph)) {
                    v = this.hashOfStems.get(stem.graph);
                    v.addElement(stem);
                } else {
                    v = new Vector<Stem>();
                    v.addElement(stem);
                }
                this.hashOfStems.put(stem.graph, v);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSuffixDataFile(String suffixDataFileName) {
        int DEBUG = 0;
        if (DEBUG > 0) {
            System.out.println("reading the suffix data file and building the hashOfSuffixes data structure");
        }
        Pattern suffixDataPattern = Pattern.compile("^\\s*([^,\\s]+)\\s*,\\s*([^,\\s]+)\\s*,\\s*(\\d*)\\s*,\\s*([+-]?)\\s*,\\s*([+-]?)\\s*,\\s*(.*)\\s*$");
        Pattern commentPattern = Pattern.compile("^\\s*#");
        Pattern blankLinePattern = Pattern.compile("^\\s*$");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(suffixDataFileName)));
            while ((line = br.readLine()) != null) {
                Matcher commentMatcher;
                if (DEBUG > 0) {
                    System.out.print("\n\nline: ");
                    System.out.println(line);
                    System.out.println();
                }
                if ((commentMatcher = commentPattern.matcher(line)).lookingAt()) {
                    if (DEBUG <= 0) continue;
                    System.out.println("\tFound a comment line\n");
                    continue;
                }
                Matcher blankLineMatcher = blankLinePattern.matcher(line);
                if (blankLineMatcher.matches()) {
                    if (DEBUG <= 0) continue;
                    System.out.println("\tFound a Blank line, skipping...\n");
                    continue;
                }
                Matcher suffixDataMatcher = suffixDataPattern.matcher(line);
                Boolean suffixDataWellFormated = suffixDataMatcher.matches();
                if (!suffixDataWellFormated.booleanValue()) {
                    System.err.print("\nIll-formated line in the suffix data file: ");
                    System.err.println(suffixDataFileName);
                    System.err.println("\n\tEach line in the suffix data file must look like:\n");
                    System.err.println("\t<suffix-graph>, <suffix-POS>, <suffix-slot>, <+|- transitivity>, <+|- imperitive>, <f-structure>\n");
                    System.err.println("The offending line is:\n");
                    System.err.print("|");
                    System.err.print(line);
                    System.err.println("|");
                    System.err.println("\nExiting...\n");
                    System.err.flush();
                    System.exit(0);
                }
                String suffixGraph = suffixDataMatcher.group(1);
                String suffixPOS = suffixDataMatcher.group(2);
                String suffixSlotIndex = suffixDataMatcher.group(3);
                String suffixTransitiveFeature = suffixDataMatcher.group(4);
                String suffixImperitiveFeature = suffixDataMatcher.group(5);
                String fStructure = suffixDataMatcher.group(6);
                if (DEBUG > 0) {
                    System.out.print("suffixGraph: ");
                    System.out.println(suffixGraph);
                    System.out.print("suffixPOS: ");
                    System.out.println(suffixPOS);
                    System.out.print("suffixSlotIndex: ");
                    System.out.println(suffixSlotIndex);
                    System.out.print("suffixTransitiveFeature: ");
                    System.out.println(suffixTransitiveFeature);
                    System.out.print("suffixImperitiveFeature: ");
                    System.out.println(suffixImperitiveFeature);
                    System.out.print("fStructure: ");
                    System.out.println(fStructure);
                }
                Suffix suffix = new Suffix();
                suffix.setVariables(suffixGraph, suffixPOS, suffixSlotIndex, suffixTransitiveFeature, suffixImperitiveFeature, fStructure);
                Vector<Object> v = null;
                if (this.hashOfSuffixes.containsKey(suffix.graph)) {
                    v = this.hashOfSuffixes.get(suffix.graph);
                    v.addElement(suffix);
                } else {
                    v = new Vector<Suffix>();
                    v.addElement(suffix);
                }
                this.hashOfSuffixes.put(suffix.graph, v);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseWordFromStdinToStdout() {
        int DEBUG = 0;
        System.err.println();
        System.err.println("Waiting for Mapudungun Words to analyze.");
        System.err.println("  Enter 1 word per line.");
        System.err.println("  To quit, enter the string \"**EXIT**\".");
        System.err.println();
        System.err.println();
        try {
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            String word = stdin.readLine();
            if (DEBUG > 0) {
                System.err.print("The java morphology analysis code is now analyzing the word: |");
                System.err.print(word);
                System.err.println("|");
            }
            while (!word.contains("**EXIT**")) {
                Vector<Vector> parsesOfAWord = this.parseWord(word);
                for (Vector parse : parsesOfAWord) {
                    for (int morphemeIndex = 0; morphemeIndex < parse.size(); ++morphemeIndex) {
                        if (morphemeIndex == 0) {
                            Stem stem = (Stem)parse.get(morphemeIndex);
                            System.out.print(stem.fstructure);
                        } else {
                            Suffix suffix = (Suffix)parse.get(morphemeIndex);
                            System.out.print(suffix.fstructure);
                        }
                        if (morphemeIndex >= parse.size() - 1) continue;
                        System.out.print(", ");
                    }
                    System.out.print("; ");
                }
                System.out.println();
                System.out.flush();
                word = stdin.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<Vector> parseWord(String word) {
        Vector<Vector> completeParses = new Vector<Vector>();
        for (int indexIntoWord = 1; indexIntoWord <= word.length(); ++indexIntoWord) {
            String potentialStemGraph = word.substring(0, indexIntoWord);
            if (!this.hashOfStems.containsKey(potentialStemGraph)) continue;
            String suffixGroup = word.substring(indexIntoWord);
            Vector<Stem> vectorOfStems = this.hashOfStems.get(potentialStemGraph);
            for (Stem stem : vectorOfStems) {
                Vector<Stem> parse = new Vector<Stem>();
                parse.add(stem);
                completeParses = this.parseSuffixGroup(suffixGroup, 0, 24, stem.category, parse, completeParses);
            }
        }
        return completeParses;
    }

    public Vector<Vector> parseSuffixGroup(String suffixGroup, int beginIndexIntoSuffixGroup, int suffixSlotMaximum, String category, Vector parse, Vector<Vector> completeParses) {
        if (beginIndexIntoSuffixGroup == suffixGroup.length()) {
            if (category.equals("V") && suffixSlotMaximum == 1 || !category.equals("V")) {
                completeParses.add((Vector)parse.clone());
            }
            return completeParses;
        }
        for (int endIndexIntoSuffixGroup = beginIndexIntoSuffixGroup + 1; endIndexIntoSuffixGroup <= suffixGroup.length(); ++endIndexIntoSuffixGroup) {
            String potentialSuffixGraph = suffixGroup.substring(beginIndexIntoSuffixGroup, endIndexIntoSuffixGroup);
            if (!this.hashOfSuffixes.containsKey(potentialSuffixGraph)) continue;
            Vector<Suffix> vectorOfSuffixes = this.hashOfSuffixes.get(potentialSuffixGraph);
            for (Suffix suffix : vectorOfSuffixes) {
                if (suffix.position >= suffixSlotMaximum || !suffix.category.equals(category) && category.length() != 0) continue;
                parse.addElement(suffix);
                completeParses = this.parseSuffixGroup(suffixGroup, endIndexIntoSuffixGroup, suffix.position, suffix.category, parse, completeParses);
                parse.removeElementAt(parse.size() - 1);
            }
        }
        return completeParses;
    }

    public static void main(String[] args) {
        System.err.println();
        System.err.println("Starting up the java implemented Mapudungun Morphological Analyzer");
        System.err.println();
        if (args.length != 2) {
            System.out.print("The command line must look like:");
            System.out.println("\tjava MapudungunMorphologyAnalysis.MapudunugnMorphologyAnalyzer <stem-data-file> <suffix-data-file>");
            System.out.println("\n\tExiting...");
            System.exit(0);
        }
        MapudungunMorphologyAnalyzer parser = new MapudungunMorphologyAnalyzer();
        String stemDataFileName = args[0];
        String suffixDataFileName = args[1];
        System.err.print("In java analyzer: Reading the stem data file: ");
        System.err.println(stemDataFileName);
        System.err.println();
        parser.readStemDataFile(stemDataFileName);
        System.err.print("In Java analyzer: Reading the suffix data file: ");
        System.err.println(suffixDataFileName);
        System.err.println();
        parser.readSuffixDataFile(suffixDataFileName);
        parser.parseWordFromStdinToStdout();
        System.err.println();
        System.err.println("Exiting peacefully the java implemented Mapudungun Morphological Analyzer");
        System.err.println();
    }

    public class Stem {
        public String graph = "";
        public String category = "";
        public String fstructure = "";

        public Stem(String graph, String category, String fstructure) {
            this.graph = graph;
            this.category = category;
            this.fstructure = fstructure;
        }
    }

    public class Suffix {
        public static final int MAX_SUFFIX_SLOT = 24;
        public String graph = "";
        public String category = "";
        public int position = 0;
        public boolean transitive = false;
        public boolean imperative = false;
        public String fstructure = "";

        public void setVariables(String g, String c, String p, String t, String m, String v) {
            this.graph = g;
            this.category = c;
            try {
                this.position = Integer.parseInt(p);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.transitive = t.equals("+");
            this.imperative = m.equals("+");
            this.fstructure = v;
        }
    }
}

