package lexicon.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;


import lexicon.dbUtils.InflectRecord;

/*
 * Created on 28/11/2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author daliabo
 * 
 * use sort of unix to create dindlections.data and dprefixes.data
 * sort inflections.data > dinflections.data
 * sort prefixes.data > dprefixes.data
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class Load2memory {
		
	private static Inflections inflections = null;

	private static Prefixes prefixes = null;
	
	private static Gimatria gimatria =null;

	private static boolean sortFile = true;
	
	
	public static Gimatria loadGimatria (String gimatriaFile){
		int counter = 0;
		//we already know the number of gimatria entries - improves performance
		gimatria = new Gimatria(1044);
		FileInputStream fileInputStream = null;
		BufferedReader in = null;
		String line ="";
		String transliterated ="";
		String val = "";
		try {
			fileInputStream = new FileInputStream(gimatriaFile);
			in = new BufferedReader(new InputStreamReader(fileInputStream));
			while ((line = in.readLine()) != null) {
				StringTokenizer gimatriaFields = new StringTokenizer(
						line, "|");
				transliterated = gimatriaFields.nextToken();
				transliterated = transliterated.replaceAll("%22","\"");
				val = gimatriaFields.nextToken();
				counter++;
				gimatria.put(transliterated,val);
			}
			in.close();
		} catch (Exception e) {
			System.err.println("gimatria file not found");
			System.err.println("Exiting...");
			System.exit(1);
		}
		return gimatria;	
	}


	public static Prefixes loadPrefixes(String dprefixesFile) {
		int counter = 0;
		prefixes = new Prefixes(174);
		FileInputStream fileInputStream = null;
		InflectRecord infRec = null;
		BufferedReader in = null;
		try {
			infRec = new InflectRecord();
			fileInputStream = new FileInputStream(dprefixesFile);
			in = new BufferedReader(new InputStreamReader(fileInputStream));
			String decodedPrefixesRecord = "";
			String prefix = "";
			ArrayList chain = null;
			boolean first = true;
			String currentPrefix = "";
			while ((decodedPrefixesRecord = in.readLine()) != null) {
				StringTokenizer inflectionsFields = new StringTokenizer(
						decodedPrefixesRecord, "|");
				prefix = inflectionsFields.nextToken();
				counter++;
				//System.out.println("counter = " + counter);
				//System.out.println("prefix =" + prefix);
				
				if (!sortFile)
					prefixes.put(prefix, decodedPrefixesRecord);
				else {	
					if (first) {
						chain = new ArrayList();
						first = false;
						chain.add(decodedPrefixesRecord);
						currentPrefix = prefix;
					} else {
						if (currentPrefix.equals(prefix))
							chain.add(decodedPrefixesRecord);
						else {
							prefixes.sput(currentPrefix, chain);
							chain = new ArrayList();
							chain.add(decodedPrefixesRecord);
							currentPrefix = prefix;		
						}
					}
				}
			}
			// for the last one
			prefixes.sput(currentPrefix, chain);
		//System.out.println("load: End Loading Prefixes file ");
			in.close();
		} catch (Exception e) {
			System.err.println("dprefixes file not found");
			System.err.println("Exiting...");
			System.exit(1);
		}
		return prefixes;
	}

	public static Inflections loadInflections(String dinflectionsFile) {
		inflections = new Inflections(650000, 1);
		FileInputStream fileInputStream = null;
		InflectRecord infRec = null;
		BufferedReader in = null;
		int counter = 0;
		try {
			infRec = new InflectRecord();
			fileInputStream = new FileInputStream(dinflectionsFile);
			in = new BufferedReader(new InputStreamReader(fileInputStream));
			String decodedInflectionRecord = "";
			String transliterated = "";
			ArrayList chain = null;
			boolean first = true;
			String currentTransliterated = "";
			while ((decodedInflectionRecord = in.readLine()) != null) {
				StringTokenizer inflectionsFields = new StringTokenizer(
						decodedInflectionRecord, "|");
				transliterated = inflectionsFields.nextToken();
				counter++;
			//	System.out.println("counter = " + counter);
			//	System.out.println("transliterated =" + transliterated);
				if (!sortFile)
					inflections.put(transliterated, decodedInflectionRecord);
				else {
					if (first) {
						chain = new ArrayList();
						first = false;
						chain.add(decodedInflectionRecord);
						currentTransliterated = transliterated;
					} else {
						if (currentTransliterated.equals(transliterated))
							chain.add(decodedInflectionRecord);
						else {
							inflections.sput(currentTransliterated, chain);
							chain = new ArrayList();
							chain.add(decodedInflectionRecord);
							currentTransliterated = transliterated;
						}
					}
				}	
		}
			//for the last one
			inflections.sput(currentTransliterated, chain);
		//	System.out.println("load: End Loading Inflections file ");
			in.close();
		} catch (Exception e) {
			//e.printStackTrace();
			System.err.println("dinflections file not found");
			System.err.println("Exiting...");
			System.exit(1);
		}
		return inflections;
	}

	public static void main(String[] args) {
//		Load2memory.loadInflections();
//		System.exit(0);
	}

}
