/*
 * Created on 05/02/2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package lexicon.analyse;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;

import javax.xml.bind.JAXBException;

import corpus.CreateCorpusXML;

import lexicon.dbUtils.InflectRecord;
import lexicon.dbUtils.PrefixRecord;
import lexicon.utils.Translate;

/**
 * @author daliabo
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */

public class TextOutput implements Constants {
	
	private static String setStatus(String status) {
		
		if (status.equals("true"))
			status = "construct";
		else if (status.equals("false"))
			status = "absolute";
		return status;
	}

	public static StringBuffer buildComplexOutput(int outputPattern,
			StringBuffer output, InflectRecord outputInflectionRec,
			String hebWord, int constructi, int suffixFunctioni,
			int baseDefinitnessi, boolean definiteArticleTag) throws Exception {

		final StringBuffer preOutput = new StringBuffer().append("[+id]")
				.append(outputInflectionRec.getBaseLexiconPointer()).append(
						"[+undotted]").append(
						outputInflectionRec.getBaseUndottedLItem()).append(
						"[+transliterated]").append(
						outputInflectionRec.getBaseTransliteratedLItem());
		String baseGender = outputInflectionRec.getBaseGender();
		String baseNumber = outputInflectionRec.getBaseNumber();
		String suffixNumber = outputInflectionRec.getSuffixNumber();
		String suffixGender = outputInflectionRec.getSuffixGender();
		String baseQuantifierType = outputInflectionRec.getBaseQuantifierType();
		String construct = outputInflectionRec.getSuffixStatus();
		String script = outputInflectionRec.getScript();
		String PGN = outputInflectionRec.getPGN();
		String baseConjunctionType = outputInflectionRec
				.getBaseConjunctionType();
		String basePerson = outputInflectionRec.getBasePerson();
		String basePronounType = outputInflectionRec.getBasePronounType();
		String binyan = outputInflectionRec.getBinyan();
		String root = outputInflectionRec.getRoot();
		root = URLDecoder.decode(root, "UTF-8");
		String tense = outputInflectionRec.getTense();
		String baseNamedEntityType = outputInflectionRec
				.getBaseNamedEntityType();
		String suffixPerson = outputInflectionRec.getSuffixPerson();
		String accusativeNominativePGN = outputInflectionRec
				.getAccusativeNominativePGN();
		String definitness = "";
		if ((definiteArticleTag && baseDefinitnessi == BASE_DEFINITNESS_TRUE_FALSE)
				|| (!definiteArticleTag && baseDefinitnessi == BASE_DEFINITNESS_TRUE_TRUE))
			definitness = "true";
		else
			definitness = "false";
		String baseNumeralType = outputInflectionRec.getBaseNumeralType();
		String dottedLexiconItem = outputInflectionRec.getDottedLexiconItem();
		switch (outputPattern) {
		case QUANTIFIER:

			if (suffixFunctioni != SUFFIX_FUNCTION_POSSESSIVE
					&& (constructi == CONSTRUCT_TRUE))

				output.append(preOutput).append("[+gender]+")
						.append(baseGender).append("[+type]+").append(
								baseQuantifierType).append("[+register]+")
						.append(script).append("[+construct]+").append(
								construct);

			else if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE
					&& (constructi == CONSTRUCT_TRUE))
				output.append(preOutput).append("[+gender]+")
						.append(baseGender).append("[+type]+").append(
								baseQuantifierType).append("[+register]+")
						.append(script).append("[+construct]+").append(
								construct).append("[+pronomialSuffix]+")
						.append(PGN);

			else if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE
					&& (constructi == CONSTRUCT_FALSE))
				output.append(preOutput).append("[+gender]+")
						.append(baseGender).append("[+type]+").append(
								baseQuantifierType).append("[+register]+")
						.append(script).append("[+pronomialSuffix]+").append(
								PGN);
			else
				output.append(preOutput).append("[+gender]+")
						.append(baseGender).append("[+type]+").append(
								baseQuantifierType).append("[+register]+")
						.append(script);

			break;
		case INTERJECTION:
		case INTERROGATIVE:

			if (suffixFunctioni != SUFFIX_FUNCTION_POSSESSIVE)
				output.append(preOutput).append("[+register]+").append(script);

			else
				output.append(preOutput).append("[+possessiveSuffix]+").append(
						PGN);

			break;

		case CONJUNCTION:

			output.append(preOutput).append("[+type]+").append(
					baseConjunctionType).append("[+register]+").append(script);
			break;

		case ADVERB:

			if (suffixFunctioni != SUFFIX_FUNCTION_POSSESSIVE) {
				output.append(preOutput);
			} else
				output.append(preOutput).append("[+possessiveSuffix]+").append(
						PGN);
			break;
		case PREPOSITION:

			if (suffixFunctioni != SUFFIX_FUNCTION_POSSESSIVE || PGN.equals("")) {
				output.append(preOutput).append("[+register]+").append(script);
			} else
				output.append(preOutput).append("[+register]+").append(script)
						.append("[+person/gender/number]+").append(PGN);
			break;
		case NOUN:
		case ADJECTIVE:

			if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) {
				output.append(preOutput).append("[+gender]+")
						.append(baseGender).append("[+number]+").append(
								baseNumber).append("[+register]+").append(
								script).append("[+construct]+").append(
								construct).append("[+possessiveSuffix]+")
						.append(PGN);

			} else {

				output.append(preOutput).append("[+gender]+")
						.append(baseGender).append("[+number]+").append(
								baseNumber).append("[+definiteness]+").append(
								definitness).append("[+register]+").append(
								script).append("[+construct]+").append(
								construct);

			}

			break;
		case PRONOUN:

			output.append(preOutput).append("[+gender]+").append(baseGender)
					.append("[+number]+").append(baseNumber).append(
							"[+person]+").append(basePerson).append("[+type]+")
					.append(basePronounType).append("[+register]+").append(
							script);
			break;

		case PROPERNAME:

			output.append(preOutput).append("[+gender]+").append(baseGender)
					.append("[+number]+").append(baseNumber).append("[+type]+")
					.append(baseNamedEntityType).append("[+definiteness]+")
					.append(definitness).append("[+register]+").append(script);
			break;
		case VERB:
			if (suffixFunctioni == SUFFIX_FUNCTION_ACCUSATIVE_OR_NOMINATIVE)
				output.append(preOutput).append("[+root]").append(root).append(
						"[+binyan]+").append(binyan).append(
						"[+person/gender/number]+").append(
						accusativeNominativePGN).append("[+register]+").append(
						script).append("[+tense]+").append(tense);
			else

				output.append(preOutput).append("[+root]").append(root).append(
						"[+binyan]+").append(binyan).append(
						"[+person/gender/number]+").append(PGN).append(
						"[+register]+").append(script).append("[+tense]+")
						.append(tense);
			break;
		case NEGATION:

			output.append(preOutput).append("[+register]+").append(script);
			break;
		case PARTICIPLE:
			if (suffixFunctioni != SUFFIX_FUNCTION_POSSESSIVE)
				output.append(preOutput).append("[+root]").append(root).append(
						"[+binyan]+").append(binyan).append("[+register]+")
						.append(script).append("[+tense]+").append(tense)
						.append("[+person]+").append(basePerson).append(
								"[+gender]+").append(baseGender).append(
								"[+number]+").append(baseNumber).append(
								"[+construct]+").append(construct).append(
								"[+definiteness]+").append(definitness);
			else
				output.append(preOutput).append("[+root]").append(root).append(
						"[+binyan]+").append(binyan).append("[+register]+")
						.append(script).append("[+tense]+").append(tense)
						.append("[+construct]+").append(construct).append(
								"[+person]+").append(basePerson).append(
								"[+gender]+").append(baseGender).append(
								"[+number]+").append(baseNumber).append(
								"[+person/gender/number]+").append(PGN);
			break;
		case PASSIVEPARTICIPLE:
			output.append(preOutput).append("[+root]").append(root).append(
					"[+binyan]+").append(binyan).append("[+register]+").append(
					script).append("[+person]+").append(basePerson).append("[+gender]+")
					.append(baseGender).append("[+number]+").append(baseNumber)
					.append("[+construct]+").append(construct).append(
							"[+definiteness]+").append(definitness).append("[+mood]+").append("passive");
			break;
		case NUMERAL:
			output.append(preOutput).append("[+gender]+").append(baseGender)
					.append("[+number]+").append(baseNumber).append("[+type]+")
					.append(baseNumeralType).append("[+construct]+").append(
							construct).append("[+definiteness]+").append(
							definitness).append("[+register]+").append(script);
			break;
		case EXISTENTIAL:
			output.append(preOutput).append("[+gender]+").append(baseGender)
					.append("[+number]+").append(baseNumber).append("[+root]+")
					.append(root).append("[+tense]+").append(tense).append(
							"[+person]+").append(basePerson).append(
							"[+definiteness]+").append(definitness);
			break;
		case IMPERSONAL:
			output.append(preOutput).append("[+gender]+").append(baseGender)
					.append("[+number]+").append(baseNumber).append("[+type]+")
					.append(baseQuantifierType).append("[+construct]+").append(
							construct).append("[+definiteness]+").append(
							definitness).append("[+register]+").append(script);
			break;
		case MODALS:
			output.append(preOutput).append("[+gender]+").append(baseGender)
					.append("[+number]+").append(baseNumber).append(
							"[+definiteness]+").append(definitness).append(
							"[+register]+").append(script);
			break;
		case WPREFIX:
			output.append(preOutput).append("[+register]+").append(script);
			break;
		case PREFIXES:
			output.append(preOutput).append("[+register]+").append(script);
			break;
		}
		return output;
	}

	public static StringBuffer buildGematriaOutput(String hebWord, int value) {
		StringBuffer output = new StringBuffer();
		output = new StringBuffer(150).append(hebWord)
				.append("	[	+numeral]").append("[+undotted]")
				.append(hebWord).append("[+type]+gematria").append(
						"[+value]+" + value);
		return output;
	}

	public static StringBuffer buildGematriaOutput(int value,
			StringBuffer output, boolean definiteArticleTag, String prefix,
			String base) {
		base = Translate.Eng2Heb(base);
		if (prefix.endsWith("h"))
			output.append("[+numeral]").append(" [+undotted]").append(base)
					.append("[+type]+gematria").append("[+value]+" + value);
		else
			output.append("[+definiteness]+").append(definiteArticleTag)
					.append("[+numeral]").append("[+undotted]").append(base)
					.append("[+type]+gematria").append("[+value]+" + value);
		return output;
	}

	public static StringBuffer buildSimpleOutput(int outputPattern,
			String hebWord) {
		StringBuffer output = new StringBuffer();
		switch (outputPattern) {
		case PUNCTUATION:
			output = new StringBuffer(150).append(hebWord).append(
					"	[	+punctuation]").append(hebWord);
			break;

		case URL:
			output = new StringBuffer(150).append(hebWord).append("	[	+URL]")
					.append(hebWord);
			break;

		case FOREIGN:
			output = new StringBuffer(150).append(hebWord).append(
					"	[	+foreign]").append(hebWord);
			break;
		case LITERAL_NUMBERS:
			output = new StringBuffer(150).append(hebWord).append(
					"	[	+numeral]").append("[+type]+literal number");
			break;

		//		case GEMATRIA:
		//			output = new StringBuffer(150).append(hebWord).append(
		//					" [ +quantifier]").append("[+type]+gematria").append("[+value]+" +
		// value);
		//			break;
		case NO_ENTRY:
			output = new StringBuffer(150).append(hebWord).append("	").append(
					hebWord).append("	").append(" +?");

		}
		//System.out.println("output =" + output);
		return output;
	}

	static public void buildXMLOutput(int outputPattern,
			InflectRecord outputInflectionRec, String hebWord, int constructi,
			int suffixFunctioni, CreateCorpusXML createXML)
			throws JAXBException, UnsupportedEncodingException {
		String baseGender = outputInflectionRec.getBaseGender();
		String baseNumber = outputInflectionRec.getBaseNumber();
		String suffixNumber = outputInflectionRec.getSuffixNumber();
		String suffixGender = outputInflectionRec.getSuffixGender();
		String baseQuantifierType = outputInflectionRec.getBaseQuantifierType();
		String construct = setStatus(outputInflectionRec.getSuffixStatus());
		String script = outputInflectionRec.getScript();
		String PGN = outputInflectionRec.getPGN();
		String baseConjunctionType = outputInflectionRec
				.getBaseConjunctionType();
		String basePerson = outputInflectionRec.getBasePerson();
		String basePronounType = outputInflectionRec.getBasePronounType();
		String binyan = outputInflectionRec.getBinyan();
		String root = outputInflectionRec.getRoot();
		root = URLDecoder.decode(root, "UTF-8");
		String tense = outputInflectionRec.getTense();
		String id = outputInflectionRec.getBaseLexiconPointer();
		String transliterated = outputInflectionRec
				.getBaseTransliteratedLItem();
		String baseNamedEntityType = outputInflectionRec
				.getBaseNamedEntityType();
		String undotted = outputInflectionRec.getBaseUndottedLItem();
		String suffixPerson = outputInflectionRec.getSuffixPerson();
		String suffixFunction = outputInflectionRec.getSuffixFunction();
		String baseDefinitness = outputInflectionRec.getBaseDefinitness();
		String baseNumeralType = outputInflectionRec.getBaseNumeralType();
		String register = outputInflectionRec.getScript();
		String dottedLexiconItem = outputInflectionRec.getDottedLexiconItem();
		if (dottedLexiconItem ==null)
			dottedLexiconItem = "";

		if (baseDefinitness.equals("tt"))
			baseDefinitness = "true";
		else
			baseDefinitness = "false";
		switch (outputPattern) {
		case QUANTIFIER:
			createXML.createQuantifierAnalysis(baseGender, baseNumber,
					construct, PGN, baseQuantifierType, transliterated,
					undotted, id, suffixFunction, suffixNumber, suffixGender,
					suffixPerson, -1, register,dottedLexiconItem);
			break;
		case INTERJECTION:
			createXML.createInterjectionAnalysis(transliterated, undotted, id, hebWord, register, dottedLexiconItem);
			break;
		case INTERROGATIVE:
			createXML.createInterrogativeAnalysis(baseGender, baseNumber,
					basePerson, transliterated, undotted, id,hebWord, register, dottedLexiconItem);
			break;
		case CONJUNCTION:
			createXML.createConjunctionAnalysis(baseConjunctionType,
					transliterated, undotted, id, hebWord, register, dottedLexiconItem);
			break;
		case ADVERB:
			createXML.createAdverbAnalysis(baseGender, baseNumber, basePerson,
					transliterated, undotted, id, hebWord, register, dottedLexiconItem);
			break;
		case PREPOSITION:
			createXML.createPrepositionAnalysis(suffixGender, suffixNumber,
					suffixPerson, transliterated, undotted, id, suffixFunction, hebWord, register, dottedLexiconItem);
			break;

		case ADJECTIVE:
			createXML.createAdjectiveAnalysis(baseGender, baseNumber,
					construct, transliterated, undotted, id, baseDefinitness,  hebWord, register, dottedLexiconItem);
			break;
		case NOUN:
			createXML
					.createNounAnalysis(baseGender, baseNumber, construct,
							basePerson, transliterated, undotted, id,
							suffixNumber, suffixGender, suffixPerson,
							suffixFunction, baseDefinitness, hebWord, register, dottedLexiconItem);
			break;
		case PRONOUN:
			createXML.createPronounAnalysis(baseGender, baseNumber, basePerson,
					basePronounType, transliterated, undotted, id, hebWord, register, dottedLexiconItem);
			break;
		case PROPERNAME:
			createXML.createProperNameAnalysis(baseGender, baseNumber, "",
					baseNamedEntityType, transliterated, undotted, id,
					baseDefinitness, hebWord, register, dottedLexiconItem);
			break;
		case VERB:
			createXML.createVerbAnalysis(binyan, baseGender, baseNumber,
					basePerson, root, tense, transliterated, undotted, id, hebWord, register, dottedLexiconItem);

			break;
		case NEGATION:
			createXML.createNegationAnalysis(transliterated, undotted, id, hebWord, register, dottedLexiconItem);
			break;
		case PARTICIPLE:
			createXML.createParticipleAnalysis(baseGender, baseNumber,
					construct, basePerson, transliterated, undotted, id, root,
					tense, binyan, suffixFunction, suffixPerson, suffixGender,
					suffixNumber, baseDefinitness, hebWord, register, dottedLexiconItem);
			break;
		case PASSIVEPARTICIPLE:
			createXML.createPassiveParticipleAnalysis(baseGender, baseNumber,
					construct, basePerson, transliterated, undotted, id, root,
					tense, binyan, suffixFunction, suffixPerson, suffixGender,
					suffixNumber, baseDefinitness, hebWord, register, dottedLexiconItem);
			break;
		case WPREFIX:
			createXML.createWprefixAnalysis(transliterated, undotted, id, hebWord, register, dottedLexiconItem);
			break;
		case NUMERAL:
			createXML.createNumeralAnalysis(baseGender, baseNumber, construct,
					basePerson, transliterated, undotted, id, suffixFunction,
					suffixNumber, suffixGender, suffixPerson, baseDefinitness,
					baseNumeralType, hebWord, register, dottedLexiconItem);
			break;
		case EXISTENTIAL:
			createXML.createExistentialAnalysis(baseGender, baseNumber,
					transliterated, undotted, id, root, tense, baseDefinitness,
					basePerson, hebWord, register, dottedLexiconItem);
			break;
		case IMPERSONAL:
			createXML.createImpersonalAnalysis(transliterated, undotted, id, hebWord, dottedLexiconItem);
			break;
		case MODALS:
			createXML.createModalAnalysis(baseGender, baseNumber,
					transliterated, undotted, id, hebWord, register, dottedLexiconItem);
			break;
	
		}
	}

	static public void buildXMLPrefixOutput(PrefixRecord pr, int outputPattern,
			InflectRecord outputInflectionRec, CreateCorpusXML createXML,
			int suffixFunctioni, int baseDefinitnessi, int value, String base)
			throws Exception {
		String baseGender = "";
		String baseNumber = "";
		String construct = "";
		String PGN = "";
		String transliterated = "";
		String undotted = "";
		String id = "";
		String description = "";
		String suffixFunction = "";
		String suffixNumber = "";
		String suffixGender = "";
		String suffixPerson = "";
		String definitness = "";
		String register="";
		
		boolean definiteArticleTag = false;

		if (outputPattern == GEMATRIA) {
			if (pr == null) {
				description = "definiteArticle";
				definitness = "true";
			} else {
				description = pr.getDescription();
				definiteArticleTag = pr.isDefiniteArticleTag();
				if (definiteArticleTag)
					definitness = "true";
				else
					definitness = "false";
			}

			if (baseDefinitnessi == 2)
				definitness = "true";
			
			createXML.createPrefixNumeralAnalysis("", "", "", "",
					"gematria", "", "", "", description, "", "", "", "", 
					definitness,String.valueOf(value), register, "");
			// for cases such as: "  " -  for the prefix  
		} else if (outputPattern == PREFIXES) {
			//prefix=h
			if (pr == null) {
				createXML.createPrefixesAnalysis("definiteArticle", 0);
			} else {
				description = pr.getDescription();
				definiteArticleTag = pr.isDefiniteArticleTag();
				createXML.createPrefixesAnalysis(description, baseDefinitnessi);
			}
		} else {
			definiteArticleTag = pr.isDefiniteArticleTag();
			description = pr.getDescription();
			String baseQuantifierType = outputInflectionRec
					.getBaseQuantifierType();
			baseGender = outputInflectionRec.getBaseGender();
			baseNumber = outputInflectionRec.getBaseNumber();
			suffixNumber = outputInflectionRec.getSuffixNumber();
			suffixGender = outputInflectionRec.getSuffixGender();
			construct = outputInflectionRec.getSuffixStatus();
			construct = setStatus(construct);
			String script = outputInflectionRec.getScript();
			PGN = outputInflectionRec.getPGN();
			String baseConjunctionType = outputInflectionRec
					.getBaseConjunctionType();
			String baseNumeralType = outputInflectionRec.getBaseNumeralType();
			String basePerson = outputInflectionRec.getBasePerson();
			String basePronounType = outputInflectionRec.getBasePronounType();
			String binyan = outputInflectionRec.getBinyan();
			String root = outputInflectionRec.getRoot();
			root = URLDecoder.decode(root, "UTF-8");
			String tense = outputInflectionRec.getTense();
			id = outputInflectionRec.getBaseLexiconPointer();
			transliterated = outputInflectionRec.getBaseTransliteratedLItem();
			register = outputInflectionRec.getScript();
			String baseNamedEntityType = outputInflectionRec
					.getBaseNamedEntityType();
			undotted = outputInflectionRec.getBaseUndottedLItem();
			suffixPerson = outputInflectionRec.getSuffixPerson();
			suffixFunction = outputInflectionRec.getSuffixFunction();
			String accusativeNominativeNumber = outputInflectionRec
					.getAccusativeNominativeNumber();
			String accusativeNominativeGender = outputInflectionRec
					.getAccusativeNominativeGender();
			String accusativeNominativePerson = outputInflectionRec
					.getAccusativeNominativePerson();
			String dottedLexiconItem = outputInflectionRec.getDottedLexiconItem();

			if ((definiteArticleTag && baseDefinitnessi == BASE_DEFINITNESS_TRUE_FALSE)
					|| (!definiteArticleTag && baseDefinitnessi == BASE_DEFINITNESS_TRUE_TRUE))
				definitness = "true";
			else
				definitness = "false";
			switch (outputPattern) {
			case QUANTIFIER:
				createXML.createPrefixQuantifierAnalysis(baseGender,
						baseNumber, construct, PGN, baseQuantifierType,
						transliterated, undotted, id, description,
						suffixFunction, suffixNumber, suffixGender,
						suffixPerson, -1, "", base, register, dottedLexiconItem);
				break;
				case NUMERAL:
					createXML.createPrefixNumeralAnalysis(baseGender,
							baseNumber, construct, PGN, baseNumeralType,
							transliterated, undotted, id, description,
							suffixFunction, suffixNumber, suffixGender,
							suffixPerson,  definitness, base, register, dottedLexiconItem);
					break;
			case INTERJECTION:
				createXML.createPrefixInterjectionAnalysis(transliterated,
						undotted, id, description, base, register, dottedLexiconItem);
				break;
			case INTERROGATIVE:
				createXML.createPrefixInterrogativeAnalysis(baseGender,
						baseNumber, basePerson, transliterated, undotted, id,
						description, base, register, dottedLexiconItem);
				break;
			case CONJUNCTION:
				createXML.createPrefixConjunctionAnalysis(baseConjunctionType,
						transliterated, undotted, id, description, base, register, dottedLexiconItem);
				break;
			case ADVERB:
				createXML.createPrefixAdverbAnalysis(baseGender, baseNumber,
						basePerson, transliterated, undotted, id, description, base, register, dottedLexiconItem);

				break;
			case PREPOSITION:
				createXML.createPrefixPrepositionAnalysis(suffixGender,
						suffixNumber, suffixPerson, transliterated, undotted,
						id, description, suffixFunction, base, register, dottedLexiconItem);
				break;

			case ADJECTIVE:
				createXML.createPrefixAdjectiveAnalysis(baseGender, baseNumber,
						construct, transliterated, undotted, id, description,
						definitness, base, register, dottedLexiconItem);
				break;
			case NOUN:
				createXML.createPrefixNounAnalysis(baseGender, baseNumber,
						construct, PGN, transliterated, undotted, id,
						description, suffixNumber, suffixGender, suffixPerson,
						suffixFunction, definitness, base, register, dottedLexiconItem);
				break;
			case PRONOUN:
				createXML.createPrefixPronounAnalysis(baseGender, baseNumber,
						basePerson, basePronounType, transliterated, undotted,
						id, description,base, register, dottedLexiconItem);
				break;
			case PROPERNAME:
				createXML.createPrefixProperNameAnalysis(baseGender,
						baseNumber, "", baseNamedEntityType, transliterated,
						undotted, id, description, definitness, base, register, dottedLexiconItem);
				break;
			case VERB:
				createXML.createPrefixVerbAnalysis(binyan, baseGender,
						baseNumber, basePerson, root, tense, transliterated,
						undotted, id, description, suffixFunction,
						accusativeNominativeNumber, accusativeNominativeGender,
						accusativeNominativePerson, base, register, dottedLexiconItem);

				break;
			case NEGATION:
				createXML.createPrefixNegationAnalysis(transliterated,
						undotted, id, description, base, register, dottedLexiconItem);
				break;
			case WPREFIX:
				createXML.createPrefixWprefixAnalysis(transliterated,
						undotted, id, description, base, register, dottedLexiconItem);
				break;
			case PARTICIPLE:
				createXML.createPrefixParticipleAnalysis(baseGender,
						baseNumber, construct, basePerson, transliterated,
						undotted, id, description, root, tense, binyan,
						suffixFunction, suffixPerson, suffixGender,
						suffixNumber, definitness, base, register, dottedLexiconItem);
				break;
			case PASSIVEPARTICIPLE:
				createXML.createPrefixParticipleAnalysis(baseGender,
						baseNumber, construct, basePerson, transliterated,
						undotted, id, description, root, tense, binyan,
						suffixFunction, suffixPerson, suffixGender,
						suffixNumber, definitness, base, register, dottedLexiconItem);
				break;
			}
		}

	}

	static public void buildSimpleXMLAnalysis(int outputPattern,
			CreateCorpusXML createXML, String hebWord, int value)
			throws JAXBException {
		switch (outputPattern) {
		case PUNCTUATION:
			createXML.createPunctuationAnalysis(hebWord);
			break;
		//		case GEMATRIA:
		//			createXML.createQuantifierAnalysis("", "", "", "", "gematria", "",
		//					"", hebWord, "unspecified", "", "", "",value);
		//			break;

		case LITERAL_NUMBERS:
			createXML.createNumeralAnalysis("",   "",
					  "", "",  "",
					 "", "",  "",
					  "",   "", "",
					  "",  "literal number",  hebWord,"", "");
			break;
		case FOREIGN:
			createXML.createForeignAnalysis();
			break;
		case URL:
			createXML.createURLAnalysis();
			break;
		}

	}

}
