/*
 * Created on 09/02/2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package lexicon.analyse;


/**
 * @author daliabo
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Encoder {
	static final String QUANTIFIER = "1";

	static final String INTERJECTION = "2";

	static final String INTERROGATIVE = "3";

	static final String CONJUNCTION = "4";

	static final String ADVERB = "5";

	static final String PREPOSITION = "6";

	static final String NOUN = "7";

	static final String ADJECTIVE = "8";

	static final String PRONOUN = "9";

	static final String PROPERNAME = "10";

	static final String VERB = "11";

	static final String NEGATION = "12";
	
	static final String PARTICIPLE = "13";
	
	static final String NUMERAL = "20";
	
	static final String EXISTENTIAL = "21";
	
	static final String IMPERSONAL = "22";
	
	static final String MODALS = "23";
	
	static final String WPREFIX = "24";
	
	static final String PREFIXES = "25";
	
	static final String PASSIVEPARTICIPLE = "26";

	static final String CONSTRUCT_UNDEFINED = "0";

	static final String CONSTRUCT_TRUE = "1";

	static final String CONSTRUCT_FALSE = "2";


	public static String encodeConstruct(String construct) {
		String strConstruct = "";
		if (construct == null || construct.equals("unspecified")
				|| construct.equals("null") || construct.equals("")) {
			strConstruct = CONSTRUCT_UNDEFINED;
		} else if (construct.equals("construct") || construct.equals("true") ) {
			strConstruct = CONSTRUCT_TRUE;
		} else if (construct.equals("absolute") || construct.equals("false")) {
			strConstruct = CONSTRUCT_FALSE;
		} else {
			System.out.println("illegal construct" + construct);
			System.exit(1);
		}
		return strConstruct;
	}

	public static String encodeBasePos(String basePos) {
		String strBasePos = "0";
		if (basePos.equals("quantifier"))
			strBasePos = QUANTIFIER;
		else if (basePos.equals("interjection"))
			strBasePos = INTERJECTION;
		else if (basePos.equals("interrogative"))
			strBasePos = INTERROGATIVE;
		else if (basePos.equals("conjunction"))
			strBasePos = CONJUNCTION;
		else if (basePos.equals("adverb"))
			strBasePos = ADVERB;
		else if (basePos.equals("preposition"))
			strBasePos = PREPOSITION;
		else if (basePos.equals("noun"))
			strBasePos = NOUN;
		else if (basePos.equals("adjective"))
			strBasePos = ADJECTIVE;
		else if (basePos.equals("pronoun"))
			strBasePos = PRONOUN;
		else if (basePos.equals("properName"))
			strBasePos = PROPERNAME;
		else if (basePos.equals("verb"))
			strBasePos = VERB;
		else if (basePos.equals("negation"))
			strBasePos = NEGATION;
		else if (basePos.equals("participle"))
			strBasePos = PARTICIPLE;
		else if (basePos.equals("numeral"))
			strBasePos = NUMERAL;
		else if (basePos.equals("existential"))
			strBasePos = EXISTENTIAL;
		else if (basePos.equals("impersonal"))
			strBasePos = IMPERSONAL;
		else if (basePos.equals("modals"))
			strBasePos = MODALS;
		else if (basePos.equals("wPrefix"))
			strBasePos = WPREFIX;
		else if (basePos.equals("passiveParticiple"))
			strBasePos = PASSIVEPARTICIPLE;
		else {
			System.out.println("Encoder.encodeBasePos: illegal basePos: " + basePos);
			System.exit(1);
		}
		return strBasePos;
	}

	public static String encodeBinyan(String binyan) {
		String strBinyan = "0";
		if (binyan.equals("Pa'al"))
			strBinyan = "1";
		else if (binyan.equals("Nif'al"))
			strBinyan = "2";
		else if (binyan.equals("Pi'el"))
			strBinyan = "3";
		else if (binyan.equals("Pu'al"))
			strBinyan = "4";
		else if (binyan.equals("Hif'il"))
			strBinyan = "5";
		else if (binyan.equals("Huf'al"))
			strBinyan = "6";
		else if (binyan.equals("Hitpa'el"))
			strBinyan = "7";
		else if (binyan.equals(""))
			strBinyan = "-1";
		else {
			System.out.println("illegal binyan: " + binyan);
			System.exit(1);
		}
		return strBinyan;
	}

	public static String encodePGN(String PGN) {
		String strPGN = "";
		if (PGN.equals("1p/MF/Sg"))
			strPGN = "1";
		else if (PGN.equals("2p/F/Sg"))
			strPGN = "2";
		else if (PGN.equals("2p/M/Sg"))
			strPGN = "3";
		else if (PGN.equals("3p/M/Sg"))
			strPGN = "4";
		else if (PGN.equals("3p/F/Sg"))
			strPGN = "5";
		else if (PGN.equals("1p/MF/Pl"))
			strPGN = "6";
		else if (PGN.equals("2p/M/Pl"))
			strPGN = "7";
		else if (PGN.equals("2p/F/Pl"))
			strPGN = "8";
		else if (PGN.equals("3p/M/Pl"))
			strPGN = "9";
		else if (PGN.equals("3p/F/Pl"))
			strPGN = "10";
		else if (PGN.equals("123p/M/Sg"))
			strPGN = "11";
		else if (PGN.equals("123p/F/Sg"))
			strPGN = "12";
		else if (PGN.equals("123p/F/Pl"))
			strPGN = "13";
		else if (PGN.equals("123p/M/Pl"))
			strPGN = "14";
		else if (PGN.equals("unspecified"))
			strPGN = "15";
		else if (PGN.equals("NONE"))
			strPGN = "16";
		else {
			System.out.println("illegal PGN: " + PGN);
			System.exit(1);
		}
		return strPGN;
	}

	public static String encodeTense(String tense, String lexiconItem, String word) {
		String strTense = "";
		if (tense.equals("imperative"))
			strTense = "1";
		else if (tense.equals("past"))
			strTense = "2";
		else if (tense.equals("beinoni"))
			strTense = "3";
		else if (tense.equals("future"))
			strTense = "4";
		else if (tense.equals("infinitive"))
			strTense = "5";
		else if (tense.equals("bareInfinitive"))
			strTense = "6";
		else if (tense.equals("linfinitive"))
			strTense = "7";
		else if (tense.equals(""))
			strTense = "-1";
		else {
			System.out.println("illegal tense: " + tense + " for lexiconItem: " + lexiconItem + " for input token: " + word);
			//System.exit(1);
		}
		return strTense;
	}

	public static String encodeScript(String script) {
		String strScript = "";
		if (script.equals("formal"))
			strScript = "1";
		else if (script.equals("colloquial"))
			strScript = "2";
		else if (script.equals("slang"))
			strScript = "3";
		else if (script.equals("typo"))
			strScript = "4";
		else {
			System.out.println("illegal script: " + script);
			System.exit(1);
		}
		return strScript;
	}

	public static String encodeNumber(String number) {
		String strNumber = "";
		if (number.equals("singular"))
			strNumber = "1";
		else if (number.equals("plural"))
			strNumber = "2";
		else if (number.equals("unspecified"))
			strNumber = "3";
		else if (number.equals("dual and plural"))
			strNumber = "4";
		else if (number.equals("dual"))
			strNumber = "5";
		else if (number.equals("singular and plural"))
			strNumber = "6";
		else {
			System.out.println("illegal number: " + number);
			System.exit(1);
		}
		return strNumber;
	}

	public static String encodeGender(String gender) {
		String strGender = "";
		if (gender.equals("masculine"))
			strGender = "1";
		else if (gender.equals("feminine"))
			strGender = "2";
		else if (gender.equals("unspecified"))
			strGender = "3";
		else if (gender.equals("masculine and feminine"))
			strGender = "4";
		else if (gender.equals("irrelevant"))
			strGender = "5";
		else {
			System.out.println("illegal gender: " + gender);
			System.exit(1);
		}
		return strGender;
	}

	public static String encodeBaseDefinitness(String baseDefinitness) {
		String strBaseDefinitness = "";
		if (baseDefinitness.equals("tt"))
			strBaseDefinitness = "1";
		else if (baseDefinitness.equals("tf"))
			strBaseDefinitness = "2";
		else if (baseDefinitness.equals("f"))
			strBaseDefinitness = "3";
		//else if (baseDefinitness.equals("false"))
		//	strBaseDefinitness = "f";
		//else if (baseDefinitness.equals("true"))
		//	strBaseDefinitness = "t";
		else {
			System.out.println("illegal baseDefinitness: " + baseDefinitness);
			System.exit(1);
		}
		return strBaseDefinitness;
	}

	public static String encodeBaseConjunctionType(String baseConjunctionType) {
		String strBaseConjunctionType = "";
		if (baseConjunctionType.equals("coordinating")) {
			strBaseConjunctionType = "c";
		} else if (baseConjunctionType.equals("subordinating"))
			strBaseConjunctionType = "s";
		else if (baseConjunctionType.equals("relativizing"))
			strBaseConjunctionType = "r";
		else {
			System.out.println("illegal baseConjunctionType: "
					+ baseConjunctionType);
			System.exit(1);
		}
		return strBaseConjunctionType;
	}

	public static String encodeBaseQuantifierType(String baseQuantifierType) {
		//System.out.println("encodeBaseQuantifierType: " + baseQuantifierType);
		String strBaseQuantifierType = "";
		if (baseQuantifierType.equals("numeral cardinal"))
			strBaseQuantifierType = "1";
		else if (baseQuantifierType.equals("non-numeral"))
			strBaseQuantifierType = "2";
		else if (baseQuantifierType.equals("numeral ordinal"))
			strBaseQuantifierType = "3";
		else if (baseQuantifierType.equals("unspecified"))
			strBaseQuantifierType = "4";
		else if (baseQuantifierType.equals("numeral fractional"))
			strBaseQuantifierType = "5";
		else {
			strBaseQuantifierType = "-1";
			//System.out.println("illegal baseQuantifierType: "
			//		+ baseQuantifierType);
			//System.exit(1);
		}
		return strBaseQuantifierType;
	}

	public static String encodeBasePronounType(String basePronounType) {
		String strBasePronounType = "";
		if (basePronounType.equals("interrogative"))
			strBasePronounType = "1";
		else if (basePronounType.equals("personal"))
			strBasePronounType = "2";
		else if (basePronounType.equals("demonstrative"))
			strBasePronounType = "3";
		else if (basePronounType.equals("impersonal"))
			strBasePronounType = "4";
		else if (basePronounType.equals("relativizer"))
			strBasePronounType = "5";
		else {
			strBasePronounType = "-1";
			//System.out.println("illegal basePronounType: " + basePronounType);
			//System.exit(1);
		}
		return strBasePronounType;
	}

	public static String encodeBaseNamedEntityType(String baseNamedEntityType) {
		String strBaseNamedEntityType = "";
		if (baseNamedEntityType.equals("location"))
			strBaseNamedEntityType = "1";
		else if (baseNamedEntityType.equals("person"))
			strBaseNamedEntityType = "2";
		else if (baseNamedEntityType.equals("organization"))
			strBaseNamedEntityType = "3";
		else if (baseNamedEntityType.equals("dateTime"))
			strBaseNamedEntityType = "4";
		else if (baseNamedEntityType.equals("other"))
			strBaseNamedEntityType = "5";
		else if (baseNamedEntityType.equals("product"))
			strBaseNamedEntityType = "6";
		else if (baseNamedEntityType.equals("unspecified"))
			strBaseNamedEntityType = "7";
		else {
			System.out.println("illegal baseNamedEntityType: "
					+ baseNamedEntityType);
			System.exit(1);
		}
		return strBaseNamedEntityType;
	}
	
	public static String encodeSuffixFunction(String suffixFunction){
		String suffixFunctioni ="";
		if (suffixFunction.equals("possessive"))
			suffixFunctioni = "1";
		else if (suffixFunction.equals("accusative or nominative"))
			suffixFunctioni = "2";
		else if (suffixFunction.equals("unspecified"))
			suffixFunctioni = "3";
		else{
			System.out.println("illegal suffixFunction: "
					+ suffixFunction);
			System.exit(1);
		}
		return	suffixFunctioni;
	}


	public static void main(String[] args) {
	}
}
