/*
 * Created on 05/02/2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package lexicon.analyse;

/**
 * @author daliabo
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
/**
 * @author daliabo
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class Decoder implements Constants {

	public static String decodeSuffixFunction(int suffixFunctioni,
			String transliterated) {
		String suffixFunction = "";
		switch (suffixFunctioni) {
		case 1:
			suffixFunction = "possessive";
			break;
		case 2:
			suffixFunction = "accusative or nominative";
			break;
		case 3:
			suffixFunction = "unspecified";
			break;
		default:
			System.out.println("illegal suffixFunctioni: " + suffixFunctioni
					+ "for transliterated: " + transliterated);
			System.exit(1);
		}
		return suffixFunction;
	}

	/**
	 * This method decodes the part of speech
	 * 
	 * @param posi -
	 *            the encoded value of the part of speech in the
	 *            inflections.data file
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return the decoded part of speech value
	 */
	public static String decodePos(int posi, String transliterated) {
		String pos = "";
		switch (posi) {
		case QUANTIFIER:
			pos = "quantifier";
			break;
		case INTERJECTION:
			pos = "interjection";
			break;
		case INTERROGATIVE:
			pos = "interrogative";
			break;
		case CONJUNCTION:
			pos = "conjunction";
			break;
		case ADVERB:
			pos = "adverb";
			break;
		case PREPOSITION:
			pos = "preposition";
			break;
		case NOUN:
			pos = "noun";
			break;
		case ADJECTIVE:
			pos = "adjective";
			break;
		case PRONOUN:
			pos = "pronoun";
			break;
		case PROPERNAME:
			pos = "properName";
			break;
		case VERB:
			pos = "verb";
			break;
		case NEGATION:
			pos = "negation";
			break;
		case PARTICIPLE:
			pos = "participle";
			break;
		case NUMERAL:
			pos = "numeral";
			break;
		case EXISTENTIAL:
			pos = "existential";
			break;
		case IMPERSONAL:
			pos = "impersonal";
			break;
		case MODALS:
			pos = "modals";
			break;
		case WPREFIX:
			pos = "wPrefix";
			break;
		case PASSIVEPARTICIPLE:
			pos = "passiveParticiple";
			break;
		default:
			System.out.println("Decoder:decodePos:  illegal posi: " + posi + "for transliterated: "
					+ transliterated);
			System.exit(1);
		}
		return pos;
	}

	/**
	 * This method decodes the script value
	 * 
	 * @param scripti -
	 *            the encoded value of the script in the inflections.data file
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return the decoded script value
	 */
	public static String decodeScript(int scripti, String transliterated) {
		String script = "";
		switch (scripti) {
		case 1:
			script = "formal";
			break;
		case 2:
			script = "colloquial";
			break;
		case 3:
			script = "slang";
			break;
		case 4:
			script = "typo";
			break;
		default:
			System.out.println("illegal scripti: " + scripti
					+ "for transliterated: " + transliterated);
			System.exit(1);
		}
		return script;
	}

	/**
	 * This method decodes construct value
	 * 
	 * @param constructi -
	 *            the encoded value of the construct in the inflections.data
	 *            file
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return the decoded construct value
	 */
	public static String decodeConstruct(int constructi, String transliterated) {
		String construct = "";
		switch (constructi) {
		case CONSTRUCT_UNDEFINED:
			construct = "";
			break;
		case CONSTRUCT_TRUE:
			construct = "true";
			break;
		case CONSTRUCT_FALSE:
			construct = "false";
			break;
		default:
			System.out.println("illegal constructi" + constructi
					+ "for transliterated: " + transliterated);
			System.exit(1);
		}
		return construct;
	}

	/**
	 * This method decodes binyan
	 * 
	 * @param binyani -
	 *            the encoded value of the Binyan in the inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded Binyan value
	 */
	public static String decodeBinyan(int binyani, String transliterated) {
		String binyan = "";
		switch (binyani) {
		case 1:
			binyan = "Pa'al";
			break;
		case 2:
			binyan = "Nif'al";
			break;
		case 3:
			binyan = "Pi'el";
			break;
		case 4:
			binyan = "Pu'al";
			break;
		case 5:
			binyan = "Hif'il";
			break;
		case 6:
			binyan = "Huf'al";
			break;
		case 7:
			binyan = "Hitpa'el";
			break;
		default:
			System.out.println("illegal binyani: " + binyani
					+ "for transliterated: " + transliterated);
			System.exit(1);
		}
		return binyan;
	}

	/**
	 * @param PGNi -
	 *            the encoded value of the PERSON/GENDER/NUMBER in the
	 *            inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded PGN value
	 */
	public static String decodePGN(int PGNi, String transliterated) {
		String PGN = "";
		switch (PGNi) {
		case 1:
			PGN = "1p/MF/Sg";
			break;
		case 2:
			PGN = "2p/F/Sg";
			break;
		case 3:
			PGN = "2p/M/Sg";
			break;
		case 4:
			PGN = "3p/M/Sg";
			break;
		case 5:
			PGN = "3p/F/Sg";
			break;
		case 6:
			PGN = "1p/MF/Pl";
			break;
		case 7:
			PGN = "2p/M/Pl";
			break;
		case 8:
			PGN = "2p/F/Pl";
			break;
		case 9:
			PGN = "2p/MF/Pl";
			break;
		case 10:
			PGN = "3p/M/Pl";
			break;
		case 11:
			PGN = "3p/F/Pl";
			break;
		case 12:
			PGN = "3p/MF/Pl";
			break;
		case 13:
			PGN = "123p/M/Sg";
			break;
		case 14:
			PGN = "123p/F/Sg";
			break;
		case 15:
			PGN = "123p/F/Pl";
			break;
		case 16:
			PGN = "123p/M/Pl";
			break;
		case 17:
			PGN = "1p/M/Pl";
			break;
		case 18:
			PGN = "1p/F/Pl";
			break;
		case 19:
			PGN = "unspecified";
			break;
		case 20:
			PGN = "NONE";
			break;
		default:
			System.out.println("Decoder.decodePGN: illegal PGNi: " + PGNi + "  for transliterated: "
					+ transliterated);
			System.exit(1);
		}

		return PGN;
	}

	/**
	 * @param baseQuantifierTypei -
	 *            the encoded value of the PERSON/GENDER/NUMBER in the
	 *            inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded PGN value
	 */
	public static String decodeQuantifierType(int baseQuantifierTypei,
			String transliterated) {
		String baseQuantifierType = "";
		switch (baseQuantifierTypei) {
		case 1:
			baseQuantifierType = "numeral cardinal";
			break;
		case 2:
			baseQuantifierType = "non-numeral";
			break;
		case 3:
			baseQuantifierType = "numeral ordinal";
			break;
		case 4:
			baseQuantifierType = "unspecified";
			break;
		case 5:
			baseQuantifierType = "numeral fractional";
			break;
		default:
			System.out.println("illegal baseQuantifierTypei: "
					+ baseQuantifierTypei + "for transliterated: "
					+ transliterated);
			System.exit(1);
		}
		return baseQuantifierType;
	}

	/**
	 * This method decodes gender
	 * 
	 * @param genderi -
	 *            the encoded value of the gender in the inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded Gender value
	 */
	public static String decodeGender(int genderi, String transliterated) {
		String gender = "";
		switch (genderi) {
		case 1:
			gender = "masculine";
			break;
		case 2:
			gender = "feminine";
			break;
		case 3:
			gender = "unspecified";
			break;
		case 4:
			gender = "masculine and feminine";
			break;
		case 5:
			gender = "irrelevant";
			break;
		default:
			System.out.println("illegal genderi: " + genderi
					+ " for transliterated: " + transliterated);
			System.exit(1);
		}
		return gender;
	}

	/**
	 * This method decodes number
	 * 
	 * @param numberi -
	 *            the encoded value of the number in the inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded Number value
	 */
	public static String decodeNumber(int numberi, String transliterated) {
		String number = "";
		switch (numberi) {
		case 1:
			number = "singular";
			break;
		case 2:
			number = "plural";
			break;
		case 3:
			number = "unspecified";
			break;
		case 4:
			number = "dual and plural";
			break;
		case 5:
			number = "dual";
			break;
		case 6:
			number = "singular and plural";
			break;
		default:
			System.out.println("illegal numberi: " + numberi
					+ "for transliterated: " + transliterated);
			System.exit(1);
		}
		return number;
	}

	/**
	 * This method decodes BaseNamedEntityType
	 * 
	 * @param baseNamedEntityTypei -
	 *            the encoded value of the number in the inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return -the decoded BaseNamedEntityType value
	 */
	public static String decodeBaseNamedEntityType(int baseNamedEntityTypei,
			String transliterated) {
		String baseNamedEntityType = "";
		switch (baseNamedEntityTypei) {
		case 1:
			baseNamedEntityType = "location";
			break;
		case 2:
			baseNamedEntityType = "person";
			break;
		case 3:
			baseNamedEntityType = "organization";
			break;
		case 4:
			baseNamedEntityType = "dateTime";
			break;
		case 5:
			baseNamedEntityType = "other";
			break;
		case 6:
			baseNamedEntityType = "product";
			break;
		case 7:
			baseNamedEntityType = "unspecified";
			break;
		default:
			System.out.println("illegal baseNamedEntityTypei: "
					+ baseNamedEntityTypei + "for transliterated: "
					+ transliterated);
			System.exit(1);
		}
		return baseNamedEntityType;

	}

	/**
	 * This method decodes BasePronounType
	 * 
	 * @param basePronounTypei -
	 *            the encoded value of the BasePronounType in the
	 *            inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded decodeBasePronounType value
	 */
	public static String decodeBasePronounType(int basePronounTypei,
			String transliterated) {
		String basePronounType = "";
		switch (basePronounTypei) {
		case 1:
			basePronounType = "interrogative";
			break;
		case 2:
			basePronounType = "personal";
			break;
		case 3:
			basePronounType = "demonstrative";
			break;
		case 4:
			basePronounType = "impersonal";
			break;
		case 5:
			basePronounType = "relativizer";
			break;
		default:
			System.out.println("illegal basePronounTypei: " + basePronounTypei
					+ "for transliterated: " + transliterated);
			System.exit(1);
		}
		return basePronounType;
	}

	/**
	 * This method decodes Tense
	 * 
	 * @param tensei -
	 *            the encoded value of the tensei in the inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded tense value
	 */
	public static String decodeTense(int tensei, String transliterated) {
		String tense = "";
		switch (tensei) {
		case 1:
			tense = "imperative";
			break;
		case 2:
			tense = "past";
			break;
		case 3:
			tense = "beinoni";
			break;
		case 4:
			tense = "future";
			break;
		case 5:
			tense = "infinitive";
			break;
		case 6:
			tense = "origin";
			break;
		default:
			System.out.println("illegal tensei: " + tensei
					+ "for transliterated: " + transliterated);
			System.exit(1);
		}
		return tense;
	}

	/**
	 * @param baseConjunctionTypeChar -
	 *            the encoded value of the BaseConjunctionType in the
	 *            inflections.data
	 * @param transliterated -
	 *            the transliterated form of the inflection
	 * @return - the decoded BaseConjunctionType value
	 */
	public static String decodeBaseConjunctionType(
			char baseConjunctionTypeChar, String transliterated) {
		String baseConjunctionType = "";
		switch (baseConjunctionTypeChar) {
		case 'c':
			baseConjunctionType = "coordinating";
			break;
		case 's':
			baseConjunctionType = "subordinating";
			break;
		case 'r':
			baseConjunctionType = "relativizing";
			break;
		default:
			System.out.println("illegal baseConjunctionTypeChar: "
					+ baseConjunctionTypeChar + "for transliterated: "
					+ transliterated);
			System.exit(1);
		}

		return baseConjunctionType;

	}
	
	public static String decodeBaseNumeralType(
			int baseNumeralTypei, String transliterated) {
		String baseNumeralType = "";
		switch (baseNumeralTypei) {
		case 1:
			baseNumeralType = "numeral ordinal";
			break;
		case 2:
			baseNumeralType = "numeral cardinal";
			break;
		case 3:
			baseNumeralType = "numeral fractional";
			break;
		case 4:
			baseNumeralType = "literal number";
			break;
		case 5:
			baseNumeralType = "unspecified";
			break;
		default:
			System.out.println("illegal baseNumeralTypeI: "
					+ baseNumeralTypei + "for transliterated: "
					+ transliterated);
			System.exit(1);
		}

		return baseNumeralType;

	}

	
	public static String decodeBaseDefiniteness(
			int baseDefinitenessi,String transliterated) {
		String baseDefiniteness = "";
		switch (baseDefinitenessi) {
		case 1:
			baseDefiniteness = "tt";
			break;
		case 2:
			baseDefiniteness = "tf";
			break;
		case 3:
			baseDefiniteness = "f";
			break;
		default:
			System.out.println("Decoder.decodeBaseDefiniteness : illegal baseDefinitenessI: "
					+ baseDefinitenessi + "for transliterated: "
					+ transliterated);
			System.exit(1);
		}

		return baseDefiniteness;

	}

	public static void main(String[] args) {
	}
}
