/*
 * Created on 09/02/2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package lexicon.analyse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;

import lexicon.dbUtils.InflectRecord;
import lexicon.dbUtils.PrefixRecord;
import lexicon.utils.Load2memory;
import lexicon.utils.Translate;

/**
 * @author daliabo
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class Data implements Constants{

	public static String dinflectionsFile = "";
	
	public static String dprefixesFile = "";
	
	public static String gimatriaFile ="";
	
	public static boolean webFlag;

	static ArrayList inflectionsList = null;

	static ArrayList prefixesList = null;
	
	static lexicon.utils.Prefixes prefixes;

	static lexicon.utils.Inflections inflections;
	
	static lexicon.utils.Gimatria gimatrias;

	static InflectRecord infRec;
	
	static int baseQuantifierTypei;

	static int constructi;

	static int baseDefinitnessi;

	static int basePronounTypei;

	static int binyani;

	static int tensei;
	
	static int suffixFunctioni;
	
	static int posi;
	
	static int scripti;

	static int outputPattern;

	static String pos = "";

	public Data(String dinflectionsFile,String dprefixesFile, String gimatriaFile ,boolean webFlag) {
		Data.dinflectionsFile = dinflectionsFile;
		Data.dprefixesFile = dprefixesFile;
		Data.gimatriaFile = gimatriaFile;
		Data.webFlag = webFlag;
	}
	

	public Data(){};
	
	public static void init() {
		//get from lists
		
		if (!webFlag) {
			long startTime = System.currentTimeMillis();
			//load to hashmap inflections and prefixes file
			inflections = Load2memory.loadInflections(dinflectionsFile);
			//System.out.println("End Loading Inflections file ");
			prefixes = Load2memory.loadPrefixes(dprefixesFile);
			//System.out.println("End Loading Prefixes file ");
			//long afterLoadTime = printTimesHandling(startTime);
			gimatrias = Load2memory.loadGimatria(gimatriaFile);
			//System.out.println("End Loading gimatrias file ");
			//long afterLoadTime = printTimesHandling(startTime);
		}

	}

	private long printTimesHandling(long startTime) {
		long afterLoadTime = System.currentTimeMillis();
		long load2MemoryElapsedTime = afterLoadTime - startTime;
		System.out.println("load2Memory Elapsed time = "
				+ load2MemoryElapsedTime + " ms");
		return afterLoadTime;
	}

	public static int getInflections(String key) throws Exception {
		int size = 0;
		//get from database
		if (webFlag) {
			lexicon.dbUtils.Inflections inf = new lexicon.dbUtils.Inflections();
			inflectionsList = inf.get(key);
		//get from lists
		} else {
			inflectionsList = inflections.get(key);
		}
		if (inflectionsList != null)
			size = inflectionsList.size();
		return size;
	}

	public static int getPrefixes(String key) throws Exception {
		int size = 0;
		//get from databse
		if (webFlag) {
			lexicon.dbUtils.Prefixes pref = new lexicon.dbUtils.Prefixes();
			prefixesList = pref.get(key);
		//get from lists
		} else {
			prefixesList = prefixes.get(key);
		}
		if (prefixesList != null)
			size = prefixesList.size();
		
		return size;
	}
	
	
	//gimatria returns a single matching entry
	public static int getGimatrias(String key) throws Exception {
		int val = 0;
		//get from databse
		if (webFlag) {
			val = lexicon.dbUtils.Gimatria.get(key);
		//get from lists
		} else {
			val = gimatrias.get(key);
		}	
		return val;
	}
	
	

	public static InflectRecord analyzeInflectionList(int i,String word) throws Exception {
		infRec = new InflectRecord();
		//get from the databse
		if (webFlag) {
			//System.out.println("Getting data from databse");
			//if (inflectionsList.get(i) != null){
			infRec = (InflectRecord) inflectionsList.get(i);
			String baseUndottedLItem = URLDecoder.decode(infRec.getBaseUndottedLItem(), "UTF-8");
			infRec.setBaseUndottedLItem(baseUndottedLItem);
			
			String lexiconItem = infRec.getBaseTransliteratedLItem();
			String baseQuantifierType = infRec.getBaseQuantifierType();
			// we need to encode the following becouse the morphAnalyzer used their encoded values
			// while validating rules - performance considerations.
			baseQuantifierTypei = Integer.valueOf(
					Encoder.encodeBaseQuantifierType(baseQuantifierType))
					.intValue();
			
			constructi = Integer.valueOf(Encoder.encodeConstruct(infRec.getSuffixStatus()))
			.intValue();
			
			baseDefinitnessi = Integer.valueOf(
					Encoder.encodeBaseDefinitness(infRec.getBaseDefinitness()))
					.intValue();
			
			
			String basePronounType = infRec.getBasePronounType();
			basePronounTypei = Integer.valueOf(
					Encoder.encodeBasePronounType(infRec.getBasePronounType()))
					.intValue();
			
			String suffixFunction = infRec.getSuffixFunction();
			suffixFunctioni = Integer.valueOf(Encoder.encodeSuffixFunction(infRec.getSuffixFunction()))
			.intValue();
	
			
			String binyan = infRec.getBinyan();
			binyani = Integer.valueOf(Encoder.encodeBinyan(infRec.getBinyan()))
					.intValue();
			
			String tense = infRec.getTense();
			tensei = Integer.valueOf(Encoder.encodeTense(tense,lexiconItem,word)).intValue();
			if(tense.equals("linfinitive"))
				infRec.setTense("infinitive");
			
			pos = infRec.getBasePos();
			posi= Integer.valueOf(Encoder.encodeBasePos(pos)).intValue();
			outputPattern = Integer.valueOf(Encoder.encodeBasePos(pos)).intValue();
			
			return infRec;
			//get from files
			
		} else {
			StringTokenizer st = null;
			st = new StringTokenizer((String) inflectionsList.get(i), "|");
			//System.out.println((String) inflectionsList.get(i));
			infRec.setTransliterated(st.nextToken());
			//System.out.println("Transliterated =" +
			// infRec.getTransliterated());
			infRec.setBasePos(st.nextToken());
			//System.out.println("BasePos =" + infRec.getBasePos());
			infRec.setBaseTransliteratedLItem(st.nextToken());
			//System.out.println("BaseTransliteratedLItem ="
			//		+ infRec.getBaseTransliteratedLItem());
			infRec.setScript(st.nextToken());
			//System.out.println("Script =" + infRec.getScript());
			infRec.setSuffixGender(st.nextToken());
			//System.out.println("SuffixGender =" + infRec.getSuffixGender());
			infRec.setSuffixNumber(st.nextToken());
			//System.out.println("SuffixNumber =" + infRec.getSuffixNumber());
			infRec.setSuffixStatus(st.nextToken());
			//System.out.println("SuffixStatus =" + infRec.getSuffixStatus());
			infRec.setBaseLexiconPointer(st.nextToken());
			//System.out.println("BaseLexiconPointer ="
			//		+ infRec.getBaseLexiconPointer());
			infRec.setPGN(st.nextToken());
			//System.out.println("PGN =" + infRec.getPGN());
			infRec.setBinyan(st.nextToken());
			//System.out.println("Binyan =" + infRec.getBinyan());
			infRec.setTense(st.nextToken());
			//System.out.println("Tense =" + infRec.getTense());
			infRec.setRoot(st.nextToken());
			//System.out.println("Root =" + infRec.getRoot());
			infRec.setBaseNumber(st.nextToken());
			//System.out.println("BaseNumber =" + infRec.getBaseNumber());
			infRec.setBaseGender(st.nextToken());
			//System.out.println("BaseGender =" + infRec.getBaseGender());
			infRec.setBaseNamedEntityType(st.nextToken());
			//System.out.println("BaseNamedEntityType ="
			//		+ infRec.getBaseNamedEntityType());
			infRec.setBaseDefinitness(st.nextToken());
			//System.out.println("BaseDefinitness =" +
			//infRec.getBaseDefinitness());
			infRec.setBaseConjunctionType(st.nextToken());
			//System.out.println("BaseConjunctionType ="
			//		+ infRec.getBaseConjunctionType());
			infRec.setBaseQuantifierType(st.nextToken());
			//System.out.println("BaseQuantifierType ="
			//		+ infRec.getBaseQuantifierType());
			infRec.setBasePronounType(st.nextToken());
			//System.out.println("BasePronounType =" +
			//infRec.getBasePronounType());
			infRec.setBasePerson(st.nextToken());
			//System.out.println("BasePerson =" +
			//infRec.getBasePerson());
			String suffixFunction = st.nextToken();
			infRec.setSuffixFunction(suffixFunction);
			//System.out.println("suffixFunction =" +
			//infRec.getSuffixFunction());
			infRec.setSuffixPerson(st.nextToken());
			//System.out.println("suffixPerson =" +
			//infRec.getSuffixPerson());
			infRec.setAccusativeNominativePGN(st.nextToken());
			//System.out.println("AccusativeNominativePGN =" + infRec.getAccusativeNominativePGN());
			infRec.setAccusativeNominativePerson(st.nextToken());
			//System.out.println("AccusativeNominativePerson =" + infRec.getAccusativeNominativePerson());
			infRec.setAccusativeNominativeGender(st.nextToken());
			//System.out.println("AccusativeNominativeGender =" + infRec.getAccusativeNominativeGender());
			infRec.setAccusativeNominativeNumber(st.nextToken());
			//System.out.println("AccusativeNominativeNumber =" + infRec.getAccusativeNominativeNumber());
			infRec.setBaseNumeralType(st.nextToken());
			infRec.setDottedLexiconItem(st.nextToken());
			return analyzeBaseRec();
		}
			
	}

	private static InflectRecord analyzeBaseRec() throws UnsupportedEncodingException {
		InflectRecord outputInflectionRec;
		int PGNi;
		int genderi;
		int numberi;
		int baseNamedEntityTypei;
		int baseGenderi;
		int baseNumberi;
		int accusativeNominativePGNi ;
		int accusativeNominativeGenderi;
		int accusativeNominativeNumberi;
		int baseNumeralTypei;

		outputInflectionRec = infRec;

		String transliterated = infRec.getBaseTransliteratedLItem();
	

		posi = Integer.parseInt(infRec.getBasePos());
		pos = Decoder.decodePos(posi, transliterated);
		outputPattern = posi;

		//Filling output record
		outputInflectionRec.setBasePos(pos);

		String id = infRec.getBaseLexiconPointer();

		//String baseUndottedLItem = URLDecoder.decode(infRec.getBaseUndottedLItem(), "UTF-8");
		//infRec.setBaseUndottedLItem(baseUndottedLItem);
		
		//String undotted = infRec.getBaseUndottedLItem();        
		////////////////////////
		outputInflectionRec.setBaseUndottedLItem(Translate.Eng2Heb(transliterated));
		/////////////////////////////
		String script = infRec.getScript();
		if (!script.equals("-")) {
			scripti = Integer.parseInt(script);
			script = Decoder.decodeScript(scripti, transliterated);
		} else
			scripti = -1;
		outputInflectionRec.setScript(script);
		
		String dottedLexiconItem = infRec.getDottedLexiconItem();
		if (!dottedLexiconItem.equals("-")) {
			dottedLexiconItem = URLDecoder.decode(infRec.getDottedLexiconItem(), "UTF-8");
		} else
			dottedLexiconItem = "";
		outputInflectionRec.setDottedLexiconItem(dottedLexiconItem);

		String gender = infRec.getSuffixGender();
		if (!gender.equals("-")) {
			genderi = Integer.parseInt(gender);
			gender = Decoder.decodeGender(genderi, transliterated);
		} else
			genderi = -1;
		outputInflectionRec.setSuffixGender(gender);

		String number = infRec.getSuffixNumber();
		if (!number.equals("-")) {
			numberi = Integer.parseInt(number);
			number = Decoder.decodeNumber(numberi, transliterated);
		} else
			numberi = -1;
		outputInflectionRec.setSuffixNumber(number);

		String baseQuantifierType = infRec.getBaseQuantifierType();
		if (!baseQuantifierType.equals("-")) {
			baseQuantifierTypei = Integer.parseInt(baseQuantifierType);
			baseQuantifierType = Decoder.decodeQuantifierType(
					baseQuantifierTypei, transliterated);
		} else
			baseQuantifierTypei = -1;
		outputInflectionRec.setBaseQuantifierType(baseQuantifierType);

		String baseNamedEntityType = infRec.getBaseNamedEntityType();
		if (!baseNamedEntityType.equals("-")) {
			baseNamedEntityTypei = Integer.parseInt(baseNamedEntityType);
			baseNamedEntityType = Decoder.decodeBaseNamedEntityType(
					baseNamedEntityTypei, transliterated);
		} else
			baseNamedEntityTypei = -1;
		outputInflectionRec.setBaseNamedEntityType(baseNamedEntityType);

		String basePronounType = infRec.getBasePronounType();
		if (!basePronounType.equals("-")) {
			basePronounTypei = Integer.parseInt(basePronounType);
			basePronounType = Decoder.decodeBasePronounType(basePronounTypei,
					transliterated);
		} else
			basePronounTypei = -1;
		outputInflectionRec.setBasePronounType(basePronounType);

		
		String PGN = infRec.getPGN();
		if (!PGN.equals("-")) {
			PGNi = Integer.parseInt(PGN);
			PGN = Decoder.decodePGN(PGNi, transliterated);
		} else {
			PGNi = -1;
		}
		outputInflectionRec.setPGN(PGN);

		String suffixFunction = infRec.getSuffixFunction();
		if (!suffixFunction.equals("-")) {
			suffixFunctioni = Integer.parseInt(suffixFunction);
			suffixFunction = Decoder.decodeSuffixFunction(suffixFunctioni, transliterated);
		}
		else {
			suffixFunctioni = -1;
			suffixFunction = "unspecified";
		}
		outputInflectionRec.setSuffixFunction(suffixFunction);
		
		String binyan = (infRec.getBinyan());
		if (!binyan.equals("-")) {
			binyani = Integer.parseInt(binyan);
			binyan = Decoder.decodeBinyan(binyani, transliterated);
		} else
			binyani = -1;
		outputInflectionRec.setBinyan(binyan);

		String tense = infRec.getTense();
		if (!tense.equals("-")) {
			tensei = Integer.parseInt(tense);
			tense = Decoder.decodeTense(tensei, transliterated);
		} else
			tensei = -1;
		outputInflectionRec.setTense(tense);

		String root = infRec.getRoot();
		root = Translate.Eng2Heb(root);
		//This is only becoase it is saved utf8 on inflections
		root = URLEncoder.encode(root, "UTF-8");
		outputInflectionRec.setRoot(root);

		String baseDefinitness = infRec.getBaseDefinitness();		
		if (!baseDefinitness.equals("-")) {
			baseDefinitnessi = Integer.parseInt(baseDefinitness);
			baseDefinitness = Decoder.decodeBaseDefiniteness(baseDefinitnessi,transliterated);
		} else
			baseDefinitnessi = -1;
		outputInflectionRec.setBaseDefinitness(baseDefinitness);

		String baseGender = infRec.getBaseGender();
		if (!baseGender.equals("-")) {
			baseGenderi = Integer.parseInt(baseGender);
			baseGender = Decoder.decodeGender(baseGenderi, transliterated);
		} else
			baseGenderi = -1;
		outputInflectionRec.setBaseGender(baseGender);

		String baseNumber = infRec.getBaseNumber();
		if (!baseNumber.equals("-")) {
			baseNumberi = Integer.parseInt(baseNumber);
			baseNumber = Decoder.decodeNumber(baseNumberi, transliterated);
		} else
			baseNumberi = -1;
		outputInflectionRec.setBaseNumber(baseNumber);

		String construct = infRec.getSuffixStatus();
		//if (!construct.equals("-")) {
		constructi = Integer.parseInt(construct);
		construct = Decoder.decodeConstruct(constructi, transliterated);
		//} else
		//	constructi = -1;
		outputInflectionRec.setSuffixStatus(construct);

		String basePerson = infRec.getBasePerson();
		if (basePerson.equals("-"))
			basePerson = "unspecified";
		outputInflectionRec.setBasePerson(basePerson);

		String baseConjunctionType = infRec.getBaseConjunctionType();
		if (!baseConjunctionType.equals("-")) {
			char baseConjunctionTypeChar = baseConjunctionType.charAt(0);
			baseConjunctionType = Decoder.decodeBaseConjunctionType(
					baseConjunctionTypeChar, transliterated);
		} else
			baseConjunctionType = "unspecified";
		outputInflectionRec.setBaseConjunctionType(baseConjunctionType);
		
		String suffixPerson = infRec.getSuffixPerson();
		if (suffixPerson.equals("-")){
			suffixPerson = "unspecified";
		}
		outputInflectionRec.setSuffixPerson(suffixPerson);
		
		String accusativeNominativePGN = infRec.getAccusativeNominativePGN();
		if (!accusativeNominativePGN.equals("-")){
			accusativeNominativePGNi = Integer.parseInt(accusativeNominativePGN);
			accusativeNominativePGN = Decoder.decodePGN(accusativeNominativePGNi, transliterated);
		}
		else{
			accusativeNominativePGNi = -1;
		}		
		outputInflectionRec.setAccusativeNominativePGN(accusativeNominativePGN);

		
		String accusativeNominativePerson = infRec.getAccusativeNominativePerson();
		if (accusativeNominativePerson.equals("-")){
			accusativeNominativePerson = "unspecified";
		}
		outputInflectionRec.setAccusativeNominativePerson(accusativeNominativePerson);
		
		String accusativeNominativeGender = infRec.getAccusativeNominativeGender();
		if (!accusativeNominativeGender.equals("-")) {
			accusativeNominativeGenderi = Integer.parseInt(accusativeNominativeGender);
			accusativeNominativeGender = Decoder.decodeGender(accusativeNominativeGenderi, transliterated);
		} else
			accusativeNominativeGenderi = -1;
		outputInflectionRec.setAccusativeNominativeGender(accusativeNominativeGender);
		
		
		String accusativeNominativeNumber = infRec.getAccusativeNominativeNumber();
		if (!accusativeNominativeNumber.equals("-")) {
			accusativeNominativeNumberi = Integer.parseInt(accusativeNominativeNumber);
			accusativeNominativeNumber = Decoder.decodeNumber(accusativeNominativeNumberi, transliterated);
		} else
			accusativeNominativeNumberi = -1;
		outputInflectionRec.setAccusativeNominativeNumber(accusativeNominativeNumber);
		
		String baseNumeralType = infRec.getBaseNumeralType();
		if (!baseNumeralType.equals("-")) {
			baseNumeralTypei = Integer.parseInt(baseNumeralType);
			baseNumeralType = Decoder.decodeBaseNumeralType(baseNumeralTypei,
					transliterated);
		} else
			baseNumeralTypei = -1;		
		outputInflectionRec.setBaseNumeralType(baseNumeralType);
		
		return outputInflectionRec;
	}

	public static PrefixRecord analyzePrefixList(int j) {
		PrefixRecord pr = new PrefixRecord();
		//gete from databse
		if (webFlag) {
			pr = (PrefixRecord ) prefixesList.get(j);
		}
		//get from files
		else{
		StringTokenizer st = null;
		String field = "";
		st = new StringTokenizer((String) prefixesList.get(j), "|");
		//System.out.println((String) prefixesList.get(j));
		pr.setPrefix(st.nextToken());
		//System.out.println("prefix =" + pr.getPrefix());
		pr.setDescription(st.nextToken());
		//System.out.println("description =" + pr.getDescription());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setDefiniteArticleTag(false);
		else
			pr.setDefiniteArticleTag(true);
		//System.out.println("DefiniteArticleTag =" +
		// pr.isDefiniteArticleTag());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setDefArtHE(false);
		else
			pr.setDefArtHE(true);
		//System.out.println("DefArtHE =" + pr.isDefArtHE());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setRelHE(false);
		else
			pr.setRelHE(true);
		//System.out.println("RelHE =" + pr.isRelHE());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setAdverbKAF(false);
		else
			pr.setAdverbKAF(true);
		//System.out.println("AdverbKAF =" + pr.isAdverbKAF());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setSubConOrRelSHIN(false);
		else
			pr.setSubConOrRelSHIN(true);
		//System.out.println("SubConOrRelSHIN =" + pr.isSubConOrRelSHIN());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setTempSubConKAFSHIN(false);
		else
			pr.setTempSubConKAFSHIN(true);
		//System.out.println("TempSubConKAFSHIN =" + pr.isTempSubConKAFSHIN());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setTempSubConMEMSHIN(false);
		else
			pr.setTempSubConMEMSHIN(true);
		//System.out.println("TempSubConMEMSHIN =" + pr.isTempSubConMEMSHIN());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setTempSubConLAMEDKAFSHIN(false);
		else
			pr.setTempSubConLAMEDKAFSHIN(true);
		//System.out.println("TempSubConLAMEDKAFSHIN ="
		//		+ pr.isTempSubConLAMEDKAFSHIN());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setTempSubConBETSHIN(false);
		else
			pr.setTempSubConBETSHIN(true);
		field = st.nextToken();
		if (field.equals("-"))
			pr.setRelativizerTag(false);
		else
			pr.setRelativizerTag(true);
		//System.out.println("RelativizerTag =" + pr.isRelativizerTag());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setTemporalSubConjTag(false);
		else
			pr.setTemporalSubConjTag(true);
		//System.out.println("TemporalSubConjTag =" +
		// pr.isTemporalSubConjTag());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setSubordinatingConjunctionTag(false);
		else
			pr.setSubordinatingConjunctionTag(true);
		//System.out.println("SubordinatingConjunctionTag ="
		//		+ pr.isSubordinatingConjunctionTag());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setPrefPartUnit(false);
		else
			pr.setPrefPartUnit(true);
		//System.out.println("PrefPartUnit =" + pr.isPrefPartUnit());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setPrepBET(false);
		else
			pr.setPrepBET(true);
		//System.out.println("PrepBET =" + pr.isPrepBET());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setPrepKAF(false);
		else
			pr.setPrepKAF(true);
		//System.out.println("PrepKAF =" + pr.isPrepKAF());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setPrepLAMED(false);
		else
			pr.setPrepLAMED(true);
		//System.out.println("PrepLAMED =" + pr.isPrepLAMED());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setPrepMEM(false);
		else
			pr.setPrepMEM(true);
		//System.out.println("PrepMEM =" + pr.isPrepMEM());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setPrepositionTag(false);
		else
			pr.setPrepositionTag(true);
		//System.out.println("PrepositionTag =" + pr.isPrepositionTag());
		field = st.nextToken();
		if (field.equals("-"))
			pr.setConjunctionTag(false);
		else
			pr.setConjunctionTag(true);
		//System.out.println("PrepositionTag =" + pr.isPrepositionTag());
		}
		return pr;
	}

	

	/**
	 * @return Returns the inflections.
	 */
	public  lexicon.utils.Inflections getInflections() {
		return inflections;
	}

	/**
	 * @return Returns the prefixes.
	 */
	public lexicon.utils.Prefixes getPrefixes() {
		return prefixes;
	}

	/**
	 * @return Returns the baseDefinitnessi.
	 */
	public int getBaseDefinitnessi() {
		return baseDefinitnessi;
	}

	/**
	 * @return Returns the basePronounTypei.
	 */
	public int getBasePronounTypei() {
		return basePronounTypei;
	}

	/**
	 * @return Returns the baseQuantifierTypei.
	 */
	public static int getBaseQuantifierTypei() {
		return baseQuantifierTypei;
	}

	/**
	 * @return Returns the binyani.
	 */
	public static int getBinyani() {
		return binyani;
	}

	/**
	 * @return Returns the constructi.
	 */
	public static int getConstructi() {
		return constructi;
	}

	/**
	 * @return Returns the inflectionsList.
	 */
	public ArrayList getInflectionsList() {
		return inflectionsList;
	}

	/**
	 * @return Returns the infRec.
	 */
	public InflectRecord getInfRec() {
		return infRec;
	}

	

	/**
	 * @return Returns the prefixesList.
	 */
	public ArrayList getPrefixesList() {
		return prefixesList;
	}


	/**
	 * @return Returns the tensei.
	 */
	public static int getTensei() {
		return tensei;
	}

	/**
	 * @return Returns the webFlag.
	 */
	public boolean isWebFlag() {
		return webFlag;
	}

	/**
	 * @return Returns the outputPattern.
	 */
	public static int getOutputPattern() {
		return outputPattern;
	}

	/**
	 * @return Returns the pos.
	 */
	public static String getPos() {
		return pos;
	}
	
	/**
	 * @return Returns the posi.
	 */
	public static int getPosi() {
		return posi;
	}
	/**
	 * @return Returns the suffixFunctioni.
	 */
	public static int getSuffixFunctioni() {
		return suffixFunctioni;
	}
	/**
	 * @return Returns the scripti.
	 */
	public static int getScripti() {
		return scripti;
	}
}
