/*
 * Created on 08/01/2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package corpus;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Validator;

import lexicon.analyse.Constants;
import lexicon.analyse.Encoder;
import lexicon.utils.PrefixRec;
import lexicon.utils.Translate;
import generated.*;

/**
 * @author daliabo
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class CreateCorpusXML implements Constants {
	private OutputStreamWriter pOut = null;

	JAXBContext jc;

	ArticleType article;

	ObjectFactory objFactory;

	Corpus corpus;

	ParagraphType paragraph;

	SentenceType sentence;

	TokenType token;

	AnalysisType analysis;

	PrefixType pref;

	int tokenCounter = 0;

	int sentenceCounter = 0;

	int paragraphCounter = 0;

	int analysisCounter = 0;

	String outputFile = "";

	Validator validator = null;

	public CreateCorpusXML(String outputFile) {
		this.outputFile = outputFile;
	}

	public CreateCorpusXML() {

	}

	public void createXMLdOC() {
		try {
			jc = JAXBContext.newInstance("generated");
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createXMLdOC Exception while creating JAXBContext");
			e.printStackTrace();
		}
		objFactory = new ObjectFactory();
		try {
			corpus = objFactory.createCorpus();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createXMLdOC Exception while creating corpus");
			e1.printStackTrace();
		}
		corpus.setName("Analysis Results");
		//corpus.setVersion((float) 1.0);
		corpus.setMaintainer("Dalia Bojan");
		corpus.setEmail("mila@cs.technion.ac.il");
		try {
			validator = jc.createValidator();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createXMLdOC Exception while creating Validator");
			e2.printStackTrace();
		}
	}

	public void createArticle() {

		try {
			article = objFactory.createArticleType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createArticle Exception while creating article");
			e.printStackTrace();
		}
		article.setId("1");
		corpus.getArticle().add(article);
	}

	public void createParagraph() {
		paragraphCounter++;
		try {
			paragraph = objFactory.createParagraphType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createParagraph Exception while creating paragraph");
			e.printStackTrace();
		}
		paragraph.setId(String.valueOf(paragraphCounter));
	}

	public void createSentence() {
		sentenceCounter++;
		try {
			sentence = objFactory.createSentenceType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createSentence Exception while creating Sentence");
			e.printStackTrace();
		}
		sentence.setId(String.valueOf(sentenceCounter));
	}

	public void createToken(String surface) {
		tokenCounter++;
		try {
			token = objFactory.createTokenType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createToken Exception while creating token="
							+ surface);
			e.printStackTrace();
		}
		token.setSurface(surface);
		token.setId(String.valueOf(tokenCounter));
	}

	public void finalizeToken() {
		if (tokenCounter > 0) {
			sentence.getToken().add(token);
			analysisCounter = 0;
		}
	}

	public void finalizeSentence() {
		paragraph.getSentence().add(sentence);
		tokenCounter = 0;
		analysisCounter = 0;
	}

	public void finalizeParagraph() {
		article.getParagraph().add(paragraph);
		sentenceCounter = 0;
	}

	public void finalizeEOF() {
		if (tokenCounter != 0) {
			paragraph.getSentence().add(sentence);
			article.getParagraph().add(paragraph);
		}
	}

	private String setStatus(String status) {
		if (status.equals("true"))
			status = "construct";
		else if (status.equals("false"))
			status = "absolute";
		return status;
	}

	private void setBase(BaseType base, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String dottedLexiconItem) {
		base.setTransliteratedLexiconItem(transliteratedLexiocnItem);
		//base.setLexiconItem(URLEncoder.encode(lexiconItem,"UTF-8"));
		base.setLexiconItem(lexiconItem);
		base.setLexiconPointer(lexiconPointer);
		if (!dottedLexiconItem.equals("")){
		try {
			dottedLexiconItem = URLDecoder.decode(dottedLexiconItem, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		base.setDottedLexiconItem(dottedLexiconItem);
		}
		else
			
			base.setDottedLexiconItem(lexiconItem);
	}

	private void setPrefix(String description) {
		//System.out.println("function =" + function);
		List list = null;
		try {
			list = Translate.analyzeMixedHebEng(description);
		} catch (UnsupportedEncodingException e) {
			System.out
					.println("CreateCorpusXML:setPrefix Exception while analyzeMixedHebEng for description="
							+ description);
			e.printStackTrace();
		}
		int size = list.size();
		//System.out.println("size=" + size);
		PrefixRec prefixRec = new PrefixRec();
		for (int i = 0; i < size; i++) {
			prefixRec = (PrefixRec) list.get(i);
			try {
				pref = objFactory.createPrefixType();
			} catch (JAXBException e1) {
				System.out
						.println("CreateCorpusXML:setPrefix Exception while createPrefixType for description="
								+ description);
				e1.printStackTrace();
			}
			pref.setId(String.valueOf(i + 1));
			pref.setFunction(prefixRec.getFunction());
			String prefixSurface = prefixRec.getSurface();
			//for the case of definite article
			if (prefixSurface.equals(""))
				prefixSurface = "unspecified";
			pref.setSurface(prefixSurface);
			analysis.getPrefix().add(pref);
		}

	}
	


	public void createPunctuationAnalysis(String hebWord) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPunctuationAnalysis Exception while creating Analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPunctuationAnalysis Exception while creating base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		PunctuationType punctuation = null;
		try {
			punctuation = objFactory.createPunctuationType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPunctuationAnalysis Exception while creating punctuation for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		base.setPunctuation(punctuation);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createQuantifierAnalysis(String gender, String number,
			String status, String person, String quantifierType,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String suffixFunction, String suffixNumber,
			String suffixGender, String suffixPerson, int value, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createQuantifierAnalysis Exception while creating analysis for hebWord="
							+ lexiconPointer);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createQuantifierAnalysis Exception while creating base for hebWord="
							+ lexiconPointer);
			e1.printStackTrace();
		}
		QuantifierType quantifier = null;
		try {
			quantifier = objFactory.createQuantifierType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createQuantifierAnalysis Exception while creating quantifier for hebWord="
							+ lexiconPointer);
			e2.printStackTrace();
		}
		//quantifier.setNumber(number);
		//quantifier.setPerson(person);
		//quantifier.setStatus(status);
		quantifier.setRegister(register);
		quantifier.setType(quantifierType);
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		quantifier.setGender(gender);
		base.setQuantifier(quantifier);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if (quantifierType.equals("numeral cardinal")
				&& (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE)) {
			SuffixType suffix = null;
			try {
				suffix = objFactory.createSuffixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createQuantifierAnalysis Exception while creating suffixFunction for hebWord="
								+ lexiconPointer);
				e3.printStackTrace();
			}
			suffix.setFunction("pronomial");
			suffix.setPerson(suffixPerson);
			suffix.setGender(suffixGender);
			suffix.setNumber(suffixNumber);
			analysis.setSuffix(suffix);
		}
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	
	
	public void createPrefixQuantifierAnalysis(String gender, String number,
			String status, String person, String quantifierType,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String description, String suffixFunction,
			String suffixNumber, String suffixGender, String suffixPerson,
			int value, String definiteness, String hebWord,String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixQuantifierAnalysis Exception while creating Analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixQuantifierAnalysis Exception while creating base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		QuantifierType quantifier = null;
		try {
			quantifier = objFactory.createQuantifierType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixQuantifierAnalysis Exception while creating quantifier for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		//prefix = h

		if (description.equals("definiteArticle")) {
			try {
				pref = objFactory.createPrefixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createPrefixQuantifierAnalysis Exception while creating PrefixType for hebWord="
								+ hebWord);
				e3.printStackTrace();
			}
			pref.setId("1");
			pref.setFunction(description);
			pref.setSurface("ה");
			analysis.getPrefix().add(pref);
		}
		//prefix ends with h - dalia
		else if (definiteness.equals("tt")) {
			setPrefix(description);

			try {
				pref = objFactory.createPrefixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createPrefixQuantifierAnalysis Exception while creating PrefixType prefix ends with h for hebWord="
								+ hebWord);
				e3.printStackTrace();
			}
			pref.setId("2");
			description = "definiteArticle";
			pref.setFunction("definiteArticle");
			pref.setSurface("ה");
			analysis.getPrefix().add(pref);
		} else
			setPrefix(description);
		//if (quantifierType.equals("gematria")) {
		//	quantifier.setValue(String.valueOf(value));
		//	if (!description.equals("definiteArticle"))
		//		quantifier.setDefiniteness(definiteness);
		//} else {
			setBase(base, transliteratedLexiocnItem, lexiconItem,
					lexiconPointer, dottedLexiconItem);
			quantifier.setGender(gender);
		//}
		quantifier.setType(quantifierType);
		quantifier.setRegister(register);
		base.setQuantifier(quantifier);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createNumeralAnalysis(String baseGender, String baseNumber,
			String construct, String basePerson, String transliterated,
			String lexiconItem, String lexiconPointer, String suffixFunction,
			String suffixNumber, String suffixGender, String suffixPerson,
			String definiteness, String baseNumeralType, String hebWord,String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createNumeralAnalysis Exception while creating Analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createNumeralAnalysis Exception while creating base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		NumeralType numeral = null;
		try {
			numeral = objFactory.createNumeralType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createNumeralAnalysis Exception while creating numeral type for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		numeral.setRegister(register);
		if (!baseNumeralType.equals("literal number")
				&& (!baseNumeralType.equals("gematria"))) {
			setBase(base, transliterated, lexiconItem, lexiconPointer, dottedLexiconItem);
			numeral.setDefiniteness(definiteness);
			numeral.setGender(baseGender);
			numeral.setNumber(baseNumber);
			numeral.setType(baseNumeralType);
			numeral.setStatus(construct);
			base.setNumeral(numeral);
			analysis.setBase(base);
			int suffixFunctioni = Integer.valueOf(
					Encoder.encodeSuffixFunction(suffixFunction)).intValue();
			if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) {
				SuffixType suffix = null;
				try {
					suffix = objFactory.createSuffixType();
				} catch (JAXBException e3) {
					System.out
							.println("CreateCorpusXML:createNumeralAnalysis Exception while creating suffixType for hebWord="
									+ hebWord);
					e3.printStackTrace();
				}
				suffix.setFunction("possessive");
				suffix.setPerson(suffixPerson);
				suffix.setGender(suffixGender);
				suffix.setNumber(suffixNumber);
				analysis.setSuffix(suffix);
			}
		} else {
			numeral.setType(baseNumeralType);
			numeral.setValue(hebWord);
			base.setNumeral(numeral);
			analysis.setBase(base);
		}
		token.getAnalysis().add(analysis);
	}
	
	
	public void createPrefixNumeralAnalysis(String gender, String number,
			String status, String person, String baseNumeralType,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String description, String suffixFunction,
			String suffixNumber, String suffixGender, String suffixPerson,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixNumeralAnalysis Exception while creating Analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixNumeralAnalysis Exception while creating base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		NumeralType numeral = null;
		try {
			numeral = objFactory.createNumeralType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixNumeralAnalysis Exception while creating quantifier for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}

		
		if (!description.equals("definiteArticle"))
			setPrefix(description);
			numeral.setDefiniteness(definiteness);
		if (baseNumeralType.equals("gematria")) {
			numeral.setValue(hebWord);		
		 } else {
			setBase(base, transliteratedLexiocnItem, lexiconItem,
					lexiconPointer, dottedLexiconItem);
			numeral.setDefiniteness(definiteness);
			numeral.setGender(gender);
			numeral.setNumber(number);
			numeral.setStatus(status);
			numeral.setDefiniteness(definiteness);
			numeral.setRegister(register);
		}
		numeral.setType(baseNumeralType);
		base.setNumeral(numeral);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createExistentialAnalysis(String baseGender, String baseNumber,
			String transliterated, String lexiconItem, String lexiconPointer,
			String root, String tense, String definiteness, String person,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createExistentialAnalysis Exception while creating analysis for hebWord ="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createExistentialAnalysis Exception while creating base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliterated, lexiconItem, lexiconPointer, dottedLexiconItem);
		ExistentialType existential = null;
		try {
			existential = objFactory.createExistentialType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createExistentialAnalysis Exception while creating createExistentialType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		existential.setRegister(register);
		existential.setDefiniteness(definiteness);
		if (!root.equals("")) {
			existential.setGender(baseGender);
			existential.setNumber(baseNumber);
			existential.setPerson(person);
			existential.setRoot(root);
			existential.setTense(tense);
		}
		base.setExistential(existential);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createImpersonalAnalysis(String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String hebWord, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createImpersonalAnalysis Exception while creating analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createImpersonalAnalysis Exception while creating base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ImpersonalType impersonal = null;
		try {
			impersonal = objFactory.createImpersonalType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createImpersonalAnalysis Exception while creating ImpersonalType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		base.setImpersonal(impersonal);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createModalAnalysis(String baseGender, String baseNumber,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createModalAnalysis Exception while creating analyziz for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createModalAnalysis Exception while creating base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ModalType modal = null;
		try {
			modal = objFactory.createModalType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createModalAnalysis Exception while creating ModalType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		modal.setRegister(register);
		modal.setGender(baseGender);
		modal.setNumber(baseNumber);
		base.setModal(modal);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixesAnalysis(String description, int baseDefinitnessi) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixesAnalysis Exception while creating analysis for description="
							+ description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));

		if (description.equals("definiteArticle")) {
			try {
				pref = objFactory.createPrefixType();
			} catch (JAXBException e1) {
				System.out
						.println("CreateCorpusXML:createPrefixesAnalysis Exception while creating PrefixType for description="
								+ description);
				e1.printStackTrace();
			}
			pref.setId("1");
			pref.setFunction("definiteArticle");
			pref.setSurface("ה");
			analysis.getPrefix().add(pref);
		} else {
			List list = null;
			try {
				list = Translate.analyzeMixedHebEng(description);
			} catch (UnsupportedEncodingException e1) {
				System.out
						.println("CreateCorpusXML:createPrefixesAnalysis Exception while analyzeMixedHebEng for description="
								+ description);
				e1.printStackTrace();
			}
			int size = list.size();
			//System.out.println("size=" + size);
			PrefixRec prefixRec = new PrefixRec();
			for (int i = 0; i < size; i++) {
				prefixRec = (PrefixRec) list.get(i);
				try {
					pref = objFactory.createPrefixType();
				} catch (JAXBException e2) {
					System.out
							.println("CreateCorpusXML:createPrefixesAnalysis Exception while createPrefixType for description="
									+ description);
					e2.printStackTrace();
				}
				pref.setId(String.valueOf(i + 1));
				pref.setFunction(prefixRec.getFunction());
				String prefixSurface = prefixRec.getSurface();
				//for the case of definite article
				if (prefixSurface.equals(""))
					prefixSurface = "unspecified";
				pref.setSurface(prefixSurface);
				analysis.getPrefix().add(pref);
			}
			//h handling
			if (baseDefinitnessi == 0) {
				try {
					pref = objFactory.createPrefixType();
				} catch (JAXBException e2) {
					System.out
							.println("CreateCorpusXML:createPrefixesAnalysis Exception while createPrefixType for description="
									+ description);
					e2.printStackTrace();
				}
				pref.setId(String.valueOf(size + 1));
				pref.setFunction("definiteArticle");
				pref.setSurface("ה");
				analysis.getPrefix().add(pref);
			}
		}
		token.getAnalysis().add(analysis);
	}

	public void createInterjectionAnalysis(String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createInterjectionAnalysis Exception while createAnalysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createInterjectionAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		InterjectionType interjection = null;
		try {
			interjection = objFactory.createInterjectionType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createInterjectionAnalysis Exception while create InterjectionType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		interjection.setRegister(register);
		base.setInterjection(interjection);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixInterjectionAnalysis(
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String description, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixInterjectionAnalysis Exception while create analysis for hebWord="
							+ hebWord + " description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixInterjectionAnalysis Exception while create abse for hebWord="
							+ hebWord + " description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		InterjectionType interjection = null;
		try {
			interjection = objFactory.createInterjectionType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixInterjectionAnalysis Exception while create InterjectionType for hebWord="
							+ hebWord + " description=" + description);
			e2.printStackTrace();
		}
		interjection.setRegister(register);
		base.setInterjection(interjection);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createInterrogativeAnalysis(String gender, String number,
			String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createInterrogativeAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createInterrogativeAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberPersonType interrogative = null;
		try {
			interrogative = objFactory.createGenderNumberPersonType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createInterrogativeAnalysis Exception while create GenderNumberPersonType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		interrogative.setRegister(register);
		//interrogative.setGender(gender);
		//interrogative.setNumber(number);
		//interrogative.setPerson(person);
		base.setInterrogative(interrogative);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixInterrogativeAnalysis(String gender, String number,
			String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixInterrogativeAnalysis Exception while create analysis for hebWord="
							+ hebWord + "description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixInterrogativeAnalysis Exception while create base for hebWord="
							+ hebWord + "description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberPersonType interrogative = null;
		try {
			interrogative = objFactory.createGenderNumberPersonType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixInterrogativeAnalysis Exception while createGenderNumberPersonType for hebWord="
							+ hebWord + "description=" + description);
			e2.printStackTrace();
		}
		interrogative.setRegister(register);
		//interrogative.setGender(gender);
		//interrogative.setNumber(number);
		//interrogative.setPerson(person);
		base.setInterrogative(interrogative);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createConjunctionAnalysis(String type,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createConjunctionAnalysis Exception while create analysis for hebWord="
							+ hebWord);
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createConjunctionAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ConjunctionType conjunction = null;
		try {
			conjunction = objFactory.createConjunctionType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createConjunctionAnalysis Exception while createConjunctionType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		conjunction.setRegister(register);
		conjunction.setType(type);
		base.setConjunction(conjunction);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixConjunctionAnalysis(String type,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String description, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixConjunctionAnalysis Exception while createConjunctionType for hebWord="
							+ hebWord + "  description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixConjunctionAnalysis Exception while create base for hebWord="
							+ hebWord + "  description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ConjunctionType conjunction = null;
		try {
			conjunction = objFactory.createConjunctionType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixConjunctionAnalysis Exception while create createConjunctionType for hebWord="
							+ hebWord + "  description=" + description);
			e2.printStackTrace();
		}
		conjunction.setRegister(register);
		conjunction.setType(type);
		base.setConjunction(conjunction);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createAdjectiveAnalysis(String gender, String number,
			String status, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String definiteness,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createAdjectiveAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createAdjectiveAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberStatusDefinitenessType adjective = null;
		try {
			adjective = objFactory.createGenderNumberStatusDefinitenessType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createAdjectiveAnalysis Exception while create createGenderNumberStatusDefinitenessType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		adjective.setRegister(register);
		adjective.setGender(gender);
		adjective.setNumber(number);
		adjective.setStatus(status);
		adjective.setDefiniteness(definiteness);
		base.setAdjective(adjective);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixAdjectiveAnalysis(String gender, String number,
			String status, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixAdjectiveAnalysis Exception while create analysis for hebWord="
							+ hebWord + " description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixAdjectiveAnalysis Exception while create base for hebWord="
							+ hebWord + " description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberStatusDefinitenessType adjective = null;
		try {
			adjective = objFactory.createGenderNumberStatusDefinitenessType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixAdjectiveAnalysis Exception while createGenderNumberStatusDefinitenessType for hebWord="
							+ hebWord + " description=" + description);
		}
		adjective.setRegister(register);
		adjective.setGender(gender);
		adjective.setNumber(number);
		adjective.setStatus(status);
		adjective.setDefiniteness(definiteness);
		base.setAdjective(adjective);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPronounAnalysis(String gender, String number,
			String person, String type, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPronounAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPronounAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		PronounType pronoun = null;
		try {
			pronoun = objFactory.createPronounType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPronounAnalysis Exception while createPronounType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		pronoun.setRegister(register);
		pronoun.setGender(gender);
		pronoun.setNumber(number);
		pronoun.setPerson(person);
		pronoun.setType(type);
		base.setPronoun(pronoun);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixPronounAnalysis(String gender, String number,
			String person, String type, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixPronounAnalysis Exception while create analysis for hebWord="
							+ hebWord + "  description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixPronounAnalysis Exception while create base for hebWord="
							+ hebWord + "  description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		PronounType pronoun = null;
		try {
			pronoun = objFactory.createPronounType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixPronounAnalysis Exception while createPronounType for hebWord="
							+ hebWord + "  description=" + description);
			e2.printStackTrace();
		}
		pronoun.setRegister(register);
		pronoun.setGender(gender);
		pronoun.setNumber(number);
		pronoun.setPerson(person);
		pronoun.setType(type);
		base.setPronoun(pronoun);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createProperNameAnalysis(String gender, String number,
			String person, String type, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String definiteness,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createProperNameAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createProperNameAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ProperNameType properName = null;
		try {
			properName = objFactory.createProperNameType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createProperNameAnalysis Exception while create createProperNameType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		properName.setRegister(register);
		properName.setGender(gender);
		properName.setNumber(number);
		properName.setType(type);
		properName.setDefiniteness(definiteness);
		base.setProperName(properName);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixProperNameAnalysis(String gender, String number,
			String person, String type, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixProperNameAnalysis Exception while create analysis for hebWord="
							+ hebWord + "  description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixProperNameAnalysis Exception while create base for hebWord="
							+ hebWord + "  description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ProperNameType properName = null;
		try {
			properName = objFactory.createProperNameType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixProperNameAnalysis Exception while createProperNameType for hebWord="
							+ hebWord + "  description=" + description);
			e2.printStackTrace();
		}
		properName.setRegister(register);
		properName.setGender(gender);
		properName.setNumber(number);
		properName.setType(type);
		properName.setDefiniteness(definiteness);
		base.setProperName(properName);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createAdverbAnalysis(String gender, String number,
			String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createAdverbAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createAdverbAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberPersonType adverb = null;
		try {
			adverb = objFactory.createGenderNumberPersonType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createAdverbAnalysis Exception while createGenderNumberPersonType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		adverb.setRegister(register);
		//adverb.setGender(gender);
		//adverb.setNumber(number);
		//adverb.setPerson(person);
		base.setAdverb(adverb);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixAdverbAnalysis(String gender, String number,
			String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixAdverbAnalysis Exception while create analysis for hebWord="
							+ hebWord + "  descriptionn=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixAdverbAnalysis Exception while create base  for hebWord="
							+ hebWord + "  descriptionn=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberPersonType adverb = null;
		try {
			adverb = objFactory.createGenderNumberPersonType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixAdverbAnalysis Exception while createGenderNumberPersonType  for hebWord="
							+ hebWord + "  descriptionn=" + description);
			e2.printStackTrace();
		}
		adverb.setRegister(register);
		//adverb.setGender(gender);
		//adverb.setNumber(number);
		//adverb.setPerson(person);
		base.setAdverb(adverb);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrepositionAnalysis(String suffixGender,
			String suffixNumber, String suffixPerson,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String suffixFunction, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrepositionAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrepositionAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberPersonType preposition = null;
		try {
			preposition = objFactory.createGenderNumberPersonType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrepositionAnalysis Exception while createGenderNumberPersonType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		preposition.setRegister(register);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) {
			preposition.setGender(suffixGender);
			preposition.setNumber(suffixNumber);
			preposition.setPerson(suffixPerson);
		}
		base.setPreposition(preposition);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixPrepositionAnalysis(String suffixGender,
			String suffixNumber, String suffixPerson,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String description, String suffixFunction,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixPrepositionAnalysis Exception while create analysis for hebWord="
							+ hebWord + "  description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixPrepositionAnalysis Exception while create base for hebWord="
							+ hebWord + "  description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberPersonType preposition = null;
		try {
			preposition = objFactory.createGenderNumberPersonType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixPrepositionAnalysis Exception while createGenderNumberPersonType for hebWord="
							+ hebWord + "  description=" + description);
			e2.printStackTrace();
		}
		preposition.setRegister(register);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) {
			preposition.setGender(suffixGender);
			preposition.setNumber(suffixNumber);
			preposition.setPerson(suffixPerson);
		}
		base.setPreposition(preposition);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createVerbAnalysis(String binyan, String gender, String number,
			String person, String root, String tense,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createVerbAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createVerbAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		VerbType verb = null;
		try {
			verb = objFactory.createVerbType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createVerbAnalysis Exception while createVerbType analysis for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		verb.setRegister(register);
		verb.setBinyan(binyan);
		if (!tense.equals("infinitive")) {
			verb.setGender(gender);
			verb.setNumber(number);
			verb.setPerson(person);
		}
		verb.setRoot(root);
		verb.setTense(tense);
		base.setVerb(verb);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixVerbAnalysis(String binyan, String gender,
			String number, String person, String root, String tense,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String description, String suffixFunction,
			String accusativeNominativeNumber,
			String accusativeNominativeGender,
			String accusativeNominativePerson, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixVerbAnalysis Exception while create analysis analysis for hebWord="
							+ hebWord + "  description=" + description);
			e.printStackTrace();
		}
		setPrefix(description);
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixVerbAnalysis Exception while create base  analysis for hebWord="
							+ hebWord + "  description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		VerbType verb = null;
		try {
			verb = objFactory.createVerbType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixVerbAnalysis Exception while createVerbType  for hebWord="
							+ hebWord + "  description=" + description);
			e2.printStackTrace();
		}
		verb.setRegister(register);
		verb.setBinyan(binyan);
		if (!tense.equals("infinitive")) {
			verb.setGender(gender);
			verb.setNumber(number);
			verb.setPerson(person);
		}
		verb.setRoot(root);
		verb.setTense(tense);
		base.setVerb(verb);
		analysis.setBase(base);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if (suffixFunctioni == SUFFIX_FUNCTION_ACCUSATIVE_OR_NOMINATIVE) {
			SuffixType suffix = null;
			try {
				suffix = objFactory.createSuffixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createPrefixVerbAnalysis Exception while createSuffixType  for hebWord="
								+ hebWord + "  description=" + description);
				e3.printStackTrace();
			}
			suffix.setFunction(suffixFunction);
			suffix.setPerson(accusativeNominativePerson);
			suffix.setNumber(accusativeNominativeNumber);
			suffix.setGender(accusativeNominativeGender);
			analysis.setSuffix(suffix);
		}
		token.getAnalysis().add(analysis);
	}

	public void createNegationAnalysis(String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createNegationAnalysis Exception while create  analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createNegationAnalysis Exception while base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		NegationType negation = null;
		try {
			negation = objFactory.createNegationType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createNegationAnalysis Exception while createNegationType analysis for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		negation.setRegister(register);
		base.setNegation(negation);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createWprefixAnalysis(String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixesAnalysis Exception while create  analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixesAnalysis Exception while base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		WprefixType wprefix= null;
		try {
			wprefix = objFactory.createWprefixType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createNegationAnalysis Exception while createNegationType analysis for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		wprefix.setRegister(register);
		base.setWPrefix(wprefix);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}
	public void createForeignAnalysis() {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createForeignAnalysis Exception while create  analysis");
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createForeignAnalysis Exception while create  base");
			e1.printStackTrace();
		}
		ForeignType foreign = null;
		try {
			foreign = objFactory.createForeignType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createForeignAnalysis Exception while createForeignType");
			e2.printStackTrace();
		}
		base.setForeign(foreign);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createURLAnalysis() {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createURLAnalysis Exception while create analysis");
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createURLAnalysis Exception while create base");
			e1.printStackTrace();
		}
		URLType url = null;
		try {
			url = objFactory.createURLType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createURLAnalysis Exception while createURLType");
			e2.printStackTrace();
		}
		base.setUrl(url);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixNegationAnalysis(String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixNegationAnalysis Exception while create analysis for hebWord="
							+ hebWord + " description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixNegationAnalysis Exception while create base for hebWord="
							+ hebWord + " description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		NegationType negation = null;
		try {
			negation = objFactory.createNegationType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixNegationAnalysis Exception while createNegationType for hebWord="
							+ hebWord + " description=" + description);
			e2.printStackTrace();
		}
		negation.setRegister(register);
		base.setNegation(negation);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPrefixWprefixAnalysis(String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixPrefixesAnalysis Exception while create analysis for hebWord="
							+ hebWord + " description=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixPrefixesAnalysis Exception while create base for hebWord="
							+ hebWord + " description=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		WprefixType wPrefix = null;
		try {
			wPrefix = objFactory.createWprefixType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixNegationAnalysis Exception while createNegationType for hebWord="
							+ hebWord + " description=" + description);
			e2.printStackTrace();
		}
		wPrefix.setRegister(register);
		base.setWPrefix(wPrefix);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createNounAnalysis(String gender, String number, String status,
			String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String suffixNumber,
			String suffixGender, String suffixPerson, String suffixFunction,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createNounAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createNounAnalysis Exception while create base  for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberStatusDefinitenessType noun = null;
		try {
			noun = objFactory.createGenderNumberStatusDefinitenessType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createNounAnalysis Exception while createGenderNumberStatusDefinitenessType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		noun.setRegister(register);
		noun.setGender(gender);
		noun.setNumber(number);
		noun.setStatus(status);
		noun.setDefiniteness(definiteness);
		base.setNoun(noun);
		analysis.setBase(base);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) {
			SuffixType suffix = null;
			try {
				suffix = objFactory.createSuffixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createNounAnalysis Exception while createSuffixType for hebWord="
								+ hebWord);
				e3.printStackTrace();
			}
			suffix.setFunction(suffixFunction);
			suffix.setPerson(suffixPerson);
			suffix.setNumber(suffixNumber);
			suffix.setGender(suffixGender);
			analysis.setSuffix(suffix);
		}
		token.getAnalysis().add(analysis);
	}

	public void createPrefixNounAnalysis(String gender, String number,
			String status, String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String suffixNumber, String suffixGender, String suffixPerson,
			String suffixFunction, String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixNounAnalysis Exception while create analysis for hebWord="
							+ hebWord + " decsription=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixNounAnalysis Exception while create base for hebWord="
							+ hebWord + " decsription=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		GenderNumberStatusDefinitenessType noun = null;
		try {
			noun = objFactory.createGenderNumberStatusDefinitenessType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixNounAnalysis Exception while create base for hebWord="
							+ hebWord + " decsription=" + description);
			e2.printStackTrace();
		}
		noun.setRegister(register);
		noun.setGender(gender);
		noun.setNumber(number);
		noun.setStatus(status);
		noun.setDefiniteness(definiteness);
		base.setNoun(noun);
		analysis.setBase(base);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if (suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) {
			SuffixType suffix = null;
			try {
				suffix = objFactory.createSuffixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createPrefixNounAnalysis Exception while createSuffixType for hebWord="
								+ hebWord + " decsription=" + description);
				e3.printStackTrace();
			}
			suffix.setFunction(suffixFunction);
			suffix.setPerson(suffixPerson);
			suffix.setNumber(suffixNumber);
			suffix.setGender(suffixGender);
			analysis.setSuffix(suffix);
		}
		token.getAnalysis().add(analysis);
	}

	public void createParticipleAnalysis(String gender, String number,
			String status, String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String root,
			String tense, String binyan, String suffixFunction,
			String suffixPerson, String suffixGender, String suffixNumber,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createParticipleAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createParticipleAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ParticipleType participle = null;
		try {
			participle = objFactory.createParticipleType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createParticipleAnalysis Exception while createParticipleType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		participle.setRegister(register);
		participle.setGender(gender);
		participle.setNumber(number);
		participle.setStatus(status);
		//participle.setRoot(URLEncoder.encode(root,"UTF-8"));
		participle.setRoot(root);
		//participle.setTense(tense);
		participle.setBinyan(binyan);
		participle.setPerson(person);
		participle.setDefiniteness(definiteness);
		base.setParticiple(participle);
		analysis.setBase(base);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if ((suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) || (suffixFunctioni == SUFFIX_FUNCTION_ACCUSATIVE_OR_NOMINATIVE)){
			SuffixType suffix = null;
			try {
				suffix = objFactory.createSuffixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createParticipleAnalysis Exception while createSuffixType for hebWord="
								+ hebWord);
				e3.printStackTrace();
			}
			suffix.setFunction(suffixFunction);
			suffix.setPerson(suffixPerson);
			analysis.setSuffix(suffix);
			suffix.setGender(suffixGender);
			suffix.setNumber(suffixNumber);
		}
		token.getAnalysis().add(analysis);
	}

	public void createPrefixParticipleAnalysis(String gender, String number,
			String status, String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String description,
			String root, String tense, String binyan, String suffixFunction,
			String suffixPerson, String suffixGender, String suffixNumber,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPrefixParticipleAnalysis Exception while create analysis for hebWord="
							+ hebWord + " decsription=" + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPrefixParticipleAnalysis Exception while create base for hebWord="
							+ hebWord + " decsription=" + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ParticipleType participle = null;
		try {
			participle = objFactory.createParticipleType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPrefixParticipleAnalysis Exception while createParticipleType for hebWord="
							+ hebWord + " decsription=" + description);
			e2.printStackTrace();
		}
		participle.setRegister(register);
		participle.setGender(gender);
		participle.setNumber(number);
		participle.setStatus(status);
		participle.setRoot(root);
		//participle.setTense(tense);
		participle.setBinyan(binyan);
		participle.setPerson(person);
		participle.setDefiniteness(definiteness);
		base.setParticiple(participle);
		analysis.setBase(base);
		int suffixFunctioni = Integer.valueOf(
				Encoder.encodeSuffixFunction(suffixFunction)).intValue();
		if ((suffixFunctioni == SUFFIX_FUNCTION_POSSESSIVE) || (suffixFunctioni == SUFFIX_FUNCTION_ACCUSATIVE_OR_NOMINATIVE)) {
			SuffixType suffix = null;
			try {
				suffix = objFactory.createSuffixType();
			} catch (JAXBException e3) {
				System.out
						.println("CreateCorpusXML:createPrefixParticipleAnalysis Exception while createSuffixType for hebWord="
								+ hebWord + " decsription=" + description);
				e3.printStackTrace();
			}
			suffix.setFunction(suffixFunction);
			suffix.setPerson(suffixPerson);
			suffix.setGender(suffixGender);
			suffix.setNumber(suffixNumber);
			analysis.setSuffix(suffix);
		}
		token.getAnalysis().add(analysis);
	}

	public void createPassiveParticipleAnalysis(String gender, String number,
			String status, String person, String transliteratedLexiocnItem,
			String lexiconItem, String lexiconPointer, String root,
			String tense, String binyan, String suffixFunction,
			String suffixPerson, String suffixGender, String suffixNumber,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPassiveParticipleAnalysis Exception while create analysis for hebWord="
							+ hebWord);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPassiveParticipleAnalysis Exception while create base for hebWord="
							+ hebWord);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ParticipleType participle = null;
		try {
			participle = objFactory.createParticipleType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPassiveParticipleAnalysis Exception while createPassiveParticipleType for hebWord="
							+ hebWord);
			e2.printStackTrace();
		}
		participle.setRegister(register);
		participle.setGender(gender);
		participle.setNumber(number);
		participle.setStatus(status);
		//participle.setRoot(URLEncoder.encode(root,"UTF-8"));
		participle.setRoot(root);
		participle.setBinyan(binyan);
		participle.setPerson(person);
		participle.setDefiniteness(definiteness);
		participle.setMood("passive");
		base.setParticiple(participle);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void createPassivePrefixParticipleAnalysis(String gender,
			String number, String status, String person,
			String transliteratedLexiocnItem, String lexiconItem,
			String lexiconPointer, String description, String root,
			String tense, String binyan, String suffixFunction,
			String suffixPerson, String suffixGender, String suffixNumber,
			String definiteness, String hebWord, String register, String dottedLexiconItem) {
		analysisCounter++;
		try {
			analysis = objFactory.createAnalysisType();
		} catch (JAXBException e) {
			System.out
					.println("CreateCorpusXML:createPassivePrefixParticipleAnalysis Exception while create analysis for hebWord="
							+ hebWord + "  description= " + description);
			e.printStackTrace();
		}
		analysis.setId(String.valueOf(analysisCounter));
		setPrefix(description);
		BaseType base = null;
		try {
			base = objFactory.createBaseType();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:createPassivePrefixParticipleAnalysis Exception while create base  for hebWord="
							+ hebWord + "  description= " + description);
			e1.printStackTrace();
		}
		setBase(base, transliteratedLexiocnItem, lexiconItem, lexiconPointer, dottedLexiconItem);
		ParticipleType participle = null;
		try {
			participle = objFactory.createParticipleType();
		} catch (JAXBException e2) {
			System.out
					.println("CreateCorpusXML:createPassivePrefixParticipleAnalysis Exception while createPassiveParticipleType  for hebWord="
							+ hebWord + "  description= " + description);
			e2.printStackTrace();
		}
		participle.setRegister(register);
		participle.setGender(gender);
		participle.setNumber(number);
		participle.setStatus(status);
		participle.setRoot(root);
		participle.setBinyan(binyan);
		participle.setPerson(person);
		participle.setDefiniteness(definiteness);
		base.setParticiple(participle);
		analysis.setBase(base);
		token.getAnalysis().add(analysis);
	}

	public void printDoc() {
		if (outputFile.equals(""))
			try {
				pOut = new OutputStreamWriter(System.out, "UTF8");
			} catch (UnsupportedEncodingException e) {
				System.out
						.println("CreateCorpusXML:printDoc UnsupportedEncodingException while create OutputStreamWriter");
				e.printStackTrace();
			}
		else {
			FileOutputStream out = null;
			try {
				out = new FileOutputStream(outputFile);
			} catch (FileNotFoundException e1) {
				System.out
						.println("CreateCorpusXML:printDoc FileNotFoundException while create OutputStreamWriter");
				e1.printStackTrace();
			}
			try {
				pOut = new OutputStreamWriter(out, "UTF8");
			} catch (UnsupportedEncodingException e2) {
				System.out
						.println("CreateCorpusXML:printDoc UnsupportedEncodingException while create OutputStreamWriter");
				e2.printStackTrace();
			}
		}
		Marshaller m = null;
		try {
			m = jc.createMarshaller();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e1.printStackTrace();
		}
		try {
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.FALSE);
		} catch (PropertyException e2) {
			System.out
					.println("CreateCorpusXML:printDoc PropertyException while create Marshaller");
			e2.printStackTrace();
		}
		try {
			m.marshal(corpus, pOut);
		} catch (JAXBException e3) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e3.printStackTrace();
		}
		try {
			//if (!validator.validate(corpus)) {
			//	System.err.println("Corpus Not valid !!!");
			//}
			pOut.close();
		} catch (IOException e4) {
			System.out
					.println("CreateCorpusXML:printDoc IOException while closeing pOut");
			e4.printStackTrace();
		}
	}

	public void printDoc(PrintWriter pw) {
		if (outputFile.equals(""))
			try {
				pOut = new OutputStreamWriter(System.out, "UTF8");
			} catch (UnsupportedEncodingException e) {
				System.out
						.println("CreateCorpusXML:printDoc UnsupportedEncodingException while create OutputStreamWriter");
				e.printStackTrace();
			}
		else {
			FileOutputStream out = null;
			try {
				out = new FileOutputStream(outputFile);
			} catch (FileNotFoundException e1) {
				System.out
						.println("CreateCorpusXML:printDoc FileNotFoundException while create OutputStreamWriter");
				e1.printStackTrace();
			}
			try {
				pOut = new OutputStreamWriter(out, "UTF8");
			} catch (UnsupportedEncodingException e2) {
				System.out
						.println("CreateCorpusXML:printDoc UnsupportedEncodingException while create OutputStreamWriter");
				e2.printStackTrace();
			}
		}

		Marshaller m = null;
		try {
			m = jc.createMarshaller();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e1.printStackTrace();
		}
		try {
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.FALSE);
		} catch (PropertyException e2) {
			System.out
					.println("CreateCorpusXML:printDoc PropertyException while create Marshaller");
			e2.printStackTrace();
		}
		try {
			//pw.write("<?xml-stylesheet type=\"text/xsl\"
			// href=\"output.xsl\"?>");
			m.marshal(corpus, pw);
			//Validator validator = jc.createValidator();
			//if (!validator.validate(corpus)) {
			//	System.err.println("Corpus Not valid !!!");
			//}
			//pOut.close();
		} catch (JAXBException e3) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e3.printStackTrace();
		}
	}

	public void printDoc(PrintWriter pw, String xslFileName) {
		if (outputFile.equals(""))
			try {
				pOut = new OutputStreamWriter(System.out, "UTF8");
			} catch (UnsupportedEncodingException e) {
				System.out
						.println("CreateCorpusXML:printDoc UnsupportedEncodingException while create OutputStreamWriter");
				e.printStackTrace();
			}
		else {
			FileOutputStream out = null;
			try {
				out = new FileOutputStream(outputFile);
			} catch (FileNotFoundException e1) {
				System.out
						.println("CreateCorpusXML:printDoc FileNotFoundException while create OutputStreamWriter");
				e1.printStackTrace();
			}
			try {
				pOut = new OutputStreamWriter(out, "UTF8");
			} catch (UnsupportedEncodingException e2) {
				System.out
						.println("CreateCorpusXML:printDoc UnsupportedEncodingException while create OutputStreamWriter");
				e2.printStackTrace();
			}
		}

		Marshaller m = null;
		try {
			m = jc.createMarshaller();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e1.printStackTrace();
		}
		try {
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.FALSE);
		} catch (PropertyException e2) {
			System.out
					.println("CreateCorpusXML:printDoc PropertyException while create Marshaller");
			e2.printStackTrace();
		}
		pw.write("<?xml-stylesheet type=\"text/xsl\" href=\"" + xslFileName
				+ "\"?>");
		try {
			m.marshal(corpus, pw);
			//Validator validator = jc.createValidator();
			//if (!validator.validate(corpus)) {
			//	System.err.println("Corpus Not valid !!!");
			//}
			//pOut.close();
		} catch (JAXBException e3) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e3.printStackTrace();
		}
	}

	public void printDoc(OutputStream outputStream) {
		try {
			//System.err.println("printDoc");
			pOut = new OutputStreamWriter(outputStream, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			System.out
					.println("CreateCorpusXML:printDoc UnsupportedEncodingException while create OutputStreamWriter");
			e.printStackTrace();
		}
		//pOut = new OutputStreamWriter(outputStream);
		Marshaller m = null;
		try {
			m = jc.createMarshaller();
		} catch (JAXBException e1) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e1.printStackTrace();
		}
		try {
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.FALSE);
		} catch (PropertyException e2) {
			System.out
					.println("CreateCorpusXML:printDoc PropertyException while create Marshaller");
			e2.printStackTrace();
		}
		try {
			m.marshal(corpus, outputStream);
		} catch (JAXBException e3) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Marshaller");
			e3.printStackTrace();
		}
		try {
			Validator validator = jc.createValidator();
			//if (!validator.validate(corpus)) {
			//	System.err.println("Corpus Not valid !!!");
			//}
			//pOut.close();
		} catch (JAXBException e4) {
			System.out
					.println("CreateCorpusXML:printDoc JAXBException while create Validator");
			e4.printStackTrace();
		}
		
		
	}

	public void createXMLOutputHandling() {
		createXMLdOC();
		createArticle();
		createParagraph();
		createSentence();
	}

	public static void main(String[] args) throws Exception {

		//		CreateCorpusXML c = new CreateCorpusXML();
		//		c.createXMLdOC();
		//		c.createArticle();
		//		c.createParagraph();
		//		c.createSentence();
		//		//c.createToken("dalia");
		//		c.finalizeSentence();
		//		c.printDoc();
	}
}
