(defun compile-equation (equation)
  (let ((part1 (first  equation))
	(part2 (second equation))
	(part3 (third  equation)))
  ; 
  ;   Xn  -->  (Xn)
  ;
    (if (resisterp part1) (setq part1 (list part1)))
    (if (resisterp part3) (setq part3 (list part3)))

  ; 
  ;   Branch by part2
  ; 
	   (case part2
	     (=
	       (cond ((pathp part3)
		      `(P=P ,part1 ,part3))
		     ((eq part3 '*NUMBER*)
                      `(P=NUM ,part1))
		     ((eq part3 '*INTEGER*)
                      `(P=INT ,part1))
		     ((eq part3 '*DEFINED*)
		      `(P=D ,part1))
		     ((eq part3 '*UNDEFINED*)
		      `(P=U ,part1))
		     ((eq part3 '*REMOVE*)
		      `(P=R ,part1))
		     ((or (atom part3) (atom (car part3)))
		      `(P=A ,part1 ,part3))
		     (t (equation-error equation))))

	     (=c
	      (cond ((pathp part3)
		     (equation-error equation))
		    ((or (atom part3) (atom (car part3)))
		     `(P=CA ,part1 ,part3))
		     (t (equation-error equation))))

	     (>
	       (cond ((pathp part3)
		      `(P>P ,part1 ,part3))
		     ((or (atom part3) (atom (car part3)))
		      `(P>A ,part1 ,part3))
		     (t (equation-error equation))))

	     (<=
	       `(P=L ,part1 ,part3))

 	     (==
	       (cond ((pathp part3)
		      `(P==P ,part1 ,part3))
		     (t (equation-error equation))))

	     (<
	       (cond ((pathp part3)
		      `(P<P ,part1 ,part3))
		     ((or (atom part3) (atom (car part3)))
		      `(P<A ,part1 ,part3))
		     (t (equation-error equation))))
	     (t
	       (cond ((member part2 *user-defined-equation*)
		      (compile-statements
		        (macroexpand (list part2 part1 part3))))
		     (t (equation-error equation)))))))

(defun path=integer (*fs-list* path)
   (map-dolist+ (fs *fs-list*)
     (setvalue fs path nil :mode 'integer)))

(defun path=number (*fs-list* path)
   (map-dolist+ (fs *fs-list*)
     (setvalue fs path nil :mode 'number)))

(defmacro p=int (path)
  `(setq x (path=integer x ',path)))
(defmacro p=num (path)
  `(setq x (path=number x ',path)))

(defun setvalue (fs path val &key (mode 'OVERWRITE))  ; returns a fs
  (cond
      ((null path)
 	 (case mode
	  (OVERWRITE val)
   	  (UNIFY (unify fs val))
	  (C-UNIFY (if fs (unify fs val) '*FAIL*))
	  (DEFINED (if fs fs '*FAIL*)) 
	  (INTEGER (if (and fs (integerp fs))  fs '*FAIL*)) 
	  (NUMBER (if (and fs (numberp fs))  fs '*FAIL*)) 
	  (UNDEFINED (if fs '*FAIL* nil))
	  (PUSH (append-fs-to-fs fs val))
	  (REMOVE nil)
	  (POP (pop-multi-value fs))))

         ;; if fs is *OR*, do each of the disjunction.
         ;; Return *fail* when all of the disjunction fail.
      ((and (listp fs)(eq (car fs) '*OR*))
       (or
        (list-to-value
	 (map-dolist+ (fs1 (cdr fs))
 	  (setvalue fs1 path val :mode mode)))
        '*FAIL*))

         ;; if fs is *MULTIPLE*, do each of the conjunction.
         ;; Return *fail* when any one of the disjunction fails.
      ((and (listp fs)(eq (car fs) '*MULTIPLE*))
       (let ((newvalue nil))
         (setq newvalue
           (map-dolist (fs1 (cdr fs))
 	   (setvalue fs1 path val :mode mode)))
         (if (member '*FAIL* newvalue)
             '*FAIL*
             (cons '*MULTIPLE* newvalue))))
          
         ;; else take ASSOC
      (t (let ((assoc-result (assoc (car path) fs)))
	  (if
            (null assoc-result)
	      ;; If the path doesn't exist	
	    (case mode
	      ((OVERWRITE UNIFY PUSH) (append (create-path path val) fs))
	      ((C-UNIFY DEFINED NUMBER INTEGER) '*FAIL*)
	      ((UNDEFINED REMOVE) fs))
	      
	       ;; If the path exists, call setvalue recursively
	    (let ((rec-result (setvalue (second assoc-result)
					(cdr path) val :mode mode)))
              (cond ((eq rec-result '*FAIL*) '*FAIL*)
		    ((null rec-result)(remove assoc-result fs))
	            ((cons (list (car path) rec-result)
			(remove assoc-result fs))))))))))



