package edu.cmu.cs.lti.letras.corpus;

import java.util.ArrayList;

import edu.cmu.cs.lti.letras.features.Feature;

/**
 * Some test from which we hope to learn some feature of a language based on
 * whether or not the presented sentence pair is different from another
 * particular sentence pair.
 */
public class SentenceTest {
	private final int[] requiredPairs;
	private final ArrayList<Feature> equalityImplications;
	private final ArrayList<Feature> inequalityImplications;

	public SentenceTest(int[] requiredPairs, ArrayList<Feature> equalityImplications,
			ArrayList<Feature> inequalityImplications) {
		this.requiredPairs = requiredPairs;
		this.equalityImplications = equalityImplications;
		this.inequalityImplications = inequalityImplications;
	}

	/**
	 * Get the ID's of the sentence pairs required to run this test.
	 * 
	 * @return
	 */
	public int[] getRequiredPairs() {
		return requiredPairs;
	}

	/**
	 * Get the language features that are implied by this sentence being equal
	 * with all of its required pairs.
	 * 
	 * @return
	 */
	public ArrayList<Feature> getEqualityImplications() {
		return equalityImplications;
	}

	/**
	 * Get the language features that are implied by this sentence being NOT
	 * equal with all of its required pairs.
	 */
	public ArrayList<Feature> getInequalityImplications() {
		return inequalityImplications;
	}

}
