package edu.cmu.cs.lti.letras.corpus;

import java.util.HashMap;

/**
 * A factory to ensure a 1-1 relation between SentencePair instances and sentence pair ID's.
 */
public class SentencePairFactory {

	private static final HashMap<Integer, SentencePair> pairs = new HashMap<Integer, SentencePair>();

	/**
	 * Create a new SentencePair object.
	 * 
	 * @param id
	 * @param eSentence
	 * @param fSentence
	 * @param alignments
	 * @param context
	 * @param comment
	 * @return
	 */
	public static SentencePair getInstance(int id, String[] eSentence, String[] fSentence,
			String alignments, String context, String comment) {

		assert id != -1;

		SentencePair pair = pairs.get(id);
		if (pair == null) {
			pair = new SentencePair(id, eSentence, fSentence, alignments, context,
					comment);
			pairs.put(id, pair);
		}
		
		return pair;
	}

	/**
	 * Lookup an existing SentencePair object by its unique id
	 * 
	 * @param id
	 * @return
	 */
	public static SentencePair getById(int id) {
		return pairs.get(id);
	}
}
