package edu.cmu.cs.lti.letras.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.ParseException;

import edu.cmu.cs.lti.letras.trees.SmartTree;
import edu.cmu.cs.lti.letras.trees.SmartTree.LabelMode;

public class CStructureParser {

	public static void main(String[] args) throws Exception {
		BufferedReader in = new BufferedReader(new FileReader("data/english.fixed.parsed"));

		int i = 1;
		int errors = 0;
		String line;
		while ((line = in.readLine()) != null) {

			try {
				// SmartTree<String> tree = parse("( (agent ((feature value)
				// (another-feature 2))))", "n");
				SmartTree tree = SmartTree.parse(line, "n", LabelMode.LABEL_ALL_NODES);
				System.out.println(++i + ": " + tree.toString());
			} catch (ParseException e) {
				e.printStackTrace();
				errors++;
			}
		}

		in.close();

		System.out.println("Finished with " + errors + " errors.");

		// for(int i=0; i<tree.nodeList.size(); i++)
		// System.out.println(i + ": " + tree.nodeList.get(i));
	}
}
