/**
 * The LETRAS Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 */
package edu.cmu.cs.lti.letras.filtering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

import edu.cmu.cs.lti.letras.corpus.SentencePair;
import edu.cmu.cs.lti.letras.corpus.SentencePairFactory;
import edu.cmu.cs.lti.letras.corpus.SentenceTest;

public class SentenceSelector {

	private HashSet<Integer> sentencesAlreadyElicited = new HashSet<Integer>();

	public SentenceSelector() {
	}

	public SentencePair getNextSentencePair(ArrayList<SentenceTest> remainingTests) {

		// TODO: Remove the gross inefficiency of this method when we implement
		// cost functions
		ArrayList<SentencePair> candidates = new ArrayList<SentencePair>();

		for (SentenceTest test : remainingTests) {
			for (int requiredPair : test.getRequiredPairs()) {
				// TODO: Select more intelligently which sentence we want to
				// return
				if (!sentencesAlreadyElicited.contains(requiredPair)) {
					candidates.add(SentencePairFactory.getById(requiredPair));
				}
			}
		}
		
		if(candidates.size() < 1)
			return null;
		
		// for now, just take the first sentence in the corpus that matches
		// this makes creating test data for debugging easier
		Collections.sort(candidates);
		SentencePair next = candidates.get(0);
		sentencesAlreadyElicited.add(next.getId());
		return next;
	}
}
