/**
 * The LETRAS Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 */
package edu.cmu.cs.lti.letras.filtering;

import java.util.ArrayList;
import java.util.Collection;

import edu.cmu.cs.lti.letras.featurebitmaps.Feature;
import edu.cmu.cs.lti.letras.featurebitmaps.FeatureGroup;
import edu.cmu.cs.lti.letras.featurebitmaps.FeatureGroupSet;

public class ImplicationFinder {

	// each feature group (the trigger) fires an implication that is a feature
	private final FeatureGroupSet<Feature> implicationalUniversals = new FeatureGroupSet<Feature>();
	private final ArrayList<Feature> cumulativeFeatureList = new ArrayList<Feature>();

	public ImplicationFinder(Collection<FeatureGroup<Feature>> implicationalUniversals) {
		for(FeatureGroup<Feature> f : implicationalUniversals) {
			addImplicationalUniversal(f);
		}
	}

	/**
	 * Add an implication universal axiom (known at load-time).
	 * 
	 * @param implicationalUniversal
	 */
	public void addImplicationalUniversal(FeatureGroup<Feature> implicationalUniversal) {
		implicationalUniversals.add(implicationalUniversal);
	}

	/**
	 * Add a feature that was just discovered through elicitation
	 * 
	 * @param feature
	 */
	public void addDiscoveredFeatures(Collection<Feature> newFeatures) {
		cumulativeFeatureList.addAll(newFeatures);
	}

	/**
	 * Get the implications for which features are no longer possible in this
	 * language, given the current knowledge. XXX: Is this a valid assumption?
	 * 
	 * @return
	 */
	public ArrayList<Feature> getImplications() {
		FeatureGroup<Void> allKnownFeatures = new FeatureGroup<Void>(cumulativeFeatureList, null);
		ArrayList<FeatureGroup<Feature>> subsets = implicationalUniversals.getSubsetsOf(allKnownFeatures);

		ArrayList<Feature> implications = new ArrayList<Feature>();
		for (FeatureGroup<Feature> axiom : subsets) {
			implications.add(axiom.getValue());
		}
		return implications;
	}
}
