package edu.cmu.cs.lti.letras.featuredetection;

import edu.cmu.cs.lti.letras.corpus.SentencePair;

/**
 * A matching sentence pair that matches the left-hand-side of a Rule.
 * TODO: Implement caching of fnode lookups
 */
public class SentencePatternMatch {
	private final SentencePair match;
	private final String sentenceVariable;
	private final String[] variableValues;
	// private final KeyCache<String, TreeNode> fnodeCache;

//	private static final Logger log = LogUtils.getLogger();

	public SentencePatternMatch(String sentenceVariable, final Rule rule, final int nSentencePattern, SentencePair match, String[] variableValues) {
		
		this.sentenceVariable = sentenceVariable;
		this.match = match;
		this.variableValues = variableValues;
		
//		CacheGenerator<String, TreeNode> generator = new CacheGenerator<String, TreeNode>() {
//			@Override
//			public TreeNode getUncachedValue(String key) throws Exception {
//				// example input: A (X)
//				// meaning for sentence A, match
//				
//				Integer n = rule.getSentencePatternVariables().get(var);
//				if(n == null)
//					throw new RuntimeException("Unrecognized variable: " + var);
//				rule.getSentencePatterns()[nSentencePattern];
//				
//				return null;
//			}
//		};
//		
//		this.fnodeCache = new KeyCache<String, TreeNode>(generator, log);
	}

	public SentencePair getSentencePair() {
		return match;
	}

	public String[] getVariableValues() {
		return variableValues;
	}
	
	/**
	 * The variable name used to refer to this sentence (e.g. A)
	 * 
	 * @return
	 */
	public String getSentenceVariable() {
		return sentenceVariable;
	}

	// public KeyCache<String, TreeNode> getFnodeCache() {
	// return fnodeCache;
	// }
}
