/**
 * The LETRAS Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 */
package edu.cmu.cs.lti.letras.corpus;

import java.util.HashMap;

import edu.cmu.cs.lti.letras.trees.SmartTree;

/**
 * A factory to ensure a 1-1 relation between SentencePair instances and
 * sentence pair ID's.
 */
public class SentencePairFactory {

	private static final HashMap<Integer, SentencePair> pairs = new HashMap<Integer, SentencePair>();

	/**
	 * Create a new SentencePair object.
	 * 
	 * @param id
	 * @param eSentence
	 * @param fSentence
	 * @param alignments
	 * @param context
	 * @param comment
	 * @return
	 */
	public static SentencePair getInstance(int id, String[] eSentence, String[] fSentence,
			String alignments, String context, String comment, SmartTree featureStructure,
			SmartTree constituentStructure, PhiPlusMapping phiPlusMapping, String fstLine,
			String cstLine, String myLine) {

		// assert id != -1;

		SentencePair pair = pairs.get(id);
		if (id == -1 || pair == null) {
			pair = new SentencePair(id, eSentence, fSentence, alignments, context, comment,
					featureStructure, constituentStructure, phiPlusMapping, fstLine, cstLine,
					myLine);
			pairs.put(id, pair);
		}

		return pair;
	}

	/**
	 * Lookup an existing SentencePair object by its unique id
	 * 
	 * @param id
	 * @return
	 */
	public static SentencePair getById(int id) {
		return pairs.get(id);
	}
}
