package info.jonclark.util;

import java.util.HashMap;

public class HashUtils {
    public static <T> void increment(HashMap<T, Integer> map, T key) {
	Integer value = map.get(key);
	if(value == null)
	    value = 0;
	map.put(key, value + 1);
    }
    
    public static <T> void decrement(HashMap<T, Integer> map, T key) {
	Integer value = map.get(key);
	if(value == null)
	    value = 0;
	map.put(key, value - 1);
    }
    
    public static <T> void add(HashMap<T, Integer> map, T key, int amount) {
	Integer value = map.get(key);
	if(value == null)
	    value = 0;
	map.put(key, value + amount);
    }
    
    public static <T> void subtract(HashMap<T, Integer> map, T key, int amount) {
	Integer value = map.get(key);
	if(value == null)
	    value = 0;
	map.put(key, value - amount);
    }
    
    public static void main(String[] args) throws Exception {
	System.out.println(Integer.toString(' '));
    }
}
