/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class ElicitationTool
extends JPanel {
    private Vector sentPairs;
    private Vector availableLocales;
    private String currentLocale;
    private File initfile;
    public String srcLang;
    public String tgtLang;
    JMenuItem dictMenu;
    JMenuItem dictReverseMenu;
    JMenuItem deleteAlternateMenu;
    JButton alternateAddButton;
    public int sentIndex;
    public int corpusSize;
    public int srcWordIndex;
    public int tgtWordIndex;
    public TreeSet srcWordIndices;
    public TreeSet tgtWordIndices;
    public int srcwstart;
    public int srcwend;
    public int tgtwstart;
    public int tgtwend;
    public int tmpwstart;
    public int tmpwend;
    public boolean srcReady;
    public boolean tgtReady;
    public int mode;
    public String msgfile;
    public String msgBase;
    public int msgIndex;
    final char morphdelim = (char)43;
    public Socket featureSocket;
    public PrintWriter featureOut;
    public BufferedReader featureIn;
    public String featureServer;
    public int featurePort;
    public int blockstart;
    public int blockend;
    public static final int BATCH = 0;
    public static final int INTER = 1;
    public Vector markedMatches;
    public static final int SRC = 0;
    public static final int TGT = 1;
    public static final int ADD = 0;
    public static final int DEL = 1;
    public int changeType;
    public File corpusFile;
    private boolean debug;
    private boolean interative;
    private String encoding;
    private String locale;
    private String fileencoding;
    private String homedir;
    private String lastfilename;
    private String workingdir;
    private Properties props;
    private JFrame frame;
    private JButton clearButton;
    private JButton firstButton;
    private JButton prevButton;
    private JButton nextButton;
    private JButton lastButton;
    private JLabel contextLabel;
    private JLabel sentContextLabel;
    private JLabel sourceLabel;
    private JLabel targetLabel;
    private JLabel alignmentLabel;
    private JLabel commentLabel;
    private JLabel alternateLabel;
    private JScrollBar masterBar;
    private JScrollPane srcSentScroll;
    private JScrollPane tgtSentScroll;
    private JScrollPane pairScroll;
    private boolean independentScroll;
    public JTextField sentContextField;
    public JTextField sentIndexField;
    public JTextField srcSentField;
    public JTextField tgtSentField;
    public JTextField alignField;
    public JTextField commentField;
    private final int textFieldLength = 400;
    private JComboBox changeTypeBox;
    private AlignmentIndicator alignIndicator;
    private final String textFont = "Arial Unicode MS";
    private int fontSize;
    private JFileChooser cfchooser;
    private Vector undoInfo;
    private int undoIndex;
    private boolean inUndo;
    private boolean inChange;
    private boolean dirty;
    private boolean alwaysEraseOnChange;
    private JFrame searchFrame;
    private JFrame dictFrame;
    public final HashMap srcDictionary = new HashMap();
    public final HashMap tgtDictionary = new HashMap();
    static DefaultHighlighter.DefaultHighlightPainter dhp_yellow = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
    static DefaultHighlighter.DefaultHighlightPainter dhp_green = new DefaultHighlighter.DefaultHighlightPainter(Color.green);
    static DefaultHighlighter.DefaultHighlightPainter dhp_red = new DefaultHighlighter.DefaultHighlightPainter(Color.red);

    public void ElicitationToolInit(JFrame jFrame, String string, String string2) {
        this.encoding = string2;
        this.frame = jFrame;
        this.mode = 0;
        this.srcReady = false;
        this.tgtReady = false;
        this.debug = false;
        this.dirty = false;
        if (this.debug) {
            System.out.println("In constructor\n");
        }
        this.corpusSize = 0;
        this.props = new Properties();
        this.tgtLang = "";
        this.srcLang = "";
        this.fileencoding = "UTF8";
        this.fontSize = 14;
        this.independentScroll = false;
        this.markedMatches = new Vector(6);
        this.availableLocales = new Vector(2);
        this.availableLocales.add("English");
        this.availableLocales.add("Espa\u00f1ol");
        this.currentLocale = "en";
        this.undoInfo = new Vector();
        this.alwaysEraseOnChange = false;
        this.workingdir = System.getProperty("user.home");
        this.lastfilename = null;
        this.loadInitFile();
        this.loadGUI();
        if (string.length() != 0) {
            this.corpusFile = new File(string);
            this.loadCorpus(this.corpusFile);
        }
    }

    public ElicitationTool(JFrame jFrame, String string, String string2) {
        this.ElicitationToolInit(jFrame, string, string2);
    }

    public ElicitationTool(JFrame jFrame, String string) {
        this.ElicitationToolInit(jFrame, string, "UTF8");
    }

    public ElicitationTool(JFrame jFrame) {
        this.ElicitationToolInit(jFrame, "", "UTF8");
    }

    public ElicitationTool(JFrame jFrame, String string, int n) {
        this.ElicitationToolInit(jFrame, "", "UTF8");
        this.mode = 1;
        if (this.debug) {
            System.out.println("In constructor\n");
        }
        this.sentPairs = new Vector(200);
        try {
            this.featurePort = n;
            this.featureServer = string;
            this.featureSocket = new Socket(this.featureServer, this.featurePort);
            this.featureOut = new PrintWriter(this.featureSocket.getOutputStream(), true);
            this.featureIn = new BufferedReader(new InputStreamReader(this.featureSocket.getInputStream()));
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Don't know about host: " + this.featureServer);
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't get I/O for the connection to: " + this.featureServer + ".");
            System.exit(1);
        }
        this.appendCorpusSocket();
        if (this.debug) {
            System.out.println("Running append corpus\n");
        }
    }

    public void timeStamp(String string) {
        File file = null;
        if (this.homedir == null) {
            return;
        }
        file = new File(this.homedir + "/.etlog.txt");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + "\t" + DateFormat.getTimeInstance().format(new Date()));
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void loadInitFile() {
        this.initfile = null;
        this.homedir = System.getProperty("user.home");
        if (this.homedir == null) {
            return;
        }
        this.initfile = new File(this.homedir + "/.avenue");
        if (this.initfile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.initfile);
                this.props.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.lastfilename = this.props.getProperty("History", "");
        this.workingdir = this.props.getProperty("WorkingDir", System.getProperty("user.home"));
        this.currentLocale = this.props.getProperty("CurrentLocale", "EN");
        this.independentScroll = this.props.getProperty("IndependentScroll", "false").equals("true");
        if (this.currentLocale.equalsIgnoreCase("ES")) {
            Locale.setDefault(new Locale("es", "CL"));
        } else if (this.currentLocale.equalsIgnoreCase("EN")) {
            Locale.setDefault(Locale.US);
        }
    }

    void saveInitFile() {
        this.props.setProperty("History", this.lastfilename);
        this.props.setProperty("CurrentLocale", this.currentLocale);
        this.props.setProperty("WorkingDir", this.workingdir);
        if (this.independentScroll) {
            this.props.setProperty("IndependentScroll", "true");
        } else {
            this.props.setProperty("IndependentScroll", "false");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.initfile);
            this.props.store(fileOutputStream, " Elicitation Tool properties.  Automatically generated.  Do not edit");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void changeSentence(int n) {
        SentPair sentPair = (SentPair)this.sentPairs.elementAt(this.sentIndex);
        if (!sentPair.tgtSent.equals(this.tgtSentField.getText())) {
            sentPair.tgtSent = this.tgtSentField.getText();
        }
        if (!sentPair.alignment.equals(this.alignField.getText())) {
            sentPair.alignment = this.alignField.getText();
        }
        if (!sentPair.comment.equals(this.commentField.getText())) {
            sentPair.comment = this.commentField.getText();
        }
        if ((sentPair = (SentPair)this.sentPairs.elementAt(n)) != null) {
            this.sentIndex = n;
            this.sentIndexField.setText(Integer.toString(n + 1));
            this.sentContextField.setText(sentPair.context);
            this.srcSentField.setText(sentPair.srcSent);
            this.tgtSentField.setText(sentPair.tgtSent);
            this.alignField.setText(sentPair.alignment);
            this.commentField.setText(sentPair.comment);
            if (sentPair.alternate) {
                this.alternateLabel.setText("ALT");
                this.deleteAlternateMenu.setEnabled(true);
            } else {
                this.alternateLabel.setText("    ");
                this.deleteAlternateMenu.setEnabled(false);
            }
        }
        this.tgtSentField.requestFocus();
        this.undoInfo.removeAllElements();
        this.undoIndex = 0;
        this.inUndo = false;
        this.tgtReady = false;
        this.srcReady = false;
        this.srcWordIndices.clear();
        this.tgtWordIndices.clear();
        this.markedMatches.clear();
        this.alignIndicator.update(this.alignIndicator.getGraphics());
        this.masterBar.setValue(0);
        this.srcSentScroll.getHorizontalScrollBar().setValue(0);
        this.pairScroll.getHorizontalScrollBar().setValue(0);
        this.tgtSentScroll.getHorizontalScrollBar().setValue(0);
    }

    int getWordIndex(String string, int n, int n2) {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; !Character.isLetterOrDigit(string.charAt(n3)) && n3 < n4; ++n3) {
        }
        boolean bl = true;
        n6 = n3;
        while (n3 < n4) {
            if (Character.isWhitespace(string.charAt(n3)) || string.charAt(n3) == '+' || !bl) {
                if (!Character.isWhitespace(string.charAt(n3)) && string.charAt(n3) != '+' && !bl) {
                    bl = true;
                    n6 = n3;
                } else if ((Character.isWhitespace(string.charAt(n3)) || string.charAt(n3) == '+') && bl) {
                    ++n5;
                    bl = false;
                    n7 = n3;
                    if (this.debug) {
                        System.out.println("indices " + n6 + " " + n7);
                    }
                    if (n6 == n && n7 == n2) {
                        return n5;
                    }
                }
            }
            ++n3;
        }
        if (this.debug) {
            System.out.println("indices " + n6 + " " + n7);
        }
        if (bl && n6 == n && n4 == n2) {
            return ++n5;
        }
        return -1;
    }

    int getWordIndex(String string, int n) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; Character.isWhitespace(string.charAt(n2)) && n2 < n3; ++n2) {
        }
        boolean bl = true;
        n5 = n2;
        while (n2 < n3) {
            if (Character.isWhitespace(string.charAt(n2)) || string.charAt(n2) == '+' || !bl) {
                if (!Character.isWhitespace(string.charAt(n2)) && string.charAt(n2) != '+' && !bl) {
                    bl = true;
                    n5 = n2;
                } else if ((Character.isWhitespace(string.charAt(n2)) || string.charAt(n2) == '+') && bl) {
                    ++n4;
                    bl = false;
                    n6 = n2;
                    if (this.debug) {
                        System.out.println("indices " + n5 + " " + n6);
                    }
                    if (n5 <= n && n <= n6) {
                        this.tmpwstart = n5;
                        this.tmpwend = n6;
                        return n4;
                    }
                }
            }
            ++n2;
        }
        if (this.debug) {
            System.out.println("indices " + n5 + " " + n6);
        }
        if (bl) {
            n6 = n2;
            if (n5 <= n && n <= n6) {
                this.tmpwstart = n5;
                this.tmpwend = n6;
                return ++n4;
            }
        }
        return -1;
    }

    void getOffsetsAtIndex(String string, int n, int[] nArray) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; Character.isWhitespace(string.charAt(n2)) && n2 < n3; ++n2) {
        }
        boolean bl = true;
        n5 = n2;
        while (n2 < n3) {
            if (Character.isWhitespace(string.charAt(n2)) || string.charAt(n2) == '+' || !bl) {
                if (!Character.isWhitespace(string.charAt(n2)) && string.charAt(n2) != '+' && !bl) {
                    bl = true;
                    n5 = n2;
                } else if ((Character.isWhitespace(string.charAt(n2)) || string.charAt(n2) == '+') && bl) {
                    ++n4;
                    bl = false;
                    n6 = n2;
                    if (this.debug) {
                        System.out.println("indices " + n5 + " " + n6 + " word count " + n4 + " wordindex " + n);
                    }
                    if (n4 == n) {
                        if (this.debug) {
                            System.out.println("wstart equals wend, returning " + string.substring(n5, n6));
                        }
                        nArray[0] = n5;
                        nArray[1] = n6;
                        if (this.debug) {
                            System.out.println("src starthl " + nArray[0] + " endhl " + nArray[1]);
                        }
                        return;
                    }
                }
            }
            ++n2;
        }
        if (bl) {
            n6 = n2;
            if (++n4 == n) {
                nArray[0] = n5;
                nArray[1] = n6;
                if (this.debug) {
                    System.out.println("src starthl " + nArray[0] + " endhl " + nArray[1]);
                }
                return;
            }
        }
        if (this.debug) {
            System.out.println("indices " + n5 + " " + n6 + " word count " + n4 + " wordindex " + n);
        }
        nArray[0] = 0;
        nArray[1] = 0;
        if (this.debug) {
            System.out.println("src starthl " + nArray[0] + " endhl " + nArray[1]);
        }
    }

    void showMatch(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.alignField.getText());
        String string = new String(this.alignField.getText());
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = new int[2];
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        this.tgtWordIndices.clear();
        this.srcWordIndices.clear();
        int n3 = string.lastIndexOf("(", n) + 1;
        int n4 = string.indexOf(")", n);
        int n5 = n3;
        int n6 = n3;
        while (Character.isWhitespace(string.charAt(n6))) {
            ++n6;
        }
        while (string.charAt(n6) != ',') {
            n5 = n6;
            while (Character.isDigit(string.charAt(n6))) {
                ++n6;
            }
            n2 = n6;
            vector.add(new Integer(string.substring(n5, n2)));
            while (Character.isWhitespace(string.charAt(n6))) {
                ++n6;
            }
        }
        ++n6;
        while (Character.isWhitespace(string.charAt(n6))) {
            ++n6;
        }
        while (string.charAt(n6) != ')') {
            n5 = n6;
            while (Character.isDigit(string.charAt(n6))) {
                ++n6;
            }
            n2 = n6;
            vector2.add(new Integer(string.substring(n5, n2)));
            while (Character.isWhitespace(string.charAt(n6))) {
                ++n6;
            }
        }
        try {
            int n7;
            this.markedMatches.clear();
            this.markedMatches.add(vector.get(0));
            this.markedMatches.add(vector2.get(0));
            this.markedMatches.add(Color.orange);
            this.alignIndicator.update(this.alignIndicator.getGraphics());
            this.highlightAlignments();
            this.srcSentField.getHighlighter().removeAllHighlights();
            for (n7 = 0; n7 < vector.size(); ++n7) {
                int n8 = ((Number)vector.get(n7)).intValue();
                this.getOffsetsAtIndex(this.srcSentField.getText(), n8, nArray);
                if (this.debug) {
                    System.out.println("src starthl " + nArray[0] + " endhl " + nArray[1]);
                }
                this.srcSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_yellow);
            }
            this.tgtSentField.getHighlighter().removeAllHighlights();
            for (n7 = 0; n7 < vector2.size(); ++n7) {
                int n9 = ((Number)vector2.get(n7)).intValue();
                this.getOffsetsAtIndex(this.tgtSentField.getText(), n9, nArray);
                if (this.debug) {
                    System.out.println("tgt starthl " + nArray[0] + " endhl " + nArray[1]);
                }
                this.tgtSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_yellow);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException.toString());
        }
    }

    void showMatches(int n, int n2) {
        Vector[] vectorArray = null;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        Integer n6 = new Integer(n2);
        int[] nArray = new int[2];
        this.markedMatches.clear();
        vectorArray = this.parseAlignments(this.alignField.getText());
        this.srcSentField.getHighlighter().removeAllHighlights();
        this.tgtSentField.getHighlighter().removeAllHighlights();
        for (n3 = 0; vectorArray != null && n3 < vectorArray.length; n3 += 2) {
            try {
                int n7;
                if (n == 1 && vectorArray[n3 + 1].contains(n6)) {
                    for (n7 = 0; n7 < vectorArray[n3].size(); ++n7) {
                        n4 = (Integer)vectorArray[n3].get(n7);
                        this.getOffsetsAtIndex(this.srcSentField.getText(), n4, nArray);
                        if (this.debug) {
                            System.out.println("src starthl " + nArray[0] + " endhl " + nArray[1]);
                        }
                        this.srcSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_yellow);
                    }
                    for (n7 = 0; n7 < vectorArray[n3 + 1].size(); ++n7) {
                        n5 = (Integer)vectorArray[n3 + 1].get(n7);
                        this.getOffsetsAtIndex(this.tgtSentField.getText(), n5, nArray);
                        if (this.debug) {
                            System.out.println("tgt starthl " + nArray[0] + " endhl " + nArray[1]);
                        }
                        this.tgtSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_yellow);
                    }
                    this.markedMatches.add((Integer)vectorArray[n3].get(0));
                    this.markedMatches.add((Integer)vectorArray[n3 + 1].get(0));
                    this.markedMatches.add(Color.orange);
                }
                if (n != 0 || !vectorArray[n3].contains(n6)) continue;
                for (n7 = 0; n7 < vectorArray[n3 + 1].size(); ++n7) {
                    n5 = (Integer)vectorArray[n3 + 1].get(n7);
                    this.getOffsetsAtIndex(this.tgtSentField.getText(), n5, nArray);
                    if (this.debug) {
                        System.out.println("tgt starthl " + nArray[0] + " endhl " + nArray[1]);
                    }
                    this.tgtSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_yellow);
                }
                for (n7 = 0; n7 < vectorArray[n3].size(); ++n7) {
                    n4 = (Integer)vectorArray[n3].get(n7);
                    this.getOffsetsAtIndex(this.srcSentField.getText(), n4, nArray);
                    if (this.debug) {
                        System.out.println("src starthl " + nArray[0] + " endhl " + nArray[1]);
                    }
                    this.srcSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_yellow);
                }
                this.markedMatches.add((Integer)vectorArray[n3].get(0));
                this.markedMatches.add((Integer)vectorArray[n3 + 1].get(0));
                this.markedMatches.add(Color.orange);
                continue;
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException.toString());
            }
        }
        this.alignIndicator.update(this.alignIndicator.getGraphics());
        this.highlightAlignments();
    }

    boolean delMatch(int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(this.alignField.getText());
        String string = new String(this.alignField.getText());
        String string2 = "";
        Integer n4 = new Integer(n);
        Integer n5 = new Integer(n2);
        if (this.debug) {
            System.out.println("Try to delete " + string2);
        }
        Vector[] vectorArray = this.parseAlignments(string);
        for (n3 = 0; vectorArray != null && n3 < vectorArray.length; n3 += 2) {
            int n6;
            if (!vectorArray[n3].contains(n4) || !vectorArray[n3 + 1].contains(n5)) continue;
            string2 = "(";
            Vector vector = vectorArray[n3];
            for (n6 = 0; n6 < vector.size(); ++n6) {
                string2 = string2 + (Integer)vector.get(n6);
                if (n6 + 1 >= vector.size()) continue;
                string2 = string2 + " ";
            }
            string2 = string2 + ",";
            Vector vector2 = vectorArray[n3 + 1];
            for (n6 = 0; n6 < vector2.size(); ++n6) {
                string2 = string2 + (Integer)vector2.get(n6);
                if (n6 + 1 >= vector2.size()) continue;
                string2 = string2 + " ";
            }
            int n7 = string.indexOf(string2 = string2 + ")");
            if (n7 == -1) continue;
            int n8 = n7 + string2.length();
            if (string.charAt(n8) == ',') {
                ++n8;
                while (Character.isWhitespace(string.charAt(n8))) {
                    ++n8;
                }
            } else if (string.charAt(n8) == ')') {
                if (Character.isWhitespace(string.charAt(n7 - 1))) {
                    while (Character.isWhitespace(string.charAt(n7 - 1))) {
                        --n7;
                    }
                }
                if (string.charAt(n7 - 1) == ',') {
                    --n7;
                }
            }
            stringBuffer.delete(n7, n8);
            string = stringBuffer.toString();
            break;
        }
        this.alignField.setText(stringBuffer.toString());
        this.markedMatches.clear();
        this.alignIndicator.update(this.alignIndicator.getGraphics());
        this.highlightAlignments();
        this.dirty = true;
        this.srcWordIndices.clear();
        this.tgtWordIndices.clear();
        if (!this.inUndo) {
            for (int i = 0; i < this.undoIndex; ++i) {
                this.undoInfo.removeElementAt(0);
            }
            this.undoInfo.add(0, new ActionInfo(1, new TreeSet(vectorArray[n3]), new TreeSet(vectorArray[n3 + 1])));
            this.undoIndex = 0;
        }
        return true;
    }

    Vector[] parseAlignments(String string) {
        Vector[] vectorArray = null;
        if (!string.equals("()")) {
            int n = 0;
            int n2 = 1;
            while ((n2 = string.indexOf(40, n2)) != -1) {
                ++n2;
                ++n;
            }
            vectorArray = new Vector[n * 2];
            int n3 = string.length();
            int n4 = 2;
            int n5 = 2;
            int n6 = 0;
            for (int i = 0; i < n * 2; ++i) {
                vectorArray[i] = new Vector();
            }
            while (n4 < n3 - 1) {
                int n7;
                while (Character.isWhitespace(string.charAt(n4))) {
                    ++n4;
                }
                while (string.charAt(n4) != ',') {
                    n5 = n4;
                    while (Character.isDigit(string.charAt(n4))) {
                        ++n4;
                    }
                    n7 = n4;
                    vectorArray[n6].add(new Integer(string.substring(n5, n7)));
                    while (Character.isWhitespace(string.charAt(n4))) {
                        ++n4;
                    }
                }
                ++n6;
                ++n4;
                while (Character.isWhitespace(string.charAt(n4))) {
                    ++n4;
                }
                while (string.charAt(n4) != ')') {
                    n5 = n4;
                    while (Character.isDigit(string.charAt(n4))) {
                        ++n4;
                    }
                    n7 = n4;
                    vectorArray[n6].add(new Integer(string.substring(n5, n7)));
                    while (Character.isWhitespace(string.charAt(n4))) {
                        ++n4;
                    }
                }
                ++n6;
                ++n4;
                while (Character.isWhitespace(string.charAt(n4))) {
                    ++n4;
                }
                if (string.charAt(n4) == ',') {
                    ++n4;
                }
                while (n4 < n3 && Character.isWhitespace(string.charAt(n4))) {
                    ++n4;
                }
                if (n4 >= n3 || string.charAt(n4) != '(') continue;
                ++n4;
            }
        }
        return vectorArray;
    }

    void highlightAlignments() {
        Vector[] vectorArray = null;
        String string = this.alignField.getText();
        this.alignField.getHighlighter().removeAllHighlights();
        if (!string.equals("()") && !string.equals("")) {
            int n;
            int n2 = 0;
            int n3 = 1;
            while ((n3 = string.indexOf(40, n3)) != -1) {
                ++n3;
                ++n2;
            }
            vectorArray = new Vector[n2 * 2];
            int n4 = string.length();
            int n5 = 2;
            int n6 = 2;
            int n7 = 0;
            for (n = 0; n < n2 * 2; ++n) {
                vectorArray[n] = new Vector();
            }
            while (n5 < n4 - 1) {
                int n8;
                while (Character.isWhitespace(string.charAt(n5))) {
                    ++n5;
                }
                int n9 = n5;
                while (string.charAt(n5) != ',') {
                    n6 = n5;
                    while (Character.isDigit(string.charAt(n5))) {
                        ++n5;
                    }
                    n8 = n5;
                    vectorArray[n7].add(new Integer(string.substring(n6, n8)));
                    while (Character.isWhitespace(string.charAt(n5))) {
                        ++n5;
                    }
                }
                ++n7;
                ++n5;
                while (Character.isWhitespace(string.charAt(n5))) {
                    ++n5;
                }
                while (string.charAt(n5) != ')') {
                    n6 = n5;
                    while (Character.isDigit(string.charAt(n5))) {
                        ++n5;
                    }
                    n8 = n5;
                    vectorArray[n7].add(new Integer(string.substring(n6, n8)));
                    while (Character.isWhitespace(string.charAt(n5))) {
                        ++n5;
                    }
                }
                ++n7;
                int n10 = n5;
                for (n = 0; n < this.markedMatches.size(); n += 3) {
                    Integer n11 = (Integer)vectorArray[n7 - 2].firstElement();
                    Integer n12 = (Integer)vectorArray[n7 - 1].firstElement();
                    if (((Integer)this.markedMatches.elementAt(n)).intValue() != n11.intValue() || ((Integer)this.markedMatches.elementAt(n + 1)).intValue() != n12.intValue()) continue;
                    try {
                        if ((Color)this.markedMatches.elementAt(n + 2) == Color.green) {
                            this.alignField.getHighlighter().addHighlight(n9, n10, dhp_green);
                            break;
                        }
                        this.alignField.getHighlighter().addHighlight(n9, n10, dhp_yellow);
                    }
                    catch (BadLocationException badLocationException) {}
                    break;
                }
                ++n5;
                while (Character.isWhitespace(string.charAt(n5))) {
                    ++n5;
                }
                if (string.charAt(n5) == ',') {
                    ++n5;
                }
                while (n5 < n4 && Character.isWhitespace(string.charAt(n5))) {
                    ++n5;
                }
                if (n5 >= n4 || string.charAt(n5) != '(') continue;
                ++n5;
            }
        }
    }

    void undo() {
        if (this.undoInfo.size() == 0) {
            return;
        }
        if (this.undoIndex >= this.undoInfo.size()) {
            return;
        }
        ActionInfo actionInfo = (ActionInfo)this.undoInfo.get(this.undoIndex);
        this.srcReady = false;
        this.tgtReady = false;
        this.srcWordIndices.clear();
        this.tgtWordIndices.clear();
        this.srcWordIndex = -1;
        this.tgtWordIndex = -1;
        this.srcSentField.getHighlighter().removeAllHighlights();
        this.tgtSentField.getHighlighter().removeAllHighlights();
        this.inUndo = true;
        if (actionInfo.actionType == 0) {
            this.delMatch((Integer)actionInfo.actionSrc.first(), (Integer)actionInfo.actionTgt.first());
        } else {
            this.addMatch(actionInfo.actionSrc, actionInfo.actionTgt);
        }
        this.inUndo = false;
        ++this.undoIndex;
    }

    void redo() {
        if (this.undoInfo.size() == 0) {
            return;
        }
        if (this.undoIndex == 0) {
            return;
        }
        this.srcReady = false;
        this.tgtReady = false;
        this.srcWordIndices.clear();
        this.tgtWordIndices.clear();
        this.srcWordIndex = -1;
        this.tgtWordIndex = -1;
        this.srcSentField.getHighlighter().removeAllHighlights();
        this.tgtSentField.getHighlighter().removeAllHighlights();
        --this.undoIndex;
        ActionInfo actionInfo = (ActionInfo)this.undoInfo.get(this.undoIndex);
        this.inUndo = true;
        if (actionInfo.actionType == 1) {
            this.delMatch((Integer)actionInfo.actionSrc.first(), (Integer)actionInfo.actionTgt.first());
        } else {
            this.addMatch(actionInfo.actionSrc, actionInfo.actionTgt);
        }
        this.inUndo = false;
    }

    boolean addMatch(TreeSet treeSet, TreeSet treeSet2) {
        int n;
        StringBuffer stringBuffer;
        String string = new String(this.alignField.getText());
        String string2 = "(";
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            string2 = string2 + iterator.next();
            if (!iterator.hasNext()) continue;
            string2 = string2 + " ";
        }
        string2 = string2 + ",";
        iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            string2 = string2 + iterator.next();
            if (!iterator.hasNext()) continue;
            string2 = string2 + " ";
        }
        string2 = string2 + ")";
        if (treeSet.isEmpty() || treeSet2.isEmpty()) {
            return false;
        }
        if (this.debug) {
            System.out.println("Try to add " + string2);
        }
        if (string.indexOf(string2) != -1) {
            System.out.println(string2 + " already in alignment list.");
            return false;
        }
        if (string.equals("()")) {
            stringBuffer = new StringBuffer(this.alignField.getText());
            stringBuffer.insert(1, string2);
        } else {
            Vector[] vectorArray = this.parseAlignments(string);
            stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            n = 0;
            Integer n2 = (Integer)treeSet.first();
            int n3 = n2;
            Integer n4 = (Integer)treeSet2.first();
            int n5 = n4;
            for (int i = 0; vectorArray != null && i < vectorArray.length; i += 2) {
                int n6;
                String string3 = "(";
                Vector vector = vectorArray[i];
                for (n6 = 0; n6 < vector.size(); ++n6) {
                    string3 = string3 + (Integer)vector.get(n6);
                    if (n6 + 1 >= vector.size()) continue;
                    string3 = string3 + " ";
                }
                string3 = string3 + ",";
                Vector vector2 = vectorArray[i + 1];
                for (n6 = 0; n6 < vector2.size(); ++n6) {
                    string3 = string3 + (Integer)vector2.get(n6);
                    if (n6 + 1 >= vector2.size()) continue;
                    string3 = string3 + " ";
                }
                string3 = string3 + ")";
                int n7 = (Integer)vector.get(0);
                int n8 = (Integer)vector2.get(0);
                if (i == 0 && n3 < n7) {
                    if (this.debug) {
                        System.out.println("Add at Beginning");
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append(",");
                    stringBuffer.append(string3);
                    n = 1;
                } else if (n3 == n7 && n5 < n8 && n == 0) {
                    if (this.debug) {
                        System.out.println("Add on target");
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append(",");
                    stringBuffer.append(string3);
                    n = 1;
                } else if (n3 >= n7 && i + 2 < vectorArray.length && n3 < (Integer)vectorArray[i + 2].get(0) && n == 0) {
                    if (this.debug) {
                        System.out.println("Add after src");
                    }
                    stringBuffer.append(string3);
                    stringBuffer.append(",");
                    n = 1;
                    stringBuffer.append(string2);
                } else if ((n3 > n7 || n3 == n7 && n5 > n8) && i + 2 == vectorArray.length && n == 0) {
                    if (this.debug) {
                        System.out.println("Add after src2");
                    }
                    stringBuffer.append(string3);
                    stringBuffer.append(",");
                    n = 1;
                    stringBuffer.append(string2);
                } else {
                    if (this.debug) {
                        System.out.println("Add default");
                    }
                    stringBuffer.append(string3);
                }
                if (i + 2 >= vectorArray.length) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
        }
        this.alignField.setText(stringBuffer.toString());
        this.alignIndicator.update(this.alignIndicator.getGraphics());
        this.highlightAlignments();
        if (!this.inUndo) {
            for (n = 0; n < this.undoIndex; ++n) {
                this.undoInfo.removeElementAt(0);
            }
            this.undoInfo.add(0, new ActionInfo(0, (TreeSet)treeSet.clone(), (TreeSet)treeSet2.clone()));
            this.undoIndex = 0;
        }
        this.dirty = true;
        this.srcWordIndices.clear();
        this.tgtWordIndices.clear();
        return true;
    }

    void exchangeSents() {
        String string = this.msgBase + "Tgt" + this.msgIndex + ".txt";
        File file = new File(string);
        this.saveCorpus(file, this.blockstart, this.blockend);
        ++this.msgIndex;
        String string2 = this.msgBase + "Src" + this.msgIndex + ".txt";
        File file2 = new File(string2);
        while (!file2.exists()) {
        }
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
            }
        }
        this.appendCorpus(file2);
    }

    void saveCorpusSocket() {
        int n = 0;
        this.changeSentence(this.sentIndex);
        if (this.debug) {
            System.out.println("Sending alignments to feature detector from " + this.blockstart + " to " + this.blockend);
        }
        try {
            for (n = this.blockstart; n < this.blockend; ++n) {
                SentPair sentPair = (SentPair)this.sentPairs.elementAt(n);
                this.featureOut.println("newpair");
                this.featureOut.println("srcsent: " + sentPair.srcSent);
                this.featureOut.println("tgtsent: " + sentPair.tgtSent);
                this.featureOut.println("aligned: " + sentPair.alignment);
                this.featureOut.println("context: " + sentPair.context);
                this.featureOut.println("comment: " + sentPair.comment);
                this.featureOut.println();
            }
            this.featureOut.println();
            this.featureOut.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.debug) {
            System.out.println("New sentences sent to server.");
        }
    }

    void exchangeSentsServer() {
        this.saveCorpusSocket();
        this.appendCorpusSocket();
    }

    void startInteractive() {
        int n = 25000;
        String string = "2500";
        String string2 = "temuco";
        this.sentPairs = new Vector(200);
        string2 = JOptionPane.showInputDialog("Server Name");
        if (string2 == null) {
            return;
        }
        this.props.setProperty("FeatureServer", string2);
        string = JOptionPane.showInputDialog("Server Port Number");
        if (string == null) {
            return;
        }
        n = Integer.parseInt(string);
        this.props.setProperty("FeaturePort", string);
        try {
            this.featurePort = n;
            this.featureServer = string2;
            this.featureSocket = new Socket(this.featureServer, this.featurePort);
            this.featureOut = new PrintWriter(this.featureSocket.getOutputStream(), true);
            this.featureIn = new BufferedReader(new InputStreamReader(this.featureSocket.getInputStream()));
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(null, "Don't know about host: " + this.featureServer, "Server not found", 2);
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Couldn't get I/O for the connection to: " + this.featureServer + ".", "No Connection", 2);
            return;
        }
        this.appendCorpusSocket();
        this.mode = 1;
        this.alternateAddButton.setEnabled(false);
    }

    String getWordAtIndex(String string, int n) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; Character.isWhitespace(string.charAt(n2)) && n2 < n3; ++n2) {
        }
        boolean bl = true;
        n5 = n2;
        while (n2 < n3) {
            if (Character.isWhitespace(string.charAt(n2)) || string.charAt(n2) == '+' || !bl) {
                if (!Character.isWhitespace(string.charAt(n2)) && string.charAt(n2) != '+' && !bl) {
                    bl = true;
                    n5 = n2;
                } else if ((Character.isWhitespace(string.charAt(n2)) || string.charAt(n2) == '+') && bl) {
                    ++n4;
                    bl = false;
                    n6 = n2;
                    if (this.debug) {
                        System.out.println("indices " + n5 + " " + n6 + " word count " + n4 + " wordindex " + n);
                    }
                    if (n4 == n) {
                        if (this.debug) {
                            System.out.println("wstart equals wend, returning " + string.substring(n5, n6));
                        }
                        return string.substring(n5, n6);
                    }
                }
            }
            ++n2;
        }
        if (this.debug) {
            System.out.println("indices " + n5 + " " + n6);
        }
        if (bl) {
            n6 = n2;
            if (++n4 == n) {
                return string.substring(n5, n6);
            }
        }
        return "";
    }

    String getAlignedWordSrcTgt(String string, String string2, int n) {
        String string3 = "(" + n + ",";
        StringBuffer stringBuffer = new StringBuffer();
        if (this.debug) {
            System.out.println("Look for src index " + string3);
        }
        int n2 = 0;
        while ((n2 = string2.indexOf(string3, n2)) != -1) {
            int n3 = n2 + string3.length();
            while (Character.isWhitespace(string2.charAt(n3))) {
                ++n3;
            }
            n2 = n3;
            while (Character.isDigit(string2.charAt(n3))) {
                ++n3;
            }
            int n4 = Integer.parseInt(string2.substring(n2, n3));
            stringBuffer.append(this.getWordAtIndex(string, n4).toLowerCase() + " ");
        }
        return stringBuffer.toString();
    }

    String getAlignedWordTgtSrc(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "," + n + ")";
        if (this.debug) {
            System.out.println("Look for tgt index " + string3);
        }
        int n2 = string.length();
        while ((n2 = string2.lastIndexOf(string3, n2)) != -1) {
            int n3 = n2--;
            while (Character.isDigit(string2.charAt(n3))) {
                --n2;
            }
            int n4 = Integer.parseInt(string2.substring(n2, n3));
            stringBuffer.append(this.getWordAtIndex(string, n4).toLowerCase() + " ");
        }
        return stringBuffer.toString();
    }

    Vector tokenizeWords(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        boolean bl = true;
        n4 = n;
        while (n < n2) {
            if (Character.isWhitespace(string.charAt(n)) || string.charAt(n) == '+' || !bl) {
                if (!Character.isWhitespace(string.charAt(n)) && string.charAt(n) != '+' && !bl) {
                    bl = true;
                    n4 = n;
                } else if ((Character.isWhitespace(string.charAt(n)) || string.charAt(n) == '+') && bl) {
                    ++n3;
                    bl = false;
                    n5 = n;
                    if (this.debug) {
                        System.out.println("indices " + n4 + " " + n5);
                    }
                    vector.add(string.substring(n4, n5));
                }
            }
            ++n;
        }
        if (this.debug) {
            System.out.println("indices " + n4 + " " + n5);
        }
        if (bl) {
            n5 = n;
            ++n3;
            vector.add(string.substring(n4, n5));
        }
        return vector;
    }

    void showHelp() {
        Object object;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        JEditorPane jEditorPane = null;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
        try {
            string = resourceBundle.getString("help.file");
        }
        catch (MissingResourceException missingResourceException) {
            string = "help.html";
        }
        try {
            String string2;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            object = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                stringBuffer.append(string2);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        jEditorPane = new JEditorPane("text/html", stringBuffer.toString());
        jEditorPane.setEditable(false);
        object = new JScrollPane(jEditorPane);
        JFrame jFrame = new JFrame("Help");
        String string3 = "align.gif";
        URL uRL = this.getClass().getResource("align.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        jFrame.setIconImage(imageIcon.getImage());
        jFrame.getContentPane().add("Center", (Component)object);
        jFrame.pack();
        jFrame.setSize(new Dimension(500, 570));
        jFrame.show();
        ((JScrollPane)object).getVerticalScrollBar().setValue(0);
        jEditorPane.setCaretPosition(0);
    }

    int buildDictionary(int n) {
        Vector vector = null;
        Vector vector2 = null;
        HashMap hashMap = null;
        hashMap = n == 0 ? this.srcDictionary : this.tgtDictionary;
        hashMap.clear();
        for (int i = 0; i < this.sentPairs.size(); ++i) {
            SentPair sentPair = (SentPair)this.sentPairs.elementAt(i);
            if (sentPair == null) continue;
            vector = this.tokenizeWords(sentPair.srcSent);
            vector2 = this.tokenizeWords(sentPair.tgtSent);
            Vector[] vectorArray = this.parseAlignments(sentPair.alignment);
            if (vector == null || vector2 == null || vectorArray == null) continue;
            if (this.debug) {
                System.out.println("Sentpair " + i + " match total " + vectorArray.length + " " + vector.size() + " " + vector2.size());
            }
            for (int j = 0; vectorArray != null && j < vectorArray.length && vectorArray[j].size() != 0 && vectorArray[j + 1].size() != 0; j += 2) {
                TreeSet treeSet;
                String string;
                int n2;
                String string2;
                if (n == 0) {
                    string2 = "";
                    for (n2 = 0; n2 < vectorArray[j].size() && (Integer)vectorArray[j].get(n2) > 0 && (Integer)vectorArray[j].get(n2) <= vector.size(); ++n2) {
                        string2 = string2 + ((String)vector.elementAt((Integer)vectorArray[j].get(n2) - 1)).toLowerCase();
                        if (n2 + 1 >= vectorArray[j].size()) continue;
                        string2 = string2 + " ";
                    }
                    string = "";
                    for (n2 = 0; n2 < vectorArray[j + 1].size() && (Integer)vectorArray[j + 1].get(n2) > 0 && (Integer)vectorArray[j + 1].get(n2) <= vector2.size(); ++n2) {
                        string = string + ((String)vector2.elementAt((Integer)vectorArray[j + 1].get(n2) - 1)).toLowerCase();
                        if (n2 + 1 >= vectorArray[j + 1].size()) continue;
                        string = string + " ";
                    }
                } else {
                    string = "";
                    for (n2 = 0; n2 < vectorArray[j].size() && (Integer)vectorArray[j].get(n2) > 0 && (Integer)vectorArray[j].get(n2) <= vector.size(); ++n2) {
                        string = string + ((String)vector.elementAt((Integer)vectorArray[j].get(n2) - 1)).toLowerCase();
                        if (n2 + 1 >= vectorArray[j].size()) continue;
                        string = string + " ";
                    }
                    string2 = "";
                    for (n2 = 0; n2 < vectorArray[j + 1].size() && (Integer)vectorArray[j + 1].get(n2) > 0 && (Integer)vectorArray[j + 1].get(n2) <= vector2.size(); ++n2) {
                        string2 = string2 + ((String)vector2.elementAt((Integer)vectorArray[j + 1].get(n2) - 1)).toLowerCase();
                        if (n2 + 1 >= vectorArray[j + 1].size()) continue;
                        string2 = string2 + " ";
                    }
                }
                try {
                    if (this.debug) {
                        System.out.println("Adding (" + vectorArray[j] + "," + vectorArray[j + 1] + ") head " + string2 + " def " + new String(string.getBytes("UTF8")));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println(unsupportedEncodingException.toString());
                }
                if (string2.length() == 0) continue;
                if (hashMap.containsKey(string2)) {
                    treeSet = (TreeSet)hashMap.get(string2);
                    treeSet.add(string);
                    continue;
                }
                treeSet = new TreeSet();
                treeSet.add(string);
                hashMap.put(string2, treeSet);
            }
        }
        return hashMap.size();
    }

    void showDictionary(final int n) {
        Object object;
        HashMap hashMap = null;
        Vector vector = new Vector();
        Vector<String> vector2 = null;
        this.changeSentence(this.sentIndex);
        this.buildDictionary(n);
        hashMap = n == 0 ? this.srcDictionary : this.tgtDictionary;
        Iterator iterator = new TreeSet(hashMap.keySet()).iterator();
        Iterator iterator2 = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (TreeSet)hashMap.get(string);
            iterator2 = ((TreeSet)object).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                vector2 = new Vector<String>();
                if (n2 == 0) {
                    vector2.add(string);
                } else {
                    vector2.add(" ");
                }
                vector2.add(string2);
                vector.add(vector2);
                ++n2;
            }
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
        Vector<Object> vector3 = new Vector<Object>(2);
        try {
            object = resourceBundle.getString("labels.word");
        }
        catch (MissingResourceException missingResourceException) {
            object = "Word";
        }
        vector3.add(object);
        try {
            object = resourceBundle.getString("labels.def");
        }
        catch (MissingResourceException missingResourceException) {
            object = "Definition";
        }
        vector3.add(object);
        JTable jTable = new JTable(vector, vector3);
        jTable.setFont(new Font("Arial Unicode MS", 0, 16));
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 550));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        try {
            object = resourceBundle.getString("labels.dictionary");
        }
        catch (MissingResourceException missingResourceException) {
            object = "Glossary";
        }
        object = n == 0 ? (String)object + ":  " + this.srcLang + " - " + this.tgtLang : (String)object + ":  " + this.tgtLang + " - " + this.srcLang;
        this.dictFrame = new JFrame((String)object);
        String string = "align.gif";
        URL uRL = this.getClass().getResource("align.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.dictFrame.setIconImage(imageIcon.getImage());
        try {
            object = resourceBundle.getString("menus.file");
        }
        catch (MissingResourceException missingResourceException) {
            object = "File";
        }
        JMenu jMenu = new JMenu((String)object);
        try {
            object = resourceBundle.getString("menus.save");
        }
        catch (MissingResourceException missingResourceException) {
            object = "Save";
        }
        JMenuItem jMenuItem = new JMenuItem((String)object);
        jMenu.add(jMenuItem);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.saveDictionary(n);
            }
        };
        jMenuItem.addActionListener(actionListener);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenuItem);
        this.dictFrame.setJMenuBar(jMenuBar);
        this.dictFrame.getContentPane().add("Center", jScrollPane);
        this.dictFrame.pack();
        this.dictFrame.setSize(new Dimension(500, 570));
        this.dictFrame.show();
    }

    void saveDictionary(int n) {
        HashMap hashMap = null;
        Vector vector = new Vector();
        Object var7_4 = null;
        this.changeSentence(this.sentIndex);
        this.buildDictionary(n);
        hashMap = n == 0 ? this.srcDictionary : this.tgtDictionary;
        Iterator iterator = new TreeSet(hashMap.keySet()).iterator();
        Iterator iterator2 = null;
        String string = null;
        string = n == 0 ? this.srcLang + "-" + this.tgtLang + ".gloss" : this.tgtLang + "-" + this.srcLang + ".gloss";
        System.out.println("Saving " + string + " with " + this.fileencoding);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(this.workingdir));
        jFileChooser.setSelectedFile(new File(string));
        int n2 = jFileChooser.showSaveDialog(this.frame);
        if (n2 != 0) {
            return;
        }
        string = jFileChooser.getSelectedFile().getAbsolutePath();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.fileencoding));
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                TreeSet treeSet = (TreeSet)hashMap.get(string2);
                iterator2 = treeSet.iterator();
                System.out.println(string2);
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    System.out.println("\t" + string3);
                    bufferedWriter.write("\t" + string3);
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    int autoAlign() {
        String string = this.srcSentField.getText();
        String string2 = this.tgtSentField.getText();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        int n = 0;
        Vector vector = this.tokenizeWords(string);
        Vector vector2 = this.tokenizeWords(string2);
        this.buildDictionary(0);
        block0: for (int i = 0; i < vector.size(); ++i) {
            int n2;
            TreeSet treeSet3;
            if (this.debug) {
                System.out.println("Looking up " + vector.elementAt(i));
            }
            if ((treeSet3 = (TreeSet)this.srcDictionary.get(((String)vector.elementAt(i)).toLowerCase())) == null) {
                if (!this.debug) continue;
                System.out.println("No definitions for " + vector.elementAt(i));
                continue;
            }
            if (treeSet3.size() != 1) {
                if (!this.debug) continue;
                System.out.println("Multiple definitions for " + vector.elementAt(i));
                continue;
            }
            if (this.debug) {
                System.out.println("Found " + treeSet3.size() + " definitions for " + vector.elementAt(i));
            }
            boolean bl = false;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (i == n2 || !((String)vector.elementAt(i)).equalsIgnoreCase((String)vector.elementAt(n2))) continue;
                bl = true;
            }
            if (bl) break;
            for (int j = 0; j < vector2.size(); ++j) {
                if (!treeSet3.contains(((String)vector2.elementAt(j)).toLowerCase())) continue;
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    if (j == n2 || !((String)vector2.elementAt(j)).equalsIgnoreCase((String)vector2.elementAt(n2))) continue;
                    bl = true;
                }
                if (bl) continue block0;
                if (this.debug) {
                    System.out.println("Adding match " + i + " " + j);
                }
                treeSet.clear();
                treeSet2.clear();
                treeSet.add(new Integer(i + 1));
                treeSet2.add(new Integer(j + 1));
                if (!this.addMatch(treeSet, treeSet2)) continue;
                ++n;
            }
        }
        this.debug = false;
        return n;
    }

    int conductSearch(String string, int n, JTable jTable) {
        int n2;
        Object var9_4 = null;
        for (n2 = 0; n2 < 100; ++n2) {
            jTable.setValueAt("", n2, 0);
            jTable.setValueAt("", n2, 1);
            jTable.setValueAt("", n2, 2);
        }
        jTable.setValueAt("Searching...", 0, 0);
        int n3 = this.sentPairs.size();
        int n4 = 0;
        if (n == 0) {
            for (n2 = 0; n2 < n3 && n4 < 100; ++n2) {
                SentPair sentPair = (SentPair)this.sentPairs.elementAt(n2);
                int n5 = sentPair.srcSent.toUpperCase().indexOf(string.toUpperCase());
                if (n5 == -1) continue;
                int n6 = this.getWordIndex(sentPair.srcSent, n5);
                jTable.setValueAt(this.getWordAtIndex(sentPair.srcSent, n6), n4, 0);
                jTable.setValueAt(this.getAlignedWordSrcTgt(sentPair.tgtSent, sentPair.alignment, n6), n4, 1);
                jTable.setValueAt(Integer.toString(n2 + 1), n4, 2);
                ++n4;
            }
        } else if (n == 1) {
            for (n2 = 0; n2 < n3 && n4 < 100; ++n2) {
                SentPair sentPair = (SentPair)this.sentPairs.elementAt(n2);
                int n7 = sentPair.tgtSent.toUpperCase().indexOf(string.toUpperCase());
                if (n7 == -1) continue;
                int n8 = this.getWordIndex(sentPair.tgtSent, n7);
                jTable.setValueAt(this.getWordAtIndex(sentPair.tgtSent, n8), n4, 0);
                jTable.setValueAt(this.getAlignedWordTgtSrc(sentPair.srcSent, sentPair.alignment, n8), n4, 1);
                jTable.setValueAt(Integer.toString(n2 + 1), n4, 2);
                ++n4;
            }
        } else if (n == 2) {
            for (n2 = 0; n2 < n3 && n4 < 100; ++n2) {
                SentPair sentPair = (SentPair)this.sentPairs.elementAt(n2);
                int n9 = sentPair.comment.toUpperCase().indexOf(string.toUpperCase());
                if (n9 == -1) continue;
                int n10 = this.getWordIndex(sentPair.comment, n9);
                jTable.setValueAt(string, n4, 0);
                jTable.setValueAt(Integer.toString(n2 + 1), n4, 2);
                ++n4;
            }
        }
        if (n4 == 0) {
            jTable.setValueAt("Nothing found.", 0, 0);
        }
        return 0;
    }

    int searchCorpus() {
        String string;
        Vector vector = new Vector();
        if (this.srcLang == null) {
            if (this.debug) {
                System.out.println("Src lang is null, returning.");
            }
            return 0;
        }
        for (int i = 0; i < 100; ++i) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(" ");
            vector2.add(" ");
            vector2.add(" ");
            vector.add(vector2);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
        Vector<String> vector3 = new Vector<String>();
        try {
            string = resourceBundle.getString("labels.word");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Word";
        }
        vector3.add(string);
        try {
            string = resourceBundle.getString("labels.alignedword");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Aligned Word";
        }
        vector3.add(string);
        try {
            string = resourceBundle.getString("labels.sentindex");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Sentence Index";
        }
        vector3.add(string);
        try {
            string = resourceBundle.getString("labels.searchcorpus");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Search the Corpus";
        }
        this.searchFrame = new JFrame(string);
        String string2 = "align.gif";
        URL uRL = this.getClass().getResource("align.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.searchFrame.setIconImage(imageIcon.getImage());
        JPanel jPanel = new JPanel();
        try {
            string = resourceBundle.getString("labels.searchfor");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Search for";
        }
        jPanel.add(new JLabel(string + ": "));
        final JTextField jTextField = new JTextField(15);
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.srcLang);
        jComboBox.addItem(this.tgtLang);
        try {
            string = resourceBundle.getString("labels.comment");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Comment";
        }
        jComboBox.addItem(string);
        if (this.srcSentField.getSelectedText() != null) {
            jTextField.setText(this.srcSentField.getSelectedText().toLowerCase());
            jComboBox.setSelectedIndex(0);
        } else if (this.tgtSentField.getSelectedText() != null) {
            jTextField.setText(this.tgtSentField.getSelectedText().toLowerCase());
            jComboBox.setSelectedIndex(1);
        } else if (this.commentField.getSelectedText() != null) {
            jTextField.setText(this.commentField.getSelectedText().toLowerCase());
            jComboBox.setSelectedIndex(2);
        }
        JPanel jPanel2 = new JPanel();
        final JTable jTable = new JTable(vector, vector3);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 300));
        jTable.setSelectionMode(0);
        jTable.setFont(new Font("Arial Unicode MS", 0, 16));
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                String string;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty() && (string = (String)jTable.getValueAt(n = listSelectionModel.getMinSelectionIndex(), 2)).length() != 0) {
                    int n2 = Integer.parseInt(string) - 1;
                    ElicitationTool.this.changeSentence(n2);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTable);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ElicitationTool.this.debug) {
                    System.out.println("Searching for " + jTextField.getText());
                }
                ElicitationTool.this.conductSearch(jTextField.getText(), jComboBox.getSelectedIndex(), jTable);
            }
        };
        jTextField.addActionListener(actionListener);
        jPanel.add(jTextField);
        try {
            string = resourceBundle.getString("labels.lang");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Language";
        }
        jPanel.add(new JLabel(string + ": "));
        jPanel.add(jComboBox);
        try {
            string = resourceBundle.getString("menus.search");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Search";
        }
        JButton jButton = new JButton(string);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.conductSearch(jTextField.getText(), jComboBox.getSelectedIndex(), jTable);
            }
        };
        jButton.addActionListener(actionListener2);
        jPanel.add(jButton);
        jPanel2.add(jScrollPane);
        this.searchFrame.getContentPane().add("North", jPanel);
        this.searchFrame.getContentPane().add("South", jPanel2);
        this.searchFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ElicitationTool.this.searchFrame.hide();
            }
        });
        this.searchFrame.pack();
        this.searchFrame.setSize(new Dimension(700, 400));
        this.searchFrame.show();
        return 0;
    }

    int searchMatches() {
        JFrame jFrame = new JFrame("Search the Corpus");
        return 0;
    }

    boolean hasAlignmentPair(TreeSet treeSet, TreeSet treeSet2) {
        Vector[] vectorArray = this.parseAlignments(this.alignField.getText());
        boolean bl = true;
        for (int i = 0; vectorArray != null && i < vectorArray.length; i += 2) {
            bl = true;
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                if (vectorArray[i].contains((Integer)iterator.next())) continue;
                bl = false;
            }
            iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                if (vectorArray[i + 1].contains((Integer)iterator.next())) continue;
                bl = false;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    void addPhrase() {
        int[] nArray = new int[2];
        this.tgtSentField.getHighlighter().removeAllHighlights();
        this.srcSentField.getHighlighter().removeAllHighlights();
        this.markedMatches.clear();
        this.alignIndicator.update(this.alignIndicator.getGraphics());
        this.alignField.getHighlighter().removeAllHighlights();
        if (this.tgtSentField.getText().length() == 0 || this.srcSentField.getText().length() == 0) {
            return;
        }
        if (this.srcWordIndices.isEmpty() || this.tgtWordIndices.isEmpty()) {
            this.srcWordIndices.clear();
            this.tgtWordIndices.clear();
            this.srcReady = false;
            this.tgtReady = false;
            return;
        }
        try {
            int n;
            this.markedMatches.clear();
            this.markedMatches.add((Integer)this.srcWordIndices.first());
            this.markedMatches.add((Integer)this.tgtWordIndices.first());
            this.markedMatches.add(Color.green);
            this.alignIndicator.update(this.alignIndicator.getGraphics());
            this.highlightAlignments();
            this.srcSentField.getHighlighter().removeAllHighlights();
            Iterator iterator = this.srcWordIndices.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                this.getOffsetsAtIndex(this.srcSentField.getText(), n, nArray);
                this.srcSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_green);
            }
            this.tgtSentField.getHighlighter().removeAllHighlights();
            iterator = this.tgtWordIndices.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                this.getOffsetsAtIndex(this.tgtSentField.getText(), n, nArray);
                this.tgtSentField.getHighlighter().addHighlight(nArray[0], nArray[1], dhp_green);
            }
            this.addMatch(this.srcWordIndices, this.tgtWordIndices);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.srcReady = false;
        this.tgtReady = false;
    }

    void loadGUI() {
        ActionListener actionListener;
        JMenuItem jMenuItem;
        String string;
        JPanel jPanel = new JPanel();
        boolean bl = false;
        for (int i = 0; i < 10 && !bl; ++i) {
            try {
                this.cfchooser = new JFileChooser();
                bl = true;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                System.setProperty("swing.disableFileChooserSpeedFix", "true");
                bl = false;
            }
        }
        this.cfchooser.setCurrentDirectory(new File(this.workingdir));
        this.srcWordIndices = new TreeSet();
        this.tgtWordIndices = new TreeSet();
        this.inChange = false;
        int n = 35;
        int n2 = 1100;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (dimension.getWidth() == 800.0) {
            n2 = 850;
        } else if (dimension.getWidth() == 640.0) {
            n2 = 650;
        }
        int n3 = 200;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
        try {
            string = resourceBundle.getString("labels.title");
        }
        catch (MissingResourceException missingResourceException) {
            string = "AVENUE Elicitation Tool";
        }
        this.frame.setTitle(string);
        try {
            string = resourceBundle.getString("menus.file");
        }
        catch (MissingResourceException missingResourceException) {
            string = "File";
        }
        JMenu jMenu = new JMenu(string);
        try {
            string = resourceBundle.getString("menus.open");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Open";
        }
        JMenuItem jMenuItem2 = new JMenuItem(string);
        jMenu.add(jMenuItem2);
        final ElicitationTool elicitationTool = this;
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ElicitationTool.this.cfchooser.setCurrentDirectory(new File(ElicitationTool.this.workingdir));
                if (ElicitationTool.this.checkDirty() && (n = ElicitationTool.this.cfchooser.showOpenDialog(elicitationTool)) == 0) {
                    ElicitationTool.this.corpusFile = ElicitationTool.this.cfchooser.getSelectedFile();
                    ElicitationTool.this.loadCorpus(ElicitationTool.this.corpusFile);
                }
            }
        };
        jMenuItem2.addActionListener(actionListener2);
        try {
            string = resourceBundle.getString("menus.save");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Save";
        }
        JMenuItem jMenuItem3 = new JMenuItem(string);
        jMenu.add(jMenuItem3);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.saveCorpus(ElicitationTool.this.corpusFile);
            }
        };
        jMenuItem3.addActionListener(actionListener3);
        try {
            string = resourceBundle.getString("menus.saveas");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Save As";
        }
        JMenuItem jMenuItem4 = new JMenuItem(string);
        jMenu.add(jMenuItem4);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                if (ElicitationTool.this.corpusSize == 0) {
                    return;
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(ElicitationTool.this.workingdir));
                jFileChooser.setSelectedFile(ElicitationTool.this.corpusFile);
                int n = jFileChooser.showSaveDialog(ElicitationTool.this.frame);
                if (n != 0) {
                    return;
                }
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                ElicitationTool.this.corpusFile = file = new File(string);
                ElicitationTool.this.workingdir = file.getParent();
                ElicitationTool.this.saveCorpus(file);
            }
        };
        jMenuItem4.addActionListener(actionListener4);
        if (this.lastfilename != null && !this.lastfilename.equals("")) {
            jMenuItem = new JMenuItem(new File(this.lastfilename).getName());
            jMenu.addSeparator();
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
            actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ElicitationTool.this.checkDirty()) {
                        ElicitationTool.this.corpusFile = new File(ElicitationTool.this.lastfilename);
                        ElicitationTool.this.loadCorpus(ElicitationTool.this.corpusFile);
                    }
                }
            };
            jMenuItem.addActionListener(actionListener);
        }
        try {
            string = resourceBundle.getString("menus.quit");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Exit";
        }
        jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ElicitationTool.this.checkDirty()) {
                    ElicitationTool.this.timeStamp("Close");
                    System.exit(0);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        try {
            string = resourceBundle.getString("menus.edit");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Edit";
        }
        JMenu jMenu2 = new JMenu(string);
        try {
            string = resourceBundle.getString("menus.undo");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Undo Previous";
        }
        JMenuItem jMenuItem5 = new JMenuItem(string);
        jMenu2.add(jMenuItem5);
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.undo();
            }
        };
        jMenuItem5.addActionListener(actionListener5);
        try {
            string = resourceBundle.getString("menus.redo");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Redo Previous";
        }
        JMenuItem jMenuItem6 = new JMenuItem(string);
        jMenu2.add(jMenuItem6);
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.redo();
            }
        };
        jMenuItem6.addActionListener(actionListener6);
        try {
            string = resourceBundle.getString("menus.reset");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Clear Highlights";
        }
        JMenuItem jMenuItem7 = new JMenuItem(string);
        jMenu2.add(jMenuItem7);
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                ElicitationTool.this.markedMatches.clear();
                ElicitationTool.this.tgtWordIndices.clear();
                ElicitationTool.this.srcWordIndices.clear();
                ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                ElicitationTool.this.highlightAlignments();
                ElicitationTool.this.srcReady = false;
                ElicitationTool.this.tgtReady = false;
            }
        };
        jMenuItem7.addActionListener(actionListener7);
        try {
            string = resourceBundle.getString("menus.tools");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Tools";
        }
        JMenu jMenu3 = new JMenu(string);
        try {
            string = resourceBundle.getString("menus.word");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Search for Word";
        }
        JMenuItem jMenuItem8 = new JMenuItem(string);
        jMenu3.add(jMenuItem8);
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ElicitationTool.this.searchFrame == null) {
                    ElicitationTool.this.searchCorpus();
                } else {
                    ElicitationTool.this.searchFrame.show();
                }
            }
        };
        jMenuItem8.addActionListener(actionListener8);
        try {
            string = resourceBundle.getString("menus.showdict");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Show Dictionary";
        }
        this.dictMenu = new JMenuItem(string);
        jMenu3.add(this.dictMenu);
        ActionListener actionListener9 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ElicitationTool.this.dictFrame != null) {
                    ElicitationTool.this.dictFrame.hide();
                    ElicitationTool.this.dictFrame = null;
                }
                ElicitationTool.this.showDictionary(0);
            }
        };
        this.dictMenu.addActionListener(actionListener9);
        try {
            string = resourceBundle.getString("menus.reversedict");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Show Reverse Dictionary";
        }
        this.dictReverseMenu = new JMenuItem(string);
        jMenu3.add(this.dictReverseMenu);
        ActionListener actionListener10 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ElicitationTool.this.dictFrame != null) {
                    ElicitationTool.this.dictFrame.hide();
                    ElicitationTool.this.dictFrame = null;
                }
                ElicitationTool.this.showDictionary(1);
            }
        };
        this.dictReverseMenu.addActionListener(actionListener10);
        try {
            string = resourceBundle.getString("menus.deletealternate");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Delete Alternate";
        }
        this.deleteAlternateMenu = new JMenuItem(string);
        jMenu3.add(this.deleteAlternateMenu);
        ActionListener actionListener11 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.deleteAlternate();
            }
        };
        this.deleteAlternateMenu.addActionListener(actionListener11);
        this.deleteAlternateMenu.setEnabled(false);
        try {
            string = resourceBundle.getString("menus.lang");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Display";
        }
        JMenu jMenu4 = new JMenu(string);
        try {
            string = resourceBundle.getString("menus.english");
        }
        catch (MissingResourceException missingResourceException) {
            string = "English";
        }
        JMenuItem jMenuItem9 = new JMenuItem(string);
        jMenu4.add(jMenuItem9);
        ActionListener actionListener12 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.currentLocale = "en";
            }
        };
        jMenuItem9.addActionListener(actionListener12);
        try {
            string = resourceBundle.getString("menus.spanish");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Espa\u00f1ol";
        }
        JMenuItem jMenuItem10 = new JMenuItem(string);
        jMenu4.add(jMenuItem10);
        ActionListener actionListener13 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.currentLocale = "es";
            }
        };
        jMenuItem10.addActionListener(actionListener13);
        jMenu3.add(jMenu4);
        try {
            string = resourceBundle.getString("menus.scrolling");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Scrolling";
        }
        JMenu jMenu5 = new JMenu(string);
        ButtonGroup buttonGroup = new ButtonGroup();
        try {
            string = resourceBundle.getString("menus.independent");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Independent";
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jMenu5.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (this.independentScroll) {
            jRadioButtonMenuItem.setSelected(true);
        }
        ActionListener actionListener14 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.independentScroll = true;
                JOptionPane.showMessageDialog(null, "You will need to restart the Elicitation Tool for change to take effect.", "Restart for changes", 1);
            }
        };
        jRadioButtonMenuItem.addActionListener(actionListener14);
        try {
            string = resourceBundle.getString("menus.dependent");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Dependent";
        }
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(string);
        jMenu5.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem2);
        if (!this.independentScroll) {
            jRadioButtonMenuItem2.setSelected(true);
        }
        ActionListener actionListener15 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.independentScroll = false;
                JOptionPane.showMessageDialog(null, "You will need to restart the Elicitation Tool for change to take effect.", "Restart for changes", 1);
            }
        };
        jRadioButtonMenuItem2.addActionListener(actionListener15);
        jMenu3.add(jMenu5);
        try {
            string = resourceBundle.getString("menus.interactive");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Start Feature Finder";
        }
        JMenuItem jMenuItem11 = new JMenuItem(string);
        jMenu3.add(jMenuItem11);
        ActionListener actionListener16 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.startInteractive();
            }
        };
        jMenuItem11.addActionListener(actionListener16);
        try {
            string = resourceBundle.getString("menus.auto");
        }
        catch (MissingResourceException missingResourceException) {
            string = "AutoAlign Pair";
        }
        JMenuItem jMenuItem12 = new JMenuItem(string);
        jMenu3.add(jMenuItem12);
        ActionListener actionListener17 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.autoAlign();
            }
        };
        jMenuItem12.addActionListener(actionListener17);
        try {
            string = resourceBundle.getString("menus.help");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Help";
        }
        JMenu jMenu6 = new JMenu(string);
        try {
            string = resourceBundle.getString("menus.showhelp");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Help Contents";
        }
        JMenuItem jMenuItem13 = new JMenuItem(string);
        jMenu6.add(jMenuItem13);
        ActionListener actionListener18 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.showHelp();
            }
        };
        jMenuItem13.addActionListener(actionListener18);
        try {
            string = resourceBundle.getString("menus.about");
        }
        catch (MissingResourceException missingResourceException) {
            string = "About Align Tool";
        }
        JMenuItem jMenuItem14 = new JMenuItem(string);
        jMenu6.add(jMenuItem14);
        ActionListener actionListener19 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = System.getProperty("java.version");
                JOptionPane.showMessageDialog(ElicitationTool.this.frame, "<HTML>Elicitation Interface v1.3<BR>AVENUE Project<BR>Erik Peterson, 2002-04<BR>eepeter@cs.cmu.edu<BR>Last Update: Feb. 27, 2004<BR>Java version: " + string, "About Elicitaton Interface", 1);
            }
        };
        jMenuItem14.addActionListener(actionListener19);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu6);
        this.frame.setJMenuBar(jMenuBar);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new FlowLayout());
        this.firstButton = new JButton("<<");
        try {
            string = resourceBundle.getString("tooltip.firstsent");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Go to first sentence";
        }
        this.firstButton.setToolTipText(string);
        this.prevButton = new JButton("<");
        try {
            string = resourceBundle.getString("tooltip.prevsent");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Go back one sentence";
        }
        this.prevButton.setToolTipText(string);
        this.sentIndexField = new JTextField("1", 4);
        this.nextButton = new JButton(">");
        try {
            string = resourceBundle.getString("tooltip.nextsent");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Go forward one sentence";
        }
        this.nextButton.setToolTipText(string);
        this.lastButton = new JButton(">>");
        try {
            string = resourceBundle.getString("tooltip.lastsent");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Go to last sentence";
        }
        this.lastButton.setToolTipText(string);
        jPanel.add(this.firstButton);
        jPanel.add(this.prevButton);
        jPanel.add(this.sentIndexField);
        jPanel.add(this.nextButton);
        jPanel.add(this.lastButton);
        ActionListener actionListener20 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ElicitationTool.this.sentPairs == null || ElicitationTool.this.sentPairs.size() == 0) {
                    return;
                }
                if (((JButton)actionEvent.getSource()).getText().equals("<<")) {
                    ElicitationTool.this.changeSentence(0);
                } else if (((JButton)actionEvent.getSource()).getText().equals("<")) {
                    if (ElicitationTool.this.sentIndex != 0) {
                        ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex - 1);
                    }
                } else if (((JButton)actionEvent.getSource()).getText().equals(">")) {
                    if (ElicitationTool.this.mode == 0) {
                        if (ElicitationTool.this.sentIndex < ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex + 1);
                        }
                    } else if (ElicitationTool.this.mode == 1) {
                        if (ElicitationTool.this.sentIndex < ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex + 1);
                        } else if (ElicitationTool.this.sentIndex == ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.exchangeSentsServer();
                        }
                    }
                } else if (((JButton)actionEvent.getSource()).getText().equals(">>")) {
                    if (ElicitationTool.this.mode == 0) {
                        ElicitationTool.this.changeSentence(ElicitationTool.this.corpusSize - 1);
                    } else if (ElicitationTool.this.mode == 1) {
                        ElicitationTool.this.exchangeSentsServer();
                    }
                }
            }
        };
        this.firstButton.addActionListener(actionListener20);
        this.prevButton.addActionListener(actionListener20);
        this.nextButton.addActionListener(actionListener20);
        this.lastButton.addActionListener(actionListener20);
        ActionListener actionListener21 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ElicitationTool.this.sentPairs == null || ElicitationTool.this.sentPairs.size() == 0) {
                    return;
                }
                int n = Integer.parseInt(((JTextField)actionEvent.getSource()).getText());
                if (n >= 0 && n <= ElicitationTool.this.corpusSize) {
                    ElicitationTool.this.changeSentence(n - 1);
                    ElicitationTool.this.inChange = true;
                } else {
                    ElicitationTool.this.sentIndexField.setText(Integer.toString(ElicitationTool.this.sentIndex + 1));
                }
            }
        };
        this.sentIndexField.addActionListener(actionListener21);
        try {
            string = resourceBundle.getString("labels.context");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Context:";
        }
        this.contextLabel = new JLabel(string);
        this.contextLabel.setFont(new Font("Monospaced", 0, 16));
        this.sentContextField = new JTextField(400);
        this.sentContextField.setFont(new Font("Monospaced", 0, 16));
        this.sentContextField.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.sentContextField, 21, 30);
        jScrollPane.setPreferredSize(new Dimension(n2 - n3, n + 10));
        jScrollPane.setMinimumSize(new Dimension(n2 - n3, n + 10));
        jScrollPane.setMaximumSize(new Dimension(1000, n + 10));
        try {
            string = resourceBundle.getString("labels.source");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Eliciting:";
        }
        this.sourceLabel = new JLabel(string);
        this.sourceLabel.setFont(new Font("Monospaced", 0, 16));
        this.srcSentField = new JTextField(400);
        this.srcSentField.setFont(new Font("Arial Unicode MS", 0, 16));
        this.srcSentField.setEditable(true);
        if (!this.independentScroll) {
            this.srcSentScroll = new JScrollPane(this.srcSentField, 21, 31);
            this.srcSentScroll.setPreferredSize(new Dimension(n2 - n3, n));
            this.srcSentScroll.setMinimumSize(new Dimension(n2 - 420, n));
            this.srcSentScroll.setMaximumSize(new Dimension(n2 - 120, n));
        } else {
            this.srcSentScroll = new JScrollPane(this.srcSentField, 21, 32);
            this.srcSentScroll.setPreferredSize(new Dimension(n2 - n3, n + 10));
            this.srcSentScroll.setMinimumSize(new Dimension(n2 - 420, n + 10));
            this.srcSentScroll.setMaximumSize(new Dimension(n2 - 120, n + 10));
        }
        this.srcSentField.setSelectedTextColor(Color.gray);
        MouseListener mouseListener = new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Point point = null;
                if (ElicitationTool.this.srcSentField.getText().length() == 0) {
                    return;
                }
                point = mouseEvent.getPoint();
                int n = ElicitationTool.this.srcSentField.viewToModel(point);
                if (!mouseEvent.isControlDown()) {
                    ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.srcWordIndices.clear();
                } else if (ElicitationTool.this.srcWordIndices.isEmpty() && ElicitationTool.this.tgtWordIndices.isEmpty()) {
                    ElicitationTool.this.markedMatches.clear();
                    ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                    ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                }
                ElicitationTool.this.srcWordIndex = ElicitationTool.this.getWordIndex(ElicitationTool.this.srcSentField.getText(), n);
                if (!ElicitationTool.this.tgtReady && ElicitationTool.this.tgtWordIndices.size() == 0 && !mouseEvent.isControlDown()) {
                    ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.showMatches(0, ElicitationTool.this.srcWordIndex);
                }
                if (ElicitationTool.this.srcWordIndex != -1) {
                    ElicitationTool.this.srcwstart = ElicitationTool.this.tmpwstart;
                    ElicitationTool.this.srcwend = ElicitationTool.this.tmpwend;
                    try {
                        ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_yellow);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    ElicitationTool.this.srcWordIndices.add(new Integer(ElicitationTool.this.srcWordIndex));
                    ElicitationTool.this.srcReady = !mouseEvent.isControlDown();
                } else {
                    ElicitationTool.this.srcReady = false;
                }
                if (ElicitationTool.this.debug) {
                    System.out.println("char pos " + n + " word index " + ElicitationTool.this.srcWordIndex);
                }
                if (ElicitationTool.this.tgtReady && ElicitationTool.this.srcReady) {
                    if (!ElicitationTool.this.hasAlignmentPair(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices)) {
                        ElicitationTool.this.addMatch(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices);
                        try {
                            ElicitationTool.this.markedMatches.clear();
                            ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.srcWordIndex));
                            ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.tgtWordIndex));
                            ElicitationTool.this.markedMatches.add(Color.green);
                            ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                            ElicitationTool.this.highlightAlignments();
                            ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                            ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_green);
                            ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                            ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_green);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    } else {
                        ElicitationTool.this.delMatch(ElicitationTool.this.srcWordIndex, ElicitationTool.this.tgtWordIndex);
                        ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                    }
                    ElicitationTool.this.srcReady = false;
                    ElicitationTool.this.tgtReady = false;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }
        };
        this.srcSentField.addMouseListener(mouseListener);
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40) {
                    ElicitationTool.this.tgtSentField.requestFocus();
                }
                if (keyEvent.getKeyCode() == 37 && keyEvent.isAltDown() && keyEvent.isControlDown()) {
                    ElicitationTool.this.changeSentence(0);
                }
                if (keyEvent.getKeyCode() == 37 && keyEvent.isAltDown() && ElicitationTool.this.sentIndex != 0) {
                    ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex - 1);
                }
                if (keyEvent.getKeyCode() == 39 && keyEvent.isControlDown() && keyEvent.isAltDown()) {
                    if (ElicitationTool.this.mode == 0) {
                        ElicitationTool.this.changeSentence(ElicitationTool.this.corpusSize - 1);
                    } else if (ElicitationTool.this.mode == 1) {
                        ElicitationTool.this.exchangeSentsServer();
                    }
                }
                if (keyEvent.getKeyCode() == 39 && keyEvent.isAltDown()) {
                    if (ElicitationTool.this.mode == 0) {
                        if (ElicitationTool.this.sentIndex < ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex + 1);
                        }
                    } else if (ElicitationTool.this.mode == 1) {
                        if (ElicitationTool.this.sentIndex < ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex + 1);
                        } else if (ElicitationTool.this.sentIndex == ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.exchangeSentsServer();
                        }
                    }
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
                    if (keyEvent.isAltDown()) {
                        ElicitationTool.this.addPhrase();
                        keyEvent.consume();
                        return;
                    }
                    if (ElicitationTool.this.srcSentField.getText().length() == 0) {
                        return;
                    }
                    int n = ElicitationTool.this.srcSentField.getCaretPosition();
                    if (!keyEvent.isControlDown()) {
                        ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.srcWordIndices.clear();
                    } else if (ElicitationTool.this.srcWordIndices.isEmpty() && ElicitationTool.this.tgtWordIndices.isEmpty()) {
                        ElicitationTool.this.markedMatches.clear();
                        ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                        ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                    }
                    ElicitationTool.this.srcWordIndex = ElicitationTool.this.getWordIndex(ElicitationTool.this.srcSentField.getText(), n);
                    if (!ElicitationTool.this.tgtReady && ElicitationTool.this.tgtWordIndices.size() == 0 && !keyEvent.isControlDown()) {
                        ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.showMatches(0, ElicitationTool.this.srcWordIndex);
                    }
                    if (ElicitationTool.this.srcWordIndex != -1) {
                        ElicitationTool.this.srcwstart = ElicitationTool.this.tmpwstart;
                        ElicitationTool.this.srcwend = ElicitationTool.this.tmpwend;
                        try {
                            ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_yellow);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        ElicitationTool.this.srcWordIndices.add(new Integer(ElicitationTool.this.srcWordIndex));
                        ElicitationTool.this.srcReady = !keyEvent.isControlDown();
                    } else {
                        ElicitationTool.this.srcReady = false;
                    }
                    if (ElicitationTool.this.debug) {
                        System.out.println("char pos " + n + " word index " + ElicitationTool.this.srcWordIndex);
                    }
                    if (ElicitationTool.this.tgtReady && ElicitationTool.this.srcReady) {
                        if (!ElicitationTool.this.hasAlignmentPair(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices)) {
                            ElicitationTool.this.addMatch(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices);
                            try {
                                ElicitationTool.this.markedMatches.clear();
                                ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.srcWordIndex));
                                ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.tgtWordIndex));
                                ElicitationTool.this.markedMatches.add(Color.green);
                                ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                                ElicitationTool.this.highlightAlignments();
                                ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                                ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_green);
                                ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                                ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_green);
                            }
                            catch (BadLocationException badLocationException) {
                                badLocationException.printStackTrace();
                            }
                        } else {
                            ElicitationTool.this.delMatch(ElicitationTool.this.srcWordIndex, ElicitationTool.this.tgtWordIndex);
                            ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                            ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                        }
                        ElicitationTool.this.srcReady = false;
                        ElicitationTool.this.tgtReady = false;
                    }
                }
                keyEvent.consume();
            }
        };
        this.srcSentField.addKeyListener(keyListener);
        this.tgtSentField = new JTextField(400);
        this.tgtSentField.setFont(new Font("Arial Unicode MS", 0, 16));
        this.tgtSentField.setText("");
        this.tgtSentField.setEditable(true);
        this.tgtSentField.setSelectedTextColor(Color.gray);
        this.alignField = new JTextField(400);
        this.alignField.setFont(new Font("Arial Unicode MS", 0, 16));
        this.alignField.setEditable(false);
        MouseListener mouseListener2 = new MouseListener(){

            public void mouseReleased(MouseEvent mouseEvent) {
                Point point = null;
                if (ElicitationTool.this.tgtSentField.getText().length() == 0) {
                    return;
                }
                point = mouseEvent.getPoint();
                int n = ElicitationTool.this.alignField.viewToModel(point);
                ElicitationTool.this.srcReady = false;
                ElicitationTool.this.tgtReady = false;
                ElicitationTool.this.srcWordIndices.clear();
                ElicitationTool.this.tgtWordIndices.clear();
                ElicitationTool.this.showMatch(n);
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }
        };
        this.alignField.addMouseListener(mouseListener2);
        this.clearButton = new JButton("Reset");
        ActionListener actionListener22 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                ElicitationTool.this.markedMatches.clear();
                ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                ElicitationTool.this.highlightAlignments();
                ElicitationTool.this.srcReady = false;
                ElicitationTool.this.tgtReady = false;
            }
        };
        this.clearButton.addActionListener(actionListener22);
        this.clearButton.setMaximumSize(new Dimension(35, 30));
        try {
            string = resourceBundle.getString("labels.addphrase");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Add Phrase";
        }
        JButton jButton = new JButton(string);
        ActionListener actionListener23 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.addPhrase();
            }
        };
        jButton.addActionListener(actionListener23);
        jButton.setPreferredSize(new Dimension(95, 20));
        jButton.setMaximumSize(new Dimension(95, 20));
        try {
            string = resourceBundle.getString("labels.alternate");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Add Alternate";
        }
        this.alternateAddButton = new JButton(string);
        ActionListener actionListener24 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElicitationTool.this.addAlternate();
            }
        };
        this.alternateAddButton.addActionListener(actionListener24);
        this.alternateAddButton.setMaximumSize(new Dimension(35, 30));
        jPanel.add(this.alternateAddButton);
        this.alternateLabel = new JLabel("    ");
        jPanel.add(this.alternateLabel);
        this.alignIndicator = new AlignmentIndicator(this.srcSentField, this.tgtSentField, this.alignField, this.markedMatches);
        this.pairScroll = new JScrollPane(this.alignIndicator, 21, 31);
        this.pairScroll.setPreferredSize(new Dimension(n2 - n3, n + 40));
        this.pairScroll.setMinimumSize(new Dimension(n2 - n3, n + 40));
        try {
            string = resourceBundle.getString("labels.target");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Target:";
        }
        this.targetLabel = new JLabel(string);
        this.targetLabel.setFont(new Font("Monospaced", 0, 16));
        if (!this.independentScroll) {
            this.tgtSentScroll = new JScrollPane(this.tgtSentField, 21, 31);
            this.tgtSentScroll.setPreferredSize(new Dimension(n2 - n3, n));
            this.tgtSentScroll.setMinimumSize(new Dimension(n2 - n3, n));
        } else {
            this.tgtSentScroll = new JScrollPane(this.tgtSentField, 21, 32);
            this.tgtSentScroll.setPreferredSize(new Dimension(n2 - n3, n + 10));
            this.tgtSentScroll.setMinimumSize(new Dimension(n2 - n3, n + 10));
        }
        MouseListener mouseListener3 = new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Point point = null;
                if (ElicitationTool.this.tgtSentField.getText().length() == 0) {
                    return;
                }
                point = mouseEvent.getPoint();
                int n = ElicitationTool.this.tgtSentField.viewToModel(point);
                ElicitationTool.this.tgtWordIndex = ElicitationTool.this.getWordIndex(ElicitationTool.this.tgtSentField.getText(), n);
                if (!mouseEvent.isControlDown()) {
                    ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.tgtWordIndices.clear();
                } else if (ElicitationTool.this.srcWordIndices.isEmpty() && ElicitationTool.this.tgtWordIndices.isEmpty()) {
                    ElicitationTool.this.markedMatches.clear();
                    ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                    ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                }
                if (!ElicitationTool.this.srcReady && ElicitationTool.this.srcWordIndices.size() == 0 && !mouseEvent.isControlDown()) {
                    ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.showMatches(1, ElicitationTool.this.tgtWordIndex);
                }
                if (ElicitationTool.this.tgtWordIndex != -1) {
                    ElicitationTool.this.tgtwstart = ElicitationTool.this.tmpwstart;
                    ElicitationTool.this.tgtwend = ElicitationTool.this.tmpwend;
                    try {
                        ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_yellow);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    ElicitationTool.this.tgtWordIndices.add(new Integer(ElicitationTool.this.tgtWordIndex));
                    ElicitationTool.this.tgtReady = !mouseEvent.isControlDown();
                } else {
                    ElicitationTool.this.tgtReady = false;
                }
                if (ElicitationTool.this.debug) {
                    System.out.println("char pos " + n + " word index " + ElicitationTool.this.tgtWordIndex);
                }
                if (ElicitationTool.this.tgtReady && ElicitationTool.this.srcReady) {
                    if (!ElicitationTool.this.hasAlignmentPair(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices)) {
                        ElicitationTool.this.addMatch(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices);
                        try {
                            ElicitationTool.this.markedMatches.clear();
                            ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.srcWordIndex));
                            ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.tgtWordIndex));
                            ElicitationTool.this.markedMatches.add(Color.green);
                            ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                            ElicitationTool.this.highlightAlignments();
                            ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                            ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_green);
                            ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                            ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_green);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    } else {
                        ElicitationTool.this.delMatch(ElicitationTool.this.srcWordIndex, ElicitationTool.this.tgtWordIndex);
                        try {
                            ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_red);
                            ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_red);
                            ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                            ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    ElicitationTool.this.srcReady = false;
                    ElicitationTool.this.tgtReady = false;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }
        };
        this.tgtSentField.addMouseListener(mouseListener3);
        KeyListener keyListener2 = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    ElicitationTool.this.srcSentField.requestFocus();
                }
                if (keyEvent.getKeyCode() == 37 && keyEvent.isControlDown() && keyEvent.isAltDown()) {
                    ElicitationTool.this.changeSentence(0);
                }
                if (keyEvent.getKeyCode() == 37 && keyEvent.isAltDown() && ElicitationTool.this.sentIndex != 0) {
                    ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex - 1);
                }
                if (keyEvent.getKeyCode() == 39 && keyEvent.isControlDown() && keyEvent.isAltDown()) {
                    if (ElicitationTool.this.mode == 0) {
                        ElicitationTool.this.changeSentence(ElicitationTool.this.corpusSize - 1);
                    } else if (ElicitationTool.this.mode == 1) {
                        ElicitationTool.this.exchangeSentsServer();
                    }
                }
                if (keyEvent.getKeyCode() == 39 && keyEvent.isAltDown()) {
                    if (ElicitationTool.this.mode == 0) {
                        if (ElicitationTool.this.sentIndex < ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex + 1);
                        }
                    } else if (ElicitationTool.this.mode == 1) {
                        if (ElicitationTool.this.sentIndex < ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.changeSentence(ElicitationTool.this.sentIndex + 1);
                        } else if (ElicitationTool.this.sentIndex == ElicitationTool.this.corpusSize - 1) {
                            ElicitationTool.this.exchangeSentsServer();
                        }
                    }
                }
                keyEvent.consume();
            }

            public void keyTyped(KeyEvent keyEvent) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
                if (ElicitationTool.this.inChange) {
                    ElicitationTool.this.inChange = false;
                    return;
                }
                if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
                    if (keyEvent.isAltDown()) {
                        ElicitationTool.this.addPhrase();
                        keyEvent.consume();
                        return;
                    }
                    if (ElicitationTool.this.tgtSentField.getText().length() == 0) {
                        return;
                    }
                    int n = ElicitationTool.this.tgtSentField.getCaretPosition();
                    ElicitationTool.this.tgtWordIndex = ElicitationTool.this.getWordIndex(ElicitationTool.this.tgtSentField.getText(), n);
                    if (!keyEvent.isControlDown()) {
                        ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.tgtWordIndices.clear();
                    } else if (ElicitationTool.this.srcWordIndices.isEmpty() && ElicitationTool.this.tgtWordIndices.isEmpty()) {
                        ElicitationTool.this.markedMatches.clear();
                        ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                        ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                    }
                    if (!ElicitationTool.this.srcReady && ElicitationTool.this.srcWordIndices.size() == 0 && !keyEvent.isControlDown()) {
                        ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.showMatches(1, ElicitationTool.this.tgtWordIndex);
                    }
                    if (ElicitationTool.this.tgtWordIndex != -1) {
                        ElicitationTool.this.tgtwstart = ElicitationTool.this.tmpwstart;
                        ElicitationTool.this.tgtwend = ElicitationTool.this.tmpwend;
                        try {
                            ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_yellow);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        ElicitationTool.this.tgtWordIndices.add(new Integer(ElicitationTool.this.tgtWordIndex));
                        ElicitationTool.this.tgtReady = !keyEvent.isControlDown();
                    } else {
                        ElicitationTool.this.tgtReady = false;
                    }
                    if (ElicitationTool.this.debug) {
                        System.out.println("char pos " + n + " word index " + ElicitationTool.this.tgtWordIndex);
                    }
                    if (ElicitationTool.this.tgtReady && ElicitationTool.this.srcReady) {
                        if (!ElicitationTool.this.hasAlignmentPair(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices)) {
                            ElicitationTool.this.addMatch(ElicitationTool.this.srcWordIndices, ElicitationTool.this.tgtWordIndices);
                            try {
                                ElicitationTool.this.markedMatches.clear();
                                ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.srcWordIndex));
                                ElicitationTool.this.markedMatches.add(new Integer(ElicitationTool.this.tgtWordIndex));
                                ElicitationTool.this.markedMatches.add(Color.green);
                                ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                                ElicitationTool.this.highlightAlignments();
                                ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                                ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_green);
                                ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                                ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_green);
                            }
                            catch (BadLocationException badLocationException) {
                                badLocationException.printStackTrace();
                            }
                        } else {
                            ElicitationTool.this.delMatch(ElicitationTool.this.srcWordIndex, ElicitationTool.this.tgtWordIndex);
                            try {
                                ElicitationTool.this.srcSentField.getHighlighter().addHighlight(ElicitationTool.this.srcwstart, ElicitationTool.this.srcwend, dhp_red);
                                ElicitationTool.this.tgtSentField.getHighlighter().addHighlight(ElicitationTool.this.tgtwstart, ElicitationTool.this.tgtwend, dhp_red);
                                ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                                ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                            }
                            catch (BadLocationException badLocationException) {
                                badLocationException.printStackTrace();
                            }
                        }
                        ElicitationTool.this.srcReady = false;
                        ElicitationTool.this.tgtReady = false;
                    }
                    keyEvent.consume();
                    return;
                }
                if (!ElicitationTool.this.alignField.getText().equals("()")) {
                    String string;
                    String string2;
                    if (ElicitationTool.this.alwaysEraseOnChange) {
                        ElicitationTool.this.alignField.setText("()");
                        ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                        ElicitationTool.this.highlightAlignments();
                        ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                        ElicitationTool.this.srcReady = false;
                        ElicitationTool.this.tgtReady = false;
                        ElicitationTool.this.srcWordIndices.clear();
                        ElicitationTool.this.tgtWordIndices.clear();
                        return;
                    }
                    Object[] objectArray = new String[]{"Yes Always", "Yes", "No"};
                    try {
                        string2 = resourceBundle.getString("labels.yesalways");
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = "Yes Always";
                    }
                    objectArray[0] = string2;
                    try {
                        string2 = resourceBundle.getString("labels.yes");
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = "Yes";
                    }
                    objectArray[1] = string2;
                    try {
                        string2 = resourceBundle.getString("labels.no");
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = "No";
                    }
                    objectArray[2] = string2;
                    try {
                        string2 = resourceBundle.getString("labels.editwarning");
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = "Editing Translation will erase alignments.  Continue?";
                    }
                    try {
                        string = resourceBundle.getString("labels.warningshort");
                    }
                    catch (MissingResourceException missingResourceException) {
                        string = "Warning";
                    }
                    int n = JOptionPane.showOptionDialog(null, string2, string, -1, 2, null, objectArray, objectArray[1]);
                    if (n == 2) {
                        keyEvent.consume();
                        return;
                    }
                    if (n == 0) {
                        ElicitationTool.this.alwaysEraseOnChange = true;
                    } else if (n == 1) {
                        // empty if block
                    }
                    ElicitationTool.this.alignField.setText("()");
                    ElicitationTool.this.alignIndicator.update(ElicitationTool.this.alignIndicator.getGraphics());
                    ElicitationTool.this.alignField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.srcReady = false;
                    ElicitationTool.this.tgtReady = false;
                    ElicitationTool.this.srcWordIndices.clear();
                    ElicitationTool.this.tgtWordIndices.clear();
                } else {
                    ElicitationTool.this.srcSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.tgtSentField.getHighlighter().removeAllHighlights();
                    ElicitationTool.this.srcReady = false;
                    ElicitationTool.this.tgtReady = false;
                    ElicitationTool.this.srcWordIndices.clear();
                    ElicitationTool.this.tgtWordIndices.clear();
                }
                ElicitationTool.this.dirty = true;
            }
        };
        this.tgtSentField.addKeyListener(keyListener2);
        try {
            string = resourceBundle.getString("labels.align");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Alignment:";
        }
        this.alignmentLabel = new JLabel(string);
        this.alignmentLabel.setFont(new Font("Monospaced", 0, 16));
        JScrollPane jScrollPane2 = new JScrollPane(this.alignField, 21, 30);
        jScrollPane2.setPreferredSize(new Dimension(n2 - n3, n + 10));
        jScrollPane2.setMinimumSize(new Dimension(n2 - n3, n + 10));
        try {
            string = resourceBundle.getString("labels.comment");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Comment:";
        }
        this.commentLabel = new JLabel(string);
        this.commentLabel.setFont(new Font("Monospaced", 0, 16));
        this.commentField = new JTextField(400);
        this.commentField.setFont(new Font("Arial Unicode MS", 0, 16));
        JScrollPane jScrollPane3 = new JScrollPane(this.commentField, 21, 30);
        jScrollPane3.setPreferredSize(new Dimension(n2 - n3, n + 10));
        jScrollPane3.setMinimumSize(new Dimension(n2 - n3, n + 10));
        KeyListener keyListener3 = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                ElicitationTool.this.dirty = true;
            }
        };
        this.commentField.addKeyListener(keyListener3);
        JLabel jLabel = new JLabel(" ");
        jLabel.setFont(new Font("Monospaced", 0, 16));
        this.masterBar = new JScrollBar(0, 0, 450, 0, 4500);
        this.masterBar.setPreferredSize(new Dimension(n2 - n3, n - 12));
        this.masterBar.setMinimumSize(this.masterBar.getPreferredSize());
        this.masterBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                int n = adjustmentEvent.getValue();
                ElicitationTool.this.srcSentScroll.getHorizontalScrollBar().setValue(n);
                ElicitationTool.this.pairScroll.getHorizontalScrollBar().setValue(n);
                ElicitationTool.this.tgtSentScroll.getHorizontalScrollBar().setValue(n);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.contextLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.masterBar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)this.srcSentScroll, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 15);
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.pairScroll, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)this.targetLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tgtSentScroll, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.alignmentLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)this.commentLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)jScrollPane3, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
    }

    void loadCorpus(File file) {
        BufferedReader bufferedReader;
        FileInputStream fileInputStream;
        String string = null;
        SentPair sentPair = null;
        this.sentPairs = new Vector(200);
        this.markedMatches.clear();
        this.undoInfo.clear();
        this.tgtReady = false;
        this.srcReady = false;
        this.inUndo = false;
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, "File does not exist", "File does not exist", 0);
            return;
        }
        this.workingdir = file.getParent();
        this.lastfilename = file.getAbsolutePath();
        this.fileencoding = this.encoding;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, this.encoding));
            string = bufferedReader.readLine();
            string = string.trim();
            if (string.startsWith("encoding: ")) {
                this.fileencoding = string.substring(10);
            }
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            String string2;
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, this.fileencoding));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("#") != -1) continue;
                if (string.startsWith("srclang: ")) {
                    this.srcLang = string.substring(9);
                    continue;
                }
                if (string.startsWith("tgtlang: ")) {
                    this.tgtLang = string.substring(9);
                    continue;
                }
                if (string.startsWith("newpair")) {
                    if (sentPair != null) {
                        if (sentPair.getAlignment().length() == 0) {
                            sentPair.setAlignment("()");
                        }
                        this.sentPairs.addElement(sentPair);
                        sentPair = new SentPair();
                        continue;
                    }
                    sentPair = new SentPair();
                    sentPair.setAlignment("()");
                    continue;
                }
                if (string.indexOf("context: ") == 0) {
                    sentPair.context = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("srcsent: ")) {
                    sentPair.srcSent = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("tgtsent: ")) {
                    sentPair.tgtSent = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("comment: ")) {
                    sentPair.setComment(new String(string.substring(9)));
                    continue;
                }
                if (string.startsWith("aligned: ")) {
                    sentPair.setAlignment(new String(string.substring(9)));
                    continue;
                }
                if (!string.startsWith("alternate")) continue;
                sentPair.alternate = true;
            }
            if (sentPair.getAlignment().length() == 0) {
                sentPair.setAlignment("()");
            }
            this.sentPairs.addElement(sentPair);
            ((InputStream)fileInputStream).close();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
            try {
                string2 = resourceBundle.getString("labels.frame");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = "AVENUE Elicitation Tool";
            }
            this.frame.setTitle(string2 + " " + this.srcLang + "-" + this.tgtLang);
            resourceBundle = ResourceBundle.getBundle("etlabels");
            try {
                string2 = resourceBundle.getString("labels.dictionary");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = "Dictionary";
            }
            if (this.srcLang.length() == 0) {
                this.srcLang = "Eliciting";
            }
            if (this.tgtLang.length() == 0) {
                this.tgtLang = "Elicited";
            }
            this.dictMenu.setText(this.srcLang + " - " + this.tgtLang + " " + string2);
            this.dictReverseMenu.setText(this.tgtLang + " - " + this.srcLang + " " + string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.corpusSize = this.sentPairs.size();
        this.sentIndex = 0;
        sentPair = (SentPair)this.sentPairs.elementAt(0);
        if (sentPair != null) {
            this.sentContextField.setText(sentPair.context);
            this.sentIndexField.setText("1");
            this.sentIndex = 0;
            this.srcSentField.setText(sentPair.srcSent);
            this.tgtSentField.setText(sentPair.tgtSent);
            this.alignField.setText(sentPair.alignment);
            this.commentField.setText(sentPair.comment);
            this.alignIndicator.update(this.alignIndicator.getGraphics());
            this.highlightAlignments();
        }
        this.tgtSentField.requestFocus();
        this.dirty = false;
    }

    void deleteAlternate() {
        if (this.sentPairs == null || this.sentPairs.size() == 0) {
            return;
        }
        SentPair sentPair = (SentPair)this.sentPairs.elementAt(this.sentIndex);
        if (!sentPair.alternate) {
            return;
        }
        if (this.sentIndex > 0) {
            this.changeSentence(this.sentIndex - 1);
            this.sentPairs.removeElementAt(this.sentIndex + 1);
            this.corpusSize = this.sentPairs.size();
            this.dirty = true;
        }
    }

    void addAlternate() {
        if (this.srcSentField.getText().length() == 0) {
            return;
        }
        SentPair sentPair = new SentPair();
        sentPair.context = this.sentContextField.getText();
        sentPair.srcSent = this.srcSentField.getText();
        sentPair.tgtSent = "";
        sentPair.setComment(this.commentField.getText());
        sentPair.setAlignment("()");
        sentPair.alternate = true;
        this.sentPairs.add(this.sentIndex + 1, sentPair);
        this.changeSentence(this.sentIndex + 1);
        this.corpusSize = this.sentPairs.size();
        this.dirty = true;
    }

    void appendCorpus(File file) {
        String string = null;
        SentPair sentPair = null;
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, this.encoding));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("#") != -1) continue;
                if (string.startsWith("srclang: ")) {
                    this.srcLang = string.substring(9);
                    continue;
                }
                if (string.startsWith("tgtlang: ")) {
                    this.tgtLang = string.substring(9);
                    continue;
                }
                if (string.startsWith("newpair")) {
                    if (sentPair != null) {
                        sentPair.setAlignment("()");
                        this.sentPairs.addElement(sentPair);
                        sentPair = new SentPair();
                        continue;
                    }
                    sentPair = new SentPair();
                    continue;
                }
                if (string.indexOf("context: ") == 0) {
                    sentPair.context = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("srcsent: ")) {
                    sentPair.srcSent = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("tgtsent: ")) {
                    sentPair.tgtSent = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("comment: ")) {
                    sentPair.setComment(new String(string.substring(9)));
                    continue;
                }
                if (!string.startsWith("aligned: ")) continue;
                sentPair.setAlignment(new String(string.substring(9)));
            }
            sentPair.setAlignment("()");
            this.sentPairs.addElement(sentPair);
            ((InputStream)fileInputStream).close();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
            try {
                string2 = resourceBundle.getString("labels.frame");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = "AVENUE Elicitation Tool";
            }
            if (this.srcLang != null && this.tgtLang != null) {
                this.frame.setTitle(string2 + " " + this.srcLang + "-" + this.tgtLang);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.blockstart = this.corpusSize;
        this.blockend = this.sentPairs.size();
        if (this.blockstart == 0) {
            sentPair = (SentPair)this.sentPairs.elementAt(this.blockstart);
            if (sentPair != null) {
                this.sentContextField.setText(sentPair.context);
                this.srcSentField.setText(sentPair.srcSent);
                this.tgtSentField.setText(sentPair.tgtSent);
                this.alignField.setText(sentPair.alignment);
                this.commentField.setText(sentPair.comment);
            }
        } else {
            this.changeSentence(this.blockstart);
        }
        this.sentIndex = this.corpusSize;
        this.corpusSize = this.sentPairs.size();
    }

    void appendCorpusSocket() {
        String string = null;
        SentPair sentPair = null;
        int n = 0;
        try {
            while (n < 2 && (string = this.featureIn.readLine()) != null) {
                if (string.length() == 0) {
                    ++n;
                    continue;
                }
                n = 0;
                if (string.indexOf("#") != -1) continue;
                if (string.startsWith("srclang: ")) {
                    this.srcLang = string.substring(9);
                    continue;
                }
                if (string.startsWith("tgtlang: ")) {
                    this.tgtLang = string.substring(9);
                    continue;
                }
                if (string.startsWith("newpair")) {
                    if (sentPair != null) {
                        sentPair.setAlignment("()");
                        this.sentPairs.addElement(sentPair);
                        sentPair = new SentPair();
                        continue;
                    }
                    sentPair = new SentPair();
                    continue;
                }
                if (string.indexOf("context: ") == 0) {
                    sentPair.context = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("srcsent: ")) {
                    sentPair.srcSent = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("tgtsent: ")) {
                    sentPair.tgtSent = new String(string.substring(9));
                    continue;
                }
                if (string.startsWith("comment: ")) {
                    sentPair.setComment(new String(string.substring(9)));
                    continue;
                }
                if (!string.startsWith("aligned: ")) continue;
                sentPair.setAlignment(new String(string.substring(9)));
            }
            sentPair.setAlignment("()");
            this.sentPairs.addElement(sentPair);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.blockstart = this.corpusSize;
        this.blockend = this.sentPairs.size();
        if (this.blockstart == 0) {
            sentPair = (SentPair)this.sentPairs.elementAt(this.blockstart);
            if (sentPair != null) {
                this.sentContextField.setText(sentPair.context);
                this.srcSentField.setText(sentPair.srcSent);
                this.tgtSentField.setText(sentPair.tgtSent);
                this.alignField.setText(sentPair.alignment);
                this.commentField.setText(sentPair.comment);
            }
        } else {
            this.changeSentence(this.blockstart);
        }
        this.sentIndex = this.corpusSize;
        this.corpusSize = this.sentPairs.size();
    }

    boolean checkDirty() {
        String string;
        String string2;
        this.saveInitFile();
        if (this.mode == 1) {
            return true;
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("etlabels");
        Object[] objectArray = new String[]{"Yes", "No", "Cancel"};
        try {
            string2 = resourceBundle.getString("labels.yes");
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Yes";
        }
        objectArray[0] = string2;
        try {
            string2 = resourceBundle.getString("labels.no");
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "No";
        }
        objectArray[1] = string2;
        try {
            string2 = resourceBundle.getString("labels.cancel");
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Cancel";
        }
        objectArray[2] = string2;
        try {
            string2 = resourceBundle.getString("labels.savecheck");
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Would you like to save your changes?";
        }
        try {
            string = resourceBundle.getString("labels.checkshort");
        }
        catch (MissingResourceException missingResourceException) {
            string = "Save changes?";
        }
        if (this.dirty) {
            int n = JOptionPane.showOptionDialog(null, string2, string, -1, 2, null, objectArray, objectArray[1]);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                this.saveCorpus(this.corpusFile);
                return true;
            }
            if (n == 1) {
                return true;
            }
        } else {
            return true;
        }
        return true;
    }

    void saveCorpus(File file) {
        SentPair sentPair;
        int n = 0;
        if (this.sentPairs == null) {
            return;
        }
        this.changeSentence(this.sentIndex);
        this.lastfilename = file.getAbsolutePath();
        Charset charset = Charset.forName(this.fileencoding);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        for (n = 0; n < this.sentPairs.size(); ++n) {
            sentPair = (SentPair)this.sentPairs.elementAt(n);
            if (charsetEncoder.canEncode(sentPair.tgtSent)) continue;
            this.fileencoding = "UTF8";
            break;
        }
        if (this.debug) {
            System.out.println("Saving corpus...");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.fileencoding));
            bufferedWriter.write("encoding: ");
            bufferedWriter.write(this.fileencoding, 0, this.fileencoding.length());
            bufferedWriter.newLine();
            bufferedWriter.write("srclang: ");
            bufferedWriter.write(this.srcLang, 0, this.srcLang.length());
            bufferedWriter.newLine();
            bufferedWriter.write("tgtlang: ");
            bufferedWriter.write(this.tgtLang, 0, this.tgtLang.length());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            for (n = 0; n < this.sentPairs.size(); ++n) {
                sentPair = (SentPair)this.sentPairs.elementAt(n);
                bufferedWriter.write("newpair");
                bufferedWriter.newLine();
                bufferedWriter.write("srcsent: ");
                bufferedWriter.write(sentPair.srcSent, 0, sentPair.srcSent.length());
                bufferedWriter.newLine();
                bufferedWriter.write("tgtsent: ");
                bufferedWriter.write(sentPair.tgtSent, 0, sentPair.tgtSent.length());
                bufferedWriter.newLine();
                bufferedWriter.write("aligned: ");
                bufferedWriter.write(sentPair.alignment, 0, sentPair.alignment.length());
                bufferedWriter.newLine();
                bufferedWriter.write("context: ");
                bufferedWriter.write(sentPair.context, 0, sentPair.context.length());
                bufferedWriter.newLine();
                bufferedWriter.write("comment: ");
                bufferedWriter.write(sentPair.comment, 0, sentPair.comment.length());
                bufferedWriter.newLine();
                if (sentPair.alternate) {
                    bufferedWriter.write("alternate");
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            ((OutputStream)fileOutputStream).close();
            this.dirty = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Corpus saved.");
        }
    }

    void saveCorpus(File file, int n, int n2) {
        int n3 = 0;
        this.changeSentence(this.sentIndex);
        if (this.debug) {
            System.out.println("Saving corpus... to " + file + " from " + n + " to " + n2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
            bufferedWriter.write("srclang: ");
            bufferedWriter.write(this.srcLang, 0, this.srcLang.length());
            bufferedWriter.newLine();
            bufferedWriter.write("tgtlang: ");
            bufferedWriter.write(this.tgtLang, 0, this.tgtLang.length());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            for (n3 = n; n3 < n2; ++n3) {
                SentPair sentPair = (SentPair)this.sentPairs.elementAt(n3);
                bufferedWriter.write("newpair");
                bufferedWriter.newLine();
                bufferedWriter.write("srcsent: ");
                bufferedWriter.write(sentPair.srcSent, 0, sentPair.srcSent.length());
                bufferedWriter.newLine();
                bufferedWriter.write("tgtsent: ");
                bufferedWriter.write(sentPair.tgtSent, 0, sentPair.tgtSent.length());
                bufferedWriter.newLine();
                bufferedWriter.write("aligned: ");
                bufferedWriter.write(sentPair.alignment, 0, sentPair.alignment.length());
                bufferedWriter.newLine();
                bufferedWriter.write("context: ");
                bufferedWriter.write(sentPair.context, 0, sentPair.context.length());
                bufferedWriter.newLine();
                bufferedWriter.write("comment: ");
                bufferedWriter.write(sentPair.comment, 0, sentPair.comment.length());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.debug) {
            System.out.println("Corpus saved.");
        }
    }

    public static void main(String[] stringArray) {
        String string;
        int n;
        String string2;
        String string3;
        boolean bl;
        block22: {
            String string4 = UIManager.getSystemLookAndFeelClassName();
            boolean bl2 = false;
            boolean bl3 = false;
            bl = false;
            boolean bl4 = true;
            string3 = "";
            string2 = "";
            n = -1;
            string = "";
            String string5 = "en";
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-interactive")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-file")) {
                    if (i + 1 >= stringArray.length) continue;
                    string3 = new String(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-server")) {
                    if (i + 1 >= stringArray.length) continue;
                    string2 = new String(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-port")) {
                    if (i + 1 >= stringArray.length) continue;
                    try {
                        n = Integer.parseInt(stringArray[i + 1]);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-font")) {
                    if (i + 1 >= stringArray.length) continue;
                    String string6 = new String(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-encoding")) {
                    if (i + 1 >= stringArray.length) continue;
                    string = new String(stringArray[i + 1]);
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-locale")) {
                    if (i + 1 >= stringArray.length) continue;
                    string5 = new String(stringArray[i + 1]);
                    if (string5.equalsIgnoreCase("ES")) {
                        Locale.setDefault(new Locale("es", "CL"));
                        continue;
                    }
                    if (!string5.equalsIgnoreCase("EN")) continue;
                    Locale.setDefault(Locale.US);
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-help") && !stringArray[i].equalsIgnoreCase("-h")) continue;
                System.out.println("ElicitationTool -interactive -encoding encoding -file file -font font -locale [en|es]");
                System.exit(0);
            }
            try {
                UIManager.setLookAndFeel(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl2) {
                    System.err.println("Couldn't find class for specified look and feel:" + string4);
                }
                if (bl2) {
                    System.err.println("Did you include the L&F library in the class path?");
                }
                if (bl2) {
                    System.err.println("Using the default look and feel.");
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                if (bl2) {
                    System.err.println("Can't use the specified look and feel (" + string4 + ") on this platform.");
                }
                if (bl2) {
                    System.err.println("Using the default look and feel.");
                }
            }
            catch (Exception exception) {
                if (bl2) {
                    System.err.println("Couldn't get specified look and feel (" + string4 + "), for some reason.");
                }
                if (bl2) {
                    System.err.println("Using the default look and feel.");
                }
                if (!bl2) break block22;
                exception.printStackTrace();
            }
        }
        JFrame jFrame = new JFrame("AVENUE Elicitation Tool");
        final ElicitationTool elicitationTool = bl ? new ElicitationTool(jFrame, string3, string) : (n != -1 ? new ElicitationTool(jFrame, string2, n) : (string3.length() > 0 ? new ElicitationTool(jFrame, string3) : new ElicitationTool(jFrame)));
        elicitationTool.timeStamp("Open");
        String string7 = "align.gif";
        URL uRL = elicitationTool.getClass().getResource("align.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        jFrame.setIconImage(imageIcon.getImage());
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (elicitationTool.checkDirty()) {
                    elicitationTool.timeStamp("Close");
                    System.exit(0);
                }
            }
        });
        jFrame.getContentPane().add("Center", elicitationTool);
        jFrame.pack();
        jFrame.setSize(new Dimension(1100, 460));
        jFrame.show();
    }

    class ActionInfo {
        public int actionType;
        public TreeSet actionSrc;
        public TreeSet actionTgt;

        public ActionInfo(int n, TreeSet treeSet, TreeSet treeSet2) {
            this.actionType = n;
            this.actionSrc = treeSet;
            this.actionTgt = treeSet2;
        }
    }
}

